/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCallPostprocessor;

class HTTPReference
extends AbstractNamedObject {
    protected HTTPFabricConnection connection;
    protected String getMethod;
    protected FabricAddress address;
    private RemoteMethodCall additionalCall;
    private String firstCall = "getModerator";

    HTTPReference(String name, HTTPFabricConnection connection) {
        super(name);
        this.connection = connection;
    }

    HTTPReference(FabricAddress address, HTTPFabricConnection connection) {
        super(null);
        this.address = address;
        this.connection = connection;
    }

    protected void setAdditionalCall(RemoteMethodCall call) {
        this.additionalCall = call;
    }

    protected RemoteMethodCall makeReferenceGetCall() {
        Object[] referenceArgs = new Object[1];
        if (this.name != null) {
            referenceArgs[0] = this.name;
        } else if (this.address != null) {
            referenceArgs[0] = this.address;
        } else {
            referenceArgs = new Object[]{};
        }
        return new RemoteMethodCall(this.getMethod, referenceArgs);
    }

    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] moderatorArgs = new Object[]{};
        if (this.firstCall != null) {
            call.pushMethodCall(new RemoteMethodCall(this.firstCall, moderatorArgs));
        }
        if (this.additionalCall != null) {
            call.pushMethodCall(this.additionalCall);
        }
        call.pushMethodCall(this.makeReferenceGetCall());
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null);
    }

    protected Object invoke(String methodName, Object[] args, RemoteMethodCallPostprocessor postprocessor) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] moderatorArgs = new Object[]{};
        if (this.firstCall != null) {
            call.pushMethodCall(new RemoteMethodCall(this.firstCall, moderatorArgs));
        }
        if (this.additionalCall != null) {
            call.pushMethodCall(this.additionalCall);
        }
        call.pushMethodCall(this.makeReferenceGetCall());
        if (methodName != null) {
            call.pushMethodCall(new RemoteMethodCall(methodName, args));
        }
        call.setPostprocessorMethodCall(postprocessor);
        return this.connection.invokeRemoteCall(call, null);
    }

    void setFirstCall(String firstCall) {
        this.firstCall = firstCall;
    }

    public boolean lookup() {
        Object result = this.invoke(null, null, RemoteMethodCallPostprocessor.IS_NULL);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return result != null && (Boolean)result == false;
    }

    public String lookupName() {
        Object result = this.invoke(null, null, RemoteMethodCallPostprocessor.GET_NAME_IF_NOT_NULL);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }
}

