/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPDomainConstraintReference;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPFabricNodeReference;
import com.streamscape.cli.http.HTTPFabricNodeReferenceBase;
import com.streamscape.cli.http.HTTPRangeConstraintReference;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.DomainConstraintReference;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.RangeConstraintReference;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCallPostprocessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class HTTPModerator
extends HTTPFabricNodeReferenceBase
implements Moderator {
    HTTPModerator(HTTPFabricConnection fabricConnection) {
        super((String)null, fabricConnection);
    }

    @Override
    public String getDomain() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getDomain", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public FabricNodeReference getFabricNode() throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] noArgs = new Object[]{};
        call.pushMethodCall(new RemoteMethodCall("getModerator", noArgs));
        call.pushMethodCall(new RemoteMethodCall("getFabricNode", noArgs));
        call.pushMethodCall(new RemoteMethodCall("getName", noArgs));
        Object result = this.connection.invokeRemoteCall(call, null);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        String nodeName = (String)result;
        return new HTTPFabricNodeReference(nodeName, this.connection);
    }

    @Override
    public List<FabricNodeReference> getFabricNodes() throws HTTPFabricException {
        return this.listFabricNodes().stream().map(name -> new HTTPFabricNodeReference((String)name, this.connection)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<String> listFabricNodes() throws HTTPFabricException {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listFabricNodes", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public FabricNodeReference lookupFabricNode(FabricAddress address) throws HTTPFabricException {
        HTTPFabricNodeReference reference = new HTTPFabricNodeReference(address, this.connection);
        String name = reference.lookupName();
        if (name != null) {
            return new HTTPFabricNodeReference(name, this.connection);
        }
        return null;
    }

    @Override
    public FabricNodeReference lookupFabricNode(String name) throws HTTPFabricException {
        HTTPFabricNodeReference reference = new HTTPFabricNodeReference(name, this.connection);
        if (reference.lookup()) {
            return reference;
        }
        return null;
    }

    @Override
    public List<DomainConstraintReference> getDomainConstraints() {
        Object[] names;
        Object[] args = new Object[]{};
        Object result = this.invoke("getDomainConstraints", args, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<DomainConstraintReference> references = new ArrayList<DomainConstraintReference>();
        for (Object name : names = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(name, String.class);
            references.add(new HTTPDomainConstraintReference((String)name, this.connection));
        }
        return references;
    }

    @Override
    public List<DomainConstraintReference> getDomainConstraints(String pattern) {
        Object[] names;
        Object[] args = new Object[]{pattern};
        Object result = this.invoke("getDomainConstraints", args, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<DomainConstraintReference> references = new ArrayList<DomainConstraintReference>();
        for (Object name : names = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(name, String.class);
            references.add(new HTTPDomainConstraintReference((String)name, this.connection));
        }
        return references;
    }

    @Override
    public DomainConstraintReference lookupDomainConstraint(String name) {
        HTTPDomainConstraintReference reference = new HTTPDomainConstraintReference(name, this.connection);
        if (reference.lookup()) {
            return reference;
        }
        return null;
    }

    @Override
    public List<RangeConstraintReference> getRangeConstraints() {
        Object[] names;
        Object[] args = new Object[]{};
        Object result = this.invoke("getRangeConstraints", args, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<RangeConstraintReference> references = new ArrayList<RangeConstraintReference>();
        for (Object name : names = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(name, String.class);
            references.add(new HTTPRangeConstraintReference((String)name, this.connection));
        }
        return references;
    }

    @Override
    public List<RangeConstraintReference> getRangeConstraints(String pattern) {
        Object[] names;
        Object[] args = new Object[]{pattern};
        Object result = this.invoke("getRangeConstraints", args, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<RangeConstraintReference> references = new ArrayList<RangeConstraintReference>();
        for (Object name : names = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(name, String.class);
            references.add(new HTTPRangeConstraintReference((String)name, this.connection));
        }
        return references;
    }

    @Override
    public RangeConstraintReference lookupRangeConstraint(String name) {
        HTTPRangeConstraintReference reference = new HTTPRangeConstraintReference(name, this.connection);
        if (reference.lookup()) {
            return reference;
        }
        return null;
    }

    @Override
    public List<String> listDomainConstraints() {
        Object[] args = new Object[]{};
        Object result = this.invoke("listDomainConstraints", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public List<String> listRangeConstraints() {
        Object[] args = new Object[]{};
        Object result = this.invoke("listRangeConstraints", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public List<String> listClusters() {
        Object result = this.invoke("listClusters", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public List<String> listFabricNodesInCluster(String clusterName) {
        Object result = this.invoke("listClusters", new Object[]{clusterName});
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public EventFlowMap getEventFlowMap(boolean all) {
        Object result = this.invoke("getEventFlowMap", new Object[]{all});
        HTTPFabricConnection.processServerAnswer(result, EventFlowMap.class);
        return (EventFlowMap)result;
    }

    @Override
    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] moderatorArgs = new Object[]{};
        call.pushMethodCall(new RemoteMethodCall("getModerator", moderatorArgs));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null);
    }

    @Override
    protected Object invoke(String methodName, Object[] args, RemoteMethodCallPostprocessor postprocessor) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] moderatorArgs = new Object[]{};
        call.pushMethodCall(new RemoteMethodCall("getModerator", moderatorArgs));
        if (methodName != null) {
            call.pushMethodCall(new RemoteMethodCall(methodName, args));
        }
        call.setPostprocessorMethodCall(postprocessor);
        return this.connection.invokeRemoteCall(call, null);
    }
}

