/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPComponentReference;
import com.streamscape.cli.http.HTTPComponentReferenceBase;
import com.streamscape.cli.http.HTTPEventCacheReference;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventCacheReference;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCallPostprocessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class HTTPFabricNodeReferenceBase
extends HTTPComponentReferenceBase {
    HTTPFabricNodeReferenceBase(String name, HTTPFabricConnection fabricConnection) {
        super(name, fabricConnection);
    }

    HTTPFabricNodeReferenceBase(FabricAddress address, HTTPFabricConnection fabricConnection) {
        super(address, fabricConnection);
    }

    public List<ComponentReference> getComponents(EventScope eventScope) {
        Object[] componentNames;
        Object[] args = new Object[]{eventScope};
        Object result = this.invoke("getComponents", args, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ComponentReference> components = new ArrayList<ComponentReference>();
        for (Object componentName : componentNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(componentName, String.class);
            HTTPComponentReference reference = new HTTPComponentReference((String)componentName, this.connection);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            components.add(reference);
        }
        return components;
    }

    public List<EventCacheReference> getEventCaches() {
        List<String> names = this.listEventCaches();
        ArrayList<EventCacheReference> caches = new ArrayList<EventCacheReference>();
        for (String name : names) {
            HTTPEventCacheReference reference = new HTTPEventCacheReference(name, this.connection);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            caches.add(reference);
        }
        return caches;
    }

    public List<String> listComponents() {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listComponents", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        Vector<String> vector = new Vector<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listEventCaches() {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("listEventCaches", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        Vector<String> vector = new Vector<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public ComponentReference lookupComponent(FabricAddress address) {
        String name;
        HTTPComponentReference reference = new HTTPComponentReference(address, this.connection);
        if (this.getMethod != null) {
            reference.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = reference.lookupName()) != null) {
            reference = new HTTPComponentReference(name, this.connection);
            if (this.getMethod != null) {
                reference.setAdditionalCall(reference.makeReferenceGetCall());
            }
            return reference;
        }
        return null;
    }

    public ComponentReference lookupComponent(String name) {
        HTTPComponentReference reference = new HTTPComponentReference(name, this.connection);
        if (this.getMethod != null) {
            reference.setAdditionalCall(this.makeReferenceGetCall());
        }
        return reference.lookup() ? reference : null;
    }

    public EventCacheReference lookupEventCache(String eventFilter) {
        HTTPEventCacheReference reference = new HTTPEventCacheReference(eventFilter, this.connection);
        if (this.getMethod != null) {
            reference.setAdditionalCall(this.makeReferenceGetCall());
        }
        return reference.lookup() ? reference : null;
    }
}

