/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.cli.tlp.FabricConnectionFactoryException;

public class HTTPFabricConnectionFactory
extends FabricConnectionFactory {
    public static final String HTTP_LOCAL_URL = "http://localhost:80";
    public static final String HTTP_CLIENT_TYPE_NAME = "Client_HTTP";
    public static final int DEFAULT_PORT_HTTP = 80;

    public HTTPFabricConnectionFactory() throws FabricConnectionFactoryException {
        this.addURL(HTTP_LOCAL_URL);
        this.setType(HTTP_CLIENT_TYPE_NAME);
        this.setDescription("HTTP Connection");
    }

    public HTTPFabricConnectionFactory(String url) throws FabricConnectionFactoryException {
        super(url);
        this.setType(HTTP_CLIENT_TYPE_NAME);
        this.setDescription("HTTP Connection");
    }

    @Override
    public void addURL(String url) throws FabricConnectionFactoryException {
        url = HTTPFabricConnectionFactory.formatUrlWithDefaultPortAndSchema(url, false, 80);
        super.addURL(url);
    }

    @Override
    public HTTPFabricConnection createConnection() throws FabricConnectionFactoryException {
        return (HTTPFabricConnection)super.createConnection();
    }

    @Override
    public HTTPFabricConnection createConnection(String userName, String password) throws FabricConnectionFactoryException {
        return (HTTPFabricConnection)super.createConnection(userName, password);
    }

    @Override
    protected FabricConnection createConnectionInstance() {
        return new HTTPFabricConnection(HTTPFabricConnectionFactory.getContext(), this.getType());
    }

    @Override
    public HTTPFabricConnection createConnection(String securityToken) throws FabricConnectionFactoryException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    protected void initBasicConnectionParameters(FabricConnection connection) throws FabricConnectionException {
        this.doInitBasicConnectionParameters(connection);
    }

    @Override
    public void setSecurityToken(String securityToken) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    static String formatUrlWithDefaultPortAndSchema(String url, boolean isHttps, int defaultPort) {
        if (url == null) {
            return url;
        }
        int pos = ((String)url).indexOf("://");
        if (pos == -1) {
            url = (isHttps ? "https://" : "http://") + (String)url;
            pos = 6;
        } else {
            pos += 2;
        }
        pos = ((String)url).indexOf(58, pos);
        if (pos == -1) {
            url = (String)url + ":" + defaultPort;
        }
        return url;
    }
}

