/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.http.HTTPClassLoader;
import com.streamscape.cli.http.HTTPClientAliasManager;
import com.streamscape.cli.http.HTTPClientComponent;
import com.streamscape.cli.http.HTTPClientException;
import com.streamscape.cli.http.HTTPClientUtils;
import com.streamscape.cli.http.HTTPComponentReferenceConnection;
import com.streamscape.cli.http.HTTPDataspaceAccessor;
import com.streamscape.cli.http.HTTPEventAsyncConsumer;
import com.streamscape.cli.http.HTTPEventCache;
import com.streamscape.cli.http.HTTPEventConsumer;
import com.streamscape.cli.http.HTTPEventFactory;
import com.streamscape.cli.http.HTTPEventReceiver;
import com.streamscape.cli.http.HTTPEventRequestConsumer;
import com.streamscape.cli.http.HTTPFabricConnectionState;
import com.streamscape.cli.http.HTTPFabricConnectionStateEvent;
import com.streamscape.cli.http.HTTPFabricConnectionStateEventListener;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPListener;
import com.streamscape.cli.http.HTTPModerator;
import com.streamscape.cli.http.HTTPRepositoryAccessor;
import com.streamscape.cli.http.HTTPRequestsStatistics;
import com.streamscape.cli.http.HTTPSLSession;
import com.streamscape.cli.http.HTTPSecurityManager;
import com.streamscape.cli.http.HTTPServiceAccessor;
import com.streamscape.cli.http.HTTPStatistics;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.cli.tlp.PingState;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.JVM;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ExceptionStrategy;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventCache;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.EventRequestConsumer;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.sef.dispatcher.AbstractHTTPFabricConnection;
import com.streamscape.sef.dispatcher.SLAudioMessageListener;
import com.streamscape.sef.dispatcher.SLAudioMessageProcessor;
import com.streamscape.sef.dispatcher.SLFileMessageListener;
import com.streamscape.sef.dispatcher.SLFileMessageProcessor;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.group.FabricGroupLink;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.http.server.fabric.HTTPEventListener;
import com.streamscape.sef.network.http.server.fabric.HTTPEventTransmitter;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionInfo;
import com.streamscape.sef.network.http.server.fabric.LinkMode;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCallPostprocessor;
import com.streamscape.sef.network.http.server.servlet.JsonExchangeServlet;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSession;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class HTTPFabricConnection
extends AbstractHTTPFabricConnection
implements FabricConnection {
    public static final int DEFAULT_HTTP_TIMEOUT_IN_MS = 30000;
    public static final int DEFAULT_FILE_TRANSFERS_DIRECT_CONSUMERS_TIMEOUT_IN_MS = 20000;
    public static final int DEFAULT_REVERSE_HOLD_TIMEOUT_MS = 10000;
    public static final int DEFAULT_REVERSE_REPLY_TIMEOUT_MS = 12000;
    public static final long DEFAULT_LEASE_TIMEOUT = 60000L;
    public static final String MAGIC = "5eeve2ec";
    public static final String FABRIC_REALM = "Fabric";
    public static final String FABRIC_URL = "/fabric";
    public static final String FABRIC_SESSION = "FabricSession";
    HTTPClientComponent componentParams = new HTTPClientComponent();
    HTTPClientComponent component = new HTTPClientComponent();
    List<String> urls = new ArrayList<String>();
    ClientId clientId;
    String userName;
    long leasePeriod = 60000L;
    long sessionTimeout = 60000L;
    long creationTime;
    long lastAccessTime;
    LinkMode openLinkMode = LinkMode.START;
    LinkMode closeLinkMode = LinkMode.STOP;
    transient FabricContext context;
    transient String url;
    transient TimeZone hostTimezone;
    transient TimeZone nodeTimezone;
    transient String sessionId = "";
    transient long httpTimeoutMs = 30000L;
    transient long fileTransfersDirectConsumersTimeoutMs = 20000L;
    transient long asyncConsumerAndSLMessageTimeoutsForReverseMonitorMs = 30000L;
    transient long reverseReplyTimeoutMs = 12000L;
    transient long reverseConnectionHoldTimeoutMs = 10000L;
    transient int maxRetriesCount = 2;
    transient int reconnectAttempts = -1;
    transient long reconnectInterval = 1L;
    transient long connectionReopenInterval = 30L;
    volatile transient boolean isOpened = false;
    transient long openTime = 0L;
    transient AtomicLong unique = new AtomicLong(0L);
    transient String userPassword;
    transient HTTPClientWrapper httpClientWrapper;
    transient ObjectMediationAliasManager aliasManager = new HTTPClientAliasManager();
    transient JSONSerializer serializer;
    transient Map<String, HTTPEventConsumer> directConsumers = new HashMap<String, HTTPEventConsumer>();
    transient Map<String, HTTPEventAsyncConsumer> asyncConsumers = new HashMap<String, HTTPEventAsyncConsumer>();
    transient Map<String, HTTPEventReceiver> receivers = new HashMap<String, HTTPEventReceiver>();
    transient Map<String, HTTPEventRequestConsumer> requestConsumers = new HashMap<String, HTTPEventRequestConsumer>();
    transient Map<String, HTTPSLSession> slSessions = new ConcurrentHashMap<String, HTTPSLSession>();
    transient Set<String> boundEvents = Collections.synchronizedSet(new LinkedHashSet());
    transient Map<String, HTTPServiceAccessor> serviceAccessors = new HashMap<String, HTTPServiceAccessor>();
    transient Map<String, HTTPDataspaceAccessor> dataspaceAccessors = new HashMap<String, HTTPDataspaceAccessor>();
    transient FabricEventListener exceptionListener;
    transient HTTPEventFactory eventFactory = new HTTPEventFactory(this);
    transient SLFileMessageProcessor slFileMessageProcessor = new SLFileMessageProcessor();
    transient SLAudioMessageProcessor slAudioMessageProcessor = new SLAudioMessageProcessor();
    static transient HTTPClassLoader classLoader;
    transient ReverseCallableExecutor reverseCallableExecutor = new SingleFabricThreadReverseCallableExecutorWithMonitor();
    final transient ReentrantReadWriteLock reopenLock = new ReentrantReadWriteLock();
    final transient ReentrantReadWriteLock.WriteLock reopenWriteLock = this.reopenLock.writeLock();
    final transient ReentrantReadWriteLock.ReadLock reopenReadLock = this.reopenLock.readLock();
    volatile transient boolean isReopening = false;
    transient boolean serverConnectionLost = false;
    transient long serverConnectionLostStartTime = 0L;
    transient long serverConnectionRepairedTime = 0L;
    transient long reverseConnectionErrorsCount = 0L;
    transient long reverseConnectionErrorsCountLast = 0L;
    transient long reopenTime = 0L;
    transient long reopenCount = 0L;
    transient Exception reopenError = null;
    transient long reopenFailedTime = 0L;
    transient boolean reopenOnAnyCall = false;
    volatile transient MonitoredOperation currentReopenOperation = null;
    transient HTTPRequestsStatistics reverseRequests = new HTTPRequestsStatistics();
    transient HTTPRequestsStatistics isOpenedRequests = new HTTPRequestsStatistics();
    transient HTTPRequestsStatistics allRequests = new HTTPRequestsStatistics();
    final transient ReentrantLock stateListenersEventLock = new ReentrantLock();
    transient List<HTTPFabricConnectionStateEventListener> stateListeners = new CopyOnWriteArrayList<HTTPFabricConnectionStateEventListener>();
    static String IS_OPENED_INTERNAL;

    HTTPFabricConnection(FabricContext context, String type) {
        this.context = context;
        this.setType(type);
        try {
            HTTPClientUtils.addJavaAliases(this.aliasManager);
            HTTPClientUtils.addSysTypeAliases(this.aliasManager);
            HTTPClientUtils.realiasHttpAliases(this.aliasManager);
            this.serializer = this.createJSONSerializer("HTTPFabricConnection$Serializer");
        }
        catch (FactoryManagerException criticalError) {
            this.log(Trace.Level.ERROR, "Failed to initialize aliases and json serializer. Cause: {}", criticalError.getMessage());
            throw new HTTPFabricException("Critical exception: ", criticalError);
        }
        this.initClassLoader(context);
        this.slFileMessageProcessor.setSLMessageListener(new SLMessageListener(){

            @Override
            public void onMessage(SLMessage message) {
                try {
                    for (HTTPSLSession session : HTTPFabricConnection.this.slSessions.values()) {
                        if (session.slMessageListener == null || !session.getName().equals(message.getSLSessionName())) continue;
                        Trace.logDebug("Invoke " + String.valueOf(this.getClass()), session.getName() + " slang session message listener. Message: " + message.toString());
                        session.slMessageListener.onMessage(message);
                    }
                }
                catch (Throwable exception) {
                    Trace.logError(this, "Error while while processing " + String.valueOf(message) + ". Cause: " + exception.getMessage());
                }
            }
        });
        this.slAudioMessageProcessor.setSLMessageListener(new SLMessageListener(){

            @Override
            public void onMessage(SLMessage message) {
                try {
                    for (HTTPSLSession session : HTTPFabricConnection.this.slSessions.values()) {
                        if (session.slMessageListener == null || !session.getName().equals(message.getSLSessionName())) continue;
                        Trace.logDebug("Invoke " + String.valueOf(this.getClass()), session.getName() + " slang session message listener. Message: " + message.toString());
                        session.slMessageListener.onMessage(message);
                    }
                }
                catch (Throwable exception) {
                    Trace.logError(this, "Error while while processing " + String.valueOf(message) + ". Cause: " + exception.getMessage());
                }
            }
        });
    }

    public JSONSerializer.JsonSerializerBuilderImpl createJSONSerializerBuilder(String name) {
        return (JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)JSONSerializer.builder().setName(name)).setAliasManager(this.aliasManager)).setJsonNotation(JsonNotation.TYPE)).setJsonNotationLevel(HTTPUtils.JSON_NOTATITION_LEVEL_FOR_FABRIC.toArray(new JsonNotationLevel[0]))).addJsonNotationLevel(JsonNotationLevel.POLYMORPHIC_PRIMITIVE_OBJECTS);
    }

    public JSONSerializer createJSONSerializer(String name) {
        return this.createJSONSerializerBuilder(name).build();
    }

    public void setUseSeparateClassLoader(boolean useSeparateClassLoader) {
        try {
            if (useSeparateClassLoader || !JVM.is9()) {
                ClassLoader parent = Thread.currentThread().getContextClassLoader();
                classLoader = useSeparateClassLoader ? new HTTPClassLoader(new URLClassLoader(new URL[0], parent)) : new HTTPClassLoader(parent);
                this.serializer.setClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initClassLoader(FabricContext context) {
        try {
            if (JVM.is9()) {
                classLoader = context != null ? new HTTPClassLoader(context.getSystemClassLoaderChain(), context) : new HTTPClassLoader(new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader()));
                this.serializer.setClassLoader(classLoader);
            } else {
                classLoader = context != null ? new HTTPClassLoader(context.getSystemClassLoaderChain(), context) : new HTTPClassLoader();
                this.serializer.setClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ClassLoader getClassLoader() {
        return classLoader;
    }

    public long getReverseReplyTimeout() {
        return this.reverseReplyTimeoutMs;
    }

    public void setReverseReplyTimeout(long reverseReplyTimeoutMs) {
        this.reverseReplyTimeoutMs = reverseReplyTimeoutMs;
        this.log(Trace.Level.INFO, "reverseReplyTimeoutMs set to {} ms.", reverseReplyTimeoutMs);
    }

    public void setReverseConnectionHoldTimeout(long reverseConnectionHoldTimeoutMs) {
        if (this.leasePeriod != -1L && this.leasePeriod < reverseConnectionHoldTimeoutMs * 2L) {
            throw new HTTPFabricException("reverseConnectionHoldTimeoutMs should be less than leasePeriod at least two times.");
        }
        this.reverseConnectionHoldTimeoutMs = reverseConnectionHoldTimeoutMs;
        if (this.httpClientWrapper != null) {
            this.doSetReverseConnectionHoldTimeout(this.httpClientWrapper);
        } else {
            this.log(Trace.Level.INFO, "reverseConnectionHoldTimeoutMs set to {} ms.", this.reverseConnectionHoldTimeoutMs);
        }
        this.reverseReplyTimeoutMs = this.reverseConnectionHoldTimeoutMs + 2000L;
    }

    public long getReverseConnectionHoldTimeout() {
        return this.reverseConnectionHoldTimeoutMs;
    }

    private void doSetReverseConnectionHoldTimeout(HTTPClientWrapper client) {
        try {
            this.invokeRemoteCall(client, "setReverseConnectionHoldTimeout", new Object[]{this.reverseConnectionHoldTimeoutMs}, null);
            Object timeout = this.invokeRemoteCall(client, "getReverseConnectionHoldTimeout", new Object[0], null);
            HTTPFabricConnection.processServerAnswer(timeout, Number.class);
            this.reverseConnectionHoldTimeoutMs = ((Number)timeout).intValue();
            this.log(Trace.Level.INFO, "reverseConnectionHoldTimeoutMs set to {} ms.", this.reverseConnectionHoldTimeoutMs);
        }
        catch (Exception exception) {
            this.reverseConnectionHoldTimeoutMs = this.leasePeriod / 2L;
            this.reverseReplyTimeoutMs = 5000L;
            this.log(Trace.Level.INFO, "Failed to set reverseConnectionHoldTimeoutMs on server, set it to " + this.reverseConnectionHoldTimeoutMs, new Object[0]);
        }
        if (this.reverseReplyTimeoutMs > this.reverseConnectionHoldTimeoutMs + 2000L) {
            this.reverseReplyTimeoutMs = this.reverseConnectionHoldTimeoutMs + 2000L;
            this.log(Trace.Level.INFO, "reverseReplyTimeoutMs set to {} ms.", this.reverseReplyTimeoutMs);
        }
    }

    public long getHttpTimeout() {
        return this.httpTimeoutMs;
    }

    public void setHttpTimeout(int httpTimeoutMs) {
        if (httpTimeoutMs < 0) {
            httpTimeoutMs = 0;
        }
        this.httpTimeoutMs = httpTimeoutMs;
        if (this.httpClientWrapper != null) {
            this.httpClientWrapper.getHttpClient().setTimeout(httpTimeoutMs);
        }
        if (httpTimeoutMs == 0) {
            Trace.logInfo(this, "WARNING: http fabric connection {} httpTimeoutMs is set to 0, set fileTransfersDirectConsumersTimeoutMs to 20 mins.", this.getName());
            this.setFileTransfersDirectConsumersTimeout(1200000L);
        } else {
            this.setFileTransfersDirectConsumersTimeout(httpTimeoutMs * 2 / 3);
        }
        this.log(Trace.Level.INFO, "httpTimeoutMs set to {} ms.", this.httpTimeoutMs);
    }

    public long getFileTransfersDirectConsumersTimeout() {
        return this.fileTransfersDirectConsumersTimeoutMs;
    }

    public void setFileTransfersDirectConsumersTimeout(long fileTransfersDirectConsumersTimeoutMs) {
        if (this.httpTimeoutMs > 0L && fileTransfersDirectConsumersTimeoutMs > this.httpTimeoutMs) {
            throw new HTTPFabricException("File transfer timeout should be less than http.");
        }
        this.fileTransfersDirectConsumersTimeoutMs = fileTransfersDirectConsumersTimeoutMs;
        if (this.httpClientWrapper != null) {
            this.doSetFileTransfersDirectRequestsTimeout(this.httpClientWrapper);
        }
        this.log(Trace.Level.INFO, "fileTransfersDirectConsumersTimeoutMs set to {} ms.", this.fileTransfersDirectConsumersTimeoutMs);
    }

    private void doSetFileTransfersDirectRequestsTimeout(HTTPClientWrapper wrapper) {
        this.invokeRemoteCall(wrapper, "setFileTransfersDirectConsumersTimeout", new Object[]{this.fileTransfersDirectConsumersTimeoutMs}, null);
        Object timeout = this.invokeRemoteCall(wrapper, "getFileTransfersDirectConsumersTimeout", new Object[0], null);
        HTTPFabricConnection.processServerAnswer(timeout, Number.class);
        if (this.fileTransfersDirectConsumersTimeoutMs != (long)((Number)timeout).intValue()) {
            throw new HTTPFabricException("Failed to set file transfer timeout on server.");
        }
        if (this.httpTimeoutMs > 0L && this.fileTransfersDirectConsumersTimeoutMs > this.httpTimeoutMs) {
            throw new HTTPFabricException("File transfer timeout should be less than http.");
        }
    }

    public void setAsyncConsumerAndSLMessageTimeoutsForReverseMonitorMs(long asyncConsumerAndSLMessageTimeoutsForReverseMonitorMs) {
        this.asyncConsumerAndSLMessageTimeoutsForReverseMonitorMs = asyncConsumerAndSLMessageTimeoutsForReverseMonitorMs;
    }

    public long getAsyncConsumerAndSLMessageTimeoutsForReverseMonitorMs() {
        return this.asyncConsumerAndSLMessageTimeoutsForReverseMonitorMs;
    }

    public void enableReverseThreadMonitor(boolean enabled) {
        if (this.isOpened) {
            throw new HTTPFabricException("Reverse thread monitor can be enabled/disabled on not opened connection only.");
        }
        this.reverseCallableExecutor = enabled ? new SingleFabricThreadReverseCallableExecutorWithMonitor() : new SingleFabricThreadReverseCallableExecutor();
    }

    public long getLeasePeriod() {
        return this.leasePeriod;
    }

    public void setLeasePeriod(long leasePeriod) {
        if (leasePeriod == -1L && this.isOpened()) {
            leasePeriod = this.sessionTimeout;
        }
        if (leasePeriod != -1L && leasePeriod < this.reverseConnectionHoldTimeoutMs * 2L) {
            throw new HTTPFabricException("leasePeriod should be greater than reverseConnectionHoldTimeoutMs at least two times. Call setReverseConnectionHoldTimeout() first.");
        }
        this.leasePeriod = leasePeriod;
        if (this.httpClientWrapper != null) {
            this.invokeRemoteCall(this.httpClientWrapper, "setLeasePeriod", new Object[]{leasePeriod}, null);
            try {
                Object timeout = this.invokeRemoteCall(this.httpClientWrapper, "getReverseConnectionHoldTimeout", new Object[0], null);
                HTTPFabricConnection.processServerAnswer(timeout, Number.class);
                if (this.reverseConnectionHoldTimeoutMs != (long)((Number)timeout).intValue()) {
                    this.reverseConnectionHoldTimeoutMs = ((Number)timeout).intValue();
                    this.log(Trace.Level.ERROR, "reverseConnectionHoldTimeoutMs was updated on server to {} ms", this.reverseConnectionHoldTimeoutMs);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log(Trace.Level.INFO, "leasePeriod set to {} ms.", this.leasePeriod);
    }

    public void setMaxRetriesCount(int maxRetriesCount) {
        if (maxRetriesCount <= 0) {
            maxRetriesCount = 1;
        }
        this.maxRetriesCount = maxRetriesCount;
    }

    public int getMaxRetriesCount() {
        return this.maxRetriesCount;
    }

    public void setReopenOnAnyCall(boolean reopenOnAnyCall) {
        this.reopenOnAnyCall = reopenOnAnyCall;
    }

    public boolean isReopenOnAnyCall() {
        return this.reopenOnAnyCall;
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public long getTimestamp() {
        return this.creationTime;
    }

    @Override
    public void open() throws HTTPFabricException {
        this.reopenWriteLock.lock();
        try {
            if (this.isOpened) {
                throw new HTTPFabricException("Connection already opened. Close first.");
            }
            if (this.userName == null) {
                throw new HTTPFabricException("Null user name specified.");
            }
            this.log(Trace.Level.DEBUG, "Opening connection...", new Object[0]);
            this.resetStatistics();
            this.openInternal();
            this.isOpened = true;
            this.openTime = System.currentTimeMillis();
            this.onStateChange(HTTPFabricConnectionState.OPENED);
            this.doSetFileTransfersDirectRequestsTimeout(this.httpClientWrapper);
            this.doSetReverseConnectionHoldTimeout(this.httpClientWrapper);
            this.createSLFileRequestConsumer();
            this.createSLAudioRequestConsumer();
            this.log(Trace.Level.INFO, "Connection opened. httpTimeoutMs: {} ms, leasePeriod: {} ms, fileTransfersDirectConsumersTimeoutMs: {} ms, reverseReplyTimeoutMs: {} ms, reverseConnectionHoldTimeoutMs: {} ms", this.httpTimeoutMs, this.leasePeriod, this.fileTransfersDirectConsumersTimeoutMs, this.reverseReplyTimeoutMs, this.reverseConnectionHoldTimeoutMs);
            this.startReverseConnectionThread();
        }
        finally {
            if (!this.isOpened && this.httpClientWrapper != null) {
                this.httpClientWrapper.closeQuiet();
                this.httpClientWrapper = null;
            }
            this.reopenWriteLock.unlock();
        }
    }

    @Override
    public void open(long timeout) throws FabricConnectionException, SecurityManagerException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    private void resetStatistics() {
        this.serverConnectionLostStartTime = 0L;
        this.serverConnectionRepairedTime = 0L;
        this.reverseConnectionErrorsCount = 0L;
        this.reverseConnectionErrorsCountLast = 0L;
        this.reopenTime = 0L;
        this.reopenCount = 0L;
        this.reopenFailedTime = 0L;
        this.reopenError = null;
        this.isOpenedRequests = new HTTPRequestsStatistics();
        this.allRequests = new HTTPRequestsStatistics();
        this.reverseRequests = new HTTPRequestsStatistics();
    }

    private void openInternal() {
        HTTPServerFabricConnectionInfo openedConnection = this.connect();
        this.component = openedConnection.component;
        this.sessionId = openedConnection.sessionId;
        this.clientId = openedConnection.clientId;
        this.leasePeriod = openedConnection.leasePeriod;
        this.sessionTimeout = openedConnection.sessionTimeout;
        this.creationTime = openedConnection.creationTime;
        this.lastAccessTime = openedConnection.lastAccessTime;
        this.openLinkMode = openedConnection.openLinkMode;
        this.closeLinkMode = openedConnection.closeLinkMode;
        this.hostTimezone = TimeZone.getTimeZone(openedConnection.hostTimezone);
        this.nodeTimezone = TimeZone.getTimeZone(openedConnection.nodeTimezone);
        if (this.sessionId == null || this.sessionId.length() == 0 || this.sessionId.equals("null")) {
            this.httpClientWrapper.closeQuiet();
            this.httpClientWrapper = null;
            this.component = new HTTPClientComponent();
            this.sessionId = "";
            throw new HTTPFabricException("Opening HTTP connection failed, sessionId is null, please retry again.");
        }
    }

    private HTTPServerFabricConnectionInfo connect() throws HTTPFabricException {
        HTTPServerFabricConnectionInfo result = null;
        HTTPFabricException connectingException = null;
        for (String url : this.urls) {
            try {
                this.log(Trace.Level.INFO, "Connecting to '{}'...", url);
                result = this.doConnect(url);
                this.url = url;
            }
            catch (HTTPFabricException exception) {
                this.log(Trace.Level.INFO, "Connecting to '{}' failed. Cause: {}", url, exception.getMessage());
                connectingException = exception;
            }
        }
        if (result == null) {
            throw connectingException;
        }
        return result;
    }

    private HTTPServerFabricConnectionInfo doConnect(String url) throws HTTPFabricException {
        Object result;
        Object[] args;
        byte[] data;
        if (this.httpClientWrapper != null) {
            this.httpClientWrapper.lock();
            try {
                this.httpClientWrapper.replaceClient(this.createHttpClientWrapper(url).getHttpClient());
                this.httpClientWrapper.url = url;
            }
            finally {
                this.httpClientWrapper.unlock();
            }
        } else {
            this.httpClientWrapper = this.createHttpClientWrapper(url);
        }
        if ((data = this.invoke("open", args = new Object[]{this.componentParams.name, this.componentParams.type, this.componentParams.description, this.clientId, this.componentParams.eventScope, this.leasePeriod, this.openLinkMode}, "login")) == null) {
            throw new HTTPFabricException("Empty answer from server for 'open()' call.");
        }
        try {
            result = this.serializer.deserialize(data);
        }
        catch (IAbstractExceptionEvent criticalJsonError) {
            this.log(Trace.Level.ERROR, "Deserialization of answer from server failed. Cause: {}", criticalJsonError.getMessage());
            throw new HTTPFabricException("Deserialization of answer from server failed.", criticalJsonError);
        }
        HTTPFabricConnection.processServerAnswer(result, HTTPServerFabricConnectionInfo.class);
        if (result == null) {
            throw new HTTPFabricException("No answer from server for 'open()' call.");
        }
        return (HTTPServerFabricConnectionInfo)result;
    }

    private void setCurrentReopenOperation(String name, long timeout) {
        this.currentReopenOperation = new MonitoredOperation(name, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reopen(boolean withLock) {
        if (!withLock || withLock && this.reopenWriteLock.tryLock()) {
            try {
                this.setCurrentReopenOperation("Reopen: open internal.", this.getHttpTimeout() + 2000L);
                if (!this.isOpened) {
                    throw new HTTPFabricException("Connection closed.");
                }
                this.isReopening = true;
                this.onStateChange(HTTPFabricConnectionState.REOPEN_START);
                this.log(Trace.Level.INFO, "Reopening connection.", new Object[0]);
                this.sessionId = null;
                try {
                    this.openInternal();
                }
                catch (Exception exception) {
                    if (this.sessionId == null) {
                        this.reopenError = exception;
                        this.onStateChange(HTTPFabricConnectionState.REOPEN_FAILED, exception);
                        throw exception;
                    }
                    this.reopenFailed(exception);
                }
                this.setCurrentReopenOperation("Reopen: set transfer direct request timeouts.", this.getHttpTimeout() + 2000L);
                try {
                    this.doSetFileTransfersDirectRequestsTimeout(this.httpClientWrapper);
                }
                catch (Exception exception) {
                    this.reopenFailed(exception);
                }
                this.setCurrentReopenOperation("Reopen: set reverse connection hold timeouts.", this.getHttpTimeout() + 2000L);
                try {
                    this.doSetReverseConnectionHoldTimeout(this.httpClientWrapper);
                }
                catch (Exception exception) {
                    this.reopenFailed(exception);
                }
                this.setCurrentReopenOperation("Reopen: create sl file/audio request consumer..", this.getHttpTimeout() + 2000L);
                try {
                    this.requestConsumers.remove(SLFileMessage.getRequestConsumerName());
                    this.createSLFileRequestConsumer();
                    this.requestConsumers.remove(SLAudioMessage.getRequestConsumerName());
                    this.createSLAudioRequestConsumer();
                }
                catch (Exception exception) {
                    this.reopenFailed(exception);
                }
                Consumer<Runnable> reopen = r -> {
                    try {
                        this.setCurrentReopenOperation("Reopen: " + String.valueOf(r), 2L * this.getHttpTimeout() + 2000L);
                        r.run();
                    }
                    catch (Exception exception) {
                        this.reopenFailed(exception);
                        this.checkNotOpenedAndThrowOnReopen();
                    }
                };
                this.log(Trace.Level.INFO, "Rebinding events.", new Object[0]);
                for (String string : this.boundEvents) {
                    reopen.accept(() -> this.bindProducerFor(eventId));
                }
                this.log(Trace.Level.INFO, "Recreating slang sessions.", new Object[0]);
                for (HTTPSLSession hTTPSLSession : this.slSessions.values()) {
                    reopen.accept(hTTPSLSession::reopen);
                }
                this.log(Trace.Level.INFO, "Recreating direct event consumers.", new Object[0]);
                for (HTTPEventConsumer hTTPEventConsumer : this.directConsumers.values()) {
                    reopen.accept(hTTPEventConsumer::open);
                }
                this.log(Trace.Level.INFO, "Recreating async event consumers.", new Object[0]);
                for (HTTPEventAsyncConsumer hTTPEventAsyncConsumer : this.asyncConsumers.values()) {
                    reopen.accept(hTTPEventAsyncConsumer::open);
                }
                this.log(Trace.Level.INFO, "Recreating receivers.", new Object[0]);
                for (HTTPEventReceiver hTTPEventReceiver : this.receivers.values()) {
                    reopen.accept(hTTPEventReceiver::open);
                }
                this.log(Trace.Level.INFO, "Recreating request consumers.", new Object[0]);
                this.requestConsumers.values().stream().filter(consumer -> !SLFileMessage.getRequestConsumerName().equals(consumer.getName()) && !SLAudioMessage.getRequestConsumerName().equals(consumer.getName())).forEach(consumer -> reopen.accept(consumer::open));
                this.log(Trace.Level.INFO, "Recreating service accessors.", new Object[0]);
                for (HTTPServiceAccessor hTTPServiceAccessor : this.serviceAccessors.values()) {
                    reopen.accept(hTTPServiceAccessor::open);
                }
                this.log(Trace.Level.INFO, "Recreating dataspace accessors.", new Object[0]);
                for (HTTPDataspaceAccessor hTTPDataspaceAccessor : this.dataspaceAccessors.values()) {
                    reopen.accept(hTTPDataspaceAccessor::open);
                }
                this.log(Trace.Level.INFO, "Connection reopened. httpTimeoutMs: {} ms, leasePeriod: {} ms, fileTransfersDirectConsumersTimeoutMs: {} ms, reverseReplyTimeoutMs: {} ms, reverseConnectionHoldTimeoutMs: {} ms", this.httpTimeoutMs, this.leasePeriod, this.fileTransfersDirectConsumersTimeoutMs, this.reverseReplyTimeoutMs, this.reverseConnectionHoldTimeoutMs);
                this.isReopening = false;
                this.reopenTime = System.currentTimeMillis();
                ++this.reopenCount;
                this.onStateChange(HTTPFabricConnectionState.REOPEN_END);
                this.checkNotOpenedAndThrowOnReopen();
            }
            finally {
                this.currentReopenOperation = null;
                this.isReopening = false;
                if (withLock) {
                    this.reopenWriteLock.unlock();
                }
            }
            return true;
        }
        return false;
    }

    private void checkNotOpenedAndThrowOnReopen() {
        if (!this.isOpened) {
            this.isOpened = true;
            this.closeInternal(1L);
            throw new HTTPFabricException("Connection closed.");
        }
    }

    protected void reopenAction(RunnableException r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            this.reopenFailed(exception);
        }
    }

    protected void reopenFailed(Exception exception) {
        this.log(Trace.Level.ERROR, "Reopen exception: " + exception.getMessage(), new Object[0]);
        if (this.sessionId != null && this.sessionId.length() != 0) {
            this.closeSession();
            this.sessionId = "xxx";
        }
        this.reopenFailedTime = System.currentTimeMillis();
        this.reopenError = exception;
        this.onStateChange(HTTPFabricConnectionState.REOPEN_FAILED, exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new HTTPFabricException("Reopen failed.", exception);
    }

    private void closeSession() {
        if (this.sessionId != null && this.sessionId.length() != 0 && this.url != null) {
            try {
                HTTPClientWrapper wrapper = this.createHttpClientWrapper(5000L);
                HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
                call.pushMethodCall(new RemoteMethodCall("close", new Object[0]));
                byte[] callbytes = (MAGIC + this.serializer.serialize(call)).getBytes();
                String query = this.makeFabricUrl("logout");
                long startTime = System.currentTimeMillis();
                try {
                    HTTPClientResponse response = wrapper.getHttpClient().Post(query, callbytes);
                    response.getStatusCode();
                    response.getData();
                    wrapper.closeQuiet();
                }
                catch (Exception e) {
                    Runnable runnable = () -> {
                        while (System.currentTimeMillis() - startTime < this.getLeasePeriod()) {
                            try {
                                HTTPClientResponse response = wrapper.getHttpClient().Post(query, callbytes);
                                response.getStatusCode();
                                response.getData();
                                break;
                            }
                            catch (Exception response) {
                                if (Thread.interrupted()) break;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                    break;
                                }
                            }
                        }
                        wrapper.closeQuiet();
                    };
                    FabricThreadManager.getInstance().createDaemonThread("HTTP:FabricConnection.FailedOpenConnectionClose", "Closing unsuccessful opened connection...", runnable).start();
                }
            }
            catch (Exception exception) {
                this.log(Trace.Level.ERROR, "Closing session failed.", new Object[0]);
                Trace.logException(this, exception, true);
            }
        }
    }

    @Override
    protected void checkNotOpened() throws HTTPFabricException {
        if (this.isOpened) {
            throw new HTTPFabricException("Connection '" + this.getFullName() + "' is opened.");
        }
    }

    protected void checkOpened() throws HTTPFabricException {
        if (!this.isOpened) {
            throw new HTTPFabricException("Connection '" + this.getFullName() + "' is not opened.");
        }
    }

    @Override
    public void close() throws HTTPFabricException {
        this.closeInternal(2000L);
    }

    @Override
    public void close(long timeout) throws HTTPFabricException {
        if (timeout > 0L) {
            this.closeInternal(2000L, new Object[]{timeout});
        } else {
            this.forceClose();
        }
    }

    private void closeInternal(long reverseThreadTimeout) throws HTTPFabricException {
        this.closeInternal(reverseThreadTimeout, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(long reverseThreadTimeout, Object[] args) throws HTTPFabricException {
        block9: {
            try {
                if (!this.isOpened) break block9;
                this.log(Trace.Level.INFO, "Closing connection.", new Object[0]);
                this.isOpened = false;
                this.reopenWriteLock.lock();
                try {
                    this.isOpened = false;
                    try {
                        this.invokeRemoteCall("close", args, "logout");
                    }
                    catch (Exception e) {
                        this.log(Trace.Level.DEBUG, e.getMessage(), new Object[0]);
                    }
                    this.httpClientWrapper.closeQuiet();
                    this.httpClientWrapper = null;
                    if (reverseThreadTimeout > 0L) {
                        this.reverseCallableExecutor.finish(reverseThreadTimeout);
                    }
                    this.boundEvents.clear();
                    this.directConsumers.clear();
                    this.asyncConsumers.clear();
                    this.receivers.clear();
                    this.requestConsumers.clear();
                    this.serviceAccessors.clear();
                    this.dataspaceAccessors.clear();
                    this.slSessions.clear();
                    this.slFileMessageProcessor.close();
                    this.slAudioMessageProcessor.close();
                    this.component = new HTTPClientComponent();
                    this.sessionId = "";
                }
                finally {
                    this.reopenWriteLock.unlock();
                }
            }
            finally {
                this.onStateChange(HTTPFabricConnectionState.CLOSED);
            }
        }
    }

    private void closeInternalQuiet() throws HTTPFabricException {
        try {
            this.closeInternal(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeQuiet() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceClose() throws HTTPFabricException {
        block8: {
            try {
                if (!this.isOpened) break block8;
                this.log(Trace.Level.DEBUG, "Force close connection.", new Object[0]);
                this.isOpened = false;
                this.reopenWriteLock.lock();
                try {
                    this.isOpened = false;
                    Object[] args = new Object[]{};
                    try {
                        this.invokeRemoteCall("forceClose", args, "logout");
                    }
                    catch (Exception e) {
                        this.log(Trace.Level.DEBUG, e.getMessage(), new Object[0]);
                    }
                    this.httpClientWrapper.closeQuiet();
                    this.httpClientWrapper = null;
                    this.reverseCallableExecutor.finish(2000L);
                    this.boundEvents.clear();
                    this.directConsumers.clear();
                    this.asyncConsumers.clear();
                    this.receivers.clear();
                    this.requestConsumers.clear();
                    this.serviceAccessors.clear();
                    this.dataspaceAccessors.clear();
                    this.slSessions.clear();
                    this.slFileMessageProcessor.close();
                    this.slAudioMessageProcessor.close();
                    this.component = new HTTPClientComponent();
                    this.sessionId = "";
                }
                finally {
                    this.reopenWriteLock.unlock();
                }
            }
            finally {
                this.onStateChange(HTTPFabricConnectionState.CLOSED);
            }
        }
    }

    protected void closeSLFiles(String slSessionName) {
        this.slFileMessageProcessor.close(slSessionName);
    }

    protected void closeSLAudio(String slSessionName) {
        this.slAudioMessageProcessor.close(slSessionName);
    }

    private boolean isNetworkError(Throwable exception) {
        if (exception instanceof HTTPFabricException) {
            exception = exception.getCause();
        }
        return exception instanceof IOException || exception instanceof ModuleException;
    }

    @Override
    public ClientId getClientId() {
        return this.clientId;
    }

    @Override
    public String getDescription() {
        if (this.isOpened) {
            return this.component.description;
        }
        return this.componentParams.description;
    }

    @Override
    public EventScope getEventScope() {
        if (this.isOpened) {
            return this.componentParams.eventScope;
        }
        return this.component.eventScope;
    }

    @Override
    public FabricAddress getFabricAddress() throws HTTPFabricException {
        this.checkOpened();
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return this.component.fabricAddress;
    }

    @Override
    public String getName() {
        if (this.isOpened) {
            return this.component.name;
        }
        return this.componentParams.name;
    }

    @Override
    public String getType() {
        if (this.isOpened) {
            return this.component.type;
        }
        return this.componentParams.type;
    }

    String getFullName() {
        if (this.isOpened) {
            return ModeratorUtils.makeComponentFullName(this.component.type, this.component.name);
        }
        return ModeratorUtils.makeComponentFullName(this.componentParams.type, this.componentParams.name);
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setClientId(ClientId clientId) throws HTTPFabricException {
        this.setName(clientId.toString());
        this.clientId = clientId;
    }

    @Override
    public void setDescription(String description) throws HTTPFabricException {
        this.checkNotOpened();
        HTTPFabricConnection.checkDescription(description);
        this.componentParams.description = description;
    }

    @Override
    public void setEventScope(EventScope eventScope) throws HTTPFabricException {
        this.checkNotOpened();
        this.componentParams.eventScope = eventScope;
    }

    @Override
    public void setName(String name) throws HTTPFabricException {
        this.doSetName(name, false);
    }

    @Override
    protected void doSetName(String name) {
        this.componentParams.name = name;
    }

    @Override
    public void addURL(String url) throws HTTPFabricException {
        this.checkNotOpened();
        if (!this.urls.contains(url)) {
            this.urls.add(url);
        }
    }

    @Override
    public void removeURL(String url) throws HTTPFabricException {
        this.checkNotOpened();
        this.urls.remove(url);
    }

    @Override
    public List<String> getURLs() {
        return new ArrayList<String>(this.urls);
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public long getConnectionReopenInterval() {
        return this.connectionReopenInterval;
    }

    public void setConnectionReopenInterval(long connectionReopenInterval) {
        this.connectionReopenInterval = connectionReopenInterval;
    }

    @Override
    public boolean isReconnecting() {
        return this.isOpened && (this.serverConnectionLost || this.isReopening || this.reopenFailedTime > this.reopenTime);
    }

    public void setType(String type) {
        this.checkNotOpened();
        this.componentParams.type = type;
    }

    @Override
    public void setUserName(String user) throws HTTPFabricException {
        this.checkNotOpened();
        this.userName = user;
    }

    @Override
    public void setPassword(String password) throws HTTPFabricException {
        this.checkNotOpened();
        this.userPassword = password;
    }

    @Override
    public void setSecurityToken(String token) throws FabricConnectionException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    public void addSemanticType(Class<?> typeClass) throws FactoryManagerException {
        HTTPClientUtils.addAlias(typeClass, this.aliasManager);
    }

    public ObjectMediationAliasManager getAliasManager() {
        return this.aliasManager;
    }

    public HTTPEventFactory getEventFactory() {
        return this.eventFactory;
    }

    @Override
    public void acknowledgeEvent(EventDatagram event, boolean withSourceData, AcknowledgeAction action, String recipientId, EventScope eventScope, long timeToLive) throws HTTPFabricException {
        Object[] args = new Object[]{event, withSourceData, action, recipientId, eventScope, timeToLive};
        this.invokeRemoteCall("acknowledgeEvent", args);
    }

    @Override
    public void acknowledgeException(ExceptionEventDatagram ex, AcknowledgeAction action, String recipientId, EventScope eventScope, long timeToLive) throws HTTPFabricException {
        Object[] args = new Object[]{ex, action, recipientId, eventScope, timeToLive};
        this.invokeRemoteCall("acknowledgeException", args);
    }

    @Override
    public void addEventCache(String eventFilter, int maxSize, CacheThresholdAction thresholdAction) throws HTTPFabricException {
        Object[] args = new Object[]{eventFilter, maxSize, thresholdAction};
        this.invokeRemoteCall("addEventCache", args);
    }

    @Override
    public void bindProducerFor(String eventId) throws HTTPFabricException {
        Object[] args = new Object[]{eventId};
        this.invokeRemoteCall("bindProducerFor", args);
        this.boundEvents.add(eventId);
    }

    @Override
    public DomainConstraint createDomainConstraint(String domainName, String description, Set<Object> values) throws HTTPFabricException {
        Object[] args = new Object[]{domainName, description, values};
        Object result = this.invokeRemoteCall("createDomainConstraint", args);
        HTTPFabricConnection.processServerAnswer(result, DomainConstraint.class);
        return (DomainConstraint)result;
    }

    @Override
    public RangeConstraint createRangeConstraint(String rangeName, String description, Object minValue, Object maxValue) throws HTTPFabricException {
        Object[] args = new Object[]{rangeName, description, minValue, maxValue};
        Object result = this.invokeRemoteCall("createRangeConstraint", args);
        HTTPFabricConnection.processServerAnswer(result, RangeConstraint.class);
        return (RangeConstraint)result;
    }

    @Override
    public HTTPEventAsyncConsumer createEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws HTTPFabricException {
        if (!(listener instanceof HTTPListener)) {
            final FabricEventListener l = listener;
            listener = new HTTPListener(this){

                @Override
                public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
                    l.onEvent(event);
                }
            };
        }
        HTTPEventAsyncConsumer consumer = new HTTPEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, this);
        consumer.open();
        return consumer;
    }

    @Override
    public HTTPEventConsumer createEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws HTTPFabricException {
        if (!(listener instanceof HTTPListener)) {
            final FabricEventListener l = listener;
            listener = new HTTPListener(this){

                @Override
                public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
                    l.onEvent(event);
                }
            };
        }
        HTTPEventConsumer consumer = new HTTPEventConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, this);
        consumer.open();
        return consumer;
    }

    @Override
    public EventReceiver createEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws HTTPFabricException {
        HTTPEventReceiver receiver = new HTTPEventReceiver(receiverName, eventFilter, eventSelector, eventScope, noLocal, this);
        receiver.open();
        return receiver;
    }

    @Override
    public SLSession createSLSession() throws HTTPFabricException {
        this.checkOpened();
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return new HTTPSLSession(this);
    }

    @Override
    public SLSession createSLSession(String nodeName) throws HTTPFabricException {
        this.checkOpened();
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return new HTTPSLSession(this, nodeName);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String serviceType, String serviceName) throws HTTPFabricException {
        return this.createServiceAccessor(null, serviceType, serviceName);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String nodeName, String serviceType, String serviceName) throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return new HTTPServiceAccessor(nodeName, serviceType, serviceName, this);
    }

    @Override
    public void dropConsumer(String consumerName) throws HTTPFabricException {
        if (this.directConsumers.containsKey(consumerName)) {
            this.directConsumers.remove(consumerName);
        } else if (this.asyncConsumers.containsKey(consumerName)) {
            this.asyncConsumers.remove(consumerName);
        } else if (this.requestConsumers.containsKey(consumerName)) {
            this.requestConsumers.remove(consumerName);
        }
        Object[] args = new Object[]{consumerName};
        this.invokeRemoteCall("dropConsumer", args);
    }

    @Override
    public void dropDomainConstraint(String domainName) throws HTTPFabricException {
        Object[] args = new Object[]{domainName};
        this.invokeRemoteCall("dropDomainConstraint", args);
    }

    @Override
    public void dropRangeConstraint(String rangeName) throws HTTPFabricException {
        Object[] args = new Object[]{rangeName};
        this.invokeRemoteCall("dropRangeConstraint", args);
    }

    @Override
    public void dropEventAsyncConsumer(String consumerName) throws HTTPFabricException {
        this.asyncConsumers.remove(consumerName);
        Object[] args = new Object[]{consumerName};
        this.invokeRemoteCall("dropEventAsyncConsumer", args);
    }

    @Override
    public void dropEventConsumer(String consumerName) throws HTTPFabricException {
        this.directConsumers.remove(consumerName);
        Object[] args = new Object[]{consumerName};
        this.invokeRemoteCall("dropEventConsumer", args);
    }

    @Override
    public void dropEventReceiver(String receiverName) throws HTTPFabricException {
        this.receivers.remove(receiverName);
        Object[] args = new Object[]{receiverName};
        this.invokeRemoteCall("dropEventReceiver", args);
    }

    @Override
    public AuthenticationType getAuthenticationType() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invokeRemoteCall("getAuthenticationType", args);
        HTTPFabricConnection.processServerAnswer(result, AuthenticationType.class);
        return (AuthenticationType)((Object)result);
    }

    @Override
    public DomainConstraint getDomainConstraint(String domainName) throws HTTPFabricException {
        Object[] args = new Object[]{domainName};
        Object result = this.invokeRemoteCall("getDomainConstraint", args);
        HTTPFabricConnection.processServerAnswer(result, DomainConstraint.class);
        return (DomainConstraint)result;
    }

    @Override
    public RangeConstraint getRangeConstraint(String rangeName) throws HTTPFabricException {
        Object[] args = new Object[]{rangeName};
        Object result = this.invokeRemoteCall("getRangeConstraint", args);
        HTTPFabricConnection.processServerAnswer(result, RangeConstraint.class);
        return (RangeConstraint)result;
    }

    @Override
    public EventAsyncConsumer getEventAsyncConsumer(String consumerName) {
        return this.asyncConsumers.get(consumerName);
    }

    @Override
    public EventConsumer getEventConsumer(String consumerName) {
        return this.directConsumers.get(consumerName);
    }

    @Override
    public EventReceiver getEventReceiver(String receiverName) {
        return this.receivers.get(receiverName);
    }

    @Override
    public Moderator getModerator() throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return new HTTPModerator(this);
    }

    @Override
    public ComponentReference getComponentReference() throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return new HTTPComponentReferenceConnection(this);
    }

    @Override
    public SecurityManager getSecurityManager() throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return new HTTPSecurityManager(this);
    }

    @Override
    public boolean hasBoundEventIds() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invokeRemoteCall("hasBoundEventIds", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean isBoundEventId(String eventId) throws HTTPFabricException {
        Object[] args = new Object[]{eventId};
        Object result = this.invokeRemoteCall("isBoundEventId", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean isSecurityEnabled() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invokeRemoteCall("isSecurityEnabled", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listBoundEventIds() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invokeRemoteCall("listBoundEventIds", args);
        HTTPFabricConnection.processServerAnswer(result, Object.class);
        return new ArrayList<Object>(Arrays.asList((Object[])result));
    }

    @Override
    public ExceptionStrategy getExceptionStrategy() throws FabricConnectionException {
        Object[] args = new Object[]{};
        Object result = this.invokeRemoteCall("getExceptionStrategy", args);
        HTTPFabricConnection.processServerAnswer(result, ExceptionStrategy.class);
        return (ExceptionStrategy)((Object)result);
    }

    @Override
    public void setExceptionStrategy(ExceptionStrategy exceptionStrategy) throws FabricConnectionException {
        Object[] args = new Object[]{exceptionStrategy};
        this.invokeRemoteCall("setExceptionStrategy", args);
    }

    @Override
    public List<String> listEventAsyncConsumers() throws HTTPFabricException {
        return new ArrayList<String>(this.asyncConsumers.keySet());
    }

    @Override
    public List<String> listEventConsumers() throws HTTPFabricException {
        return new ArrayList<String>(this.directConsumers.keySet());
    }

    @Override
    public List<String> listEventReceivers() throws HTTPFabricException {
        return new ArrayList<String>(this.receivers.keySet());
    }

    @Override
    public PingResult ping() {
        try {
            Object result = this.executeAnonymousCall("ping", new Object[0]);
            if (result instanceof PingResult) {
                return (PingResult)result;
            }
        }
        catch (HTTPFabricException hTTPFabricException) {
            // empty catch block
        }
        return new PingResult(PingState.UNAVAILABLE);
    }

    @Override
    public void raiseAcknowledgement(AcknowledgementEvent event, EventScope eventScope, long timeToLive) throws HTTPFabricException {
        Object[] args = new Object[]{event, eventScope, timeToLive};
        this.invokeRemoteCall("raiseAcknowledgement", args);
    }

    @Override
    public void raiseAdvisory(AdvisoryEventDatagram event, EventScope eventScope) throws HTTPFabricException {
        Object[] args = new Object[]{event, eventScope};
        this.invokeRemoteCall("raiseAdvisory", args);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive) throws HTTPFabricException {
        Object[] args = new Object[]{event, eventScope, timeToLive};
        this.invokeRemoteCall("raiseEvent", args);
    }

    @Override
    public void raiseException(ExceptionEventDatagram event, EventScope eventScope) throws HTTPFabricException {
        Object[] args = new Object[]{event, eventScope};
        this.invokeRemoteCall("raiseException", args);
    }

    public ImmutableEventDatagram raiseRequest(String consumerName, ImmutableEventDatagram request, long timeout) throws HTTPFabricException {
        Object[] args = new Object[]{consumerName, request, timeout};
        Object result = this.invokeRemoteCall("raiseRequest", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public ImmutableEventDatagram raiseRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout) throws HTTPFabricException {
        return this.raiseRequest(consumer.getName(), request, timeout);
    }

    @Override
    public AcknowledgementEvent raiseRequest(EventDatagram request, EventScope eventScope, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws HTTPFabricException {
        Object[] args = new Object[]{request, eventScope, distributionStrategy, matchStrategy, timeout};
        Object result = this.invokeRemoteCall("raiseRequest", args);
        HTTPFabricConnection.processServerAnswer(result, AcknowledgementEvent.class);
        return (AcknowledgementEvent)result;
    }

    @Override
    public void removeEventCache(String eventFilter) throws HTTPFabricException {
        Object[] args = new Object[]{eventFilter};
        this.invokeRemoteCall("removeEventCache", args);
    }

    @Override
    public EventCache getEventCache(String eventFilter) throws FabricConnectionException {
        if (this.component.eventScope == EventScope.LOCAL || this.component.eventScope == EventScope.OBSERVABLE) {
            throw new HTTPFabricException("Connection has local LOCAL or OBSERVABLE event scope.");
        }
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getEventCache", new Object[]{eventFilter}));
        call.setPostprocessorMethodCall(RemoteMethodCallPostprocessor.IS_NULL);
        Object result = this.invokeRemoteCall(call, null);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        if (result != null && !((Boolean)result).booleanValue()) {
            return new HTTPEventCache(eventFilter, this);
        }
        return null;
    }

    @Override
    public void setDomainConstraint(DomainConstraint domain) throws HTTPFabricException {
        Object[] args = new Object[]{domain};
        this.invokeRemoteCall("setDomainConstraint", args);
    }

    @Override
    public void setRangeConstraint(RangeConstraint range) throws HTTPFabricException, FabricEventDispatcherException {
        Object[] args = new Object[]{range};
        this.invokeRemoteCall("setRangeConstraint", args);
    }

    @Override
    public void unbindProducerFor(String eventId) throws HTTPFabricException {
        this.boundEvents.remove(eventId);
        Object[] args = new Object[]{eventId};
        this.invokeRemoteCall("unbindProducerFor", args);
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(DataspaceType dataspaceType, String dataspaceName) throws HTTPFabricException {
        return this.createDataspaceAccessor(null, dataspaceType, dataspaceName);
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName) throws HTTPFabricException {
        this.checkOpened();
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        return new HTTPDataspaceAccessor(nodeName, dataspaceType, dataspaceName, this);
    }

    @Override
    public List<String> listRequestConsumers() throws HTTPFabricException {
        return new ArrayList<String>(this.requestConsumers.keySet());
    }

    @Override
    public EventRequestConsumer getRequestConsumer(String consumerName) throws HTTPFabricException {
        return this.requestConsumers.get(consumerName);
    }

    @Override
    public EventRequestConsumer createRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope) throws HTTPFabricException {
        HTTPEventRequestConsumer consumer = new HTTPEventRequestConsumer(consumerName, listener, eventScope, this);
        consumer.open();
        return consumer;
    }

    @Override
    public void dropRequestConsumer(String consumerName) throws HTTPFabricException {
        this.requestConsumers.remove(consumerName);
        Object[] args = new Object[]{consumerName};
        this.invokeRemoteCall("dropRequestConsumer", args);
    }

    @Override
    public RepositoryAccessor getRepositoryAccessor() throws HTTPFabricException {
        return this.getRepositoryAccessor(null);
    }

    @Override
    public RepositoryAccessor getRepositoryAccessor(String nodeName) throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            return null;
        }
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getRepositoryAccessor", new Object[]{nodeName}));
        call.setPostprocessorMethodCall(RemoteMethodCallPostprocessor.IS_NULL);
        Object result = this.invokeRemoteCall(call, null);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        if (result != null && !((Boolean)result).booleanValue()) {
            return new HTTPRepositoryAccessor(nodeName, this);
        }
        throw new HTTPFabricException("Node with name '" + nodeName + "' not found.");
    }

    static <T> T processServerAnswer(Object answer, Class<T> expectedClass) throws HTTPFabricException {
        if (answer != null && !expectedClass.isAssignableFrom(answer.getClass())) {
            if (answer instanceof HTTPClientException) {
                throw new HTTPFabricException((HTTPClientException)answer);
            }
            if (Trace.isDebugEnabled(HTTPFabricConnection.class.getName())) {
                Trace.logDebug(HTTPFabricConnection.class, "Wrong answer: " + String.valueOf(answer));
            }
            throw new HTTPFabricException("Unexpected answer from server: class = " + answer.getClass().getName() + ", expected = " + expectedClass.getName() + ".");
        }
        return (T)answer;
    }

    static byte[] processServerByteArrayAnswer(Object answer) {
        if (answer == null) {
            return null;
        }
        if (answer instanceof HTTPClientException) {
            throw new HTTPFabricException((HTTPClientException)answer);
        }
        if (answer.getClass() == byte[].class) {
            return (byte[])answer;
        }
        if (answer.getClass() == String.class) {
            return Base64.decode((String)answer);
        }
        throw new HTTPFabricException("Unexpected answer from server: class = " + String.valueOf(answer.getClass()) + ", expected byte[] or String.");
    }

    Object invokeRemoteCall(String methodName, Object[] args) throws HTTPFabricException {
        return this.invokeRemoteCall(this.httpClientWrapper, methodName, args, null);
    }

    Object invokeRemoteCall(String methodName, Object[] args, String query) throws HTTPFabricException {
        return this.invokeRemoteCall(this.httpClientWrapper, methodName, args, query);
    }

    Object invokeRemoteCall(HTTPClientWrapper wrapper, String methodName, Object[] args, String query) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.invokeRemoteCall(wrapper, call, query);
    }

    Object invokeRemoteCall(HTTPFabricConnectionRemoteCall call, String query) throws HTTPFabricException {
        return this.invokeRemoteCall(call, query, null);
    }

    Object invokeRemoteCall(HTTPFabricConnectionRemoteCall call, String query, Class<?> resultClazz) throws HTTPFabricException {
        return this.invokeRemoteCall(this.httpClientWrapper, call, query, resultClazz);
    }

    Object invokeRemoteCall(HTTPClientWrapper wrapper, HTTPFabricConnectionRemoteCall call, String query) throws HTTPFabricException {
        return this.invokeRemoteCall(wrapper, call, query, null);
    }

    Object invokeRemoteCall(HTTPClientWrapper wrapper, HTTPFabricConnectionRemoteCall call, String query, long timeout) throws HTTPFabricException {
        return this.invokeRemoteCall(wrapper, call, query, null, timeout);
    }

    Object invokeRemoteCall(HTTPClientWrapper wrapper, HTTPFabricConnectionRemoteCall call, String query, Class<?> resultClazz) throws HTTPFabricException {
        return this.invokeRemoteCall(wrapper, call, query, resultClazz, -1L);
    }

    Object invokeRemoteCall(HTTPClientWrapper wrapper, HTTPFabricConnectionRemoteCall call, String query, Class<?> resultClazz, long timeout) throws HTTPFabricException {
        return this.deserializeResponse(this.invoke(wrapper, call, query, timeout), resultClazz);
    }

    protected byte[] invoke(String methodName, Object[] args, String query) throws HTTPFabricException {
        return this.invoke(this.httpClientWrapper, methodName, args, query, -1L);
    }

    protected byte[] invoke(String methodName, Object[] args, String query, long timeout) throws HTTPFabricException {
        return this.invoke(this.httpClientWrapper, methodName, args, query, timeout);
    }

    protected byte[] invoke(HTTPClientWrapper wrapper, String methodName, Object[] args, String query, long timeout) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.invoke(wrapper, call, query, timeout);
    }

    protected byte[] invoke(HTTPFabricConnectionRemoteCall call, String query) throws HTTPFabricException {
        return this.invoke(this.httpClientWrapper, call, query, -1L);
    }

    protected byte[] invoke(HTTPClientWrapper wrapper, HTTPFabricConnectionRemoteCall call, String query, long timeout) throws HTTPFabricException {
        return this.invoke(wrapper, call, query, timeout, this.maxRetriesCount);
    }

    private boolean isOpenCall(HTTPFabricConnectionRemoteCall call) {
        return call != null && call.getMethodCallsCount() == 1 && call.getMethodCall(0).getMethodName().equals("open");
    }

    private boolean isIsOpenedCall(HTTPFabricConnectionRemoteCall call) {
        return call != null && call.getMethodCallsCount() == 1 && call.getMethodCall(0).getMethodName().equals("isOpened");
    }

    private boolean isIsOpenedInternalCall(HTTPFabricConnectionRemoteCall call) {
        if (call != null && call.getMethodCallsCount() == 1 && call.getMethodCall(0).getMethodName().equals(IS_OPENED_INTERNAL)) {
            call.getMethodCall(0).updateMethodName("isOpened");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] invoke(HTTPClientWrapper wrapper, HTTPFabricConnectionRemoteCall call, String query, long timeout, int retriesCount) throws HTTPFabricException {
        boolean needReopenReadLock = true;
        if (!this.reopenReadLock.tryLock()) {
            throw new HTTPFabricException("Fabric connection reopening is in progress...");
        }
        try {
            if (this.isReopening && !this.isOpenCall(call) && !this.reopenWriteLock.isHeldByCurrentThread()) {
                throw new HTTPFabricException("Fabric connection reopening is in progress...");
            }
            byte[] data = null;
            String fabricUrl = this.makeFabricUrl(query);
            boolean isIsOpenedInternalCall = this.isIsOpenedInternalCall(call);
            boolean isIsOpenedCall = this.isIsOpenedCall(call);
            try {
                long oldTimeout;
                block62: {
                    if (wrapper == null) {
                        wrapper = this.httpClientWrapper;
                    }
                    if (wrapper == null) throw new HTTPFabricException("Connection '" + this.getFullName() + "' is not opened.");
                    if (wrapper.getHttpClient() == null) {
                        throw new HTTPFabricException("Connection '" + this.getFullName() + "' is not opened.");
                    }
                    String callString = MAGIC + this.serializer.serialize(call);
                    wrapper.lock();
                    oldTimeout = -1L;
                    if (timeout != -1L) {
                        oldTimeout = wrapper.getHttpClient().getTimeout();
                        wrapper.getHttpClient().setTimeout(timeout);
                    }
                    int retry = 0;
                    IOException httpException = null;
                    HTTPClientResponse response = null;
                    while (retry < retriesCount) {
                        this.log(Trace.Level.DEBUG, "Posting to {}{}, retry {}/{}, request data {}.", wrapper.url, fabricUrl, ++retry, retriesCount, this.cutForLog(callString));
                        long startRequestTime = System.currentTimeMillis();
                        this.allRequests.incRequestsCount();
                        this.allRequests.addBytesSent(fabricUrl.length() + callString.length());
                        if (isIsOpenedCall) {
                            this.isOpenedRequests.incRequestsCount();
                            this.isOpenedRequests.addBytesSent(fabricUrl.length() + callString.length());
                        }
                        try {
                            response = wrapper.getHttpClient().Post(fabricUrl, callString);
                        }
                        catch (Exception exception) {
                            this.allRequests.incExceptionResponsesCount();
                            if (!isIsOpenedCall) throw exception;
                            this.isOpenedRequests.incExceptionResponsesCount();
                            throw exception;
                        }
                        try {
                            data = response.getData();
                            break;
                        }
                        catch (SocketTimeoutException exception) {
                            this.log(Trace.Level.DEBUG, "Socket timeout exception caught on {}, retry {}/{} after {} ms, on {}. Reopen http client and rethrow exception.", fabricUrl, retry, retriesCount, System.currentTimeMillis() - startRequestTime, wrapper == this.httpClientWrapper ? "main client" : "not main client");
                            this.allRequests.incTimeoutResponsesCount();
                            if (isIsOpenedCall) {
                                this.isOpenedRequests.incTimeoutResponsesCount();
                            }
                            try {
                                this.replaceClient(wrapper, wrapper.url);
                                throw exception;
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            throw exception;
                        }
                        catch (IOException exception) {
                            httpException = exception;
                            this.log(Trace.Level.DEBUG, "IO exception caught on {}, retry {}/{} after {} ms, on {}. Reopen connection and {}.", fabricUrl, retry, retriesCount, System.currentTimeMillis() - startRequestTime, wrapper == this.httpClientWrapper ? "main client" : "not main client", retry >= retriesCount ? "throw exception " : "resend request");
                            this.allRequests.incExceptionResponsesCount();
                            if (isIsOpenedCall) {
                                this.isOpenedRequests.incExceptionResponsesCount();
                            }
                            this.replaceClient(wrapper, wrapper.url);
                            if (retry >= retriesCount) {
                                throw exception;
                            }
                            this.allRequests.intRetriesCount();
                            if (!isIsOpenedCall) continue;
                            this.isOpenedRequests.intRetriesCount();
                        }
                        catch (Exception exception) {
                            this.allRequests.incExceptionResponsesCount();
                            if (!isIsOpenedCall) throw exception;
                            this.isOpenedRequests.incExceptionResponsesCount();
                            throw exception;
                        }
                    }
                    if (response.getStatusCode() == 200) {
                        this.allRequests.incSuccessfulResponsesCount();
                        if (isIsOpenedCall) {
                            this.isOpenedRequests.incSuccessfulResponsesCount();
                        }
                    } else if (response.getStatusCode() == 401) {
                        this.allRequests.incUnauthorizedResponsesCount();
                        if (isIsOpenedCall) {
                            this.isOpenedRequests.incUnauthorizedResponsesCount();
                        }
                    } else {
                        this.allRequests.incErrorResponsesCount();
                        if (isIsOpenedCall) {
                            this.isOpenedRequests.incErrorResponsesCount();
                        }
                    }
                    if (data != null) {
                        this.allRequests.addBytesReceived(data.length);
                        if (isIsOpenedCall) {
                            this.isOpenedRequests.addBytesReceived(data.length);
                        }
                    }
                    if (Arrays.equals(data, JsonExchangeServlet.REQUEST_ALREADY_PROCESSED)) {
                        this.allRequests.incDuplicateResponsesCount();
                        if (isIsOpenedCall) {
                            this.isOpenedRequests.incDuplicateResponsesCount();
                        }
                        if (httpException != null) throw httpException;
                        httpException = new IOException("Request already processed.");
                        throw httpException;
                    }
                    if (response.getStatusCode() != 200) {
                        String string;
                        if (Trace.isDebugEnabled(this.getClass().getName())) {
                            this.log(Trace.Level.DEBUG, "HTTP request url: {}{}", wrapper.url, fabricUrl);
                            this.log(Trace.Level.DEBUG, "HTTP request userName: {}", this.userName);
                            this.log(Trace.Level.DEBUG, "HTTP request data: {}", this.cutForLog(callString));
                            this.log(Trace.Level.DEBUG, "HTTP response status: {}", response.getStatusCode());
                            this.log(Trace.Level.DEBUG, "HTTP response content length: {}", data != null ? Integer.valueOf(data.length) : null);
                            this.log(Trace.Level.DEBUG, "HTTP response content: {}", data != null ? new String(this.cutForLog(data)) : null);
                        }
                        if (response.getStatusCode() == 401) {
                            if (!this.isOpened) {
                                String string2;
                                if (StringUtils.isEmpty(response.getReasonLine())) {
                                    string2 = "Authentication failed.";
                                    throw new HTTPFabricException(string2);
                                }
                                string2 = response.getReasonLine();
                                throw new HTTPFabricException(string2);
                            }
                            if (this.isReopening) {
                                String string3;
                                if (!this.isOpenCall(call)) throw new HTTPFabricException("Fabric connection lost. Reopening is in progress.");
                                if (StringUtils.isEmpty(response.getReasonLine())) {
                                    string3 = "Authentication failed.";
                                    throw new HTTPFabricException(string3);
                                }
                                string3 = response.getReasonLine();
                                throw new HTTPFabricException(string3);
                            }
                            this.log(Trace.Level.ERROR, "Server responded with status 401(unauthorized). It means that session is not valid or expired. It can be caused by acceptor or node restart.", new Object[0]);
                            if (this.isReopenOnAnyCall() || isIsOpenedInternalCall) {
                                long reopenTimeOld = this.reopenTime;
                                this.reopenReadLock.unlock();
                                if (!this.reopenWriteLock.tryLock()) {
                                    needReopenReadLock = false;
                                    throw new HTTPFabricException("Fabric connection lost. Reopening is in progress.");
                                }
                                try {
                                    if (this.reopenTime == reopenTimeOld) {
                                        this.reopen(false);
                                    }
                                }
                                finally {
                                    this.reopenReadLock.lock();
                                    this.reopenWriteLock.unlock();
                                }
                                this.replaceClient(wrapper, this.url);
                                byte[] byArray = this.invoke(wrapper, call, query, timeout, retriesCount);
                                if (timeout != -1L && wrapper.getHttpClient() != null) {
                                    wrapper.getHttpClient().setTimeout(oldTimeout);
                                }
                                wrapper.unlock();
                                return byArray;
                            }
                            throw new HTTPFabricException("Fabric connection lost. Waiting for reconnection...");
                        }
                        int n = response.getStatusCode();
                        if (data != null) {
                            string = new String(this.cutForLog(data));
                            throw new HTTPFabricException("Error http response received. Status " + n + ". Data: " + string + ".");
                        }
                        string = null;
                        throw new HTTPFabricException("Error http response received. Status " + n + ". Data: " + string + ".");
                    }
                    if (data != null && data.length != 0) break block62;
                    byte[] byArray = null;
                    if (timeout != -1L && wrapper.getHttpClient() != null) {
                        wrapper.getHttpClient().setTimeout(oldTimeout);
                    }
                    wrapper.unlock();
                    return byArray;
                    {
                        catch (Throwable throwable) {
                            if (timeout != -1L && wrapper.getHttpClient() != null) {
                                wrapper.getHttpClient().setTimeout(oldTimeout);
                            }
                            wrapper.unlock();
                            throw throwable;
                        }
                    }
                }
                if (timeout != -1L && wrapper.getHttpClient() != null) {
                    wrapper.getHttpClient().setTimeout(oldTimeout);
                }
                wrapper.unlock();
            }
            catch (IOException exception) {
                this.log(Trace.Level.ERROR, "Failed to execute http request to {}. Error {}", fabricUrl, exception.getMessage());
                throw new HTTPFabricException(exception);
            }
            catch (Exception exception) {
                if (exception instanceof HTTPFabricException) {
                    throw (HTTPFabricException)exception;
                }
                this.log(Trace.Level.ERROR, "Failed to execute http request to {}. Error {}", fabricUrl, exception.getMessage());
                throw new HTTPFabricException(exception.toString(), exception);
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (needReopenReadLock) {
                this.reopenReadLock.unlock();
            }
        }
    }

    private void replaceClient(HTTPClientWrapper wrapper, String url) {
        HTTPClient newClient = this.createHttpClientWrapper(url, wrapper.getHttpClient().getTimeout(), false).getHttpClient();
        wrapper.replaceClient(newClient);
        wrapper.url = url;
    }

    private byte[] cutForLog(byte[] data) {
        if (data != null && data.length > 1000) {
            byte[] begin = Arrays.copyOf(data, 1000);
            byte[] end = Arrays.copyOfRange(data, data.length - 100, data.length);
            byte[] middle = "\n.....\n.....\n".getBytes();
            data = Arrays.copyOf(begin, begin.length + end.length + middle.length);
            System.arraycopy(middle, 0, data, begin.length, middle.length);
            System.arraycopy(end, 0, data, begin.length + middle.length, end.length);
        }
        return data;
    }

    private String cutForLog(String data) {
        if (data != null && ((String)data).length() > 1150) {
            data = ((String)data).substring(0, 1000) + "\n.....\n.....\n" + ((String)data).substring(((String)data).length() - 100);
        }
        return data;
    }

    protected Object deserializeResponse(byte[] data) throws HTTPFabricException {
        return this.deserializeResponse(data, null);
    }

    protected Object deserializeResponse(byte[] data, Class<?> clazz) throws HTTPFabricException {
        Object returnedObject;
        block4: {
            if (data == null) {
                return null;
            }
            returnedObject = null;
            this.eventFactory.setCurrentThreadFactory();
            try {
                returnedObject = clazz != null ? this.serializer.deserialize(clazz, data) : this.serializer.deserialize(data);
            }
            catch (Throwable exception) {
                this.eventFactory.unsetCurrentThreadFactory();
                if (returnedObject != null) break block4;
                this.log(Trace.Level.ERROR, "Failed to deserialize answer from server of size {} bytes. Cause: {}.\n", data.length, exception.getMessage(), new String(this.cutForLog(data)));
                throw new HTTPFabricException("Failed to deserialize answer from server: " + exception.getMessage(), exception);
            }
        }
        if (returnedObject instanceof HTTPClientException) {
            HTTPClientException exception = (HTTPClientException)returnedObject;
            throw new HTTPFabricException(exception.getCause() != null ? exception.getCause() : exception);
        }
        return returnedObject;
    }

    protected String makeFabricUrl(String query) {
        StringBuilder builder = new StringBuilder();
        builder.append(FABRIC_URL).append("?");
        if (query != null) {
            builder.append(query).append('&');
        }
        if (this.isOpened || query != null && query.equals("logout")) {
            builder.append(FABRIC_SESSION).append("=").append(this.sessionId != null ? this.sessionId : "").append("&");
        }
        builder.append("unique").append("=").append(this.unique.incrementAndGet());
        return builder.toString();
    }

    protected HTTPClientWrapper createHttpClientWrapper() throws HTTPFabricException {
        return this.createHttpClientWrapper(this.url);
    }

    protected HTTPClientWrapper createHttpClientWrapper(String url) throws HTTPFabricException {
        return this.createHttpClientWrapper(url, this.httpTimeoutMs, false);
    }

    protected HTTPClientWrapper createAnonymousHttpClientWrapper(String url) throws HTTPFabricException {
        return this.createHttpClientWrapper(url, this.httpTimeoutMs, true);
    }

    protected HTTPClientWrapper createHttpClientWrapper(long timeout) throws HTTPFabricException {
        return this.createHttpClientWrapper(this.url, timeout, false);
    }

    protected HTTPClientWrapper createHttpClientWrapper(String url, long timeout, boolean anonymous) throws HTTPFabricException {
        LinkAddress linkAddress;
        try {
            if (url == null) {
                url = this.url;
            }
            linkAddress = new LinkAddress(url);
        }
        catch (FabricException exception) {
            throw new HTTPFabricException("Parsing URL '" + url + "' failed.", exception);
        }
        String host = linkAddress.getAddress().getHostString();
        int port = linkAddress.getAddress().getPort();
        return new HTTPClientWrapper(this.createHttpClient(host, port, timeout, anonymous), url);
    }

    protected HTTPClient createHttpClient(String host, int port, long timeout, boolean anonymous) throws HTTPFabricException {
        HTTPClient client = this.createHTTPClientObject(host, port);
        client.setTimeout((int)timeout);
        client.setAllowUserInteraction(false);
        client.setContext(new Object());
        String user = anonymous ? "anonymous" : this.userName;
        String password = anonymous ? "anonymous" : this.userPassword;
        client.addBasicAuthorization(FABRIC_REALM, user, password);
        client.addDigestAuthorization(FABRIC_REALM, user, password);
        return client;
    }

    protected HTTPClient createHTTPClientObject(String host, int port) throws HTTPFabricException {
        return new HTTPClient(host, port);
    }

    protected void startReverseConnectionThread() {
        this.reverseCallableExecutor.start(new ReverseRunnable());
    }

    @Override
    public FabricGroupManager getGroupManager() throws FabricConnectionException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public FabricGroupLink joinGroup(String groupName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void leaveGroup(String groupName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public FabricGroupLink getGroupLink(String groupName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public List<String> listGroups() throws FabricConnectionException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void setExceptionListener(FabricEventListener listener) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        if (listener != null) {
            if (this.exceptionListener != null) {
                this.dropConsumer("ExceptionListener");
            }
            this.exceptionListener = listener;
            this.createEventAsyncConsumer("ExceptionListener", this.exceptionListener, "exception.#", null, EventScope.INHERITED, false).start();
        } else if (this.exceptionListener != null) {
            this.exceptionListener = null;
            this.dropConsumer("ExceptionListener");
        }
    }

    @Override
    public FabricEventListener getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void exportExtensionArchive(File jarFile) throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL || this.component.eventScope == EventScope.OBSERVABLE) {
            throw new HTTPFabricException("Connection has local LOCAL or OBSERVABLE event scope.");
        }
        HTTPRepositoryAccessor repositoryAccessor = (HTTPRepositoryAccessor)this.getRepositoryAccessor();
        if (repositoryAccessor == null) {
            throw new HTTPFabricException("Obtaining repository accessor failed.");
        }
        repositoryAccessor.addExtensionArchive(jarFile);
    }

    @Override
    public void importExtensionArchive(String archiveName) throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            throw new HTTPFabricException("Connection has local LOCAL event scope.");
        }
        HTTPRepositoryAccessor repositoryAccessor = (HTTPRepositoryAccessor)this.getRepositoryAccessor();
        if (repositoryAccessor == null) {
            throw new HTTPFabricException("Obtaining repository accessor failed.");
        }
        if (!repositoryAccessor.existsExtensionArchive(archiveName)) {
            throw new HTTPFabricException("Extension archive '" + archiveName + "' does not exist.");
        }
        byte[] archiveContent = repositoryAccessor.getExtensionArchive(archiveName);
        try {
            classLoader.addArchive(archiveName, archiveContent, -1L);
        }
        catch (ArchiveException exception) {
            throw new HTTPFabricException("Adding archive to class loader failed.", exception);
        }
    }

    @Override
    public void importPackage(String packageName) throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            throw new HTTPFabricException("Connection has local LOCAL event scope.");
        }
        HTTPRepositoryAccessor repositoryAccessor = (HTTPRepositoryAccessor)this.getRepositoryAccessor();
        if (repositoryAccessor == null) {
            throw new HTTPFabricException("Obtaining repository accessor failed.");
        }
        if (!repositoryAccessor.existsPackage(packageName)) {
            throw new HTTPFabricException("Package '" + packageName + "' does not exist.");
        }
        Package pkg = repositoryAccessor.getPackage(packageName);
        HashMap<String, byte[]> archives = new HashMap<String, byte[]>();
        for (String archiveName : pkg.listJARs()) {
            if (!repositoryAccessor.existsArchive(archiveName)) {
                throw new HTTPFabricException("Archive '" + archiveName + "' does not exist.");
            }
            archives.put(archiveName, repositoryAccessor.getArchive(archiveName));
        }
        try {
            classLoader.addArchives(archives);
        }
        catch (ArchiveException exception) {
            throw new HTTPFabricException("Adding package archives to class loader failed.", exception);
        }
    }

    @Override
    public void exportSemanticType(String typeName) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void importSemanticType(String typeName) throws HTTPFabricException {
        if (this.component.eventScope == EventScope.LOCAL) {
            throw new HTTPFabricException("Connection has local LOCAL event scope.");
        }
        if (this.aliasManager.existsSemanticType(typeName)) {
            throw new HTTPFabricException("Semantic type '" + typeName + "' already exists.");
        }
        Object[] args = new Object[]{typeName, classLoader.getArchiveTimestamps()};
        Object result = this.invokeRemoteCall("invokeImportSemanticTypeRequest", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        this.doImportSemanticTypes((Object[])result);
    }

    @Override
    public void exportEventPrototype(String eventId) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void importEventPrototype(String eventId) throws FabricConnectionException, DatagramFactoryException {
        if (this.component.eventScope == EventScope.LOCAL || this.component.eventScope == EventScope.OBSERVABLE) {
            throw new HTTPFabricException("Connection has local LOCAL or OBSERVABLE event scope.");
        }
        this.invokeImportEventPrototypeRequest(eventId, classLoader.getArchiveTimestamps());
    }

    protected void invokeImportEventPrototypeRequest(String eventId, Map<String, Long> archiveTimestamps) {
        Object[] args = new Object[]{eventId, archiveTimestamps};
        Object result = this.invokeRemoteCall("invokeImportEventPrototypeRequest", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        if (result == null) {
            throw new HTTPFabricException("Wrong response received from node.");
        }
        Object[] objects = (Object[])result;
        if (objects.length < 2 || objects[0] == null) {
            throw new HTTPFabricException("Wrong response received from node.");
        }
        if (!(objects[0] instanceof Prototype)) {
            this.doImportSemanticTypes(objects);
            this.invokeImportEventPrototypeRequest(eventId, null);
        } else {
            this.doImportEventPrototypes(eventId, objects);
        }
    }

    protected void doImportSemanticTypes(Object[] objects) {
        if (objects == null) {
            throw new HTTPFabricException("Wrong response received from node.");
        }
        if (objects.length < 2 || objects[0] == null || objects[0].getClass() != Object[].class || objects[1] == null || !(objects[1] instanceof Map)) {
            throw new HTTPFabricException("Wrong response received from node.");
        }
        Map archives = (Map)objects[1];
        for (Map.Entry entry : ((Map)objects[1]).entrySet()) {
            if (!(entry.getKey() instanceof String) || entry.getValue().getClass() != Pair.class) {
                throw new HTTPFabricException("Wrong response received from node.");
            }
            try {
                Pair archiveData = (Pair)entry.getValue();
                classLoader.addArchive((String)entry.getKey(), HTTPFabricConnection.processServerByteArrayAnswer(archiveData.first), (Long)archiveData.second);
            }
            catch (ArchiveException exception) {
                throw new HTTPFabricException("Adding archive '" + String.valueOf(entry.getKey()) + "' to class loader failed. Cause: " + String.valueOf(exception));
            }
        }
        for (Object type : (Object[])objects[0]) {
            if (!(type instanceof SemanticType)) {
                throw new HTTPFabricException("Wrong response received from node.");
            }
            try {
                if (this.aliasManager.existsSemanticType(((SemanticType)type).getTypeName())) continue;
                this.aliasManager.alias((SemanticType)type);
            }
            catch (FactoryManagerException exception) {
                throw new HTTPFabricException("Importing semantic type '" + ((SemanticType)type).getTypeName() + "' failed.", exception);
            }
        }
    }

    protected void doImportEventPrototypes(String eventId, Object[] objects) {
        if (objects == null) {
            throw new HTTPFabricException("Wrong response received from node.");
        }
        if (objects.length < 2 || objects[0] == null || objects[0].getClass() != Prototype.class || objects[1] == null || !(objects[1] instanceof ImmutableEventDatagram)) {
            throw new HTTPFabricException("Wrong response received from node.");
        }
        Prototype prototype = (Prototype)objects[0];
        ImmutableEventDatagram event = (ImmutableEventDatagram)objects[1];
        this.eventFactory.addEventPrototype(eventId, event);
    }

    void putSLSession(String sessionName, HTTPSLSession slSession) {
        this.slSessions.put(sessionName, slSession);
    }

    void removeSLSession(String sessionName) {
        this.slSessions.remove(sessionName);
    }

    protected void checkException(byte[] data) throws HTTPFabricException {
        Object returnedObject;
        if (data == null) {
            throw new HTTPFabricException("Null server answer");
        }
        String dataString = new String(data);
        if (!dataString.contains("HTTPClientException")) {
            return;
        }
        try {
            returnedObject = this.serializer.deserialize(data);
        }
        catch (Throwable criticalJsonError) {
            this.log(Trace.Level.ERROR, "Failed to deserialize server answer: {}. Cause: {}", criticalJsonError.getMessage());
            throw new HTTPFabricException("Failed to deserialize server answer: " + new String(data), criticalJsonError);
        }
        if (returnedObject instanceof HTTPClientException) {
            throw new HTTPFabricException((HTTPClientException)returnedObject);
        }
        String className = returnedObject.getClass().getName();
        throw new HTTPFabricException("Unexpected server answer: class = " + className);
    }

    @Override
    public TimeZone getHostTimezone() throws FabricConnectionException {
        return this.hostTimezone;
    }

    @Override
    public TimeZone getNodeTimezone() throws FabricConnectionException {
        return this.nodeTimezone;
    }

    @Override
    public Charset getCCSID() throws FabricConnectionException {
        return null;
    }

    @Override
    public long nextGlobalCount() throws FabricConnectionException {
        Object result = this.invokeRemoteCall("nextGlobalCount", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Long.class);
        return (Long)result;
    }

    @Override
    public long showGlobalCounter() throws FabricConnectionException {
        Object result = this.invokeRemoteCall("showGlobalCounter", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Long.class);
        return (Long)result;
    }

    @Override
    public long resetGlobalCounter() throws FabricConnectionException {
        Object result = this.invokeRemoteCall("resetGlobalCounter", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Long.class);
        return (Long)result;
    }

    public String getRuntimeVersion() {
        Object result = this.executeAnonymousCall("getRuntimeVersion", new Object[0]);
        if (result instanceof Number) {
            result = result.toString();
        }
        return HTTPFabricConnection.processServerAnswer(result, String.class);
    }

    public String getSysplexDomain() {
        Object result = this.executeAnonymousCall("getSysplexDomain", new Object[0]);
        return HTTPFabricConnection.processServerAnswer(result, String.class);
    }

    public String getAcceptorName() {
        Object result = this.executeAnonymousCall("getAcceptorName", new Object[0]);
        return HTTPFabricConnection.processServerAnswer(result, String.class);
    }

    public List<String> listOrganizations() {
        Object result = this.executeAnonymousCall("listOrganizations", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        return new ArrayList<Object>(Arrays.asList((Object[])result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAnonymousCall(String methodName, Object[] args) {
        Object result;
        if (this.isOpened) {
            result = this.invokeRemoteCall(methodName, args);
        } else {
            String url = this.url;
            if (url == null) {
                if (this.urls == null || this.urls.size() == 0) {
                    throw new HTTPFabricException("Connection URL not set.");
                }
                url = this.urls.get(0);
            }
            HTTPClientWrapper wrapper = this.createAnonymousHttpClientWrapper(url);
            try {
                result = this.invokeRemoteCall(wrapper, methodName, args, "anonymous");
            }
            finally {
                wrapper.closeQuiet();
            }
        }
        return result;
    }

    public void log(Trace.Level level, String message, Object ... args) {
        if (!Trace.isEnabled(this.getClass(), level)) {
            return;
        }
        message = this.toString() + " " + (String)message;
        switch (level) {
            case DEBUG: {
                Trace.logDebug(this, (String)message, args);
                break;
            }
            case INFO: {
                Trace.logInfo(this, (String)message, args);
                break;
            }
            case ERROR: {
                Trace.logError(this, (String)message, args);
                break;
            }
            default: {
                Trace.logDebug(this, (String)message, args);
            }
        }
    }

    public String toString() {
        return "[ " + this.getName() + ", sessionId: " + this.sessionId + ", isOpened: " + this.isOpened + " ]";
    }

    public void setReverseCallableExecutor(ReverseCallableExecutor reverseCallableExecutor) {
        if (this.isOpened()) {
            throw new HTTPFabricException("Reverse callable executor cannot be set when connection is opened.");
        }
        this.reverseCallableExecutor = reverseCallableExecutor;
    }

    private EventRequestConsumer getSystemRequestConsumer(String consumerName) throws HTTPFabricException {
        return this.requestConsumers.get(consumerName);
    }

    private EventRequestConsumer createSystemRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope) throws HTTPFabricException {
        HTTPEventRequestConsumer consumer = new HTTPEventRequestConsumer(consumerName, listener, eventScope, this);
        Object[] args = new Object[]{consumerName, new HTTPEventListener(consumerName, true), eventScope};
        byte[] data = this.invoke("createSystemRequestConsumer", args, null);
        this.checkException(data);
        this.requestConsumers.put(consumerName, consumer);
        return consumer;
    }

    private void createSLFileRequestConsumer() {
        String fileRequestConsumerName = SLFileMessage.getRequestConsumerName();
        try {
            EventRequestConsumer requestConsumer = this.getSystemRequestConsumer(fileRequestConsumerName);
            if (requestConsumer == null) {
                this.createSystemRequestConsumer(fileRequestConsumerName, new SLFileMessageListener(this.slFileMessageProcessor, this), EventScope.INHERITED);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Creation of file request consumer '" + fileRequestConsumerName + "' for fabric connection '" + this.getName() + "' failed.");
        }
    }

    private void createSLAudioRequestConsumer() {
        String audioRequestConsumerName = SLAudioMessage.getRequestConsumerName();
        try {
            EventRequestConsumer requestConsumer = this.getSystemRequestConsumer(audioRequestConsumerName);
            if (requestConsumer == null) {
                this.createSystemRequestConsumer(audioRequestConsumerName, new SLAudioMessageListener(this.slAudioMessageProcessor, this), EventScope.INHERITED);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Creation of audio request consumer '" + audioRequestConsumerName + "' for fabric connection '" + this.getName() + "' failed.");
        }
    }

    private void fabricConnectionLost() {
        this.onStateChange(HTTPFabricConnectionState.FABRIC_CONNECTION_LOST);
        this.closeQuiet();
    }

    private void serverConnectionLost() {
        if (!this.serverConnectionLost) {
            this.serverConnectionLost = true;
            this.serverConnectionLostStartTime = System.currentTimeMillis();
            this.onStateChange(HTTPFabricConnectionState.SERVER_CONNECTION_LOST);
        }
    }

    private void serverConnectionRepaired() {
        if (this.serverConnectionLost) {
            this.serverConnectionLost = false;
            this.serverConnectionRepairedTime = System.currentTimeMillis();
            this.onStateChange(HTTPFabricConnectionState.SERVER_CONNECTION_REPAIRED);
        }
    }

    public void addStateEventListener(HTTPFabricConnectionStateEventListener listener) {
        this.stateListeners.add(listener);
    }

    public void removeStateEventListener(HTTPFabricConnectionStateEventListener listener) {
        this.stateListeners.remove(listener);
    }

    private void onStateChange(HTTPFabricConnectionState state) {
        this.onStateChange(state, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStateChange(HTTPFabricConnectionState state, Object params) {
        this.stateListenersEventLock.lock();
        try {
            HTTPFabricConnectionStateEvent stateEvent = new HTTPFabricConnectionStateEvent(state, params);
            for (HTTPFabricConnectionStateEventListener listener : this.stateListeners) {
                try {
                    listener.onStateEvent(stateEvent);
                }
                catch (Throwable exception) {
                    this.log(Trace.Level.ERROR, "On state change callback exception.", new Object[0]);
                    Trace.logException(this, exception, true);
                }
            }
        }
        finally {
            this.stateListenersEventLock.unlock();
        }
    }

    public HTTPStatistics getStatistics() {
        HTTPStatistics statistics = new HTTPStatistics();
        statistics.setOpened(this.isOpened());
        statistics.setOpenTime(this.openTime);
        statistics.setConnected(this.isOpened() && !this.isReconnecting());
        statistics.setLastServerConnectionLostTime(this.serverConnectionLostStartTime);
        statistics.setLastServerConnectionRepairedTime(this.serverConnectionRepairedTime);
        statistics.setLastReconnectRetries(this.reverseConnectionErrorsCountLast == 0L ? this.reverseConnectionErrorsCount : this.reverseConnectionErrorsCountLast);
        statistics.setLastReopenTime(this.reopenTime);
        statistics.setReopenCount(this.reopenCount);
        statistics.setLastReopenError(this.reopenError);
        statistics.setLastReopenFailedTime(this.reopenFailedTime);
        if (this.reopenFailedTime > this.reopenTime) {
            statistics.setNextReopenAt(this.reopenFailedTime + this.getConnectionReopenInterval() * 1000L);
        }
        statistics.setIsOpenedRequests(this.isOpenedRequests);
        statistics.setReverseRequests(this.reverseRequests);
        statistics.setAllRequests(this.allRequests);
        return statistics;
    }

    static {
        IS_OPENED_INTERNAL = "isOpenedInternal";
    }

    class SingleFabricThreadReverseCallableExecutorWithMonitor
    implements ReverseCallableExecutor {
        private FabricThread reverseConnectionThread;
        private ReverseRunnable reverseRunnable;
        private FabricThread reverseMonitorThread;
        private final AtomicLong index = new AtomicLong();
        private final ReentrantLock lock = new ReentrantLock();

        SingleFabricThreadReverseCallableExecutorWithMonitor() {
        }

        private void startReverseConnectionThread(Runnable runnable) {
            this.reverseRunnable = (ReverseRunnable)runnable;
            this.reverseConnectionThread = FabricThreadManager.getInstance().createDaemonThread("HTTP:FabricConnection.Reverse", "Reverse connection thread N" + this.index.incrementAndGet() + ".", this.reverseRunnable);
            this.reverseConnectionThread.start();
        }

        @Override
        public void start(Runnable runnable) {
            this.lock.lock();
            try {
                this.startReverseConnectionThread(runnable);
                this.reverseMonitorThread = FabricThreadManager.getInstance().createDaemonThread("HTTP:FabricConnection.ReverseMonitor", "Reverse connection monitor thread.", new ReverseMonitor());
                this.reverseMonitorThread.start();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(long timeout) {
            block9: {
                this.lock.lock();
                try {
                    if (this.reverseConnectionThread != null) {
                        try {
                            this.reverseConnectionThread.getResult(timeout);
                        }
                        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException exception) {
                            this.reverseConnectionThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.reverseConnectionThread = null;
                    }
                    if (this.reverseMonitorThread == null) break block9;
                    this.reverseMonitorThread.interrupt();
                    try {
                        this.reverseMonitorThread.getResult(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.reverseMonitorThread = null;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private class ReverseMonitor
        implements Runnable {
            private ReverseMonitor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HTTPFabricConnection.this.log(Trace.Level.INFO, "Starting reverse monitor thread.", new Object[0]);
                try {
                    while (HTTPFabricConnection.this.isOpened && SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseRunnable != null) {
                        try {
                            MonitoredOperation currentReverseOperation = SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseRunnable.currentReverseOperation;
                            if (currentReverseOperation != null && currentReverseOperation.isTimedOut()) {
                                boolean needToRerun = false;
                                if (HTTPFabricConnection.this.isReopening) {
                                    MonitoredOperation currentReopenOperation = HTTPFabricConnection.this.currentReopenOperation;
                                    if (currentReopenOperation != null && currentReopenOperation.isTimedOut()) {
                                        HTTPFabricConnection.this.log(Trace.Level.ERROR, "Reverse thread is executing operation '{}' started at '{}' timeout {}ms and being hung on reopen operation '{}' started at '{}' timeout {}ms.", currentReverseOperation.name, new Date(currentReverseOperation.startTime), currentReverseOperation.timeout, currentReopenOperation.name, new Date(currentReopenOperation.startTime), currentReopenOperation.timeout);
                                        needToRerun = true;
                                    }
                                } else {
                                    Thread.sleep(1000L);
                                    if (currentReverseOperation == SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseRunnable.currentReverseOperation && !HTTPFabricConnection.this.isReopening) {
                                        HTTPFabricConnection.this.log(Trace.Level.ERROR, "Reverse thread is being hung on operation '{}' started at '{}' timeout {}ms.", currentReverseOperation.name, new Date(currentReverseOperation.startTime), currentReverseOperation.timeout);
                                        needToRerun = true;
                                    }
                                }
                                if (needToRerun) {
                                    SingleFabricThreadReverseCallableExecutorWithMonitor.this.lock.lock();
                                    try {
                                        if (HTTPFabricConnection.this.isOpened) {
                                            if (SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseConnectionThread != null) {
                                                String stackTrace = Arrays.stream(Optional.ofNullable(SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseConnectionThread.getStackTrace()).orElse(new StackTraceElement[0])).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                                                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Reverse thread stack trace:\n{}", stackTrace);
                                                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Stopping hung reverse thread.", new Object[0]);
                                                SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseConnectionThread.interrupt();
                                                if (SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseRunnable != null) {
                                                    SingleFabricThreadReverseCallableExecutorWithMonitor.this.reverseRunnable.isInterrupted = true;
                                                }
                                            } else {
                                                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Reverse thread is null.", new Object[0]);
                                            }
                                            if (HTTPFabricConnection.this.isOpened) {
                                                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Starting new reverse thread.", new Object[0]);
                                                SingleFabricThreadReverseCallableExecutorWithMonitor.this.startReverseConnectionThread(new ReverseRunnable());
                                            }
                                        }
                                    }
                                    finally {
                                        SingleFabricThreadReverseCallableExecutorWithMonitor.this.lock.unlock();
                                    }
                                }
                            }
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException exception) {
                            HTTPFabricConnection.this.log(Trace.Level.INFO, "Reverse monitor thread interrupted.", new Object[0]);
                            Thread.currentThread().interrupt();
                            break;
                        }
                        catch (Exception exception) {
                            HTTPFabricConnection.this.log(Trace.Level.ERROR, "Reverse monitor thread exception: {}", exception.getMessage());
                            Trace.logException(this, exception, true);
                        }
                    }
                }
                finally {
                    HTTPFabricConnection.this.log(Trace.Level.INFO, "Reverse monitor thread finished.", new Object[0]);
                }
            }
        }
    }

    public static interface ReverseCallableExecutor {
        public void start(Runnable var1);

        public void finish(long var1);
    }

    private static class MonitoredOperation {
        private String name;
        private long timeout;
        private long startTime;

        MonitoredOperation(String name, long timeout) {
            this.name = name;
            this.timeout = timeout;
            this.startTime = System.currentTimeMillis();
        }

        public boolean isTimedOut() {
            return System.currentTimeMillis() - this.startTime > this.timeout;
        }
    }

    public static class HTTPClientWrapper {
        private HTTPClient httpClient;
        private String url;
        private final ReentrantLock lock = new ReentrantLock();

        public HTTPClientWrapper(HTTPClient httpClient, String url) {
            this.httpClient = httpClient;
            this.url = url;
        }

        public void replaceClient(HTTPClient httpClient) {
            HTTPClient oldClient = this.httpClient;
            this.httpClient = httpClient;
            this.closeQuiet(oldClient);
        }

        public HTTPClient getHttpClient() {
            return this.httpClient;
        }

        public void closeQuiet() {
            this.closeQuiet(this.httpClient);
            this.httpClient = null;
        }

        private void closeQuiet(HTTPClient client) {
            if (client != null) {
                try {
                    client.destory();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }
    }

    static class SingleFabricThreadReverseCallableExecutor
    implements ReverseCallableExecutor {
        private FabricThread reverseConnectionThread;

        SingleFabricThreadReverseCallableExecutor() {
        }

        @Override
        public void start(Runnable runnable) {
            this.reverseConnectionThread = FabricThreadManager.getInstance().createDaemonThread("HTTP:FabricConnection.Reverse", "Reverse connection thread.", runnable);
            this.reverseConnectionThread.start();
        }

        @Override
        public void finish(long timeout) {
            if (this.reverseConnectionThread != null) {
                try {
                    this.reverseConnectionThread.getResult(timeout);
                }
                catch (InterruptedException | CancellationException | ExecutionException | TimeoutException exception) {
                    this.reverseConnectionThread.interrupt();
                }
                this.reverseConnectionThread = null;
            }
        }
    }

    public static interface RunnableException {
        public void run() throws Exception;
    }

    private class ReverseRunnable
    implements Runnable {
        private HTTPClientWrapper reverseWrapper = null;
        private long reverseConnectionTimedOutFirstTime = 0L;
        private MonitoredOperation currentReverseOperation = null;
        private volatile boolean isInterrupted = false;

        private ReverseRunnable() {
        }

        private boolean isNotOpenedException(Exception exception) {
            if (exception instanceof HTTPFabricException && exception.getMessage().endsWith(" is not opened.")) {
                HTTPFabricConnection.this.log(Trace.Level.INFO, "WARNING: Connection not opened exception received, close fabric connection and stop reverse thread.", new Object[0]);
                HTTPFabricConnection.this.closeInternalQuiet();
                return true;
            }
            return false;
        }

        private void sleep(long startTime, long minTime) throws InterruptedException {
            long t = System.currentTimeMillis() - startTime;
            if (t < minTime) {
                HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Sleeping {} milliseconds...", minTime - t);
                Thread.sleep(minTime - t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isOpenedInternal() {
            HTTPClientWrapper wrapper = null;
            try {
                this.currentReverseOperation = new MonitoredOperation("Reverse: is opened internal request.", 30000L);
                wrapper = HTTPFabricConnection.this.createHttpClientWrapper(5000L);
                Object result = HTTPFabricConnection.this.invokeRemoteCall(wrapper, IS_OPENED_INTERNAL, new Object[0], null);
                boolean bl = HTTPFabricConnection.processServerAnswer(result, Boolean.class);
                return bl;
            }
            finally {
                if (wrapper != null) {
                    wrapper.closeQuiet();
                }
            }
        }

        private boolean reconnect() throws InterruptedException {
            if (HTTPFabricConnection.this.reverseConnectionErrorsCount == 0L) {
                return true;
            }
            if (HTTPFabricConnection.this.getReconnectAttempts() == 0 || HTTPFabricConnection.this.getReconnectAttempts() > 0 && HTTPFabricConnection.this.reverseConnectionErrorsCount > (long)HTTPFabricConnection.this.getReconnectAttempts()) {
                HTTPFabricConnection.this.log(Trace.Level.INFO, "Reconnect attempts {} limit reached. Closing connection.", HTTPFabricConnection.this.getReconnectAttempts());
                HTTPFabricConnection.this.fabricConnectionLost();
                return false;
            }
            if (HTTPFabricConnection.this.reverseConnectionErrorsCount > 1L) {
                long timeout = HTTPFabricConnection.this.getReconnectInterval();
                if (HTTPFabricConnection.this.reopenFailedTime > HTTPFabricConnection.this.reopenTime) {
                    timeout = HTTPFabricConnection.this.getConnectionReopenInterval();
                }
                this.currentReverseOperation = new MonitoredOperation("Reverse: sleeping for reconnect interval.", timeout * 1000L + 5000L);
                Thread.sleep(timeout * 1000L);
                this.currentReverseOperation = null;
            }
            if (!HTTPFabricConnection.this.isOpened) {
                return false;
            }
            try {
                HTTPFabricConnection.this.log(Trace.Level.INFO, "Reconnection attempt {}/{} ...", HTTPFabricConnection.this.reverseConnectionErrorsCount, HTTPFabricConnection.this.getReconnectAttempts());
                boolean isOpenedInternal = this.isOpenedInternal();
                if (isOpenedInternal) {
                    HTTPFabricConnection.this.log(Trace.Level.INFO, "Reconnect successful!", new Object[0]);
                    HTTPFabricConnection.this.reverseConnectionErrorsCountLast = HTTPFabricConnection.this.reverseConnectionErrorsCount;
                    HTTPFabricConnection.this.reverseConnectionErrorsCount = 0L;
                    HTTPFabricConnection.this.serverConnectionRepaired();
                    return true;
                }
                this.reverseConnectionTimedOutFirstTime = 0L;
                if (HTTPFabricConnection.this.isOpened) {
                    HTTPFabricConnection.this.log(Trace.Level.INFO, "Connection on server closed. Closing fabric connection.", new Object[0]);
                    HTTPFabricConnection.this.fabricConnectionLost();
                }
                return false;
            }
            catch (Exception exception) {
                this.reverseConnectionTimedOutFirstTime = 0L;
                if (Trace.isDebugEnabled(HTTPFabricConnection.class)) {
                    Trace.logException(this, exception, true);
                }
                if (this.isNotOpenedException(exception)) {
                    HTTPFabricConnection.this.log(Trace.Level.INFO, "Connection on server closed. Closing fabric connection.", new Object[0]);
                    HTTPFabricConnection.this.fabricConnectionLost();
                } else {
                    HTTPFabricConnection.this.serverConnectionLost();
                }
                HTTPFabricConnection.this.onStateChange(HTTPFabricConnectionState.RECONNECT_FAILED, exception);
                ++HTTPFabricConnection.this.reverseConnectionErrorsCount;
                HTTPFabricConnection.this.reverseConnectionErrorsCountLast = 0L;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            HTTPFabricConnection.this.log(Trace.Level.INFO, "Starting reverse connection thread.", new Object[0]);
            HTTPClientResponse reverseResponse = null;
            long postTime = 0L;
            long getStatusTime = 0L;
            try {
                while (HTTPFabricConnection.this.isOpened && !this.isInterrupted) {
                    if (this.isInterrupted || Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    this.currentReverseOperation = null;
                    if (!this.reconnect()) continue;
                    if (this.isInterrupted || Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    try {
                        this.currentReverseOperation = new MonitoredOperation("Reverse thread: post reverse request.", 2L * HTTPFabricConnection.this.getReverseReplyTimeout() + 5000L);
                        if (this.reverseWrapper == null) {
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Opening reverse connection...", new Object[0]);
                            this.reverseWrapper = this.createReverseClientWrapper();
                            reverseResponse = null;
                        }
                        if (reverseResponse == null) {
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Reverse connection...", new Object[0]);
                            String reverseUrl = HTTPFabricConnection.this.makeFabricUrl("reverse");
                            postTime = System.currentTimeMillis();
                            HTTPFabricConnection.this.reverseRequests.incRequestsCount();
                            HTTPFabricConnection.this.reverseRequests.addBytesSent(reverseUrl.length() + HTTPFabricConnection.MAGIC.length());
                            reverseResponse = this.reverseWrapper.getHttpClient().Post(reverseUrl, HTTPFabricConnection.MAGIC);
                        }
                        try {
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Getting reverse response status...", new Object[0]);
                            getStatusTime = System.currentTimeMillis();
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Getting reverse response data...", new Object[0]);
                            byte[] data = reverseResponse.getData();
                            if (data != null) {
                                HTTPFabricConnection.this.reverseRequests.addBytesReceived(data.length);
                            }
                            Object answer = HTTPFabricConnection.this.deserializeResponse(data);
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Reverse response data got.", new Object[0]);
                            if (this.isInterrupted || Thread.currentThread().isInterrupted()) {
                                throw new InterruptedException();
                            }
                            if (reverseResponse.getStatusCode() == 401) {
                                this.reverseWrapper.closeQuiet();
                                this.reverseWrapper = null;
                                HTTPFabricConnection.this.reverseRequests.incUnauthorizedResponsesCount();
                                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Reverse request returned status 401(unauthorized). It means that session is not valid or expired. It can be caused by acceptor or node restart. Trying to reopen...", new Object[0]);
                                HTTPFabricConnection.this.reopen(true);
                                continue;
                            }
                            HTTPFabricConnection.this.reverseConnectionErrorsCountLast = HTTPFabricConnection.this.reverseConnectionErrorsCount;
                            HTTPFabricConnection.this.reverseConnectionErrorsCount = 0L;
                            this.reverseConnectionTimedOutFirstTime = 0L;
                            try {
                                if (reverseResponse.getStatusCode() == 200) {
                                    HTTPFabricConnection.this.reverseRequests.incSuccessfulResponsesCount();
                                } else {
                                    HTTPFabricConnection.this.reverseRequests.incErrorResponsesCount();
                                }
                                if (answer instanceof String && ((String)answer).length() == 0) {
                                    if (reverseResponse.getStatusCode() != 200) {
                                        HTTPFabricConnection.this.log(Trace.Level.DEBUG, "HTTP server replied with empty response and status " + reverseResponse.getStatusCode() + ".", new Object[0]);
                                        this.sleep(getStatusTime, 1000L);
                                        continue;
                                    }
                                    HTTPFabricConnection.this.log(Trace.Level.DEBUG, "HTTP server replied with empty response. Reopening reverse connection...", new Object[0]);
                                    continue;
                                }
                                if (answer == null) {
                                    HTTPFabricConnection.this.log(Trace.Level.DEBUG, "HTTP server replied with null response.", new Object[0]);
                                    this.sleep(getStatusTime, 1000L);
                                    continue;
                                }
                                this.processEvents(answer);
                            }
                            finally {
                                reverseResponse = null;
                            }
                        }
                        catch (SocketTimeoutException exception) {
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Timeout exception when getting reverse data.", new Object[0]);
                            HTTPFabricConnection.this.reverseRequests.incTimeoutResponsesCount();
                            if (System.currentTimeMillis() - postTime < HTTPFabricConnection.this.getReverseConnectionHoldTimeout() + 1000L) continue;
                            if (this.reverseConnectionTimedOutFirstTime == 0L) {
                                this.reverseConnectionTimedOutFirstTime = System.currentTimeMillis();
                            }
                            ++HTTPFabricConnection.this.reverseConnectionErrorsCount;
                            HTTPFabricConnection.this.reverseConnectionErrorsCountLast = 0L;
                        }
                        catch (InterruptedException exception) {
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Interrupted exception when getting reverse data.", new Object[0]);
                            Thread.currentThread().interrupt();
                            throw exception;
                        }
                        catch (Exception exception) {
                            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Exception when getting reverse data. Cause: {}", exception.getMessage());
                            HTTPFabricConnection.this.reverseRequests.incExceptionResponsesCount();
                            ++HTTPFabricConnection.this.reverseConnectionErrorsCount;
                            HTTPFabricConnection.this.reverseConnectionErrorsCountLast = 0L;
                            this.reverseConnectionTimedOutFirstTime = 0L;
                            if (this.reverseWrapper == null) continue;
                            this.reverseWrapper.closeQuiet();
                            this.reverseWrapper = null;
                        }
                    }
                    catch (InterruptedException exception) {
                        HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Interrupted exception when execution reverse operation.", new Object[0]);
                        Thread.currentThread().interrupt();
                        throw exception;
                    }
                    catch (Exception exception) {
                        HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Exception when executing reverse operation. Cause: {}", exception.getMessage());
                        HTTPFabricConnection.this.reverseRequests.incExceptionResponsesCount();
                        ++HTTPFabricConnection.this.reverseConnectionErrorsCount;
                        HTTPFabricConnection.this.reverseConnectionErrorsCountLast = 0L;
                        this.reverseConnectionTimedOutFirstTime = 0L;
                        if (!(exception instanceof IOException) && !(exception instanceof ModuleException) || this.reverseWrapper == null) continue;
                        this.reverseWrapper.closeQuiet();
                        this.reverseWrapper = null;
                    }
                }
            }
            catch (InterruptedException exception) {
                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Reverse thread was interrupted. Close connection.", new Object[0]);
                HTTPFabricConnection.this.closeQuiet();
            }
            if (this.reverseWrapper != null) {
                this.reverseWrapper.closeQuiet();
                this.reverseWrapper = null;
            }
            HTTPFabricConnection.this.log(Trace.Level.INFO, "Reverse connection thread {}.", this.isInterrupted ? "has been interrupted and finished" : "finished");
        }

        private HTTPClientWrapper createReverseClientWrapper() {
            return HTTPFabricConnection.this.createHttpClientWrapper(HTTPFabricConnection.this.getReverseReplyTimeout());
        }

        protected void processEvents(Object serverAnswer) throws InterruptedException {
            if (!(serverAnswer instanceof Object[])) {
                String className = serverAnswer.getClass().getName();
                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Unexpected event from server: class = {}, expected = Object[]", className);
                if (serverAnswer instanceof String) {
                    HTTPFabricConnection.this.log(Trace.Level.ERROR, "Response length: {}, data {}", ((String)serverAnswer).length(), HTTPFabricConnection.this.cutForLog((String)serverAnswer));
                }
                return;
            }
            Object[] transmitters = (Object[])serverAnswer;
            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Start of processing {} objects received from server.", transmitters.length);
            for (Object object : transmitters) {
                if (this.isInterrupted || Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (!(object instanceof HTTPEventTransmitter)) {
                    if (object instanceof String && object.equals("{\"intercepted\" : true}")) continue;
                    HTTPFabricConnection.this.log(Trace.Level.ERROR, "Unexpected event from server: class = {}, expected = HTTPEventTransmitter", object.getClass().getName());
                    continue;
                }
                HTTPEventTransmitter transmitter = (HTTPEventTransmitter)object;
                if (transmitter.getEvent() instanceof ImmutableEventDatagram) {
                    String consumerName = transmitter.getConsumerName();
                    ImmutableEventDatagram event = (ImmutableEventDatagram)transmitter.getEvent();
                    HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Received event: {} for {}, id: {}", event.getEventId(), consumerName, transmitter.getEventUniqueId());
                    HTTPEventConsumer consumer = HTTPFabricConnection.this.directConsumers.get(consumerName);
                    if (consumer != null) {
                        this.processDirectEvent(consumer, event, transmitter.getEventUniqueId());
                        continue;
                    }
                    consumer = HTTPFabricConnection.this.asyncConsumers.get(consumerName);
                    if (consumer != null) {
                        this.processAsyncEvent(consumer, event, transmitter.getEventUniqueId());
                        continue;
                    }
                    HTTPEventRequestConsumer requestConsumer = HTTPFabricConnection.this.requestConsumers.get(consumerName);
                    if (requestConsumer != null) {
                        this.processRequestEvent(requestConsumer, event, transmitter.getEventUniqueId());
                        continue;
                    }
                    HTTPFabricConnection.this.log(Trace.Level.ERROR, "No such consumer: {}", consumerName);
                    continue;
                }
                if (transmitter.getEvent() instanceof SLMessage) {
                    this.processSLMessage((SLMessage)transmitter.getEvent(), transmitter.getEventUniqueId());
                    continue;
                }
                HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Unknown object {} in event transmitter consumer name {}, uniqueId {}.", transmitter.getEvent(), transmitter.getConsumerName(), transmitter.getEventUniqueId());
            }
            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "End of processing {} objects received from server.", transmitters.length);
        }

        protected void processSLMessage(SLMessage message, long eventUniqueId) {
            this.currentReverseOperation = new MonitoredOperation("Reverse thread: processing sl message.", HTTPFabricConnection.this.getAsyncConsumerAndSLMessageTimeoutsForReverseMonitorMs());
            HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Received SL message: {}, unique id: {}", message, eventUniqueId);
            HTTPSLSession slSession = HTTPFabricConnection.this.slSessions.get(message.getSLSessionName());
            if (slSession != null && slSession.slMessageListener != null) {
                slSession.slMessageListener.onMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processDirectEvent(HTTPEventConsumer consumer, ImmutableEventDatagram event, long eventUniqueId) {
            this.currentReverseOperation = new MonitoredOperation("Reverse thread: processing direct event.", HTTPFabricConnection.this.getFileTransfersDirectConsumersTimeout() + HTTPFabricConnection.this.getHttpTimeout());
            Exception exception = null;
            try {
                consumer.getEventListener().onEvent(event);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.sendEventCompleted(eventUniqueId, exception, "direct event");
            }
        }

        protected void processAsyncEvent(HTTPEventConsumer consumer, ImmutableEventDatagram event, long eventUniqueId) {
            this.currentReverseOperation = new MonitoredOperation("Reverse thread: processing async event.", HTTPFabricConnection.this.getAsyncConsumerAndSLMessageTimeoutsForReverseMonitorMs());
            try {
                consumer.getEventListener().onEvent(event);
            }
            catch (Exception exception) {
                HTTPFabricConnection.this.log(Trace.Level.ERROR, "Exception caught when processing async event in consumer {}, eventUniqueId: {}", consumer.getName(), eventUniqueId);
                Trace.logException(this, exception, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processRequestEvent(HTTPEventRequestConsumer consumer, ImmutableEventDatagram event, long eventUniqueId) {
            this.currentReverseOperation = new MonitoredOperation("Reverse thread: processing request.", HTTPFabricConnection.this.getFileTransfersDirectConsumersTimeout() + HTTPFabricConnection.this.getHttpTimeout());
            Serializable ack = null;
            try {
                ack = consumer.getRequestListener().onRequest(event);
            }
            catch (Exception e) {
                ack = e;
            }
            finally {
                this.sendEventCompleted(eventUniqueId, ack, "direct request");
            }
        }

        private void sendEventCompleted(long eventUniqueId, Object ack, String name) {
            block8: {
                HTTPFabricConnection.this.log(Trace.Level.DEBUG, "Sending {} completion, unique id: {}.", name, eventUniqueId);
                Object[] args = new Object[]{eventUniqueId, ack};
                try {
                    if (this.reverseWrapper == null) {
                        this.reverseWrapper = this.createReverseClientWrapper();
                    }
                    try {
                        HTTPFabricConnection.this.invokeRemoteCall(this.reverseWrapper, "eventCompleted", args, null);
                    }
                    catch (HTTPFabricException exception) {
                        if (exception.getCause() instanceof IOException || exception.getCause() instanceof ModuleException) {
                            HTTPFabricConnection.this.log(Trace.Level.ERROR, "Sending {} completion, unique id: {}. Renew connection. Error: {}", name, eventUniqueId, exception.getCause().getMessage());
                            HTTPFabricConnection.this.replaceClient(this.reverseWrapper, null);
                            HTTPFabricConnection.this.invokeRemoteCall(this.reverseWrapper, "eventCompleted", args, null);
                            break block8;
                        }
                        throw exception;
                    }
                }
                catch (Exception e) {
                    HTTPFabricConnection.this.log(Trace.Level.ERROR, "Sending {} completion, unique id: {}. Error: {}", name, eventUniqueId, e.getMessage());
                    if (this.reverseWrapper == null) break block8;
                    args[1] = null;
                    try {
                        HTTPFabricConnection.this.invokeRemoteCall(this.reverseWrapper, "eventCompleted", args, null);
                    }
                    catch (Exception e1) {
                        HTTPFabricConnection.this.log(Trace.Level.ERROR, "Sending {} completion #2, unique id: {}. Error: {}", name, eventUniqueId, e1.getMessage());
                    }
                }
            }
        }
    }
}

