/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPConsumerBase;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.enums.FlowControlMode;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import java.util.function.Function;

class HTTPEventReceiver
extends HTTPConsumerBase
implements EventReceiver {
    private String eventFilter;
    private EventScope eventScope;
    private boolean noLocal;
    private int maxDepth = -2;
    private FlowControlMode flowControlMode = null;
    private HTTPFabricConnection.HTTPClientWrapper wrapper = null;

    HTTPEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, HTTPFabricConnection fabricConnection) {
        super(receiverName, eventSelector, fabricConnection);
        this.eventFilter = eventFilter;
        this.eventScope = eventScope;
        this.noLocal = noLocal;
        this.method = "getEventReceiver";
    }

    protected void open() {
        if (this.wrapper != null) {
            this.wrapper.closeQuiet();
            this.wrapper = null;
        }
        this.wrapper = this.connection.createHttpClientWrapper();
        Object[] args = new Object[]{this.getName(), this.eventFilter, this.eventSelector, this.eventScope, this.noLocal};
        byte[] data = this.connection.invoke("createEventReceiver", args, null);
        this.connection.checkException(data);
        this.connection.receivers.put(this.getName(), this);
        if (this.maxDepth != -2) {
            this.connection.reopenAction(() -> this.setMaxDepth(this.maxDepth));
        }
        if (this.flowControlMode != null) {
            this.connection.reopenAction(() -> this.setFlowControlMode(this.flowControlMode));
        }
    }

    @Override
    public void close() throws HTTPFabricException {
        try {
            super.close();
        }
        finally {
            if (this.wrapper != null) {
                this.wrapper.closeQuiet();
                this.wrapper = null;
            }
        }
    }

    @Override
    public int getMaxDepth() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getMaxDepth", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public void setMaxDepth(int maxDepth) throws HTTPFabricException {
        Object[] args = new Object[]{maxDepth};
        this.invoke("setMaxDepth", args);
        this.maxDepth = maxDepth;
    }

    @Override
    public FlowControlMode getFlowControlMode() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getFlowControlMode", args);
        HTTPFabricConnection.processServerAnswer(result, FlowControlMode.class);
        return (FlowControlMode)((Object)result);
    }

    @Override
    public void setFlowControlMode(FlowControlMode flowControlMode) throws HTTPFabricException {
        Object[] args = new Object[]{flowControlMode};
        this.invoke("setFlowControlMode", args);
        this.flowControlMode = flowControlMode;
    }

    @Override
    public void clear() throws HTTPFabricException {
        Object[] args = new Object[]{};
        this.invoke("clear", args);
    }

    @Override
    public int getCurrentDepth() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getCurrentDepth", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public ImmutableEventDatagram receive() throws HTTPFabricException {
        ImmutableEventDatagram result;
        while ((result = this.receive(this.connection.getHttpTimeout() / 2L)) == null) {
        }
        return result;
    }

    @Override
    public ImmutableEventDatagram receive(long waitTime) throws HTTPFabricException {
        return this.invokeRecieveWithTimeout(timeout -> {
            Object[] args = new Object[]{timeout};
            Object result = this.invoke("receive", args);
            HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
            return (ImmutableEventDatagram)result;
        }, waitTime);
    }

    @Override
    public ImmutableEventDatagram receiveNoWait() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("receiveNoWait", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public ImmutableEventDatagram receive(String eventSelector) throws HTTPFabricException {
        Object[] args = new Object[]{eventSelector};
        Object result = this.invoke("receive", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public ImmutableEventDatagram receive(String eventSelector, long waitTime) throws HTTPFabricException {
        return this.invokeRecieveWithTimeout(timeout -> {
            Object[] args = new Object[]{eventSelector, timeout};
            Object result = this.invoke("receive", args);
            HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
            return (ImmutableEventDatagram)result;
        }, waitTime);
    }

    private ImmutableEventDatagram invokeRecieveWithTimeout(Function<Long, ImmutableEventDatagram> s, long waitTime) {
        long endTime = System.currentTimeMillis() + waitTime;
        while (waitTime > 0L) {
            long timeout;
            long l = timeout = this.connection.getHttpTimeout() / 2L < waitTime ? this.connection.getHttpTimeout() / 2L : waitTime;
            if (System.currentTimeMillis() + timeout > endTime) {
                timeout = endTime - System.currentTimeMillis();
            }
            if (timeout <= 0L) {
                timeout = 1000L;
            }
            waitTime -= timeout;
            ImmutableEventDatagram result = s.apply(timeout);
            if (result != null) {
                return result;
            }
            if (System.currentTimeMillis() < endTime) continue;
            break;
        }
        return null;
    }

    @Override
    public ImmutableEventDatagram receiveNoWait(String eventSelector) throws HTTPFabricException {
        Object[] args = new Object[]{eventSelector};
        Object result = this.invoke("receiveNoWait", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        return this.invoke(methodName, args, -1L);
    }

    protected Object invoke(String methodName, Object[] args, long timeout) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] consumerArgs = new Object[]{this.name};
        call.pushMethodCall(new RemoteMethodCall(this.method, consumerArgs));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(this.wrapper, call, null, timeout);
    }
}

