/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import java.util.HashMap;

public class HTTPEventFactory {
    protected HTTPFabricConnection connection;
    protected HashMap<String, ImmutableEventDatagram> eventsCache = new HashMap();
    private static final ThreadLocal<Pair<HTTPEventFactory, Integer>> currentThreadFactory = new ThreadLocal();

    HTTPEventFactory(HTTPFabricConnection fabricConnection) {
        this.connection = fabricConnection;
    }

    public AcknowledgementEvent createAcknowledgement(EventDatagram event) throws HTTPFabricException {
        return this.createAcknowledgement(event, false);
    }

    public AcknowledgementEvent createAcknowledgement(EventDatagram event, boolean withSourceData) throws HTTPFabricException {
        Object[] args = new Object[]{event, withSourceData};
        Object result = this.invokeEventFactory("createAcknowledgement", args);
        HTTPFabricConnection.processServerAnswer(result, AcknowledgementEvent.class);
        return (AcknowledgementEvent)result;
    }

    public ImmutableEventDatagram createEvent(String eventId) throws HTTPFabricException {
        return this.createEvent(eventId, true);
    }

    public ImmutableEventDatagram createEvent(String eventId, boolean withImport) throws HTTPFabricException {
        ImmutableEventDatagram event = this.eventsCache.get(eventId);
        if (event != null) {
            return event;
        }
        if (withImport) {
            Object[] args = new Object[]{eventId};
            Object result = this.invokeEventFactory("createEvent", args);
            HTTPFabricConnection.processServerAnswer(result, EventDatagram.class);
            event = (EventDatagram)result;
            this.eventsCache.put(eventId, event);
        }
        return event;
    }

    public OpaqueDatagram createOpaqueEvent(String eventId) throws HTTPFabricException {
        ImmutableEventDatagram event = this.eventsCache.get(eventId);
        if (event != null) {
            if (event instanceof OpaqueDatagram) {
                return (OpaqueDatagram)event;
            }
            throw new HTTPFabricException("Invalid event [" + eventId + "] model. Expected opaque, but passed '" + event.getClass().getSimpleName() + "'.");
        }
        Object[] args = new Object[]{eventId};
        Object result = this.invokeOpaqueFactory("createEvent", args);
        HTTPFabricConnection.processServerAnswer(result, OpaqueDatagram.class);
        event = (OpaqueDatagram)result;
        this.eventsCache.put(eventId, event);
        return (OpaqueDatagram)event;
    }

    protected Object invokeOpaqueFactory(String methodName, Object[] args) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getOpaqueDatagramFactory", new Object[0]));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null);
    }

    protected Object invokeEventFactory(String methodName, Object[] args) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getEventDatagramFactory", new Object[0]));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null);
    }

    protected void addEventPrototype(String eventId, ImmutableEventDatagram event) {
        this.eventsCache.put(eventId, event);
    }

    protected boolean existsEventPrototype(String eventId) {
        return this.eventsCache.containsKey(eventId);
    }

    public static HTTPEventFactory getCurrentThreadFactory() {
        Pair<HTTPEventFactory, Integer> pair = currentThreadFactory.get();
        if (pair != null) {
            return (HTTPEventFactory)pair.first;
        }
        return null;
    }

    protected void setCurrentThreadFactory() {
        Pair<HTTPEventFactory, Integer> pair = currentThreadFactory.get();
        if (pair == null) {
            pair = new Pair<HTTPEventFactory, Integer>(this, 0);
        }
        Pair<HTTPEventFactory, Integer> pair2 = pair;
        Integer n = (Integer)pair2.second;
        pair2.second = (Integer)pair2.second + 1;
        currentThreadFactory.set(pair);
    }

    protected void unsetCurrentThreadFactory() {
        Pair<HTTPEventFactory, Integer> pair = currentThreadFactory.get();
        if (pair != null) {
            Pair<HTTPEventFactory, Integer> pair2 = pair;
            Integer n = (Integer)pair2.second;
            pair2.second = (Integer)pair2.second - 1;
            if ((Integer)pair.second <= 0) {
                currentThreadFactory.remove();
            }
        } else {
            currentThreadFactory.remove();
        }
    }
}

