/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPConsumerBase;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPListener;
import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.DispatchMode;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.http.server.fabric.HTTPEventListener;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;

class HTTPEventConsumer
extends HTTPConsumerBase
implements EventConsumer {
    protected HTTPListener listener;
    protected String eventFilter;
    protected EventScope eventScope;
    protected boolean noLocal;

    HTTPEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, HTTPFabricConnection fabricConnection) {
        super(consumerName, eventSelector, fabricConnection);
        this.listener = (HTTPListener)listener;
        this.eventFilter = eventFilter;
        this.eventScope = eventScope;
        this.noLocal = noLocal;
        this.method = "getEventConsumer";
    }

    protected void open() {
        this.listener.setConsumer(this.getName());
        Object[] args = new Object[]{this.getName(), new HTTPEventListener(this.getName(), true), this.eventFilter, this.eventSelector, this.eventScope, this.noLocal};
        byte[] data = this.connection.invoke("createEventConsumer", args, null);
        this.connection.checkException(data);
        this.connection.directConsumers.put(this.getName(), this);
    }

    public ConsumerState getCurrentState() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getCurrentState", args);
        HTTPFabricConnection.processServerAnswer(result, ConsumerState.class);
        return (ConsumerState)result;
    }

    @Override
    public FabricEventListener getEventListener() {
        return this.listener;
    }

    public boolean matchesEventId(String eventId) throws HTTPFabricException {
        Object[] args = new Object[]{eventId};
        Object result = this.invoke("matchesEventId", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void setEventListener(FabricEventListener listener) {
        this.listener = (HTTPListener)listener;
    }

    @Override
    public DispatchMode getDispatchMode() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getDispatchMode", args);
        HTTPFabricConnection.processServerAnswer(result, DispatchMode.class);
        return (DispatchMode)((Object)result);
    }

    @Override
    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        Object[] consumerArgs = new Object[]{this.name};
        call.pushMethodCall(new RemoteMethodCall(this.method, consumerArgs));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null);
    }
}

