/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sef.EventCache;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import java.util.ArrayList;
import java.util.List;

public class HTTPEventCache
implements EventCache {
    protected HTTPFabricConnection connection;
    protected String eventFilter = null;

    HTTPEventCache(String eventFilter, HTTPFabricConnection fabricConnection) {
        this.connection = fabricConnection;
        this.eventFilter = eventFilter;
    }

    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getEventCache", new Object[]{this.eventFilter}));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        return this.connection.invokeRemoteCall(call, null);
    }

    @Override
    public String getEventFilter() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getEventFilter", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public int getMaxSize() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getMaxSize", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public CacheThresholdAction getThresholdAction() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getThresholdAction", args);
        HTTPFabricConnection.processServerAnswer(result, CacheThresholdAction.class);
        return (CacheThresholdAction)((Object)result);
    }

    @Override
    public void setMaxSize(int maxSize) throws HTTPFabricException {
        Object[] args = new Object[]{maxSize};
        this.invoke("setMaxSize", args);
    }

    @Override
    public int getSize() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSize", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public List<ImmutableEventDatagram> getEvents() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ImmutableEventDatagram> events = new ArrayList<ImmutableEventDatagram>();
        for (Object object : (Object[])result) {
            if (object != null && !(object instanceof ImmutableEventDatagram)) {
                throw new HTTPFabricException("Wrong object received '" + String.valueOf(object.getClass()) + "' instead of 'ImmutableEventDatagram'.");
            }
            events.add((ImmutableEventDatagram)object);
        }
        return events;
    }

    @Override
    public void clear() throws HTTPFabricException {
        Object[] args = new Object[]{};
        this.invoke("clear", args);
    }
}

