/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPEventConsumer;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.lib.evqueue.DeliveryMode;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.enums.FlowControlMode;
import com.streamscape.sef.network.http.server.fabric.HTTPEventListener;

public class HTTPEventAsyncConsumer
extends HTTPEventConsumer
implements EventAsyncConsumer {
    private boolean isStarted = false;
    private boolean isSuspended = false;
    private int maxDepth = -2;
    private FlowControlMode flowControlMode = null;
    private DeliveryMode deliveryMode = null;
    private long deliverySpinWait = -2L;

    HTTPEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, HTTPFabricConnection fabricConnection) {
        super(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, fabricConnection);
        this.method = "getEventAsyncConsumer";
    }

    @Override
    protected void open() {
        this.listener.setConsumer(this.getName());
        Object[] args = new Object[]{this.getName(), new HTTPEventListener(this.getName(), false), this.eventFilter, this.eventSelector, this.eventScope, this.noLocal};
        byte[] data = this.connection.invoke("createEventAsyncConsumer", args, null);
        this.connection.checkException(data);
        this.connection.asyncConsumers.put(this.getName(), this);
        if (this.isStarted) {
            this.connection.reopenAction(this::start);
            if (this.isSuspended) {
                this.connection.reopenAction(this::suspend);
            }
        }
        if (this.maxDepth != -2) {
            this.connection.reopenAction(() -> this.setMaxDepth(this.maxDepth));
        }
        if (this.flowControlMode != null) {
            this.connection.reopenAction(() -> this.setFlowControlMode(this.flowControlMode));
        }
        if (this.deliveryMode != null) {
            this.connection.reopenAction(() -> this.setDeliveryMode(this.deliveryMode));
        }
        if (this.deliverySpinWait != -2L) {
            this.connection.reopenAction(() -> this.setDeliverySpinWait(this.deliverySpinWait));
        }
    }

    @Override
    public int getMaxDepth() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getMaxDepth", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public void setMaxDepth(int maxDepth) throws HTTPFabricException {
        Object[] args = new Object[]{maxDepth};
        this.invoke("setMaxDepth", args);
        this.maxDepth = maxDepth;
    }

    @Override
    public FlowControlMode getFlowControlMode() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getFlowControlMode", args);
        HTTPFabricConnection.processServerAnswer(result, FlowControlMode.class);
        return (FlowControlMode)((Object)result);
    }

    @Override
    public void setFlowControlMode(FlowControlMode flowControlMode) throws HTTPFabricException {
        Object[] args = new Object[]{flowControlMode};
        this.invoke("setFlowControlMode", args);
        this.flowControlMode = flowControlMode;
    }

    @Override
    public DeliveryMode getDeliveryMode() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getDeliveryMode", args);
        HTTPFabricConnection.processServerAnswer(result, DeliveryMode.class);
        return (DeliveryMode)((Object)result);
    }

    @Override
    public void setDeliveryMode(DeliveryMode deliveryMode) throws HTTPFabricException {
        Object[] args = new Object[]{deliveryMode};
        this.invoke("setDeliveryMode", args);
        this.deliveryMode = deliveryMode;
    }

    @Override
    public long getDeliverySpinWait() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getDeliverySpinWait", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).longValue();
    }

    @Override
    public void setDeliverySpinWait(long deliverySpinWait) throws HTTPFabricException {
        Object[] args = new Object[]{deliverySpinWait};
        this.invoke("setDeliverySpinWait", args);
        this.deliverySpinWait = deliverySpinWait;
    }

    @Override
    public void start() throws HTTPFabricException {
        Object[] args = new Object[]{};
        try {
            this.invoke("start", args);
            this.isStarted = true;
        }
        catch (Exception exception) {
            try {
                this.isStarted = this.isStarted();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    @Override
    public void stop() throws HTTPFabricException {
        Object[] args = new Object[]{};
        try {
            this.invoke("stop", args);
            this.isStarted = false;
        }
        catch (Exception exception) {
            try {
                this.isStarted = this.isStarted();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    @Override
    public void suspend() throws HTTPFabricException {
        Object[] args = new Object[]{};
        try {
            this.invoke("suspend", args);
            this.isSuspended = true;
        }
        catch (Exception exception) {
            try {
                this.isSuspended = this.isSuspended();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    @Override
    public void resume() throws HTTPFabricException {
        Object[] args = new Object[]{};
        try {
            this.invoke("resume", args);
            this.isSuspended = false;
        }
        catch (Exception exception) {
            try {
                this.isSuspended = this.isSuspended();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    @Override
    public void clear() throws HTTPFabricException {
        Object[] args = new Object[]{};
        this.invoke("clear", args);
    }

    @Override
    public int getCurrentDepth() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getCurrentDepth", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public void close(long timeout) throws HTTPFabricException {
        this.invoke("close", new Object[]{timeout});
    }

    @Override
    public void forceClose() {
        Object[] args = new Object[]{};
        this.invoke("forceClose", args);
    }

    public ImmutableEventDatagram receive() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("receive", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    public ImmutableEventDatagram receive(long waitTime) throws HTTPFabricException {
        Object[] args = new Object[]{waitTime};
        Object result = this.invoke("receive", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    public ImmutableEventDatagram receiveNoWait() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("receiveNoWait", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    public ImmutableEventDatagram receive(String eventSelector) throws HTTPFabricException {
        Object[] args = new Object[]{eventSelector};
        Object result = this.invoke("receive", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    public ImmutableEventDatagram receive(String eventSelector, long waitTime) throws HTTPFabricException {
        Object[] args = new Object[]{eventSelector, waitTime};
        Object result = this.invoke("receive", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    public ImmutableEventDatagram receiveNoWait(String eventSelector) throws HTTPFabricException {
        Object[] args = new Object[]{eventSelector};
        Object result = this.invoke("receiveNoWait", args);
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public boolean isStarted() {
        Object[] args = new Object[]{};
        Object result = this.invoke("isStarted", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        this.isStarted = (Boolean)result;
        return (Boolean)result;
    }

    @Override
    public boolean isSuspended() {
        Object[] args = new Object[]{};
        Object result = this.invoke("isSuspended", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        this.isSuspended = (Boolean)result;
        return (Boolean)result;
    }
}

