/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.Trace;
import com.streamscape.cli.ClientState;
import com.streamscape.cli.ds.CollectionFactory;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPSLSession;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.accessor.FabricComponentAccessorStateListener;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dispatcher.AccessibleObjectComponent;
import com.streamscape.sef.dispatcher.DataspaceAccessorForJDBC;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.file.SLFileSessionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class HTTPDataspaceAccessor
implements DataspaceAccessor,
DataspaceAccessorForJDBC,
AccessibleObjectComponent {
    protected HTTPFabricConnection connection;
    protected Object[] getDataspaceAccessorArgs;
    private String nodeName;
    private DataspaceType dataspaceType;
    private String dataspaceName;
    private String componentType;
    private String componentName;
    private String actualNodeName;
    private SLFileSessionContext sessionContext = SLFileSessionContext.CLIENT;
    private long requestTimeout = -2L;
    private Boolean autoSwitching = null;
    private Boolean autoCommit = null;
    private Boolean readOnly = null;
    private Integer transactionIsolation = null;
    private Integer transferBufferSize = null;
    private Integer fetchSize = null;
    private Integer downloadableBlobSize = null;
    private String uniqueAccessorName;
    private HTTPFabricConnection.HTTPClientWrapper wrapper = null;
    private static AtomicLong accessorId = new AtomicLong(0L);

    HTTPDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName, HTTPFabricConnection connection) {
        this.nodeName = nodeName;
        this.dataspaceType = dataspaceType;
        this.dataspaceName = dataspaceName;
        this.connection = connection;
        this.uniqueAccessorName = "fabricconnection_" + accessorId.incrementAndGet();
        this.getDataspaceAccessorArgs = new Object[1];
        this.getDataspaceAccessorArgs[0] = this.uniqueAccessorName;
        this.open();
    }

    protected void open() {
        if (this.wrapper != null) {
            this.wrapper.closeQuiet();
        }
        this.wrapper = this.connection.createHttpClientWrapper();
        Object[] createDataspaceAccessorArgs = new Object[]{this.nodeName, this.dataspaceType, this.dataspaceName, this.uniqueAccessorName};
        byte[] data = this.connection.invoke("createDataspaceAccessor", createDataspaceAccessorArgs, null);
        if (data != null) {
            this.connection.checkException(data);
        }
        this.connection.dataspaceAccessors.put(this.uniqueAccessorName, this);
        try {
            this.setSessionContext(this.sessionContext);
        }
        catch (HTTPFabricException exception) {
            Trace.logError(this, "Failed to set accessor session context to client, for " + this.getName());
            Trace.logException(this, exception, false);
        }
        if (this.requestTimeout != -2L) {
            this.connection.reopenAction(() -> this.setRequestTimeout(this.requestTimeout));
        }
        if (this.autoSwitching != null) {
            this.connection.reopenAction(() -> this.setAutoSwitching(this.autoSwitching));
        }
        if (this.autoCommit != null) {
            this.connection.reopenAction(() -> this.setAutoCommit(this.autoCommit));
        }
        if (this.readOnly != null) {
            this.connection.reopenAction(() -> this.setReadOnly(this.readOnly));
        }
        if (this.transactionIsolation != null) {
            this.connection.reopenAction(() -> this.setTransactionIsolation(this.transactionIsolation));
        }
        if (this.transferBufferSize != null) {
            this.connection.reopenAction(() -> this.setTransferBufferSize(this.transferBufferSize));
        }
        if (this.fetchSize != null) {
            this.connection.reopenAction(() -> this.setFetchSize(this.fetchSize));
        }
        if (this.downloadableBlobSize != null) {
            this.connection.reopenAction(() -> this.setDownloadableBlobSize(this.downloadableBlobSize));
        }
    }

    @Override
    public String getAccessorName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getAccessorName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public EventScope getEventScope() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getEventScope", args);
        HTTPFabricConnection.processServerAnswer(result, EventScope.class);
        return (EventScope)((Object)result);
    }

    @Override
    public String getNodeName() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getNodeName", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public String getComponentType() {
        if (this.componentType == null) {
            Object[] args = new Object[]{};
            Object result = this.invoke("getComponentType", args);
            HTTPFabricConnection.processServerAnswer(result, String.class);
            this.componentType = (String)result;
        }
        return this.componentType;
    }

    @Override
    public String getComponentName() {
        if (this.componentName == null) {
            Object[] args = new Object[]{};
            Object result = this.invoke("getComponentName", args);
            HTTPFabricConnection.processServerAnswer(result, String.class);
            this.componentName = (String)result;
        }
        return this.componentName;
    }

    @Override
    public ComponentModel getComponentModel() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getComponentModel", args);
        HTTPFabricConnection.processServerAnswer(result, ComponentModel.class);
        return (ComponentModel)((Object)result);
    }

    @Override
    public long getRequestTimeout() {
        if (this.requestTimeout == -2L) {
            Object[] args = new Object[]{};
            Object result = this.invoke("getRequestTimeout", args);
            HTTPFabricConnection.processServerAnswer(result, Number.class);
            this.requestTimeout = ((Number)result).longValue();
        }
        return this.requestTimeout;
    }

    @Override
    public void setRequestTimeout(long timeout) {
        Object[] args = new Object[]{timeout};
        this.invoke("setRequestTimeout", args);
        this.requestTimeout = timeout;
    }

    @Override
    public boolean autoSwitching() {
        Object[] args = new Object[]{};
        Object result = this.invoke("autoSwitching", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void setAutoSwitching(boolean autoSwitching) {
        Object[] args = new Object[]{autoSwitching};
        this.invoke("setAutoSwitching", args);
        this.autoSwitching = autoSwitching;
    }

    @Override
    public boolean switchComponent() throws FabricComponentAccessorException {
        Object[] args = new Object[]{};
        Object result = this.invoke("switchComponent", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean resync() throws FabricComponentAccessorException {
        Object[] args = new Object[]{};
        Object result = this.invoke("resync", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement, long timeout) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement};
        Object result = this.invoke("invokeLanguageRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement, long timeout) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("invokeLanguageRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeInterruptRequest(String command) throws FabricComponentAccessorException {
        Object[] args = new Object[]{command};
        Object result = this.invoke("invokeInterruptRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeCompleteRequest(String statement) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement};
        Object result = this.invoke("invokeCompleteRequest", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public SLResponse invokeCompleteRequest(String statement, long timeout) throws FabricComponentAccessorException {
        Object[] args = new Object[]{statement, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("invokeCompleteRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, SLResponse.class);
        return (SLResponse)result;
    }

    @Override
    public boolean isOpened() {
        if (!this.connection.isOpened()) {
            return false;
        }
        Object[] args = new Object[]{};
        Object result = this.invoke("isOpened", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void close() {
        Object[] args = new Object[]{};
        try {
            this.invoke("close", args);
        }
        finally {
            this.connection.dataspaceAccessors.remove(this.uniqueAccessorName);
            if (this.wrapper != null) {
                this.wrapper.closeQuiet();
                this.wrapper = null;
            }
        }
    }

    @Override
    public boolean isAvailable() {
        Object[] args = new Object[]{};
        Object result = this.invoke("isAvailable", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public String getActualNodeName() {
        if (this.actualNodeName == null) {
            Object[] args = new Object[]{};
            Object result = this.invoke("getActualNodeName", args);
            HTTPFabricConnection.processServerAnswer(result, String.class);
            this.actualNodeName = (String)result;
        }
        return this.actualNodeName;
    }

    @Override
    public AccessorSessionReference getSession() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSession", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (AccessorSessionReference)result;
    }

    @Override
    public void setStateListener(FabricComponentAccessorStateListener listener) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public void setStateListener(FabricComponentAccessorStateListener listener, long repeatInterval) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public List<String> listSinkEvents() {
        Object[] args = new Object[]{};
        Object result = this.invoke("listSinkEvents", args);
        return this.objectsArrayToStringArrayList(result);
    }

    @Override
    public boolean hasSinkEvents() {
        Object[] args = new Object[]{};
        Object result = this.invoke("hasSinkEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public List<String> listActionableEvents() {
        Object[] args = new Object[]{};
        Object result = this.invoke("listActionableEvents", args);
        return this.objectsArrayToStringArrayList(result);
    }

    @Override
    public boolean hasActionableEvents() {
        Object[] args = new Object[]{};
        Object result = this.invoke("hasActionableEvents", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        Object[] args = new Object[]{eventId};
        Object result = this.invoke("existsActionableEvent", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void enableEventTrigger(String triggerName) {
        Object[] args = new Object[]{triggerName};
        this.invoke("enableEventTrigger", args);
    }

    @Override
    public void disableEventTrigger(String triggerName) {
        Object[] args = new Object[]{triggerName};
        this.invoke("disableEventTrigger", args);
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        Object[] args = new Object[]{triggerName};
        this.invoke("removeEventTrigger", args);
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("getEventTriggerDefinition", args);
        HTTPFabricConnection.processServerAnswer(result, EventTriggerDefinition.class);
        return (EventTriggerDefinition)result;
    }

    @Override
    public void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        Object[] args = new Object[]{};
        this.invoke("removeAllEventTriggers", args);
    }

    @Override
    public void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        Object[] args = new Object[]{triggerName};
        this.invoke("compileEventTrigger", args);
    }

    @Override
    public String getLastError(String triggerName) {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("getLastError", args);
        HTTPFabricConnection.processServerAnswer(result, String.class);
        return (String)result;
    }

    @Override
    public EventTriggerState getTriggerState(String triggerName) {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("getTriggerState", args);
        HTTPFabricConnection.processServerAnswer(result, EventTriggerState.class);
        return (EventTriggerState)((Object)result);
    }

    @Override
    public TriggerActionTime getTriggerActionTime(String triggerName) {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("getTriggerActionTime", args);
        HTTPFabricConnection.processServerAnswer(result, TriggerActionTime.class);
        return (TriggerActionTime)((Object)result);
    }

    @Override
    public List<String> listEventTriggers() {
        Object[] args = new Object[]{};
        Object result = this.invoke("listEventTriggers", args);
        return this.objectsArrayToStringArrayList(result);
    }

    @Override
    public List<EventTriggerDefinition> getEventTriggerDefinitions() {
        Object[] array;
        Object[] args = new Object[]{};
        Object result = this.invoke("getEventTriggerDefinitions", args);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<EventTriggerDefinition> list = new ArrayList<EventTriggerDefinition>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, EventTriggerDefinition.class);
            list.add((EventTriggerDefinition)obj);
        }
        return list;
    }

    @Override
    public boolean hasEventTriggers() {
        Object[] args = new Object[]{};
        Object result = this.invoke("hasEventTriggers", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        Object[] args = new Object[]{triggerName};
        Object result = this.invoke("existsEventTrigger", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void dropCollectionFactory(String name) throws DataspaceComponentException {
        Object[] args = new Object[]{name};
        this.invoke("dropCollectionFactory", args);
    }

    @Override
    public List<String> listCollections() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("listCollections", args);
        return this.objectsArrayToStringArrayList(result);
    }

    @Override
    public DataCollection lookupCollection(String name) throws DataspaceComponentException {
        throw new HTTPFabricException("Not implemented yet");
    }

    @Override
    public CollectionFactory createCollectionFactory(CollectionType type) throws DataspaceComponentException {
        throw new HTTPFabricException("Not implemented yet");
    }

    @Override
    public void storeCollectionFactory(String name, CollectionFactory factory) throws DataspaceComponentException {
        throw new HTTPFabricException("Not implemented yet");
    }

    @Override
    public CollectionFactory lookupCollectionFactory(String name) throws DataspaceComponentException {
        throw new HTTPFabricException("Not implemented yet");
    }

    @Override
    public void dropCollection(String name) throws DataspaceComponentException {
        Object[] args = new Object[]{name};
        this.invoke("dropCollection", args);
    }

    @Override
    public long getSessionId() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSessionId", args);
        HTTPFabricConnection.processServerAnswer(result, Long.class);
        return ((Long)result).intValue();
    }

    @Override
    public int getSessionState() {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSessionState", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public void commit() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        this.invoke("commit", args);
    }

    @Override
    public boolean getAutoCommit() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getAutoCommit", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public int getTransactionIsolation() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getTransactionIsolation", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public boolean isClosed() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("isClosed", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean isReadOnly() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("isReadOnly", args);
        HTTPFabricConnection.processServerAnswer(result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public void rollback() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        this.invoke("rollback", args);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws DataspaceComponentException {
        Object[] args = new Object[]{autoCommit};
        this.invoke("setAutoCommit", args);
        this.autoCommit = autoCommit;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws DataspaceComponentException {
        Object[] args = new Object[]{readOnly};
        this.invoke("setReadOnly", args);
        this.readOnly = readOnly;
    }

    @Override
    public void setTransactionIsolation(int level) throws DataspaceComponentException {
        Object[] args = new Object[]{level};
        this.invoke("setTransactionIsolation", args);
        this.transactionIsolation = level;
    }

    @Override
    public RowSet executeQuery(String query, Object ... params) throws DataspaceComponentException {
        Object[] args = new Object[]{query, params};
        Object result = this.invoke("executeQuery", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, RowSet.class);
        return (RowSet)result;
    }

    @Override
    public RowSet executeQuery(String query) throws DataspaceComponentException {
        Object[] args = new Object[]{query};
        Object result = this.invoke("executeQuery", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, RowSet.class);
        return (RowSet)result;
    }

    @Override
    public Object callFunction(String query, Object ... params) throws DataspaceComponentException {
        Object[] args = new Object[]{query, params};
        return this.invoke("callFunction", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
    }

    @Override
    public Object callFunction(String query) throws DataspaceComponentException {
        Object[] args = new Object[]{query};
        return this.invoke("callFunction", args, HTTPSLSession.calculateHttpTimeout(-1L, this.requestTimeout));
    }

    @Override
    public void setFetchSize(int fetchSize) throws DataspaceComponentException {
        Object[] args = new Object[]{fetchSize};
        this.invoke("setFetchSize", args);
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getFetchSize", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public void setSessionContext(SLFileSessionContext sessionContext) throws HTTPFabricException {
        Object[] args = new Object[]{sessionContext};
        this.invoke("setSessionContext", args);
        this.sessionContext = sessionContext;
    }

    @Override
    public SLFileSessionContext getSessionContext() throws HTTPFabricException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getSessionContext", args);
        HTTPFabricConnection.processServerAnswer(result, SLFileSessionContext.class);
        return (SLFileSessionContext)((Object)result);
    }

    @Override
    public void setTransferBufferSize(int transferBufferSize) throws DataspaceComponentException {
        Object[] args = new Object[]{transferBufferSize};
        this.invoke("setTransferBufferSize", args);
        this.transferBufferSize = transferBufferSize;
    }

    @Override
    public int getTransferBufferSize() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getTransferBufferSize", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    @Override
    public void setDownloadableBlobSize(int downloadableBlobSize) throws DataspaceComponentException {
        Object[] args = new Object[]{downloadableBlobSize};
        this.invoke("setDownloadableBlobSize", args);
        this.downloadableBlobSize = downloadableBlobSize;
    }

    @Override
    public int getDownloadableBlobSize() throws DataspaceComponentException {
        Object[] args = new Object[]{};
        Object result = this.invoke("getDownloadableBlobSize", args);
        HTTPFabricConnection.processServerAnswer(result, Number.class);
        return ((Number)result).intValue();
    }

    protected Object invoke(String methodName, Object[] args) throws HTTPFabricException {
        return this.invoke(methodName, args, -1L);
    }

    protected Object invoke(String methodName, Object[] args, long timeout) throws HTTPFabricException {
        HTTPFabricConnectionRemoteCall call = new HTTPFabricConnectionRemoteCall();
        call.pushMethodCall(new RemoteMethodCall("getDataspaceAccessor", this.getDataspaceAccessorArgs));
        call.pushMethodCall(new RemoteMethodCall(methodName, args));
        Object response = this.connection.invokeRemoteCall(this.wrapper, call, null, timeout);
        HTTPDataspaceAccessor.processAccessibleObjects(response, this);
        return response;
    }

    private List<String> objectsArrayToStringArrayList(Object objects) {
        Object[] array;
        HTTPFabricConnection.processServerAnswer(objects, Object[].class);
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : array = (Object[])objects) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public ImmutableEventDatagram raiseDataspaceWriteMessage(OpaqueEvent event, long timeout) throws Exception {
        Object[] args = new Object[]{event, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("raiseDataspaceWriteMessage", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
    }

    @Override
    public void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
    }

    @Override
    public String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        return null;
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        return null;
    }

    @Override
    public OpaqueEvent createOpaqueEvent(String eventId, Object data) throws Exception {
        if (RuntimeState.isActive() || ClientState.isActive()) {
            return AccessibleObjectComponent.super.createOpaqueEvent(eventId, data);
        }
        OpaqueEvent opaqueEvent = (OpaqueEvent)this.connection.getEventFactory().createOpaqueEvent(eventId);
        opaqueEvent.setData(data);
        return opaqueEvent;
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        return false;
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
    }

    @Override
    public String getComponentFullNameWithNode() {
        return ModeratorUtils.makeComponentFullName(this.nodeName, this.getComponentType(), this.getComponentName());
    }

    @Override
    public ImmutableEventDatagram raiseSystemRequest(ImmutableEventDatagram request, long timeout) throws Exception {
        Object[] args = new Object[]{request, HTTPSLSession.calculateSlangTimeout(this.connection, timeout, this.requestTimeout)};
        Object result = this.invoke("raiseSystemRequest", args, HTTPSLSession.calculateHttpTimeout(timeout, this.requestTimeout));
        HTTPFabricConnection.processServerAnswer(result, ImmutableEventDatagram.class);
        return (ImmutableEventDatagram)result;
    }

    @Override
    public FabricNodeReference lookupFabricNode(String name) {
        return this.connection.getModerator().lookupFabricNode(name);
    }

    public static void processAccessibleObjects(Object response, Object accessor) {
        if (response instanceof SLResponse) {
            SLResponse slResponse = (SLResponse)response;
            if (slResponse.getRowSet() != null && slResponse.getRowSet() instanceof AccessibleObjectProxy) {
                ((AccessibleObjectProxy)((Object)slResponse.getRowSet())).setAccessor(accessor);
            }
            if (slResponse.getObject() != null && slResponse.getObject() instanceof AccessibleObjectProxy) {
                ((AccessibleObjectProxy)slResponse.getObject()).setAccessor(accessor);
            }
            if (slResponse.getObject() != null && slResponse.getObject() instanceof Object[]) {
                Object[] array;
                for (Object o : array = (Object[])slResponse.getObject()) {
                    if (!(o instanceof AccessibleObjectProxy)) continue;
                    ((AccessibleObjectProxy)o).setAccessor(accessor);
                }
            }
        } else if (response instanceof AccessibleObjectProxy) {
            ((AccessibleObjectProxy)response).setAccessor(accessor);
        }
    }
}

