/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPAccessorReference;
import com.streamscape.cli.http.HTTPAccessorSessionReference;
import com.streamscape.cli.http.HTTPAsyncConsumerReference;
import com.streamscape.cli.http.HTTPConsumerReference;
import com.streamscape.cli.http.HTTPDirectConsumerReference;
import com.streamscape.cli.http.HTTPEndpointReference;
import com.streamscape.cli.http.HTTPEventConsumerReference;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPReceiverReference;
import com.streamscape.cli.http.HTTPReference;
import com.streamscape.cli.http.HTTPReplicationSourceReference;
import com.streamscape.cli.http.HTTPReplicationTargetReference;
import com.streamscape.cli.http.HTTPRequestConsumerReference;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.AsyncConsumerReference;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.DirectConsumerReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.ReceiverReference;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCallPostprocessor;
import java.util.ArrayList;
import java.util.List;

class HTTPComponentReferenceBase
extends HTTPEndpointReference {
    HTTPComponentReferenceBase(String name, HTTPFabricConnection fabricConnection) {
        super(name, fabricConnection);
    }

    HTTPComponentReferenceBase(FabricAddress address, HTTPFabricConnection fabricConnection) {
        super(address, fabricConnection);
    }

    public List<ConsumerReference> getConsumers(EventScope eventScope) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getConsumers", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ConsumerReference> consumers = new ArrayList<ConsumerReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPConsumerReference reference = new HTTPConsumerReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<EventConsumerReference> getEventConsumers(EventScope eventScope) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getEventConsumers", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<EventConsumerReference> consumers = new ArrayList<EventConsumerReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPEventConsumerReference reference = new HTTPEventConsumerReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<DirectConsumerReference> getDirectConsumers(EventScope eventScope) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getDirectConsumers", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<DirectConsumerReference> consumers = new ArrayList<DirectConsumerReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPDirectConsumerReference reference = new HTTPDirectConsumerReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<AsyncConsumerReference> getAsyncConsumers(EventScope eventScope) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getAsyncConsumers", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<AsyncConsumerReference> consumers = new ArrayList<AsyncConsumerReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPAsyncConsumerReference reference = new HTTPAsyncConsumerReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<ReceiverReference> getReceivers(EventScope eventScope) throws HTTPFabricException {
        Object[] receiverNames;
        Object result = this.invoke("getReceivers", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ReceiverReference> receivers = new ArrayList<ReceiverReference>();
        for (Object receiverName : receiverNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(receiverName, String.class);
            HTTPReceiverReference reference = new HTTPReceiverReference((String)receiverName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            receivers.add(reference);
        }
        return receivers;
    }

    public List<RequestConsumerReference> getRequestConsumers(EventScope eventScope) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getRequestConsumers", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<RequestConsumerReference> consumers = new ArrayList<RequestConsumerReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPRequestConsumerReference reference = new HTTPRequestConsumerReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<AccessorReference> getAccessors(EventScope eventScope) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getAccessors", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<AccessorReference> consumers = new ArrayList<AccessorReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPAccessorReference reference = new HTTPAccessorReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<AccessorSessionReference> getAccessorSessions(EventScope eventScope) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getAccessorSessions", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<AccessorSessionReference> consumers = new ArrayList<AccessorSessionReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPAccessorSessionReference reference = new HTTPAccessorSessionReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<EventConsumerReference> getEventConsumers(String groupName) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getEventConsumers", new Object[]{groupName}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<EventConsumerReference> consumers = new ArrayList<EventConsumerReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPEventConsumerReference reference = new HTTPEventConsumerReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<AsyncConsumerReference> getAsyncConsumers(String groupName) throws HTTPFabricException {
        Object[] consumerNames;
        Object result = this.invoke("getAsyncConsumers", new Object[]{groupName}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<AsyncConsumerReference> consumers = new ArrayList<AsyncConsumerReference>();
        for (Object consumerName : consumerNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(consumerName, String.class);
            HTTPAsyncConsumerReference reference = new HTTPAsyncConsumerReference((String)consumerName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            consumers.add(reference);
        }
        return consumers;
    }

    public List<ReceiverReference> getReceivers(String groupName) throws HTTPFabricException {
        Object[] receiverNames;
        Object result = this.invoke("getReceivers", new Object[]{groupName}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ReceiverReference> receivers = new ArrayList<ReceiverReference>();
        for (Object receiverName : receiverNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(receiverName, String.class);
            HTTPReceiverReference reference = new HTTPReceiverReference((String)receiverName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            receivers.add(reference);
        }
        return receivers;
    }

    public List<String> listAsyncConsumers() throws HTTPFabricException {
        Object[] array;
        Object result = this.invoke("listAsyncConsumers", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listConsumers() throws HTTPFabricException {
        Object[] array;
        Object result = this.invoke("listConsumers", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listDirectConsumers() throws HTTPFabricException {
        Object[] array;
        Object result = this.invoke("listDirectConsumers", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listEventConsumers() throws HTTPFabricException {
        Object[] array;
        Object result = this.invoke("listEventConsumers", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listReceivers() throws HTTPFabricException {
        Object[] array;
        Object result = this.invoke("listReceivers", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listRequestConsumers() throws HTTPFabricException {
        Object[] array;
        Object result = this.invoke("listRequestConsumers", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public AsyncConsumerReference lookupAsyncConsumer(FabricAddress address) throws HTTPFabricException {
        String name;
        HTTPAsyncConsumerReference consumer = new HTTPAsyncConsumerReference(address, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPAsyncConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public AsyncConsumerReference lookupAsyncConsumer(String name) throws HTTPFabricException {
        HTTPAsyncConsumerReference consumer = new HTTPAsyncConsumerReference(name, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPAsyncConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public ConsumerReference lookupConsumer(FabricAddress address) throws HTTPFabricException {
        String name;
        HTTPConsumerReference consumer = new HTTPConsumerReference(address, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public ConsumerReference lookupConsumer(String name) throws HTTPFabricException {
        HTTPConsumerReference consumer = new HTTPConsumerReference(name, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public DirectConsumerReference lookupDirectConsumer(FabricAddress address) throws HTTPFabricException {
        String name;
        HTTPDirectConsumerReference consumer = new HTTPDirectConsumerReference(address, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPDirectConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public DirectConsumerReference lookupDirectConsumer(String name) throws HTTPFabricException {
        HTTPDirectConsumerReference consumer = new HTTPDirectConsumerReference(name, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPDirectConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public EventConsumerReference lookupEventConsumer(FabricAddress address) throws HTTPFabricException {
        String name;
        HTTPEventConsumerReference consumer = new HTTPEventConsumerReference(address, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPEventConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public EventConsumerReference lookupEventConsumer(String name) throws HTTPFabricException {
        HTTPEventConsumerReference consumer = new HTTPEventConsumerReference(name, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPEventConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public ReceiverReference lookupReceiver(FabricAddress address) throws HTTPFabricException {
        String name;
        HTTPReceiverReference receiver = new HTTPReceiverReference(address, this.connection);
        this.initFirstCall(receiver);
        if (this.getMethod != null) {
            receiver.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = receiver.lookupName()) != null) {
            receiver = new HTTPReceiverReference(name, this.connection);
            this.initFirstCall(receiver);
            return receiver;
        }
        return null;
    }

    public ReceiverReference lookupReceiver(String name) throws HTTPFabricException {
        HTTPReceiverReference receiver = new HTTPReceiverReference(name, this.connection);
        this.initFirstCall(receiver);
        if (this.getMethod != null) {
            receiver.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = receiver.lookupName()) != null) {
            receiver = new HTTPReceiverReference(name, this.connection);
            this.initFirstCall(receiver);
            return receiver;
        }
        return null;
    }

    public RequestConsumerReference lookupRequestConsumer(FabricAddress address) throws HTTPFabricException {
        String name;
        HTTPRequestConsumerReference consumer = new HTTPRequestConsumerReference(address, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPRequestConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public RequestConsumerReference lookupRequestConsumer(String name) throws HTTPFabricException {
        HTTPRequestConsumerReference consumer = new HTTPRequestConsumerReference(name, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPRequestConsumerReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public AccessorSessionReference lookupAccessorSession(FabricAddress address) throws HTTPFabricException {
        String name;
        HTTPAccessorSessionReference consumer = new HTTPAccessorSessionReference(address, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPAccessorSessionReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public AccessorReference lookupAccessor(String name) throws HTTPFabricException {
        HTTPAccessorReference consumer = new HTTPAccessorReference(name, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPAccessorReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public AccessorSessionReference lookupAccessorSession(String name) throws HTTPFabricException {
        HTTPAccessorSessionReference consumer = new HTTPAccessorSessionReference(name, this.connection);
        this.initFirstCall(consumer);
        if (this.getMethod != null) {
            consumer.setAdditionalCall(this.makeReferenceGetCall());
        }
        if ((name = consumer.lookupName()) != null) {
            consumer = new HTTPAccessorSessionReference(name, this.connection);
            this.initFirstCall(consumer);
            return consumer;
        }
        return null;
    }

    public List<ReplicationSourceReference> getReplicationSources() {
        List<String> replicationSourceNames = this.listReplicationSources();
        ArrayList<ReplicationSourceReference> replicationSources = new ArrayList<ReplicationSourceReference>();
        for (String name : replicationSourceNames) {
            HTTPReplicationSourceReference reference = new HTTPReplicationSourceReference(name, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            replicationSources.add(reference);
        }
        return replicationSources;
    }

    public List<ReplicationTargetReference> getReplicationTargets() {
        List<String> replicationTargetNames = this.listReplicationSources();
        ArrayList<ReplicationTargetReference> replicationTargets = new ArrayList<ReplicationTargetReference>();
        for (String name : replicationTargetNames) {
            HTTPReplicationTargetReference reference = new HTTPReplicationTargetReference(name, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            replicationTargets.add(reference);
        }
        return replicationTargets;
    }

    public List<ReplicationSourceReference> getReplicationSources(EventScope eventScope) {
        Object[] referenceNames;
        Object result = this.invoke("getReplicationSources", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ReplicationSourceReference> references = new ArrayList<ReplicationSourceReference>();
        for (Object referenceName : referenceNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(referenceName, String.class);
            HTTPReplicationSourceReference reference = new HTTPReplicationSourceReference((String)referenceName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            references.add(reference);
        }
        return references;
    }

    public List<ReplicationTargetReference> getReplicationTargets(EventScope eventScope) {
        Object[] referenceNames;
        Object result = this.invoke("getReplicationTargets", new Object[]{eventScope}, RemoteMethodCallPostprocessor.GET_NAMES_FROM_LIST);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<ReplicationTargetReference> references = new ArrayList<ReplicationTargetReference>();
        for (Object referenceName : referenceNames = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(referenceName, String.class);
            HTTPReplicationTargetReference reference = new HTTPReplicationTargetReference((String)referenceName, this.connection);
            this.initFirstCall(reference);
            if (this.getMethod != null) {
                reference.setAdditionalCall(this.makeReferenceGetCall());
            }
            references.add(reference);
        }
        return references;
    }

    public ReplicationSourceReference lookupReplicationSource(String name) {
        HTTPReplicationSourceReference replicationSource = new HTTPReplicationSourceReference(name, this.connection);
        this.initFirstCall(replicationSource);
        if (this.getMethod != null) {
            replicationSource.setAdditionalCall(this.makeReferenceGetCall());
        }
        if (replicationSource.lookup()) {
            return replicationSource;
        }
        return null;
    }

    public ReplicationTargetReference lookupReplicationTarget(String name) {
        HTTPReplicationTargetReference replicationTarget = new HTTPReplicationTargetReference(name, this.connection);
        this.initFirstCall(replicationTarget);
        if (this.getMethod != null) {
            replicationTarget.setAdditionalCall(this.makeReferenceGetCall());
        }
        if (replicationTarget.lookup()) {
            return replicationTarget;
        }
        return null;
    }

    public List<String> listReplicationSources() {
        Object[] array;
        Object result = this.invoke("listReplicationSources", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listReplicationTargets() {
        Object[] array;
        Object result = this.invoke("listReplicationTargets", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listAccessors() {
        Object[] array;
        Object result = this.invoke("listAccessors", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    public List<String> listAccessorSessions() {
        Object[] array;
        Object result = this.invoke("listAccessorSessions", new Object[0]);
        HTTPFabricConnection.processServerAnswer(result, Object[].class);
        ArrayList<String> vector = new ArrayList<String>();
        for (Object obj : array = (Object[])result) {
            HTTPFabricConnection.processServerAnswer(obj, String.class);
            vector.add((String)obj);
        }
        return vector;
    }

    void initFirstCall(HTTPReference reference) {
    }
}

