/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPClientAliasManager;
import com.streamscape.cli.http.HTTPClientUtils;
import com.streamscape.cli.http.HTTPEventAsyncConsumer;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricConnectionFactory;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.cli.http.HTTPListener;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.enums.EventScope;

class HTTPClientMain {
    HTTPClientMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) {
        if (arguments.length < 2) {
            System.out.println("Usage: client <event-id> <'raise' | 'receive' | 'subscribe'>\n");
            return;
        }
        String eventId = arguments[0];
        String action = arguments[1];
        HTTPFabricConnection connection = null;
        try {
            connection = new HTTPFabricConnectionFactory("http://localhost:11800").createConnection("admin", "admin");
            connection.open();
            ImmutableEventDatagram event = connection.getEventFactory().createEvent(eventId);
            connection.bindProducerFor(eventId);
            HTTPClientAliasManager aliasManager = new HTTPClientAliasManager();
            HTTPClientUtils.addJavaAliases(aliasManager);
            HTTPClientUtils.addSysTypeAliases(aliasManager);
            HTTPClientUtils.realiasHttpAliases(aliasManager);
            JSONSerializerFactory factory = JSONSerializerFactory.getInstance();
            final JSONSerializer serializer = factory.createSerializerDefaultBuilderLazy("HTTPClientMain").apply(builder -> {
                builder.setAliasManager(aliasManager);
                builder.setJsonNotation(JsonNotation.TOP_ELEMENT);
                builder.setPrettyPrint(true);
            }).getOrBuild();
            if (action.equals("raise")) {
                connection.raiseEvent(event, EventScope.GLOBAL, 0L);
                System.out.println("Raised: " + serializer.serialize(event));
            } else if (action.equals("receive")) {
                EventReceiver receiver = connection.createEventReceiver("Receiver", eventId, null, EventScope.GLOBAL, false);
                System.out.println("Receiving ...");
                ImmutableEventDatagram received = receiver.receive();
                System.out.println("Received: " + serializer.serialize(received));
            } else if (action.equals("subscribe")) {
                HTTPListener listener = new HTTPListener(){

                    @Override
                    public void onEvent(ImmutableEventDatagram consumedEvent) {
                        try {
                            System.out.println("Consumed: " + serializer.serialize(consumedEvent));
                        }
                        catch (IAbstractExceptionEvent e) {
                            System.err.println("Consuming event failed: " + String.valueOf(e));
                        }
                    }
                };
                HTTPEventAsyncConsumer consumer = connection.createEventAsyncConsumer("Consumer", listener, eventId, null, EventScope.GLOBAL, false);
                System.out.println("Consuming ...");
                consumer.start();
            } else {
                System.out.println("Usage: client <event-id> <'raise' | 'receive' | 'subscribe'>\n");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        finally {
            try {
                if (!action.equals("subscribe")) {
                    connection.close();
                }
            }
            catch (HTTPFabricException e) {
                e.printStackTrace();
            }
        }
    }
}

