/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.http;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import java.util.List;
import java.util.Map;

public class HTTPClientAliasManagerWithAutoImport
implements SemanticTypeCache,
AliasManager {
    private final HTTPFabricConnection connection;
    private final ObjectMediationAliasManager aliasManager;

    public HTTPClientAliasManagerWithAutoImport(HTTPFabricConnection connection) {
        this.connection = connection;
        this.aliasManager = connection.getAliasManager();
    }

    @Override
    public String resolveSemanticClass(Class semanticClass) {
        return this.aliasManager.resolveSemanticClass(semanticClass);
    }

    @Override
    public SemanticType lookupSemanticType(String typeName) {
        this.importSemanticTypeIfNotExist(typeName);
        return this.aliasManager.lookupSemanticType(typeName);
    }

    @Override
    public SemanticType lookupSemanticClass(Class semanticClass) {
        return this.aliasManager.lookupSemanticClass(semanticClass);
    }

    @Override
    public SemanticType lookupSemanticClass(String className) {
        return this.aliasManager.lookupSemanticClass(className);
    }

    @Override
    public boolean existsSemanticType(String typeName) {
        this.importSemanticTypeIfNotExist(typeName);
        return this.aliasManager.existsSemanticType(typeName);
    }

    @Override
    public boolean existsSemanticClass(Class semanticClass) {
        return this.aliasManager.existsSemanticClass(semanticClass);
    }

    @Override
    public boolean existsSemanticClass(String className) {
        return this.aliasManager.existsSemanticClass(className);
    }

    @Override
    public List<String> listSemanticTypes() {
        return this.aliasManager.listSemanticTypes();
    }

    @Override
    public String resolveSemanticType(String typeName) {
        this.importSemanticTypeIfNotExist(typeName);
        return this.aliasManager.resolveSemanticType(typeName);
    }

    @Override
    public String resolveSemanticClass(String className) {
        return this.aliasManager.resolveSemanticClass(className);
    }

    @Override
    public List<String> listSemanticTypesByAncestor(String ancestorName) {
        return this.aliasManager.listSemanticTypesByAncestor(ancestorName);
    }

    @Override
    public List<String> listUserSemanticTypes() {
        return this.aliasManager.listUserSemanticTypes();
    }

    @Override
    public List<String> listUserSemanticTypesByAncestor(String ancestorName) {
        return this.aliasManager.listUserSemanticTypesByAncestor(ancestorName);
    }

    @Override
    public void alias(String alias, Class type) throws FactoryManagerException {
        this.aliasManager.alias(alias, type);
    }

    @Override
    public void aliasImmutableType(SemanticType semanticType) throws FactoryManagerException {
        this.aliasManager.aliasImmutableType(semanticType);
    }

    @Override
    public void aliasImmutableType(Class clazz) {
        this.aliasManager.aliasImmutableType(clazz);
    }

    @Override
    public boolean isImmutableTypeAliased(Class clazz) {
        return this.aliasManager.isImmutableTypeAliased(clazz);
    }

    @Override
    public void alias(SemanticType type) throws FactoryManagerException {
        this.aliasManager.alias(type);
    }

    @Override
    public void unalias(SemanticType type) throws FactoryManagerException {
        this.aliasManager.unalias(type);
    }

    @Override
    public void unalias(String alias) throws FactoryManagerException {
        this.aliasManager.unalias(alias);
    }

    @Override
    public List<String> listAliases() {
        return this.aliasManager.listAliases();
    }

    @Override
    public String lookup(Class clazz) {
        return this.aliasManager.lookup(clazz);
    }

    @Override
    public String lookup(String typeName) {
        this.importSemanticTypeIfNotExist(typeName);
        return this.aliasManager.lookup(typeName);
    }

    @Override
    public String resolveClass(String className) {
        return this.aliasManager.resolveClass(className);
    }

    @Override
    public boolean isAliased(String typeName) {
        this.importSemanticTypeIfNotExist(typeName);
        return this.aliasManager.isAliased(typeName);
    }

    @Override
    public boolean isAliased(Class type) {
        return this.aliasManager.isAliased(type);
    }

    @Override
    public boolean isClassAliased(String className) {
        return this.aliasManager.isClassAliased(className);
    }

    public boolean isInstanceOfAncestor(String typeName) throws FactoryManagerException {
        return this.aliasManager.isInstanceOfAncestor(typeName);
    }

    @Override
    public List<String> listComponentSemanticTypes(String typeName) {
        return this.aliasManager.listSemanticTypes();
    }

    @Override
    public List<String> listDependentSemanticTypes(String typeName) {
        return this.aliasManager.listDependentSemanticTypes(typeName);
    }

    @Override
    public List<String> listDependentUserSemanticTypes(String typeName) {
        return this.aliasManager.listDependentUserSemanticTypes(typeName);
    }

    @Override
    public boolean isSemanticTypeDependsOn(String typeName, String targetTypeName) {
        return this.aliasManager.isSemanticTypeDependsOn(typeName, targetTypeName);
    }

    @Override
    public Map<String, Object> getAncestorTree() {
        return this.aliasManager.getAncestorTree();
    }

    @Override
    public Map<String, Object> getUserAncestorTree() {
        return this.aliasManager.getUserAncestorTree();
    }

    private void importSemanticTypeIfNotExist(String typeName) {
        if (!this.aliasManager.existsSemanticType(typeName)) {
            this.connection.importSemanticType(typeName);
        }
    }
}

