/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.cli.ds.collection;

import com.streamscape.cli.ds.collection.FacetsKeys;
import com.streamscape.cli.ds.collection.FacetsValues;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.stable.rplmethod.IsMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethodHidden;
import com.streamscape.ds.types.FacetsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Facets
extends LinkedHashMap<String, Object> {
    public Facets() {
    }

    public Facets(Map map) {
        super(map);
    }

    public FacetsKeys keys() {
        return new FacetsKeys(this.keySet());
    }

    public FacetsValues values() {
        return new FacetsValues((Collection<?>)super.values());
    }

    @RPLMethod(description="Creates new Facets which is copy of current Facets and with deleted specified key.\nCan be used in UPDATE statement.", samples={"facets newFacet = myfacet.delete('mykey')"})
    @IsMethod
    public Facets delete(String key) {
        Facets copy = new Facets((Map)this);
        copy.remove(key);
        return copy;
    }

    @Override
    @RPLMethod(description="Behaviour is different depending on context.\nIn assigment statement: updates value for specified key in this Facets object and return old value associated with this key.\nIn UPDATE statement: creates new Facets which is copy of current Facets and with updated value for specified key. ", samples={"facets newFacet = myfacet.put('mykey', 'myvalue')"})
    @IsMethod
    public Facets put(String key, Object value) {
        if (FacetsUtils.isUpdateStatementLevel2()) {
            return this.set(key, value);
        }
        super.put(key, value);
        return this;
    }

    @Override
    @RPLMethod(description="Updates values for specified keys in this Facets object.\nCannot be used in UPDATE statement.", samples={"myfacet.putAll({a: 1, b: 'qwe',})"})
    @IsMethod
    public void putAll(Map facet) {
        super.putAll(facet);
    }

    @RPLMethod(description="Creates new Facets which is copy of current Facets and with updated value for specified key.\nCan be used in UPDATE statement.", samples={"facets newFacet = myfacet.set('mykey', 'myvalue')"})
    @IsMethod
    public Facets set(String key, Object value) {
        Facets copy = new Facets((Map)this);
        copy.putInternal(key, value);
        return copy;
    }

    @RPLMethod(description="Creates new Facets which is copy of current Facets and with updated values from provided Map.\nCan be used in UPDATE statement.", samples={"facets newFacet = myfacet.setAll(frommap)", "facets newFacet = myfacet.setAll(new facets({mykey: 'myvalue', anotherkey: 123}))"})
    @IsMethod
    public Facets setAll(Map facet) {
        Facets copy = new Facets((Map)this);
        copy.putAll(facet);
        return copy;
    }

    public Facets deleteAll() {
        return new Facets();
    }

    @RPLMethod(description="Creates new Facets which is copy of current Facets with entries sorted by value.", samples={"facets newFacet = myfacet.sortByValues('asc')", "facets newFacet = myfacet.sortByValues('ascending')", "facets newFacet = myfacet.sortByValues('desc')", "facets newFacet = myfacet.sortByValues('descending')"})
    @IsMethod
    public Facets sortByValues(String direction) {
        if (direction == null) {
            throw new DataspaceException("Direction is null.");
        }
        if ((direction = direction.toLowerCase()).equals("asc") || direction.equals("ascending")) {
            return this.sortByValuesInternal(1);
        }
        if (direction.equals("desc") || direction.equals("descending")) {
            return this.sortByValuesInternal(-1);
        }
        throw new DataspaceException("Invalid direction '" + direction + "' should be one of {asc | ascending | desc | descending}.");
    }

    private Facets sortByValuesInternal(int direction) {
        Facets result = new Facets();
        ArrayList entries = new ArrayList(this.entrySet());
        entries.sort((e1, e2) -> {
            if (e1.getValue() instanceof Comparable) {
                return direction * ((Comparable)e1.getValue()).compareTo(e2.getValue());
            }
            if (e2.getValue() instanceof Comparable) {
                return -direction * ((Comparable)e2.getValue()).compareTo(e1.getValue());
            }
            return 0;
        });
        entries.forEach((? super E e) -> result.put((String)e.getKey(), e.getValue()));
        return result;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private void putInternal(String key, Object value) {
        super.put(key, value);
    }

    @Override
    @RPLMethodHidden
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        super.replaceAll(function);
    }

    @Override
    @RPLMethodHidden
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    @RPLMethodHidden
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return super.computeIfPresent(key, remappingFunction);
    }

    @Override
    @RPLMethodHidden
    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return super.compute(key, remappingFunction);
    }

    @Override
    @RPLMethodHidden
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return super.merge(key, value, remappingFunction);
    }

    @Override
    @RPLMethodHidden
    public Object clone() {
        return super.clone();
    }
}

