/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class Version {
    public static final String COPYRIGHT = "Copyright (c) 2015-2025 StreamScape Technologies";
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 8;
    private static final int MAJOR_BUILD = 47;
    private static final int MINOR_BUILD = 0;
    private static final boolean TRIAL = false;

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 8;
    }

    public static int getMajorBuild() {
        return 47;
    }

    public static int getMinorBuild() {
        return 0;
    }

    public static String getVersion() {
        return Version.getVersion(47, 0);
    }

    protected static String getVersion(int majorBuild, int minorBuild) {
        return Version.formatVersionWithBuild(3, 8, majorBuild, minorBuild);
    }

    public static String formatVersionWithBuild(int majorVersion, int minorVersion, int majorBuild, int minorBuild) {
        return Version.formatVersion(majorVersion, minorVersion) + "." + Version.formatBuild(majorBuild, minorBuild);
    }

    private static String formatVersion() {
        return "3.8";
    }

    private static String formatVersion(int majorVersion, int minorVersion) {
        return majorVersion + "." + minorVersion;
    }

    public static String formatBuild(int majorBuild, int minorBuild) {
        return Version.formatMajorBuild(majorBuild) + Version.formatMinorBuild(minorBuild);
    }

    public static String formatMajorBuild(int majorBuild) {
        return String.format("%1$03d", majorBuild);
    }

    private static String formatMinorBuild(int minorBuild) {
        return Version.formatMinorBuild(minorBuild, true);
    }

    private static String formatMinorBuild(int minorBuild, boolean withDot) {
        return minorBuild > 0 ? (withDot ? "." : "") + String.format("%1$02d", minorBuild) : "";
    }

    public static String getVersionString() {
        return Version.getVersionString("Service Application Engine");
    }

    protected static String getVersionString(String prefix) {
        return prefix + ": Release " + Version.getVersion();
    }

    protected static String getVersionString(String prefix, int majorBuild, int minorBuild) {
        return prefix + ": Release " + Version.getVersion(majorBuild, minorBuild);
    }

    public static String getVendorString() {
        return Version.getVersionString() + " Copyright (c) 2015-2025 StreamScape Technologies";
    }

    protected static String getVendorString(String prefix, int majorBuild, int minorBuild) {
        return Version.getVersionString(prefix, majorBuild, minorBuild) + " Copyright (c) 2015-2025 StreamScape Technologies";
    }

    public static int getSerialId(int build) {
        return 308000 + build;
    }

    public static boolean isTrial() {
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            File oldFile = new File("src/com/streamscape/Version.java");
            File newFile = new File("src/com/streamscape/Version.java.new");
            try (BufferedReader reader = new BufferedReader(new FileReader("src/com/streamscape/Version.java"));
                 FileWriter writer = new FileWriter("src/com/streamscape/Version.java.new");){
                boolean done = false;
                while (reader.ready()) {
                    String str = reader.readLine();
                    if (!done && str.contains("    private static final int     MINOR_BUILD = ")) {
                        str = "    private static final int     MINOR_BUILD = 1;";
                        done = true;
                    }
                    writer.write(str);
                    writer.write("\n");
                }
            }
            if (!oldFile.delete()) {
                throw new Exception("Deleting '" + oldFile.getPath() + "' failed.");
            }
            if (!newFile.renameTo(oldFile)) {
                throw new Exception("Renaming '" + newFile.getPath() + "' to '" + oldFile.getPath() + "' failed.");
            }
            if (!oldFile.exists()) {
                throw new Exception("File '" + oldFile.getPath() + "' does not exist.");
            }
        } else {
            Version.writeBuildNumberFile(args[0], 3, 8, 47, 0);
        }
    }

    public static void writeBuildNumberFile(String appVersion, int majorVersion, int minorVersion, int majorBuild, int minorBuild) throws IOException {
        FileWriter writer = new FileWriter("build.number");
        writer.write("majorBuild=" + majorBuild + "\n");
        writer.write("majorBuildString=" + Version.formatMajorBuild(majorBuild) + "\n");
        writer.write("minorBuild=" + minorBuild + "\n");
        writer.write("minorBuildString=" + Version.formatMinorBuild(minorBuild, false) + "\n");
        writer.write("buildNumber=" + Version.formatBuild(majorBuild, minorBuild) + "\n");
        writer.write("buildNumberPrevious=" + Version.formatBuild(majorBuild, minorBuild - 1) + "\n");
        writer.write("runtimeVersion=" + Version.formatVersionWithBuild(majorVersion, minorVersion, majorBuild, minorBuild) + "\n");
        writer.write("app.version.build=" + appVersion + "\n");
        writer.write("app.version.build.full=" + appVersion + Version.formatMinorBuild(minorBuild) + "\n");
        writer.write("app.version=" + Version.formatVersion(majorVersion, minorVersion) + "." + appVersion + Version.formatMinorBuild(minorBuild) + "\n");
        writer.write("releaseTimestamp=" + new Date().getTime() + "\n");
        writer.write("buildType=" + (minorBuild > 0 ? "nightly" : "final"));
        writer.close();
    }
}

