/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceRuntimeVersionUpdater {
    public static void main(String[] args) throws Exception {
        File runtimeFile = new File("../struntime/src/com/streamscape/Version.java");
        File currentFile = new File("src/main/java/com/streamscape/RuntimeVersion.java");
        File currentFileNew = new File("src/main/java/com/streamscape/RuntimeVersion.java.new");
        String runtimeContent = new String(Files.readAllBytes(runtimeFile.toPath()));
        String currentContent = new String(Files.readAllBytes(currentFile.toPath()));
        currentContent = ServiceRuntimeVersionUpdater.replace(runtimeContent, currentContent, "MAJOR_VERSION");
        currentContent = ServiceRuntimeVersionUpdater.replace(runtimeContent, currentContent, "MINOR_VERSION");
        currentContent = ServiceRuntimeVersionUpdater.replace(runtimeContent, currentContent, "MAJOR_BUILD");
        currentContent = ServiceRuntimeVersionUpdater.replace(runtimeContent, currentContent, "MINOR_BUILD");
        currentFileNew.delete();
        Files.write(currentFileNew.toPath(), currentContent.getBytes(), new OpenOption[0]);
        if (!currentFile.delete()) {
            throw new Exception("Deleting '" + currentFile.getPath() + "' failed.");
        }
        if (!currentFileNew.renameTo(currentFile)) {
            throw new Exception("Renaming '" + currentFileNew.getPath() + "' to '" + currentFile.getPath() + "' failed.");
        }
        if (!currentFile.exists()) {
            throw new Exception("File '" + currentFile.getPath() + "' does not exist.");
        }
    }

    private static String replace(String source, String target, String name) throws Exception {
        Pattern pattern = Pattern.compile(name + "\\s*=\\s*(\\d*);");
        Matcher matcherSource = pattern.matcher(source);
        if (!matcherSource.find()) {
            throw new Exception("Pattern " + pattern.toString() + " not found in source file.");
        }
        String version = matcherSource.group(1);
        Matcher matcherTarget = pattern.matcher(target);
        if (!matcherTarget.find()) {
            throw new Exception("Pattern " + pattern.toString() + " not found in target file.");
        }
        return new StringBuilder(target).replace(matcherTarget.start(1), matcherTarget.end(1), version).toString();
    }
}

