/*
 * Decompiled with CFR 0.152.
 */
package samples.txfs;

import com.streamscape.lib.txfs.FileTransaction;
import com.streamscape.lib.txfs.FileTransactionStateAdvisoryListener;
import com.streamscape.lib.txfs.TransactionState;
import com.streamscape.lib.txfs.mf.admin.FileResourceManagerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class TxfsDemo {
    protected FileTransaction tx;
    protected String txId;
    protected static BufferedReader reader;
    protected static TxfsDemo txDemo;
    protected boolean isRecover = false;
    protected boolean isRollback = false;
    protected boolean isCommitted = false;

    public static void main(String[] args) throws IOException {
        System.out.println("Welcome to TXFS Demo. Here you can try to work with files in transacted manner.");
        System.out.println("");
        reader = new BufferedReader(new InputStreamReader(System.in));
        txDemo = new TxfsDemo();
        txDemo.askForActionBegin();
    }

    private void askForActionBegin() throws IOException {
        this.isCommitted = false;
        this.isRecover = false;
        this.isRollback = false;
        System.out.println("(1) - Begin simple transaction. Only rollback is possible");
        System.out.println("(2) - Begin suspendable transaction (It means that you can manually try to roll-forward if commit or checkpoint fails)");
        System.out.println("(3) - Begin auto-recover transaction");
        System.out.println("-----------------------");
        System.out.println("(0) - exit");
        System.out.print("Enter you choice: ");
        String line = reader.readLine();
        if (line == null || line.length() <= 0) {
            System.out.println("Wrong parameter. Please, re-enter.");
            this.askForActionBegin();
        } else {
            char ac = line.charAt(0);
            switch (ac) {
                case '1': {
                    this.startSimpleTransaction();
                    break;
                }
                case '2': {
                    this.startSuspTransaction();
                    break;
                }
                case '3': {
                    this.startAutoRecoverTransaction();
                    break;
                }
                case '0': {
                    this.exit();
                    break;
                }
                default: {
                    this.askForActionBegin();
                }
            }
        }
    }

    private void startSimpleTransaction() throws IOException {
        System.out.println("Input necessary transaction parameters");
        String workingDir = this.readUserInput("working directory");
        String name = this.readUserInput("transaction name");
        FileResourceManagerFactory.setWorkDirectory((String)workingDir);
        this.tx = FileResourceManagerFactory.createTransaction((String)name);
        this.txId = this.tx.getGuid();
        this.chooseAction();
    }

    private void startSuspTransaction() throws IOException {
        System.out.println("Input necessary transaction parameters");
        String workingDir = this.readUserInput("working directory");
        FileResourceManagerFactory.setWorkDirectory((String)workingDir);
        String name = this.readUserInput("transaction name");
        this.tx = FileResourceManagerFactory.createTransaction((String)name, (boolean)true);
        this.txId = this.tx.getGuid();
        this.chooseAction();
    }

    private void startAutoRecoverTransaction() throws IOException {
        System.out.println("Input necessary transaction parameters");
        String workingDir = this.readUserInput("working directory");
        String name = this.readUserInput("transaction name");
        long recover = -1L;
        while (recover < 0L) {
            String recoverStr = this.readUserInput("timeout between recover attempts");
            try {
                recover = Long.parseLong(recoverStr);
            }
            catch (NumberFormatException e) {
                System.out.println("Wrong input data. Input again.");
            }
        }
        int numberOfAttempts = -1;
        while (numberOfAttempts < 0) {
            String attemptsStr = this.readUserInput("number of attempts");
            try {
                numberOfAttempts = Integer.parseInt(attemptsStr);
            }
            catch (NumberFormatException e) {
                System.out.println("Wrong input data. Input again.");
            }
        }
        FileResourceManagerFactory.setWorkDirectory((String)workingDir);
        this.tx = FileResourceManagerFactory.createTransaction((String)name, (long)recover, (int)numberOfAttempts);
        this.txId = this.tx.getGuid();
        this.chooseAction();
    }

    private void chooseAction() throws IOException {
        System.out.println("");
        System.out.println("Choose further action.");
        if (!this.isCommitted) {
            System.out.println("(1) - add copy action");
            System.out.println("(2) - add move action");
            System.out.println("(3) - add delete action");
            System.out.println("(4) - add rename action");
            System.out.println("-----------------------");
            System.out.println("(6) - checkpoint");
            System.out.println("(7) - commit");
        }
        if (this.isRecover) {
            System.out.println("(8) - recover");
        }
        if (this.isRollback) {
            System.out.println("(9) - rollback");
        }
        System.out.println("-----------------------");
        System.out.println("(0) - exit");
        System.out.print("Enter you choice: ");
        String line = reader.readLine();
        if (line == null || line.length() <= 0) {
            System.out.println("Wrong parameter. Please, re-enter.");
            this.chooseAction();
        } else {
            char ac = line.charAt(0);
            try {
                switch (ac) {
                    case '1': {
                        this.addCopy();
                        break;
                    }
                    case '2': {
                        this.addMove();
                        break;
                    }
                    case '3': {
                        this.addDelete();
                        break;
                    }
                    case '4': {
                        this.addRename();
                        break;
                    }
                    case '6': {
                        this.checkpoint();
                        break;
                    }
                    case '7': {
                        this.commit();
                        break;
                    }
                    case '8': {
                        this.recover();
                        break;
                    }
                    case '9': {
                        this.rollback();
                        break;
                    }
                    case '0': {
                        this.exit();
                    }
                    default: {
                        System.out.println("Wrong input. Try again");
                        this.chooseAction();
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.out.println();
                System.out.println("Exception: " + e.getLocalizedMessage());
                this.waitForUser();
                this.chooseAction();
            }
        }
    }

    private void waitForUser() throws IOException {
        System.out.println("Press 'Enter' to continue...");
        reader.readLine();
    }

    private void addCopy() throws IOException {
        System.out.println("Enter parameters for copy action:");
        String from = this.readUserInput("source file");
        String to = this.readUserInput("destination file");
        FileResourceManagerFactory.getTransaction((String)this.txId).copy(from, to);
        System.out.println("Add copy action from '" + from + "' to '" + to + "'");
        this.chooseAction();
    }

    private void addMove() throws IOException {
        System.out.println("Enter parameters for move action:");
        String from = this.readUserInput("source file");
        String to = this.readUserInput("destination file");
        FileResourceManagerFactory.getTransaction((String)this.txId).moveFile(from, to);
        System.out.println("Add move action from '" + from + "' to '" + to + "'");
        this.chooseAction();
    }

    private void addDelete() throws IOException {
        System.out.println("Enter parameters for delete action:");
        String from = this.readUserInput("file to delete");
        this.tx.delete(from);
        System.out.println("Add delete action for '" + from + "'");
        this.chooseAction();
    }

    private void addRename() throws IOException {
        System.out.println("Enter parameters for rename action:");
        String from = this.readUserInput("source file");
        String to = this.readUserInput("destination file");
        this.tx.rename(from, to);
        System.out.println("Add rename action from '" + from + "' to '" + to + "'");
        this.chooseAction();
    }

    private void commit() throws IOException {
        System.out.println("Committing");
        try {
            this.isCommitted = true;
            this.tx.commit();
            while (!this.tx.isDone()) {
                System.out.print(".");
                Thread.sleep(200L);
            }
            this.tx.getResult();
            System.out.println("");
            System.out.println("Successful commit");
            this.waitForUser();
            this.askForActionBegin();
        }
        catch (Exception e) {
            System.out.println("\nException while committing: " + e.getCause().getLocalizedMessage());
            this.isRollback = true;
            if (this.tx.isSuspendable()) {
                this.isRecover = true;
            }
            if (this.tx.isAutoRecovery()) {
                System.out.println("Waiting for auto-recovery");
                this.tx.setListener((FileTransactionStateAdvisoryListener)new MyFileTransactionStateAdvisoryListener());
            }
            this.chooseAction();
        }
    }

    private void checkpoint() throws IOException {
        System.out.println("Start making a checkpoint...");
        try {
            this.tx.checkpoint();
            while (!this.tx.isDone()) {
                System.out.print(".");
                Thread.sleep(200L);
            }
            this.tx.getResult();
            System.out.println("");
            System.out.println("Successful commit");
            System.out.println("Checkpoint done");
            this.waitForUser();
            this.isRollback = true;
            this.chooseAction();
        }
        catch (Exception e) {
            if (this.tx.isSuspendable()) {
                this.isRecover = true;
            }
            this.isRollback = true;
            System.out.println("\nException while checkpoint: " + e.getCause().getLocalizedMessage());
            if (this.tx.isAutoRecovery()) {
                System.out.println("Waiting for auto-recovery");
                this.tx.setListener((FileTransactionStateAdvisoryListener)new MyFileTransactionStateAdvisoryListener());
            }
            this.chooseAction();
        }
    }

    private void rollback() throws IOException {
        System.out.println("Starting rollback...");
        try {
            this.tx.rollback();
            System.out.println("Successful rollback");
            this.waitForUser();
            this.askForActionBegin();
        }
        catch (Exception e) {
            System.out.println("Exception while rolling back: " + e.getLocalizedMessage());
            this.chooseAction();
        }
    }

    private void recover() throws IOException {
        System.out.println("Starting recover...");
        try {
            this.tx.recover();
            System.out.println("Successful recover");
            this.waitForUser();
            this.askForActionBegin();
        }
        catch (Exception e) {
            System.out.println("Exception while recovering: " + e.getLocalizedMessage());
            this.chooseAction();
        }
    }

    private String readUserInput(String message) {
        System.out.print("Enter " + message + ": ");
        try {
            String directory = reader.readLine();
            boolean success = true;
            if (directory == null || directory.length() <= 0) {
                success = false;
            }
            if (success) {
                return directory;
            }
            System.out.println(message + "is not correct. Please, re-enter.");
            return this.readUserInput(message);
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read " + message + "!");
            return this.readUserInput(message);
        }
    }

    private void exit() {
        System.exit(0);
    }

    private class MyFileTransactionStateAdvisoryListener
    implements FileTransactionStateAdvisoryListener {
        private MyFileTransactionStateAdvisoryListener() {
        }

        public void onStateChange(TransactionState state) {
            System.out.println("Change transaction state to " + String.valueOf(state));
            try {
                if (state == TransactionState.ONLY_ROLLBACK) {
                    TxfsDemo.this.chooseAction();
                } else if (state == TransactionState.COMMITED) {
                    System.out.println("Successfully commit transaction");
                    TxfsDemo.this.askForActionBegin();
                } else if (state == TransactionState.ROLLED_BACK) {
                    System.out.println("Successfully rolled back transaction");
                    TxfsDemo.this.askForActionBegin();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

