/*
 * Decompiled with CFR 0.152.
 */
package samples.txfs;

import com.streamscape.lib.txfs.mf.admin.FileResourceManagerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import samples.txfs.AbstractTXFSDemo;

public class OpenFileDemo
extends AbstractTXFSDemo {
    protected boolean isCreated;
    private RandomAccessFile raf;

    public static void main(String[] args) throws IOException {
        System.out.println("Welcome to TXFS Demo. Here you can try to work with files in transacted manner.");
        System.out.println("This demo shows you how to create file under transactions.");
        System.out.println("Firstly, choose working directory and transaction name");
        System.out.println("Secondly, enter file name to open");
        System.out.println("Then, you can read or write some data");
        System.out.println("Finally, you can make a checkpoint with partly created file or full commit.");
        System.out.println("Press <Enter> to start.");
        reader = new BufferedReader(new InputStreamReader(System.in));
        txDemo = new OpenFileDemo();
        reader.readLine();
        ((OpenFileDemo)txDemo).startSimpleTransaction();
    }

    private void startSimpleTransaction() throws IOException {
        System.out.println("Input necessary transaction parameters");
        String workingDir = this.readUserInput("working directory");
        String name = this.readUserInput("transaction name");
        FileResourceManagerFactory.setWorkDirectory((String)workingDir);
        this.tx = FileResourceManagerFactory.createTransaction((String)name);
        this.txId = this.tx.getGuid();
        this.chooseAction();
    }

    @Override
    protected void chooseAction() throws IOException {
        System.out.println("");
        System.out.println("Choose further action.");
        if (!this.isCommitted) {
            if (!this.isCreated) {
                System.out.println("(1) - open file action");
            } else {
                System.out.println("(2) - read data from the file");
                System.out.println("(3) - write data to the file");
                System.out.println("(4) - seek to the beginning of the file");
            }
            System.out.println("-----------------------");
            System.out.println("(6) - checkpoint");
            System.out.println("(7) - commit");
        }
        if (this.isRecover) {
            System.out.println("(8) - recover");
        }
        if (this.isRollback) {
            System.out.println("(9) - rollback");
        }
        System.out.println("-----------------------");
        System.out.println("(0) - exit");
        System.out.print("Enter you choice: ");
        String line = reader.readLine();
        if (line == null || line.length() <= 0) {
            System.out.println("Wrong parameter. Please, re-enter.");
            this.chooseAction();
        } else {
            char ac = line.charAt(0);
            try {
                switch (ac) {
                    case '1': {
                        this.addCreateFile();
                        break;
                    }
                    case '2': {
                        this.readData();
                        break;
                    }
                    case '3': {
                        this.writeData();
                        break;
                    }
                    case '4': {
                        this.seekToZero();
                        break;
                    }
                    case '6': {
                        this.checkpoint();
                        break;
                    }
                    case '7': {
                        this.commit();
                        break;
                    }
                    case '8': {
                        this.recover();
                        break;
                    }
                    case '9': {
                        this.rollback();
                        break;
                    }
                    case '0': {
                        this.exit();
                    }
                    default: {
                        System.out.println("Wrong input. Try again");
                        this.chooseAction();
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.out.println();
                System.out.println("Exception: " + e.getLocalizedMessage());
                this.waitForUser();
                this.chooseAction();
            }
        }
    }

    private void addCreateFile() throws IOException {
        System.out.println("Enter parameters for rename action:");
        String fileName = this.readUserInput("file name");
        this.raf = this.tx.open(fileName);
        this.raf.seek(0L);
        System.out.println("Prepare create file action for '" + fileName + "'");
        this.isCreated = true;
        this.chooseAction();
    }

    private void readData() throws IOException {
        System.out.println("Read data:");
        String line = this.raf.readLine();
        System.out.println(line);
        this.chooseAction();
    }

    private void writeData() throws IOException {
        String data = this.readUserInput("file data and press <Enter>");
        this.raf.write(data.getBytes());
        System.out.println("Data has been written down");
        this.chooseAction();
    }

    private void seekToZero() throws IOException {
        this.raf.seek(0L);
        System.out.println("File read position is the very beginning");
        this.chooseAction();
    }
}

