/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.xml.utils;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.StreamState;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.StreamStateEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.file.FileMetaInfo;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.xml.enums.XMLStreamState;
import java.io.File;

public class EventSenders {
    public static void sendFileProcessedEvent(File file, EventDatagramFactory datagramFactory, ServiceContext ctx, String fileActionEventId) throws DatagramFactoryException, SDOException, SecurityViolationException, FabricEventSourceException, FabricEventException {
        FileMetaInfo processed = new FileMetaInfo(file);
        FileEvent processedEvent = (FileEvent)datagramFactory.createEvent(fileActionEventId);
        processedEvent.init(processed);
        if (ctx.getIdentityPlugin() != null) {
            ctx.getIdentityPlugin().setDatagramIdentity((EventDatagram)processedEvent);
        }
        ctx.raiseEvent((ImmutableEventDatagram)processedEvent, 0L);
    }

    public static void sendXMLStreamStateEvent(XMLStreamState state, EventDatagramFactory datagramFactory, ServiceContext ctx, boolean sendStreamEvent, String streamStateEventId) {
        try {
            if (sendStreamEvent) {
                DataEvent event = (DataEvent)datagramFactory.createEvent(streamStateEventId);
                event.setData((Object)state);
                ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public static void sendStreamStateEvent(StreamState state, EventDatagramFactory datagramFactory, ServiceContext ctx, boolean sendStreamEvent, String streamStateEventId) {
        try {
            if (sendStreamEvent) {
                StreamStateEvent event = (StreamStateEvent)datagramFactory.createEvent(streamStateEventId);
                event.setStreamState(state);
                ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

