/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.xml.evSource;

import com.streamscape.lib.xml.XMLNodeEventListener;
import com.streamscape.omf.xml.EscapeStrategy;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.StreamState;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.xml.enums.SourceDispatchModel;
import com.streamscape.service.xml.evSource.DataEventListener;
import com.streamscape.service.xml.evSource.Version;
import com.streamscape.service.xml.evSource.XMLEventListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class XMLEventSource
extends AbstractDaemonService {
    private long pollingInterval = 0L;
    private String pollingFileName = null;
    private String xmlEncoding = null;
    private EscapeStrategy escapeStrategy = EscapeStrategy.ESCAPE_SYSTEM;
    private boolean sendOpenStreamEvent = false;
    private boolean sendCloseStreamEvent = false;
    private boolean sendAbortStreamEvent = false;
    private String streamStateEventId = null;
    private String fileActionEventId = null;
    private EventDatagramFactory datagramFactory = null;
    private List<XMLNodeEventListener> listeners = new ArrayList<XMLNodeEventListener>();
    private SourceDispatchModel dispatchModel = null;

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void processFile(ImmutableEventDatagram event) throws IllegalStateException {
        if (event == null || !(event instanceof FileEvent)) {
            throw new IllegalStateException("Incoming event is in incompatible format");
        }
        if (!this.activated) {
            throw new IllegalStateException("Service is not started. Incoming request can't be processed.");
        }
        try {
            String filePath = ((FileEvent)event).getAbsoluteFileName();
            if (filePath == null || filePath.isEmpty()) {
                filePath = ((FileEvent)event).getRelativeFileName();
            }
            this.processFile(filePath);
        }
        catch (Exception error) {
            throw new IllegalStateException("Failed to get filename from event: " + String.valueOf(error));
        }
    }

    protected void doRepeatableServiceLogic() {
        try {
            Thread.sleep(this.pollingInterval);
            this.processFile(this.pollingFileName);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private void processFile(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doInit() {
        try {
            super.doInit();
            if (!this.sco.hasProperty("source.dispatch.model")) {
                throw new RuntimeException("Source Dipatch Model should be specified.");
            }
            this.dispatchModel = SourceDispatchModel.valueOf(this.ctx.lookupStringProperty("source.dispatch.model").toString());
            if (this.dispatchModel == SourceDispatchModel.FILE_POLL) {
                this.pollingInterval = this.ctx.lookupNumericProperty("polling.interval");
                this.pollingFileName = this.ctx.lookupStringProperty("polling.file.name");
            }
            this.streamStateEventId = this.ctx.lookupStringProperty("stream.state.eventid");
            this.fileActionEventId = this.ctx.lookupStringProperty("file.action.eventid");
            if (this.sco.hasProperty("xml.encoding")) {
                this.xmlEncoding = this.ctx.lookupStringProperty("xml.encoding");
                this.ctx.logInfo("Encoding for parsing XML files is set to: " + this.xmlEncoding);
            }
            if (this.sco.hasProperty("xml.escaping")) {
                this.escapeStrategy = EscapeStrategy.valueOf((String)this.ctx.lookupStringProperty("xml.escaping"));
                this.ctx.logInfo("XML escaping strategy is set to '" + this.escapeStrategy.name() + "'.");
            } else {
                this.ctx.logInfo("XML escaping strategy is not set. Default '" + this.escapeStrategy.name() + "' is used.");
            }
            this.datagramFactory = EventDatagramFactory.getInstance();
            Hashtable table = this.ctx.lookupTableProperty("xpath.eventid.map");
            for (Map.Entry prop : table.entrySet()) {
                Object listener;
                String xpath = (String)prop.getKey();
                String eventId = ((ServiceConfigurationProperty)prop.getValue()).toString();
                EventDatagram event = EventDatagramFactory.getInstance().createEvent(eventId);
                XSerializer serializer = RuntimeContext.getInstance().getXSerializer();
                if (event instanceof XMLEvent) {
                    listener = new XMLEventListener(xpath, eventId, this.ctx, this.datagramFactory);
                } else if (event instanceof DataEvent) {
                    listener = new DataEventListener(xpath, eventId, this.ctx, this.datagramFactory, serializer);
                } else {
                    throw new IllegalArgumentException("Unsupported event [" + eventId + "] is specified for XPath [" + xpath + "].");
                }
                this.listeners.add((XMLNodeEventListener)listener);
            }
            this.sendOpenStreamEvent = this.ctx.lookupBooleanProperty("raise.open.stream.event");
            this.sendCloseStreamEvent = this.ctx.lookupBooleanProperty("raise.close.stream.event");
            this.sendAbortStreamEvent = this.ctx.lookupBooleanProperty("raise.abort.stream.event");
        }
        catch (ServiceConfigurationException error) {
            throw new RuntimeException(error);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw new RuntimeException(error);
        }
    }

    public void start() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL) {
            super.start();
        } else {
            this.activated = true;
        }
    }

    public void resume() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL) {
            super.resume();
        } else {
            this.activated = true;
        }
    }

    public void stop() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL) {
            super.stop();
        } else {
            this.activated = false;
        }
    }

    public void suspend() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL) {
            super.suspend();
        } else {
            this.activated = false;
        }
    }

    public static void main(String[] args) {
        try {
            TraceConfigurator.getInstance().enableLog("./tnode.log");
            TraceConfigurator.getInstance().init(true, "tnode.traces");
            System.out.println(RuntimeContext.getInstance().getXSerializer().serialize((Object)XMLEventSource.generateSco()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        if (!TypeFactory.existsSemanticType((String)StreamState.class.getSimpleName())) {
            SemanticType type = new SemanticType(StreamState.class.getSimpleName(), StreamState.class.getName());
            TypeFactory.addSemanticType((SemanticType)type);
        }
        SDOUtils.addEventPrototype((String)"FileEvent", (String)"event.xml.file");
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"XMLEventSource", (boolean)false);
        sco.setServiceClassName(XMLEventSource.class.getName());
        sco.setServiceDescription("Parses XML file and creates event stream out of it.");
        sco.setServiceDisplayName("XML Event Source");
        sco.setInvokeMode(InvokeMode.ASYNC);
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "processFile", "XMLParseRequestHandler");
        EventDatagram prototype = EventDatagramFactory.getInstance().createEvent("event.xml.file");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        handler.bindVoidResponseObject("event.xml.file.parsed");
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("source.dispatch.model", ServicePropertyType.STRING, null);
        prop.setLabel("Source Dispatch Model");
        prop.setDescription("Specifies source dispatch model, whether poll specified folder for XML file or wait an event request.");
        prop.setRange(String.valueOf((Object)SourceDispatchModel.FILE_POLL) + "," + String.valueOf((Object)SourceDispatchModel.RAISED_EVENT));
        prop.setValue(SourceDispatchModel.RAISED_EVENT.name());
        sco.addProperty(prop);
        prop = sco.createProperty("polling.file.name", ServicePropertyType.STRING, null);
        prop.setLabel("Polling File Name");
        prop.setDescription("Specifies name (mask) of the XML file for polling.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("polling.interval", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Polling Interval");
        prop.setDescription("Specifies polling interval.");
        prop.setValue((Object)1000);
        sco.addProperty(prop);
        prop = sco.createProperty("file.action.eventid", ServicePropertyType.STRING, null);
        prop.setLabel("File Action Event Id");
        prop.setDescription("Specifies Event Id of FileEvent which will be emited once XML file is parsed.");
        prop.setValue("event.xml.parsed");
        sco.addProperty(prop);
        prop = sco.createProperty("xml.encoding", ServicePropertyType.STRING, null);
        prop.setLabel("XML Encoding");
        prop.setDescription("Specifies encoding of XML file to be parsed.");
        prop.setValue("ISO-8859-1");
        sco.addProperty(prop);
        prop = sco.createProperty("xml.escaping", ServicePropertyType.STRING, null);
        prop.setLabel("XML Escaping");
        prop.setDescription("Specifies XML fragments escaping strategy.");
        prop.setRange(String.valueOf(EscapeStrategy.ESCAPE_SYSTEM) + "," + String.valueOf(EscapeStrategy.ESCAPE_SPECIAL) + "," + String.valueOf(EscapeStrategy.ESCAPE_ALL) + "," + String.valueOf(EscapeStrategy.ESCAPE_NONE));
        prop.setValue(EscapeStrategy.ESCAPE_NONE.name());
        sco.addProperty(prop);
        prop = sco.createProperty("stream.state.eventid", ServicePropertyType.STRING, null);
        prop.setLabel("Stream State Event Id");
        prop.setDescription("Specifies EventId of the DataEvent with XMLStreamState which is sent on stream state change.");
        prop.setValue("event.xml.stream.state.changed");
        sco.addProperty(prop);
        ServiceConfigurationProperty testEventId = sco.createProperty("event.xml.fragment", ServicePropertyType.STRING, null);
        prop = sco.createProperty("xpath.eventid.map", ServicePropertyType.TABLE, null);
        prop.setLabel("XPATH to EventId Map");
        prop.setDescription("Specifies mapping from XPATH (XML fragment) to EventId which should be used to emit this fragment.");
        ((Hashtable)prop.getValue()).put("//ROOT_ELEMENT", testEventId);
        sco.addProperty(prop);
        prop = sco.createProperty("raise.abort.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Abort Stream Event");
        prop.setDescription("Specifies whether XMLStreamState should be sent in case of stream abort.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("raise.open.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Open Stream Event");
        prop.setDescription("Specifies whether XMLStreamState should be sent in case of stream opened.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("raise.close.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Close Stream Event");
        prop.setDescription("Specifies whether XMLStreamState should be sent in case of stream closed.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        sco.addActionableEvent("event.xml.parsed");
        sco.addActionableEvent("event.xml.fragment");
        sco.addActionableEvent("event.xml.stream.state.changed");
        sco.addException("exception.xml.Parsing");
        return sco;
    }
}

