/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.xml.evSource;

import com.streamscape.lib.xml.XMLNode;
import com.streamscape.lib.xml.XMLNodeEventListener;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sef.service.ServiceContext;

public class DataEventListener
implements XMLNodeEventListener {
    ServiceContext ctx;
    String eventId;
    String xpath;
    EventDatagramFactory datagramFactory;
    XSerializer serializer = null;
    String rootElement;
    String semanticType;
    boolean needReplace = false;

    DataEventListener(String xpath, String eventId, ServiceContext ctx, EventDatagramFactory datagramFactory, XSerializer serializer) {
        this.xpath = xpath;
        this.eventId = eventId;
        this.ctx = ctx;
        this.datagramFactory = datagramFactory;
        this.serializer = serializer;
        this.init();
    }

    private void init() {
        try {
            DataEvent event = (DataEvent)this.datagramFactory.createEvent(this.eventId);
            Class payloadClass = event.getPayloadClass();
            SemanticTypeCache cache = RuntimeContext.getInstance().getSemanticTypeCache();
            this.semanticType = cache.resolveSemanticClass(payloadClass);
            this.rootElement = this.xpath;
            int pos = this.xpath.lastIndexOf(47);
            if (pos > 0) {
                this.rootElement = this.rootElement.substring(pos + 1);
            }
            if (!this.semanticType.equals(this.rootElement.trim())) {
                this.needReplace = true;
            }
        }
        catch (Exception error) {
            throw new RuntimeException("Unable to init listener for [" + this.xpath + "] XML fragment." + error.getMessage());
        }
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getXPath() {
        return this.xpath;
    }

    public void onData(XMLNode node) {
        try {
            DataEvent event = (DataEvent)this.datagramFactory.createEvent(this.eventId);
            String xdoc = node.getXDoc();
            if (this.needReplace) {
                xdoc = xdoc.replaceAll("<\\s*" + this.rootElement + "\\s*>", "<" + this.semanticType + ">");
                xdoc = xdoc.replaceAll("</\\s*" + this.rootElement + "\\s*>", "</" + this.semanticType + ">");
                xdoc = xdoc.replaceAll("<\\s*" + this.rootElement + "\\s*/>", "</" + this.semanticType + ">");
            }
            this.serializer.addFieldAliases(this.semanticType);
            Object actualObject = this.serializer.deserialize(xdoc);
            event.setData(actualObject);
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
        }
        catch (RuntimeException error) {
            throw error;
        }
        catch (Exception error) {
            this.ctx.logError("Unable to init DataEvent for the record [" + this.xpath + "]. " + error.getMessage());
        }
    }
}

