/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail.tools;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EmailSignature {
    private static String[] messageBottomRegexps;
    private static String[][] messageBottomWords;
    private static String DICT_PATH;
    private static Set<String> dictionary;

    public static Result process(String text, String name) {
        text = text.replaceAll("\t", "");
        text = text.replaceAll("\\uFFFD", "'");
        text = text.replaceAll("\\h", " ");
        text = text.replaceAll("\\r\\n", "\n");
        text = text.replaceAll("[\\s\\n]*\\n[\\s\\n]*", "\n");
        WindowRepresentation winRep = new WindowRepresentation(text, name);
        return winRep.process();
    }

    private static void loadDictionary() {
        dictionary = new HashSet<String>();
        try (InputStream is = EmailSignature.class.getClassLoader().getResourceAsStream(DICT_PATH);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                dictionary.add(line.toLowerCase());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load person names dictionary for EmailSignature", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String text = new String(Files.readAllBytes(Paths.get("email/1.eml", new String[0])));
        String name = "Cesar Rosa";
        Result cleanedText = EmailSignature.process(text, name);
        Files.write(Paths.get("email/cleaner_modified.eml", new String[0]), cleanedText.getWithoutSignature().getBytes(), new OpenOption[0]);
    }

    static {
        DICT_PATH = "data/person-names.dict";
        messageBottomRegexps = new String[]{"^(?i)\\-+\\s+original\\s+message\\s+\\-+", "^(?i)Sent from my iPhone", "^(?i)ticket\\s+#\\d+", "^(?i)disclaimer$", "^(?i)This e\\-mail and any(.*)", "^(?i)CONFIDENTIALITY NOTICE(.*)", "^(?i)This message and any attachment are confidential(.*)", "^(?i)This e-mail and any attachment(.*)"};
        messageBottomWords = new String[][]{{"contain", "information", "confidential"}, {"contains", "information", "confidential"}, {"email", "attachments", "confidential"}, {"message", "attachments", "confidential"}};
        EmailSignature.loadDictionary();
    }

    private static class WindowRepresentation {
        private static int MIN_WINDOW_SIZE = 4;
        private final List<String> lines;
        private final List<String> name;
        private List<Feature> lineFeatures = new ArrayList<Feature>();

        public WindowRepresentation(String text, String name) {
            if (name == null) {
                name = "";
            }
            this.lines = this.breakIntoLines(text);
            this.name = this.tokenize(name, true);
            Collections.sort(this.name);
        }

        private List<String> breakIntoLines(String text) {
            String[] linesArr = text.split("\n");
            return Arrays.stream(linesArr).map(line -> line.trim()).collect(Collectors.toList());
        }

        public Result process() {
            List<String> signLines;
            List<String> unsignLines;
            for (int i = 0; i < this.lines.size(); ++i) {
                this.lineFeatures.add(this.detectFeatures(i));
            }
            int signStartPosition = this.getSignatureStartPosition();
            if (signStartPosition == -1) {
                unsignLines = this.lines;
                signLines = Collections.EMPTY_LIST;
            } else {
                unsignLines = this.lines.subList(0, signStartPosition);
                signLines = this.lines.subList(signStartPosition, this.lines.size());
            }
            return new Result(this.joinLines(unsignLines), this.joinLines(signLines));
        }

        private String joinLines(List<String> lines) {
            return String.join((CharSequence)"\n", lines);
        }

        private int getSignatureStartPosition() {
            int pos = this.detectThankAndName();
            if (pos != -1) {
                return pos;
            }
            pos = this.detectFullNameOnly();
            if (pos != -1) {
                return pos;
            }
            int currWinSize = 0;
            ArrayList<Feature> winFeatures = new ArrayList<Feature>();
            for (int i = 0; i < this.lines.size(); ++i) {
                Feature feature = this.getLineFeature(i);
                if (!feature.equals((Object)Feature.UNKNOWN)) {
                    ++currWinSize;
                    winFeatures.add(feature);
                } else {
                    currWinSize = 0;
                    winFeatures.clear();
                }
                if (!this.checkWindowPossibleFeatures(winFeatures)) {
                    currWinSize = 0;
                    winFeatures.clear();
                }
                if (currWinSize != MIN_WINDOW_SIZE) continue;
                return i - currWinSize + 1;
            }
            return this.detectBottom();
        }

        private int detectBottom() {
            for (int i = 0; i < this.lines.size(); ++i) {
                String line = this.getLine(i);
                for (String regx : messageBottomRegexps) {
                    if (!line.matches(regx)) continue;
                    return i;
                }
                List<String> tokens = this.tokenize(line, true);
                for (String[] words : messageBottomWords) {
                    if (!this.containsAllWords(tokens, words)) continue;
                    return i;
                }
            }
            return -1;
        }

        private boolean checkWindowPossibleFeatures(List<Feature> features) {
            if (features.size() < 3) {
                return true;
            }
            if (!features.contains((Object)Feature.POSSIBLE_ADDRESS)) {
                return true;
            }
            return features.stream().distinct().count() != 1L;
        }

        private int detectThankAndName() {
            for (int i = 0; i < this.lines.size(); ++i) {
                Feature curFeature = this.getLineFeature(i);
                Feature nextFeature = this.getLineFeature(i + 1);
                if (curFeature == null || nextFeature == null || !curFeature.equals((Object)Feature.THANK) || !nextFeature.equals((Object)Feature.PART_NAME) && !nextFeature.equals((Object)Feature.FULL_NAME_ONLY)) continue;
                return i;
            }
            return -1;
        }

        private int detectFullNameOnly() {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (!this.getLineFeature(i).equals((Object)Feature.FULL_NAME_ONLY)) continue;
                return i;
            }
            return -1;
        }

        private String getLine(int i) {
            if (i < 0) {
                return null;
            }
            return this.lines.size() > i ? this.lines.get(i) : null;
        }

        private Feature getLineFeature(int i) {
            if (i < 0) {
                return null;
            }
            return this.lineFeatures.size() > i ? this.lineFeatures.get(i) : null;
        }

        private Feature detectFeatures(int i) {
            Feature feature = Feature.UNKNOWN;
            String line = this.getLine(i);
            String nextLine = this.getLine(i + 1);
            if (line == null) {
                return null;
            }
            if (this.isThankYouLine(line)) {
                return Feature.THANK;
            }
            if (this.containsPhone(line)) {
                return Feature.PHONE;
            }
            Feature prevFeature = this.getLineFeature(i - 1);
            if (this.isFullNameLine(line)) {
                return Feature.FULL_NAME_ONLY;
            }
            if (this.containsPartName(line)) {
                return Feature.PART_NAME;
            }
            if (prevFeature != null && prevFeature.equals((Object)Feature.THANK) && this.containsPartDictName(line)) {
                return Feature.PART_NAME;
            }
            if (this.isTitleLine(line)) {
                return Feature.TITLE_ONLY;
            }
            if (this.containsEmail(line)) {
                return Feature.EMAIL;
            }
            if (this.isPrePhone(line) && nextLine != null && this.containsPhone(nextLine)) {
                return Feature.PREPHONE;
            }
            if (this.containsPossibleAddress(line)) {
                return Feature.POSSIBLE_ADDRESS;
            }
            if (this.isCompanyLine(line)) {
                return Feature.COMPANY_ONLY;
            }
            return feature;
        }

        private boolean containsPartDictName(String line) {
            if (line.length() > 30) {
                return false;
            }
            List<String> lineTokens = this.tokenize(line, true);
            String name = lineTokens.get(0);
            return dictionary.contains(name);
        }

        private boolean isCompanyLine(String text) {
            return false;
        }

        private boolean isThankYouLine(String text) {
            if (text.length() > 40) {
                return false;
            }
            String exp = "^(?i)(thx|cheers|many|kind|regard|thank|best)[\\sa-z\\.,\\!]+";
            return text.matches(exp);
        }

        private boolean containsPossibleAddress(String text) {
            return WindowRepresentation.lineMatcher("\\d", text) && WindowRepresentation.lineMatcher("[a-z]", text) && text.contains(",");
        }

        private boolean containsPhone(String text) {
            return WindowRepresentation.lineMatcher("(?i)(\\-?\\d)*\\d\\d\\s?\\-?\\s?\\d\\d\\d\\d", text);
        }

        private boolean isPrePhone(String text) {
            return text.matches("^(?i)direct\\:");
        }

        private boolean containsPartName(String text) {
            List<String> textTokens = this.tokenize(text, true);
            for (String elem : this.name) {
                if (!textTokens.contains(elem)) continue;
                return true;
            }
            return false;
        }

        private boolean isFullNameLine(String text) {
            List<String> textName = this.tokenize(text, true);
            Collections.sort(textName);
            return textName.equals(this.name);
        }

        private boolean containsEmail(String text) {
            return WindowRepresentation.lineMatcher("(?i)[^(\\<|\\>)][\\w|\\+|\\.|\\_|\\-]+\\@[\\w|\\-|\\_|\\.]+\\.[a-zA-z]{2,5}[^(\\<|\\>)]", text);
        }

        private boolean isTitleLine(String text) {
            return false;
        }

        private List<String> tokenize(String text, boolean cleanTokens) {
            Stream<String> stream = Arrays.stream(text.split("[\\s\\xA0]+")).map(line -> line.trim().toLowerCase());
            if (cleanTokens) {
                stream = stream.map(token -> token.replaceAll("[^A-Za-z0-9_]", ""));
            }
            return stream.collect(Collectors.toList());
        }

        private List<String> listsIntersection(List<String> list1, List<String> list2) {
            ArrayList<String> intersection = new ArrayList<String>();
            for (String el2 : list2) {
                if (!list1.contains(el2)) continue;
                intersection.add(el2);
            }
            return intersection;
        }

        private boolean containsAllWords(List<String> line, String[] words) {
            for (String word : words) {
                if (line.contains(word)) continue;
                return false;
            }
            return true;
        }

        private static boolean lineMatcher(String patternStr, String line) {
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(line);
            return matcher.find();
        }
    }

    public static class Result {
        private String withoutSignature;
        private String signature;

        public Result(String withoutSignature, String signature) {
            this.withoutSignature = withoutSignature;
            this.signature = signature;
        }

        public String getWithoutSignature() {
            return this.withoutSignature;
        }

        public String getSignature() {
            return this.signature;
        }
    }

    private static enum Feature {
        PHONE,
        PREPHONE,
        EMAIL,
        PART_NAME,
        FULL_NAME_ONLY,
        TITLE_ONLY,
        THANK,
        UNKNOWN,
        POSSIBLE_ADDRESS,
        COMPANY_ONLY;

    }
}

