/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail.sender;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;

public class AttachmentFileDataSource
implements DataSource {
    private String filename;
    private byte[] filedata = null;
    private File file = null;
    private String mimeType = null;

    public AttachmentFileDataSource(String filename) {
        this.file = new File(filename);
        this.filename = this.file.getName();
    }

    public AttachmentFileDataSource(String filename, byte[] filedata) {
        this.filename = new File(filename).getName();
        this.filedata = filedata;
    }

    public AttachmentFileDataSource(String filename, byte[] filedata, String mimeType) {
        this.filename = new File(filename).getName();
        this.filedata = filedata;
        this.mimeType = mimeType;
    }

    public String getContentType() {
        if (this.mimeType != null) {
            return this.mimeType;
        }
        return new MimetypesFileTypeMap().getContentType(this.getName());
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.filedata != null) {
            return new ByteArrayInputStream(this.filedata);
        }
        throw new IOException("File source is undefined.");
    }

    public String getName() {
        return this.filename;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

