/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail.reader;

import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.mail.reader.MailDescriptor;
import com.streamscape.service.mail.reader.ProcessedMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailReaderUtils {
    public static ProcessedMessage parseMessage(ServiceContext ctx, Message message, long uid) {
        ProcessedMessage pmsg = new ProcessedMessage();
        try {
            ctx.logDebug("Parse message...");
            MailDescriptor desc = new MailDescriptor();
            desc.subject = message.getSubject();
            desc.contentType = message.getContentType();
            desc.sentDate = message.getSentDate();
            desc.receivedDate = message.getReceivedDate();
            ctx.logDebug("Fill recipietns fields...");
            ArrayList<String> from = new ArrayList<String>();
            Address[] senders = message.getFrom();
            if (senders != null) {
                for (Address address : senders) {
                    from.add(address.toString());
                }
                desc.from = from;
            }
            ArrayList<String> to = new ArrayList<String>();
            Address[] recipientTo = message.getRecipients(Message.RecipientType.TO);
            if (recipientTo != null) {
                for (Address address : recipientTo) {
                    to.add(address.toString());
                }
                desc.to = to;
            }
            ArrayList<String> cc = new ArrayList<String>();
            Address[] recipientCc = message.getRecipients(Message.RecipientType.CC);
            if (recipientCc != null) {
                for (Address address : recipientCc) {
                    cc.add(address.toString());
                }
                desc.cc = cc;
            }
            ArrayList<String> bcc = new ArrayList<String>();
            Address[] recipientBcc = message.getRecipients(Message.RecipientType.BCC);
            if (recipientBcc != null) {
                for (Address address : recipientBcc) {
                    bcc.add(address.toString());
                }
                desc.bcc = bcc;
            }
            ctx.logDebug("Fill body and attachments...");
            MimeMessage mimeMessage = new MimeMessage((MimeMessage)message);
            MailReaderUtils.fillMailEventBody(ctx, desc, (Message)mimeMessage);
            mimeMessage.saveChanges();
            ctx.logDebug("Message has been parsed.");
            pmsg.mailDescriptor = desc;
            pmsg.originalMessage = message;
            pmsg.truncatedMessage = mimeMessage;
            pmsg.messageUID = uid;
            return pmsg;
        }
        catch (Exception ex) {
            ctx.logError("Failed to send Mail Event. " + Utils.formatException((Throwable)ex, (String)"\n"));
            return pmsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillMailEventBody(ServiceContext ctx, MailDescriptor desc, Message message) throws IOException, MessagingException, SecurityViolationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(RuntimeContext.getInstance().getSystemClassLoaderChain());
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
            if (message.isMimeType("text/plain")) {
                ctx.logDebug("Email Message MIME Type is text/plain");
                desc.body = message.getContent().toString();
            } else if (message.isMimeType("multipart/*")) {
                String body;
                ctx.logDebug("Email Message MIME Type is multipart/*");
                MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
                desc.body = body = MailReaderUtils.getBodyFromMimeMultipart(ctx, desc, mimeMultipart);
            } else {
                ctx.logDebug("Email Message MIME Type is unknown");
                desc.body = message.getContent().toString();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static String getBodyFromMimeMultipart(ServiceContext ctx, MailDescriptor desc, MimeMultipart mimeMultipart) throws IOException, MessagingException, SecurityViolationException {
        Object body = "";
        int count = mimeMultipart.getCount();
        if (count == 0) {
            throw new MessagingException("Multipart with no body parts not supported.");
        }
        boolean multipartAlt = new ContentType(mimeMultipart.getContentType()).match("multipart/alternative");
        if (multipartAlt) {
            body = MailReaderUtils.getTextFromBodyPart(ctx, desc, mimeMultipart.getBodyPart(count - 1));
        } else {
            ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
            for (int i = 0; i < count; ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                body = (String)body + MailReaderUtils.getTextFromBodyPart(ctx, desc, bodyPart);
                String disposition = bodyPart.getDisposition();
                if (disposition == null || !disposition.equalsIgnoreCase("attachment")) continue;
                ctx.logDebug("Add attachment to MailEvent...");
                String fileName = bodyPart.getFileName();
                String contentType = bodyPart.getContentType();
                String mimeType = contentType.split(";")[0].trim();
                InputStream is = bodyPart.getInputStream();
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int lenght = 0;
                while ((lenght = is.read(buffer)) != -1) {
                    os.write(buffer, 0, lenght);
                }
                os.flush();
                os.close();
                byte[] bytes = os.toByteArray();
                MailEvent.MailAttachment attachment = new MailEvent.MailAttachment(fileName, bytes, mimeType);
                desc.attachments.add(attachment);
                bodyParts.add(bodyPart);
            }
            for (BodyPart bodyPart : bodyParts) {
                bodyPart.getParent().removeBodyPart(bodyPart);
            }
        }
        return body;
    }

    public static String getTextFromBodyPart(ServiceContext ctx, MailDescriptor desc, BodyPart bodyPart) throws IOException, MessagingException, SecurityViolationException {
        String result = "";
        if (bodyPart.isMimeType("text/plain")) {
            ctx.logDebug("BodyPart is text/plain");
            result = (String)bodyPart.getContent();
        } else if (bodyPart.isMimeType("text/html")) {
            String html;
            ctx.logDebug("BodyPart is text/html");
            result = html = (String)bodyPart.getContent();
        } else if (bodyPart.getContent() instanceof MimeMultipart) {
            ctx.logDebug("BodyPart is MimeMultipart");
            result = MailReaderUtils.getBodyFromMimeMultipart(ctx, desc, (MimeMultipart)bodyPart.getContent());
        }
        return result;
    }
}

