/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail;

import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueException;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.XMLParseException;
import com.streamscape.service.mail.AbstractStreamscapeMail;
import java.util.ArrayList;

public class ExceptionMail
extends AbstractStreamscapeMail<ExceptionEventDatagram> {
    @Override
    protected void beforeCreateMailEvent() {
        if (this.getSubjectLevel() == null) {
            this.setSubjectLevel("Exception");
        }
        if (this.getSubject() == null) {
            String subject = "Framework Error";
            if (this.getSourceEvent() instanceof ClientException) {
                subject = "Client Error";
            } else if (this.getSourceEvent() instanceof SemanticMapperException) {
                subject = "Semantic Mapper Error";
            } else if (this.getSourceEvent() instanceof ProcessQueueException) {
                subject = "Process Queue Error";
            } else if (this.getSourceEvent() instanceof XMLParseException) {
                subject = "XML Parse Error";
            }
            this.setSubject(subject);
        }
    }

    @Override
    protected String getBodyHtml() {
        StringBuffer body = new StringBuffer();
        ExceptionEventDatagram exception = (ExceptionEventDatagram)this.getSourceEvent();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"Timestamp", exception.getTimestamp()});
        rows.add(new String[]{"Component Full Name", this.getSourceComponentName()});
        if (exception instanceof ClientException) {
            rows.add(new String[]{"Connection URL", ((ClientException)exception).getConnectionName()});
        }
        if (exception.getCorrelationId() != null) {
            rows.add(new String[]{"Process Correlation ID", exception.getCorrelationId()});
        }
        rows.add(new String[]{"Exception Name", exception.getClass().getSimpleName()});
        if (exception.getErrorCodeAsString().length() > 0) {
            rows.add(new String[]{"Error Code", exception.getErrorCodeAsString()});
        }
        Object indention = "";
        boolean linked = false;
        Throwable throwable = (Throwable)exception;
        while (throwable != null && throwable instanceof Exception && (!linked || throwable != exception)) {
            Exception error = (Exception)throwable;
            rows.add(new String[]{(String)indention + "Error Message" + (linked ? " (linked)" : ""), error.getMessage()});
            throwable = error.getCause();
            indention = (String)indention + "&nbsp;&nbsp;&nbsp;";
            linked = true;
        }
        body.append(this.createTableHtml(rows));
        return body.toString();
    }
}

