/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail;

import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.service.mail.AbstractStreamscapeMail;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DatabaseSQLExceptionMail
extends AbstractStreamscapeMail<DatabaseSQLException> {
    @Override
    protected void beforeCreateMailEvent() {
        if (this.getSubjectLevel() == null) {
            this.setSubjectLevel("Exception");
        }
        if (this.getSubject() == null) {
            this.setSubject("Database SQL Error");
        }
    }

    @Override
    protected String getBodyHtml() {
        StringBuffer body = new StringBuffer();
        Object exception = (DatabaseSQLException)this.getSourceEvent();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        StringTokenizer tokenizer = new StringTokenizer(exception.getConnectionName(), ".");
        if (tokenizer.countTokens() == 3) {
            rows.add(new String[]{"Connection Name", tokenizer.nextToken()});
            rows.add(new String[]{"Connection Factory Type", tokenizer.nextToken()});
            rows.add(new String[]{"Connection Factory Name", tokenizer.nextToken()});
        } else {
            rows.add(new String[]{"Connection Name", exception.getConnectionName()});
        }
        rows.add(new String[]{"Timestamp", exception.getTimestamp().toString()});
        if (exception.getComponentName() != null) {
            rows.add(new String[]{"Component Name", exception.getComponentName()});
        }
        rows.add(new String[]{"Component Full Name", this.getSourceComponentName()});
        if (exception.getCorrelationId() != null) {
            rows.add(new String[]{"Process Correlation ID", exception.getCorrelationId()});
        }
        Object indention = "";
        boolean linked = false;
        while (exception != null) {
            rows.add(new Object[]{(String)indention + "Severity", exception.getSeverity()});
            rows.add(new Object[]{(String)indention + "Error Code", exception.getErrorCodeAsString()});
            rows.add(new Object[]{(String)indention + "SQL State", exception.getSQLState()});
            rows.add(new Object[]{(String)indention + "Error Message" + (linked ? " (linked)" : ""), exception.getMessage()});
            exception = exception.getCause() != null && exception instanceof DatabaseSQLException ? (DatabaseSQLException)exception.getCause() : null;
            indention = (String)indention + "&nbsp;&nbsp;&nbsp;";
            linked = true;
        }
        body.append(this.createTableHtml(rows));
        return body.toString();
    }
}

