/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.mail;

import com.streamscape.sdo.advisory.BlockedThreadAdvisory;
import com.streamscape.service.mail.AbstractStreamscapeMail;
import java.util.ArrayList;

public class BlockedThreadMail
extends AbstractStreamscapeMail<BlockedThreadAdvisory> {
    @Override
    protected void beforeCreateMailEvent() {
        if (this.getSubjectLevel() == null) {
            this.setSubjectLevel("Advisory");
        }
        if (this.getSubject() == null) {
            this.setSubject("Blocked Thread Advisory");
        }
    }

    @Override
    protected String getBodyHtml() {
        StringBuffer body = new StringBuffer();
        BlockedThreadAdvisory advisory = (BlockedThreadAdvisory)this.getSourceEvent();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"Timestamp", advisory.getTimestamp()});
        rows.add(new String[]{"Component Full Name", this.getSourceComponentName()});
        StringBuilder builder = new StringBuilder();
        if (advisory.getThreadStackTrace() != null) {
            for (StackTraceElement elem : advisory.getThreadStackTrace()) {
                builder.append(elem.toString()).append('\n');
            }
        }
        rows.add(new Object[]{"Blocked Thread (" + advisory.getThreadId() + ")", builder.toString()});
        builder = new StringBuilder();
        if (advisory.getBlockedByThreadStackTrace() != null) {
            for (StackTraceElement elem : advisory.getBlockedByThreadStackTrace()) {
                builder.append(elem.toString()).append('\n');
            }
        }
        rows.add(new Object[]{"Blocked By Thread (" + advisory.getBlockedByThreadId() + ")", builder.toString()});
        body.append(this.createTableHtml(rows));
        return body.toString();
    }
}

