/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.jms.evSource;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.jms.evSource.FabricEventSinkFactoryImpl;
import com.streamscape.service.jms.evSource.Version;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.transports.ExceptionEventListener;
import com.streamscape.service.osf.transports.StateNotificationEventListener;
import com.streamscape.service.osf.transports.TransportConnection;
import com.streamscape.service.osf.transports.TransportFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;

public class QueueReader
extends AbstractDaemonService
implements StateNotificationEventListener,
ExceptionEventListener {
    private boolean connected = false;
    private long pollingInterval = 5000L;
    private TransportFactory transportFactory = null;
    protected TransportConnection connection = null;
    protected Session session = null;
    protected MessageConsumer msgReceiver = null;
    protected MessageProducer ackSender = null;
    protected Queue sourceQueue = null;
    protected Queue ackQueue = null;
    private String sourceQueueName = null;
    private String ackQueueName = null;
    EventDatagramFactory eventFactory = null;
    private XSerializer serializer = null;
    private String eventId = null;

    public void doInit() {
        try {
            super.doInit();
            this.ctx = this.context.lookupServiceContext((Service)this);
            this.sco = this.ctx.getServiceConfiguration();
            this.eventFactory = EventDatagramFactory.getInstance();
            this.ctx.logInfo("Service initializing...");
            this.sourceQueueName = this.ctx.lookupStringProperty("source.queue.name");
            this.ctx.logDebug("Source queue name: " + this.sourceQueueName);
            this.ackQueueName = this.ctx.lookupStringProperty("ack.queue.name");
            this.ctx.logDebug("Ack queue name: " + this.ackQueueName);
            this.pollingInterval = this.ctx.lookupNumericProperty("polling.interval");
            this.ctx.logDebug("Polling interval: " + this.pollingInterval);
            this.eventId = this.ctx.lookupStringProperty("event.id");
            this.ctx.logDebug("EventId for outgoing events: " + this.eventId);
            this.transportFactory = this.ctx.lookupTransportFactoryProperty("transport.factory");
            this.ctx.logInfo("Transport factory created successfully.");
            this.connection = this.transportFactory.createConnection();
            this.connection.setStateNotificationEventListener((StateNotificationEventListener)this);
            this.connection.setExceptionEventListener((ExceptionEventListener)this);
            if (this.ctx.getLogger() != null) {
                this.connection.setServiceLogger(this.ctx.getLogger());
            }
            if (this.connection == null) {
                throw new RuntimeException("Unable to create connection to message broker.");
            }
            this.ctx.logInfo("Transport connection created successfully.");
            this.serializer = RuntimeContext.getInstance().getXSerializerFactory().getDefaultSerializer();
        }
        catch (ServiceConfigurationException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        catch (RuntimeContextException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        catch (Exception error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        this.ctx.logInfo("Service initialized.");
    }

    public void start() throws ServiceFrameworkException {
        this.ctx.logInfo("Starting service...");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader systemClassLoaderChain = RuntimeContext.getInstance().getPackageManifestManager().getManifestClassLoader();
        Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
        try {
            this.connection.connect();
        }
        catch (TransportException error) {
            this.ctx.logError(error.getMessage());
            throw new RuntimeException(error);
        }
        Thread.currentThread().setContextClassLoader(loader);
        super.start();
        this.ctx.logInfo("Service started.");
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Transport connection state changed: " + e.getState().toString());
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (e.getState() == ConnectionState.CONNECTED) {
            try {
                this.connection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException exception) {
                        QueueReader.this.connected = false;
                    }
                });
                this.session = this.connection.createSession(false, 1);
                if (this.session == null) {
                    this.ctx.logError("Unable to create queue session.");
                }
                this.ctx.logInfo("Queue session created successfully.");
                this.sourceQueue = this.session.createQueue(this.sourceQueueName);
                if (this.sourceQueue == null) {
                    this.ctx.logError("Unable to resolve source queue.");
                }
                this.ctx.logInfo("Source queue resolved successfully: " + String.valueOf(this.sourceQueue));
                this.ackQueue = this.session.createQueue(this.ackQueueName);
                if (this.ackQueue == null) {
                    this.ctx.logError("Unable to resolve acknowledge queue.");
                }
                this.ctx.logInfo("Acknowledge queue resolved successfully: " + String.valueOf(this.ackQueue));
                this.msgReceiver = this.session.createConsumer((Destination)this.sourceQueue);
                this.ctx.logInfo("Source queue receiver created successfully.");
                this.ackSender = this.session.createProducer((Destination)this.ackQueue);
                this.ctx.logInfo("Ack queue sender created successfully.");
                this.ctx.logInfo("Connection to the messaging broker opened.");
                this.connected = true;
                this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
            }
            catch (JMSException error) {
                error.printStackTrace();
                this.ctx.logError(error.getMessage());
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
        } else {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Connection state changed to " + e.getState().toString());
        }
    }

    protected void doRepeatableServiceLogic() {
        try {
            if (!this.connected) {
                Thread.sleep(this.pollingInterval);
            } else {
                Message msg = this.msgReceiver.receive(this.pollingInterval);
                if (msg != null) {
                    this.ctx.logDebug("JMS Message [" + msg.getJMSMessageID() + "] received.");
                    if (msg instanceof TextMessage) {
                        TextMessage txt = (TextMessage)msg;
                        Trace.logDebug(QueueReader.class, (String)("\n\nJMS Text Message\n----------------\n" + txt.getText() + "\n----------------\n"));
                        XMLEvent xmlEvent = (XMLEvent)this.serializer.deserialize("XMLEvent", txt.getText());
                        Trace.logDebug(QueueReader.class, (String)("\n\nFabric XML Event\n----------------\n" + xmlEvent.getXML() + "\n----------------\n"));
                        this.ctx.logDebug("JMS Message [" + msg.getJMSMessageID() + "] mapped to event [" + xmlEvent.getEventId() + "].");
                        FabricEventSinkFactoryImpl.reset((ImmutableEventDatagram)xmlEvent);
                        TextMessage ackMessage = this.createAcknowledge((Message)txt, (EventDatagram)xmlEvent);
                        this.raiseEvent((EventDatagram)xmlEvent);
                        if (ackMessage != null) {
                            this.sendAcknowledge((Message)ackMessage);
                        }
                    } else {
                        Trace.logDebug(QueueReader.class, (String)("Unsupported JMS Message Type '" + msg.getClass().getName() + "' received."));
                        TransportException ex = new TransportException("JMS-235", "Unsupported JMS Message Type '" + msg.getClass().getName() + "' received.");
                        ex.setConnectionName(this.connection.getName());
                        ex.setSeverity(Severity.WARNING);
                        ex.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
                        this.raiseException((IAbstractExceptionEvent)ex);
                    }
                } else {
                    Trace.logDebug(QueueReader.class, (String)"No message is available on the queue.");
                }
            }
        }
        catch (JMSException error) {
            this.connection.forceStateCheck();
            TransportException ex = new TransportException(error);
            ex.setConnectionName(this.connection.getName());
            ex.setSeverity(Severity.SEVERE);
            ex.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.raiseException((IAbstractExceptionEvent)ex);
            this.connected = false;
        }
        catch (XSerializerException error) {
            this.ctx.logError("XML Serialization error: " + error.getMessage());
        }
        catch (Exception error) {
            this.ctx.logError("Runtime Error: " + error.getClass().getName());
            this.ctx.logError(error.getMessage());
        }
    }

    private TextMessage createAcknowledge(Message msg, EventDatagram event) {
        try {
            this.ctx.logDebug("Creation acknowledge for message [" + msg.getJMSMessageID() + "]...");
            TextMessage message = this.session.createTextMessage();
            AcknowledgementEvent ack = this.eventFactory.createAcknowledgement(event);
            ack.setData((Object)event);
            ack.setCorrelationId(event.getCorrelationId());
            ack.setEventGroupId(event.getEventGroupId());
            ack.setEventKey(event.getEventKey());
            String ackMessage = this.serializer.serialize((Object)ack);
            message.setText(ackMessage);
            Trace.logDebug(QueueReader.class, (String)("\nJMS Acknowledgement Message\n---------------------------\n" + ackMessage + "\n---------------------------\n"));
            this.ctx.logDebug("Acknowledge for message [" + msg.getJMSMessageID() + "] created.");
            return message;
        }
        catch (JMSException error) {
            TransportException ex = new TransportException(error);
            ex.setConnectionName(this.connection.getName());
            ex.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            ex.setSeverity(Severity.SEVERE);
            this.raiseException((IAbstractExceptionEvent)ex);
        }
        catch (DatagramFactoryException error) {
            this.ctx.logError("Unable to create acknowledge message: " + error.getMessage());
        }
        catch (XSerializerException error) {
            this.ctx.logError("Unable to serialize acknowledge message: " + error.getMessage());
        }
        catch (Exception error) {
            this.ctx.logError("Unable to send acknowledge message: " + error.getMessage());
        }
        return null;
    }

    private void sendAcknowledge(Message msg) {
        try {
            this.ctx.logDebug("Sending acknowledge...");
            this.ackSender.send(msg);
            this.ctx.logDebug("Message acknowledged.");
        }
        catch (JMSException error) {
            TransportException ex = new TransportException(error);
            ex.setConnectionName(this.connection.getName());
            ex.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            ex.setSeverity(Severity.SEVERE);
            this.raiseException((IAbstractExceptionEvent)ex);
        }
        catch (Exception error) {
            this.ctx.logError("Unable to send acknowledge message: " + error.getMessage());
        }
    }

    public void stop() throws ServiceFrameworkException {
        this.ctx.logInfo("Stopping service...");
        super.stop();
        try {
            this.msgReceiver.close();
            this.ackSender.close();
            this.session.close();
            this.connection.disconnect();
        }
        catch (Exception error) {
            Trace.logError((Object)((Object)this), (String)("Unexpected error during service shutdown: " + error.getMessage()));
        }
        this.ctx.logInfo("Service stopped.");
    }

    private void raiseException(IAbstractExceptionEvent exception) {
        try {
            this.ctx.logError(exception.getMessage() != null ? exception.getMessage() : "Raise Exception with null message.");
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception error) {
            System.out.println("Event dispatch error in raiseException(): " + exception.getMessage());
        }
    }

    private void raiseEvent(EventDatagram event) {
        try {
            this.ctx.logDebug("Raise event [" + event.getEventId() + "].");
            event.resetReplyTo();
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
        }
        catch (Exception ex) {
            this.reportAndRethrowError(ex);
        }
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void onEvent(TransportException e) {
        this.printTransportException(e);
    }

    private void printTransportException(TransportException event) {
        this.ctx.logError("TransportException: Connection: " + event.getConnectionName() + "\nSeverity: " + String.valueOf(event.getSeverity()) + "\nError Code: " + event.getErrorCodeAsString() + "\nMessaage: " + event.getMessage());
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"QueueReader", (boolean)false);
        sco.setServiceClassName(QueueReader.class.getName());
        sco.setServiceDescription("Polls configured JMS server and publishes retrieved messages on specified EventId.");
        sco.setServiceDisplayName("JMS Queue Reader");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ServiceConfigurationProperty prop = sco.createProperty("polling.interval", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Polling Interval");
        prop.setDescription("Specifies queue polling interval.");
        prop.setValue((Object)1000);
        sco.addProperty(prop);
        prop = sco.createProperty("transport.factory", ServicePropertyType.TRANSPORT_FACTORY, null);
        prop.setLabel("Transport Connection Factory");
        prop.setDescription("Specifies JMS connection factory for connection establishment.");
        prop.setValue((Object)new TransportFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty("event.id", ServicePropertyType.STRING, null);
        prop.setLabel("Publish Event Id");
        prop.setDescription("Specifies EventId of event which is used to publish retrived messages.");
        prop.setValue("event.message");
        sco.addProperty(prop);
        prop = sco.createProperty("source.queue.name", ServicePropertyType.STRING, null);
        prop.setLabel("Source Queue Name");
        prop.setDescription("Specifies name of the queue for message retrieval.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("source.queue.name", ServicePropertyType.STRING, null);
        prop.setLabel("Acknowledge Queue Name");
        prop.setDescription("Specifies name of the queue for message receipt acknowledgement.");
        prop.setValue("");
        sco.addProperty(prop);
        sco.addActionableEvent("event.message");
        sco.addException("exception.mpi.Transport");
        return sco;
    }
}

