/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.jms.evSink.enqueue;

import com.streamscape.Trace;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.file.evSink.OutputFormat;
import com.streamscape.service.jms.evSink.enqueue.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.osf.transports.StateNotificationEventListener;
import com.streamscape.service.osf.transports.TransportConnection;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;

public class JmsEnqueueService
extends AbstractService
implements StateNotificationEventListener {
    protected TransportConnection connection = null;
    protected Session session = null;
    protected MessageProducer msgSender = null;
    protected Queue targetQueue = null;
    protected String targetQueueName = null;
    protected TransportFactory transportFactory = null;
    protected TextSerializer serializer = null;
    protected boolean connected = false;
    private OutputFormat outputFormat = OutputFormat.SPECIFIC;

    public void destroy() {
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    protected void doInit() {
        try {
            this.ctx.logInfo("Service initializing...");
            this.targetQueueName = this.ctx.lookupStringProperty("target.queue.name");
            this.ctx.logInfo("Target queue name : " + this.targetQueueName);
            this.outputFormat = OutputFormat.valueOf(this.ctx.lookupEnumProperty("output.format"));
            this.ctx.logInfo("Output format : " + String.valueOf((Object)this.outputFormat));
            this.transportFactory = this.ctx.lookupTransportFactoryProperty("transport.factory");
            this.ctx.logInfo("Transport factory created successfully.");
            this.connection = this.transportFactory.createConnection();
            this.connection.setStateNotificationEventListener((StateNotificationEventListener)this);
            if (this.connection == null) {
                throw new RuntimeException("Unable to create connection to message broker.");
            }
            this.ctx.logInfo("Transport connection created successfully.");
            switch (this.outputFormat) {
                case XML: 
                case SPECIFIC: {
                    XSerializerFactory factory = this.context.getXSerializerFactory();
                    XSerializer xSerializer = factory.createSerializer("JmsEnqueueSerializer");
                    xSerializer.mapAttribute("SemanticType", "class");
                    this.serializer = xSerializer;
                    break;
                }
                case JSON: {
                    this.serializer = this.context.getJSONSerializerFactory().getDefaultSerializer().withPrettyPrint(true);
                }
            }
            this.ctx.logInfo("Service initialized.");
        }
        catch (Throwable error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
            throw new RuntimeException(error.getMessage());
        }
    }

    public void resume() {
    }

    public void start() {
        this.ctx.logInfo("Starting service...");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader systemClassLoaderChain = this.ctx.getPackageManifestManager().getManifestClassLoader();
        Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
        try {
            this.connection.connect();
        }
        catch (TransportException error) {
            this.ctx.logError(error.getMessage());
            throw new RuntimeException(error);
        }
        Thread.currentThread().setContextClassLoader(loader);
        this.ctx.logInfo("Service started.");
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Transport connection state changed: " + e.getState().toString());
        if (e.getState() == ConnectionState.CONNECTED) {
            try {
                this.connection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException exception) {
                        JmsEnqueueService.this.connected = false;
                    }
                });
                this.session = this.connection.createSession(false, 1);
                if (this.session == null) {
                    this.ctx.logError("Unable to create queue session.");
                }
                this.ctx.logInfo("Queue session created successfully.");
                this.targetQueue = this.session.createQueue(this.targetQueueName);
                if (this.targetQueue == null) {
                    this.ctx.logError("Unable to resolve target queue.");
                }
                this.ctx.logInfo("Target queue resolved successfully: " + String.valueOf(this.targetQueue));
                this.msgSender = this.session.createProducer((Destination)this.targetQueue);
                this.ctx.logInfo("Target queue sender created successfully.");
                this.ctx.logInfo("Connection to the messaging broker opened.");
                this.connected = true;
                this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
            }
            catch (JMSException error) {
                this.raiseException((IAbstractExceptionEvent)new TransportException(error));
            }
        } else {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Transport connection state changed to " + e.getState().toString());
        }
    }

    public void enqueue(ImmutableEventDatagram event) {
        try {
            this.ctx.logInfo("New data to enqueue.");
            TextMessage message = null;
            switch (this.outputFormat) {
                case SPECIFIC: {
                    if (event instanceof MapEvent) {
                        message = this.session.createMapMessage();
                        for (String key : ((MapEvent)event).getMapNames()) {
                            message.setObjectProperty(key, ((MapEvent)event).getObject(key));
                        }
                        break;
                    }
                    if (event instanceof TextEvent) {
                        message = this.session.createTextMessage();
                        message.setText(((TextEvent)event).getText());
                        break;
                    }
                    if (event instanceof XMLEvent) {
                        message = this.session.createTextMessage();
                        message.setText(((XMLEvent)event).getXML());
                        break;
                    }
                    if (event instanceof PayloadEvent) {
                        if (!Serializable.class.isAssignableFrom(((PayloadEvent)event).getPayloadClass())) break;
                        message = this.session.createObjectMessage();
                        if (event instanceof DataEvent) {
                            ((ObjectMessage)message).setObject((Serializable)((DataEvent)event).getData());
                            break;
                        }
                        if (!(event instanceof OpaqueEvent)) break;
                        ((ObjectMessage)message).setObject((Serializable)((OpaqueEvent)event).getData());
                        break;
                    }
                    if (!(event instanceof BytesEvent)) break;
                    message = this.session.createBytesMessage();
                    ((BytesMessage)message).writeBytes(((BytesEvent)event).getBytes());
                    break;
                }
                case XML: 
                case JSON: {
                    message = this.session.createTextMessage();
                    String msgText = null;
                    if (event instanceof DataEvent) {
                        msgText = this.serializer.serialize(((DataEvent)event).getData());
                    } else if (event instanceof OpaqueEvent) {
                        msgText = this.serializer.serialize(((OpaqueEvent)event).getData());
                    } else {
                        this.ctx.logError("Unsupported event [" + event.getClass().getSimpleName() + "] received.");
                    }
                    message.setText(msgText);
                    break;
                }
            }
            if (message != null) {
                this.msgSender.send((Message)message);
                this.ctx.logInfo("Message has been enqueued.");
            } else {
                this.ctx.logError("Unable to create message to be enqueued.");
            }
        }
        catch (JMSException error) {
            this.raiseException((IAbstractExceptionEvent)new ServiceFrameworkException(6108, (Throwable)error));
        }
        catch (Exception error) {
            this.ctx.logError("Unable to compose acknowledge message: " + error.getMessage());
        }
    }

    public void stop() {
        this.ctx.logInfo("Stopping service...");
        try {
            this.msgSender.close();
            this.session.close();
            this.connection.close();
        }
        catch (Exception error) {
            Trace.logError((Object)((Object)this), (String)("Unexpected error during service shutdown: " + error.getMessage()));
        }
        this.ctx.logInfo("Service stopped.");
    }

    private void raiseException(IAbstractExceptionEvent exception) {
        try {
            this.ctx.logError(exception.getMessage() != null ? exception.getMessage() : (exception.getErrorMessage() != null ? exception.getErrorMessage() : "Exception with an empty message has been thrown."));
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception error) {
            System.out.println("Event dispatch error in raiseException(): " + exception.getMessage());
        }
    }

    public void suspend() {
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public void cancel() throws ServiceFrameworkException {
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"JmsEnqueue", (boolean)false);
        sco.setServiceClassName(JmsEnqueueService.class.getName());
        sco.setServiceDescription("Enqueues a message to the specified JMS queue.");
        sco.setServiceDisplayName("JMS Enqueue Service");
        sco.setInvokeMode(InvokeMode.ASYNC);
        SDOUtils.addDataEventPrototype((String)"event.inbound", (String)"string");
        SDOUtils.addDataEventPrototype((String)"event.outbound", (String)"Void");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "enqueue", "MessageEnqueueHandler");
        EventDatagram prototype = EventDatagramFactory.getInstance().createEvent("event.inbound");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        prototype = EventDatagramFactory.getInstance().createEvent("event.outbound");
        handler.bindResponseEvent((ImmutableEventDatagram)prototype);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("target.queue.name", ServicePropertyType.STRING, null);
        prop.setLabel("Target Queue");
        prop.setDescription("Specifies target queue name.");
        prop.setValue("TargetQueue");
        sco.addProperty(prop);
        prop = sco.createProperty("transport.factory", ServicePropertyType.TRANSPORT_FACTORY, null);
        prop.setLabel("Transport Connection Factory");
        prop.setDescription("Specifies JMS connection factory for connection establishment.");
        prop.setValue((Object)new TransportFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty("output.format", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Output Format");
        prop.setDescription("Specifies wheather event should be mapped to corresponding JMS message type or just serialized and posted as TextMessage.");
        prop.setRange(String.valueOf((Object)OutputFormat.SPECIFIC) + "," + String.valueOf((Object)OutputFormat.XML) + "," + String.valueOf((Object)OutputFormat.JSON));
        prop.setValue(OutputFormat.XML.name());
        sco.addProperty(prop);
        sco.addException("exception.mpi.Transport");
        return sco;
    }
}

