/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.http.evSink;

import com.streamscape.Trace;
import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.http.evSink.Version;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class HTTPEventSink
extends AbstractService
implements StateNotificationEventListener,
ExceptionEventListener {
    public static final String CONNECTION = "connection.http";
    public static final String STATIC_REQUEST = "static.request";
    public static final String CONTENT_FORMAT = "content.format";
    public static final String CONTENT_TYPE = "content.type";
    public static final String HTTP_METHOD = "http.method";
    public static final String URI = "uri";
    private static final String HEADER_MAP = "header.map";
    private static final String PARAMETER_MAP = "query.parameter.map";
    private HTTPConnection httpConnection = null;
    private ClientFactory connectionFactory = null;
    private HTTPRequest staticRequest = null;
    private ContentFormat contentFormat = ContentFormat.CustomString;
    private ContentType contentType = ContentType.DataObject;

    public HTTPResponse processHttpRequest(HTTPRequest request) throws ClientException {
        try {
            this.checkHttpConnection();
            this.ctx.logDebug("HTTP Request: " + request.toString());
            this.ctx.logDebug("HTTP Request Headers: " + String.valueOf(request.getHeaders()));
            this.ctx.logDebug("HTTP Request Query Parameters: " + String.valueOf(request.getQueryParameters()));
            this.httpConnection.connect();
            HTTPResponse response = this.httpConnection.execute(request);
            if (response.getStatusCode() != 200) {
                throw new ClientException(1026, "HTTP Request failure, response: " + String.valueOf(response));
            }
            this.ctx.logDebug("HTTP Response: " + String.valueOf(response));
            this.ctx.logDebug("HTTP Response Headers: " + String.valueOf(response.getHeaders()));
            this.ctx.logDebug("HTTP Response Trailers: " + String.valueOf(response.getTrailers()));
            return response;
        }
        catch (ClientException clientException) {
            throw this.initClientException(clientException);
        }
        catch (Exception exception) {
            throw this.createClientException(exception, "Unable to perform HTTP request, " + exception.getMessage());
        }
    }

    public HTTPResponse processStaticHttpRequest(Object data) throws ClientException {
        this.ctx.logInfo("Process Static HTTP Request");
        if (this.staticRequest == null) {
            throw new ClientException(1016, "Service configuration error. Static HTTP request is not configured.", Severity.SEVERE);
        }
        if (data == null) {
            throw new ClientException(1016, "Static HTTP request invocation failure. Data for request is NULL.", Severity.SEVERE);
        }
        try {
            this.checkHttpConnection();
            switch (this.contentType.ordinal()) {
                case 0: {
                    String textData = null;
                    switch (this.contentFormat.ordinal()) {
                        case 0: {
                            textData = data.toString();
                            break;
                        }
                        case 2: {
                            XSerializer xmlSerializer = this.context.getXSerializerFactory().getDefaultSerializer();
                            textData = xmlSerializer.serialize(data);
                            break;
                        }
                        case 1: {
                            textData = this.context.getJSONSerializerFactory().getDefaultSerializer().serialize(data);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported Request Content Format '" + String.valueOf((Object)this.contentFormat) + "'.");
                        }
                    }
                    this.staticRequest.setData(textData.getBytes());
                    break;
                }
                case 1: {
                    if (!(data instanceof Map)) {
                        String type = this.context.getSemanticTypeCache().resolveSemanticClass(data.getClass());
                        if (type == null) {
                            type = data.getClass().getSimpleName();
                        }
                        throw new IllegalArgumentException("Unsupported data '" + type + "'received for " + String.valueOf((Object)ContentType.ParameterMap) + " Request Content Type. Map is expected.");
                    }
                    Map queryParameters = (Map)data;
                    this.staticRequest.setQueryParameters(queryParameters);
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Request Content Type '" + String.valueOf((Object)this.contentType) + "'.");
                }
            }
            return this.processHttpRequest(this.staticRequest);
        }
        catch (Exception exception) {
            throw this.createClientException(exception, "Unable to perform HTTP request, " + exception.getMessage());
        }
    }

    private void checkHttpConnection() throws ClientException {
        if (this.httpConnection == null) {
            this.httpConnection = (HTTPConnection)this.connectionFactory.createConnection();
            this.httpConnection.setStateNotificationEventListener((StateNotificationEventListener)this);
            this.httpConnection.setExceptionEventListener((ExceptionEventListener)this);
            if (this.ctx.getLogger() != null) {
                this.httpConnection.setServiceLogger(this.ctx.getLogger());
            }
        }
    }

    protected void doInit() throws ServiceFrameworkException {
        try {
            this.assertPropertyExistAndNotNull(CONNECTION);
            this.connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION);
            if (this.ctx.existsProperty(STATIC_REQUEST) && this.ctx.lookupBooleanProperty(STATIC_REQUEST).booleanValue()) {
                this.staticRequest = new HTTPRequest();
                this.staticRequest.setHeaders(new HashMap());
                this.staticRequest.setQueryParameters(new HashMap());
                this.assertPropertyExistAndNotNull(CONTENT_TYPE);
                this.contentType = ContentType.valueOf(this.ctx.lookupEnumProperty(CONTENT_TYPE));
                this.assertPropertyExistAndNotNull(CONTENT_FORMAT);
                this.contentFormat = ContentFormat.valueOf(this.ctx.lookupEnumProperty(CONTENT_FORMAT));
                if (this.contentFormat == ContentFormat.XML) {
                    this.staticRequest.getHeaders().put("Content-Type", "application/xml");
                } else if (this.contentFormat == ContentFormat.JSON) {
                    this.staticRequest.getHeaders().put("Content-Type", "application/json");
                }
                this.assertPropertyExistAndNotNull(HTTP_METHOD);
                this.staticRequest.setMethod(this.ctx.lookupEnumProperty(HTTP_METHOD));
                this.assertPropertyExistAndNotNull(URI);
                this.staticRequest.setUri(this.ctx.lookupStringProperty(URI));
                if (this.ctx.existsProperty(HEADER_MAP)) {
                    if (this.staticRequest.getHeaders() == null) {
                        this.staticRequest.setHeaders(new HashMap());
                    }
                    Hashtable headers = this.ctx.lookupTableProperty(HEADER_MAP);
                    for (String key : headers.keySet()) {
                        this.staticRequest.getHeaders().put(key, ((ServiceConfigurationProperty)headers.get(key)).getValue().toString());
                    }
                } else {
                    this.ctx.logDebug("Static header.map is not specified.");
                }
                if (this.ctx.existsProperty(PARAMETER_MAP)) {
                    if (this.staticRequest.getQueryParameters() == null) {
                        this.staticRequest.setQueryParameters(new HashMap());
                    }
                    Hashtable parameters = this.ctx.lookupTableProperty(PARAMETER_MAP);
                    for (String key : parameters.keySet()) {
                        this.staticRequest.getQueryParameters().put(key, ((ServiceConfigurationProperty)parameters.get(key)).getValue().toString());
                    }
                } else {
                    this.ctx.logDebug("Static query.parameter.map is not specified.");
                }
                this.ctx.logDebug("Static HTTPRequest: method: " + this.staticRequest.getMethod() + ", uri: " + this.staticRequest.getSerialVersionUID() + ", headers: " + String.valueOf(this.staticRequest.getHeaders()) + ", parameters: " + String.valueOf(this.staticRequest.getQueryParameters()));
            }
            this.ctx.logInfo("HTTPEventSink initialized: " + this.toString());
            if (this.staticRequest != null) {
                this.ctx.logInfo("Static HTTP Request Mode.");
                this.ctx.logInfo("contentFormat: " + String.valueOf((Object)this.contentFormat) + ", contentType: " + String.valueOf((Object)this.contentType));
                this.ctx.logInfo("HTTP Request: " + this.staticRequest.toString());
                this.ctx.logInfo("HTTP Request Headers: " + String.valueOf(this.staticRequest.getHeaders()));
                this.ctx.logInfo("HTTP Request Query Parameters: " + String.valueOf(this.staticRequest.getQueryParameters()));
            } else {
                this.ctx.logInfo("Dynamic HTTP Request Mode.");
            }
        }
        catch (ServiceConfigurationException error) {
            this.reportAndRethrowError(error);
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.connectionFactory != null) {
            try {
                this.connectionFactory.destroyAll();
            }
            catch (Exception exception) {
                this.ctx.logError("Failed to destroy connection factory '" + this.connectionFactory.toString() + "'. Cause: " + exception.getMessage());
            }
        }
    }

    public String toString() {
        return "connection: " + String.valueOf(this.httpConnection);
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    private ClientException initClientException(ClientException clientException) {
        try {
            if (this.httpConnection != null) {
                clientException.setConnectionName(this.httpConnection.getUrl());
            }
            clientException.setSeverity(Severity.SEVERE);
            this.ctx.logError("HTTP Client Exception: " + clientException.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)clientException, (boolean)true);
            this.ctx.raiseException((ExceptionEventDatagram)clientException);
            this.ctx.logDebug("Exception event [" + clientException.getEventId() + "] event has been raised.");
        }
        catch (Exception ex) {
            System.out.println("Event dispatch exception: " + ex.getMessage() + " for HTTP Error: " + clientException.getErrorMessage());
        }
        return clientException;
    }

    private ClientException createClientException(Exception exception, String error) {
        this.ctx.logError("HTTP Client Exception: " + error);
        Trace.logException((Object)((Object)this), (Throwable)exception, (boolean)true);
        ClientException clientException = new ClientException(1026, "Unable to perform HTTP request, " + exception.getMessage(), (Throwable)exception, Severity.SEVERE);
        if (this.httpConnection != null) {
            clientException.setConnectionName(this.httpConnection.getUrl());
        }
        return clientException;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void onEvent(ClientException e) {
        this.ctx.logError("HTTP Exception: " + e.toString());
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("HTTP connection state changed: " + e.getState().toString());
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch error in raiseAdvisory(): " + ex.getMessage() + " HTTP message: " + e.getMessage());
        }
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        SDOUtils.addDataEventPrototype((String)"event.http.request", (String)"HTTPRequest");
        SDOUtils.addDataEventPrototype((String)"event.http.request.static", (String)"object");
        SDOUtils.addDataEventPrototype((String)"event.http.response", (String)"HTTPResponse");
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"HTTPEventSink", (boolean)false);
        sco.setServiceClassName(HTTPEventSink.class.getName());
        sco.setServiceDescription("Allows to send an HTTP request to the configured server.");
        sco.setServiceDisplayName("HTTP Event Sink");
        sco.setInvokeMode(InvokeMode.ASYNC);
        SemanticType httpRequestSemType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("HTTPRequest");
        SemanticType httpResponseSemType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("HTTPResponse");
        SemanticType httpStaticRequestSemType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("object");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "processHttpRequest", "HTTPRequestHandler");
        handler.bindRequestObject("event.http.request", httpRequestSemType);
        handler.bindResponseObject("event.http.response", httpResponseSemType);
        sco.addEventHandler(handler);
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "processStaticHttpRequest", "StaticHTTPRequestHandler");
        handler.bindRequestObject("event.http.request.static", httpStaticRequestSemType);
        handler.bindResponseObject("event.http.response", httpResponseSemType);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty(CONNECTION, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("HTTP Connection Factory");
        prop.setDescription("Specifies HTTP connection factory.");
        prop.setValue((Object)new ClientFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty(STATIC_REQUEST, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Static Request Flag");
        prop.setDescription("Enables static request mode for the service.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty(CONTENT_TYPE, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Request Content Type");
        prop.setDescription("Specifies Request Content Type for static request.");
        prop.setRange(ContentType.DataObject.name() + "," + ContentType.ParameterMap.name());
        prop.setValue(ContentType.DataObject.name());
        sco.addProperty(prop);
        prop = sco.createProperty(CONTENT_FORMAT, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Request Content Format");
        prop.setDescription("Specifies Request Content Format for static request.");
        prop.setRange(ContentFormat.JSON.name() + "," + ContentFormat.XML.name() + "," + ContentFormat.CustomString.name());
        prop.setValue(ContentFormat.XML.name());
        sco.addProperty(prop);
        prop = sco.createProperty(HTTP_METHOD, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Static Request HTTP Method");
        prop.setDescription("Specifies Request HTTP method for static request.");
        prop.setRange("GET,POST,PUT,PATCH,DELETE");
        prop.setValue("GET");
        sco.addProperty(prop);
        prop = sco.createProperty(URI, ServicePropertyType.STRING, null);
        prop.setLabel("Static Request HTTP URI");
        prop.setDescription("Specifies Request HTTP URI for static request.");
        prop.setValue("acme.com");
        sco.addProperty(prop);
        prop = sco.createProperty(HEADER_MAP, ServicePropertyType.TABLE, null);
        prop.setLabel("HTTP Headers");
        prop.setDescription("Specify HTTP Headers for static request.");
        ServiceConfigurationProperty headerValue = sco.createProperty("http.header.value", ServicePropertyType.STRING, "main.group");
        headerValue.setValue("header_value");
        ((Hashtable)prop.getValue()).put("header_name", headerValue);
        sco.addProperty(prop);
        prop = sco.createProperty(PARAMETER_MAP, ServicePropertyType.TABLE, null);
        prop.setLabel("HTTP Query Parameters");
        prop.setDescription("Specify static Query Parameters.");
        ServiceConfigurationProperty paramValue = sco.createProperty("query.parameter.value", ServicePropertyType.STRING, "main.group");
        paramValue.setValue("parameter_value");
        ((Hashtable)prop.getValue()).put("parameter_name", paramValue);
        sco.addProperty(prop);
        sco.addException("exception.cli.Interface");
        return sco;
    }

    public static enum ContentFormat {
        CustomString,
        JSON,
        XML;

    }

    public static enum ContentType {
        DataObject,
        ParameterMap;

    }
}

