/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.hadoop.daemon;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.lib.fs.client.AbstractFileSystemClientConnection;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.IllegalStateException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.hadoop.daemon.Version;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EVHFDaemon
extends AbstractDaemonService {
    public static String SERVICE_NAME = "prototype";
    public static final String SERVICE_TYPE = "EVHFDaemon";
    public static final String EVENT_ID = "event.hdfsFile.StateChange";
    public static final String CONNECTION = "hdfs.connection";
    public static final String ROOT_FOLDER = "root.folder";
    public static final String POLLING_INTERVAL = "polling.interval";
    public static final String PERSISTENT_SNAPSHOT = "persistent.snapshot";
    public static final String DATASPACE_NAME = "dataspace.name";
    public static final String COLLECTION_NAME = "collection.name";
    public static final String RECOVERY_WINDOW = "recovery.window";
    public static final String SORT_STRATEGY = "sort.strategy";
    public static final String MONITORS = "monitors";
    public static final String MONITOR = "monitor";
    public static final String MONITOR_NAME = "monitor.name";
    public static final String MONITOR_PATTERN = "monitor.pattern";
    public static final String MONITOR_ACTION = "monitor.action";
    public static final String MONITOR_ACTION_PARAMETER = "monitor.action.parameter";
    static File HDFS_TEMP_FOLDER = new File(".hdfs");
    private ClientConnection clientConnection = null;
    private ClientFactory connectionFactory = null;
    private FileSystem fs = null;
    String rootFolder = null;
    long pollingInterval = 60000L;
    int recoveryWindow = 0;
    TimeUnit recoveryWindowUnit = TimeUnit.SECONDS;
    boolean persistentSnapshot = false;
    String dataspaceName = null;
    String collectionName = null;
    private SortStrategy sortStrategy = SortStrategy.MODIFICATION_TIME;
    private List<FileMonitor> monitors = new ArrayList<FileMonitor>();
    private List<FileInfo> snapshot = null;
    DataspaceAccessor accessor = null;
    long fileCounter = 0L;

    protected void doInit() {
        try {
            String recoveryWindowString;
            super.doInit();
            this.rootFolder = this.ctx.lookupStringProperty(ROOT_FOLDER);
            this.ctx.logInfo("HDFS Root Folder : " + this.rootFolder);
            if (this.rootFolder == null || this.rootFolder.trim().equals("/")) {
                this.rootFolder = "";
            }
            this.pollingInterval = this.ctx.lookupNumericProperty(POLLING_INTERVAL);
            this.ctx.logInfo("Polling Interval : " + this.pollingInterval);
            this.persistentSnapshot = this.ctx.lookupBooleanProperty(PERSISTENT_SNAPSHOT);
            this.ctx.logInfo("Persistent Snapshot : " + this.persistentSnapshot);
            if (this.persistentSnapshot) {
                this.dataspaceName = this.ctx.lookupStringProperty(DATASPACE_NAME);
                this.ctx.logInfo("Snapshot Dataspace : " + this.dataspaceName);
                this.collectionName = this.ctx.lookupStringProperty(COLLECTION_NAME);
                this.ctx.logInfo("Snapshot Collection : " + this.collectionName);
            }
            if ((recoveryWindowString = this.ctx.lookupStringProperty(RECOVERY_WINDOW)).length() > 0) {
                this.setRecoveryWindow(recoveryWindowString);
                this.ctx.logInfo("Recovery Window : " + this.recoveryWindow + " " + this.recoveryWindowUnit.name());
            }
            if (this.ctx.existsProperty(SORT_STRATEGY)) {
                try {
                    this.sortStrategy = SortStrategy.valueOf(this.ctx.lookupEnumProperty(SORT_STRATEGY));
                    this.ctx.logInfo("File Sort Strategy : " + this.sortStrategy.name());
                }
                catch (IllegalArgumentException error) {
                    this.ctx.logError("Invalid sort strategy '" + this.ctx.lookupEnumProperty(SORT_STRATEGY) + "' specified. Using default '" + this.sortStrategy.name() + "'.");
                }
            }
            List list = this.ctx.lookupListProperty(MONITORS);
            for (ServiceConfigurationProperty monitorSCO : list) {
                Hashtable table = (Hashtable)monitorSCO.getValue();
                String monitorName = table.get(MONITOR_NAME) != null ? ((ServiceConfigurationProperty)table.get(MONITOR_NAME)).getValue().toString() : "";
                String monitorPattern = table.get(MONITOR_PATTERN) != null ? ((ServiceConfigurationProperty)table.get(MONITOR_PATTERN)).getValue().toString() : "";
                monitorPattern = monitorPattern.replaceAll("\\*", ".*");
                monitorPattern = monitorPattern.replaceAll("\\?", ".");
                FileAction monitorAction = null;
                try {
                    monitorAction = table.get(MONITOR_ACTION) != null ? FileAction.valueOf(((ServiceConfigurationProperty)table.get(MONITOR_ACTION)).getValue().toString()) : null;
                }
                catch (IllegalArgumentException error) {
                    throw new ServiceConfigurationException("Invalid file action '" + ((ServiceConfigurationProperty)table.get(MONITOR_ACTION)).getValue().toString() + "' is specified for monitor '" + monitorName + ".");
                }
                String monitorActionParameter = table.get(MONITOR_ACTION_PARAMETER) != null ? ((ServiceConfigurationProperty)table.get(MONITOR_ACTION_PARAMETER)).getValue().toString() : null;
                FileMonitor monitor = new FileMonitor(this);
                monitor.name = monitorName;
                monitor.pattern = Pattern.compile(monitorPattern);
                monitor.action = monitorAction;
                monitor.actionParameter = monitorActionParameter;
                this.monitors.add(monitor);
                this.ctx.logDebug("File monitor '" + monitorName + "' looking for '" + monitorPattern + "' files has been created.");
            }
            this.assertPropertyExistAndNotNull(CONNECTION);
            this.connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION);
            try {
                Trace.logDebug((Object)((Object)this), (String)"Opening up a client connection...");
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                ClassLoader systemClassLoaderChain = this.ctx.getPackageManifestManager().getManifestClassLoader();
                Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
                this.clientConnection = this.connectionFactory.createConnection();
                Trace.logDebug((Object)((Object)this), (String)"Connection created.");
                this.clientConnection.setStateNotificationEventListener(new StateNotificationEventListener(){

                    public void onEvent(ConnectionStateChangeAdvisory e) {
                        try {
                            Trace.logInfo((Object)this, (String)("Connection state changed to " + String.valueOf(e.getState()) + ", connection name " + e.getConnectionName()));
                            e.setComponentName(EVHFDaemon.this.ctx.getType() + "." + EVHFDaemon.this.ctx.getName());
                            EVHFDaemon.this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
                        }
                        catch (Exception ex) {
                            Trace.logError((Object)this, (String)("Directory table collection error in raiseAdvisory(): " + ex.getMessage()));
                        }
                    }
                });
                this.clientConnection.setExceptionEventListener(new ExceptionEventListener(this){

                    public void onEvent(ClientException e) {
                        Trace.logInfo((Object)this, (String)("Client Connection Failure: " + e.getMessage()));
                    }
                });
                try {
                    this.clientConnection.connect();
                }
                catch (Throwable exception) {
                    throw exception;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                for (int counter = 0; this.clientConnection.getState() != ConnectionState.OPEN && counter < 50; ++counter) {
                    Thread.sleep(100L);
                }
                this.fs = ((AbstractFileSystemClientConnection)this.clientConnection).getFileSystem();
            }
            catch (Throwable error) {
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
                throw new DataspaceException(error.getMessage());
            }
            if (this.persistentSnapshot) {
                this.checkSnapshotCollection();
            }
            this.initSnapshot();
        }
        catch (Exception e) {
            Trace.logError((Object)((Object)this), (String)("Failed to initialize service. " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fs = null;
        }
        if (this.clientConnection != null) {
            try {
                this.clientConnection.disconnect();
            }
            catch (ClientException clientException) {
                // empty catch block
            }
            this.clientConnection = null;
        }
        super.destroy();
    }

    private void checkSnapshotCollection() throws Exception {
        DataspaceManager manager = RuntimeContext.getInstance().getDataspaceManager();
        if (!manager.existsDataspace(this.dataspaceName)) {
            manager.createDataspace(DataspaceType.TSPACE, this.dataspaceName, EventScope.OBSERVABLE);
        }
        this.accessor = this.ctx.createDataspaceAccessor(DataspaceType.TSPACE, this.dataspaceName);
        if (this.accessor == null || !this.accessor.isAvailable()) {
            throw new IllegalStateException("Unable to open accessor to dataspace with snapshot.");
        }
        SLResponse response = this.accessor.invokeLanguageRequest("create persistent table if not exists [" + this.collectionName + "] (   FileName string, IsDirectory boolean, ModifiedDate sqldate, primary key(FileName)) ");
        if (response == null || !response.isOK()) {
            throw new IllegalStateException("Unable to initialize snapshot collection.");
        }
    }

    private void setRecoveryWindow(String window) throws ServiceConfigurationException {
        Pattern pattern = Pattern.compile("(\\d*)\\s*(\\w*)");
        Matcher matcher = pattern.matcher(window);
        String unit = null;
        if (matcher.find()) {
            this.recoveryWindow = Integer.valueOf(matcher.group(1));
            unit = matcher.group(2);
            try {
                this.recoveryWindowUnit = TimeUnit.valueOf(unit.toUpperCase());
            }
            catch (IllegalArgumentException error) {
                throw new ServiceConfigurationException("Unsupported recovery window time unit specified : " + unit + ".");
            }
        } else {
            this.recoveryWindow = Integer.valueOf(window.trim());
        }
    }

    private List<FileInfo> getFileList() throws ClientException {
        List files = null;
        try {
            files = this.fs.list(this.rootFolder);
        }
        catch (Exception error) {
            throw this.createClientException("[HDFS LIST] " + error.getMessage());
        }
        if (files != null && this.sortStrategy == SortStrategy.MODIFICATION_TIME) {
            Collections.sort(files, new Comparator<FileInfo>(this){

                @Override
                public int compare(FileInfo o1, FileInfo o2) {
                    if (o1 == null || o1.getModificationTime() == -1L) {
                        return -1;
                    }
                    if (o2 == null || o2.getModificationTime() == -1L) {
                        return 1;
                    }
                    return new java.util.Date(o1.getModificationTime()).compareTo(new java.util.Date(o2.getModificationTime()));
                }
            });
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRepeatableServiceLogic() {
        this.ctx.logDebug("Scanning remote folder '" + this.rootFolder + "' for any changes...");
        try {
            if (this.snapshot == null) {
                return;
            }
            List<FileInfo> files = this.getFileList();
            if (files == null) {
                this.ctx.logDebug("Unable to retrieve file list from the server.");
                return;
            }
            for (FileInfo file : files) {
                FileInfo oldFile;
                if (file.getName().equals(".") || file.getName().equals("..")) continue;
                if (!this.isSnapshotContainsFile(this.snapshot, file)) {
                    this.applyMonitor(file);
                    this.sendStateChangeEvent(file, FileState.CREATED);
                    continue;
                }
                int index = this.snapshot.indexOf(file);
                if (index <= 0 || (oldFile = this.snapshot.get(index)).getModificationTime() <= 0L || file.getModificationTime() <= 0L || oldFile.getModificationTime() == file.getModificationTime()) continue;
                this.sendStateChangeEvent(file, FileState.MODIFIED);
            }
            for (FileInfo file : this.snapshot) {
                if (this.isSnapshotContainsFile(files, file)) continue;
                this.sendStateChangeEvent(file, FileState.DELETED);
            }
            if (this.persistentSnapshot) {
                this.persistSnapshot(files);
            }
            this.snapshot = files;
        }
        catch (ClientException exception) {
            this.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception exception) {
            this.raiseException((ExceptionEventDatagram)this.createClientException("Download failed: " + exception.getMessage()));
        }
        finally {
            try {
                Thread.sleep(this.pollingInterval);
            }
            catch (InterruptedException e) {
                this.activated = false;
                this.snapshot = null;
                Trace.logDebug((Object)((Object)this), (String)("HDFS polling interrupt: " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMonitor(FileInfo file) {
        block18: for (FileMonitor monitor : this.monitors) {
            Matcher matcher = monitor.pattern.matcher(file.getName());
            if (!matcher.find()) continue;
            switch (monitor.action.ordinal()) {
                case 1: {
                    Object targetDir;
                    try {
                        targetDir = monitor.actionParameter;
                        if (targetDir != null && !((String)targetDir).trim().startsWith("/")) {
                            targetDir = this.rootFolder + "/" + (String)targetDir;
                        }
                        this.ctx.logDebug("Renaming new file '" + file.getName() + "' to '" + (String)targetDir + "'...");
                        this.fs.rename(this.rootFolder + "/" + file.getName(), this.rootFolder + "/" + (String)targetDir);
                        this.ctx.logDebug("File '" + file.getName() + "' has been renamed.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to rename file '" + file.getName() + "'. " + error.getMessage());
                    }
                    continue block18;
                }
                case 0: {
                    Object targetDir;
                    try {
                        targetDir = monitor.actionParameter;
                        if (targetDir != null && !((String)targetDir).trim().startsWith("/")) {
                            targetDir = this.rootFolder + "/" + (String)targetDir;
                        }
                        this.ctx.logDebug("Copying new file '" + file.getName() + "' to '" + (String)targetDir + "'...");
                        File tempFile = new File(HDFS_TEMP_FOLDER, "TEMP_HDFS_FILE_" + System.currentTimeMillis() + "_" + ++this.fileCounter + ".TMP");
                        try {
                            this.fs.copy(this.rootFolder + "/" + file.getName(), (String)targetDir + "/" + file.getName());
                        }
                        finally {
                            if (tempFile != null && tempFile.exists()) {
                                tempFile.delete();
                                tempFile = null;
                            }
                        }
                        this.ctx.logDebug("File '" + file.getName() + "' has been copied.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to copy file '" + file.getName() + "'. " + error.getMessage());
                    }
                    continue block18;
                }
                case 3: {
                    try {
                        this.ctx.logDebug("Deleting file '" + file.getName() + "'...");
                        this.fs.delete(this.rootFolder + "/" + file.getName(), false);
                        this.ctx.logDebug("File '" + file.getName() + "' has been deleted.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to delete file '" + file.getName() + "'. " + error.getMessage());
                    }
                    continue block18;
                }
                case 2: {
                    Object targetDir;
                    try {
                        targetDir = monitor.actionParameter;
                        if (targetDir != null && !((String)targetDir).trim().startsWith("/")) {
                            targetDir = this.rootFolder + "/" + (String)targetDir;
                        }
                        this.ctx.logDebug("Moving new file '" + file.getName() + "' to '" + (String)targetDir + "'...");
                        this.fs.rename(this.rootFolder + "/" + file.getName(), (String)targetDir + "/" + file.getName());
                        this.ctx.logDebug("File '" + file.getName() + "' has been moved to '" + (String)targetDir + "'.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to move file '" + file.getName() + "'. " + error.getMessage());
                    }
                    continue block18;
                }
                case 4: {
                    continue block18;
                }
            }
            this.ctx.logError("Unsupported file action '" + monitor.action.name() + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSnapshot() {
        if (this.persistentSnapshot && this.accessor != null) {
            this.ctx.logDebug("Initializing HDFS folder snapshot from dataspace collection...");
            try {
                ArrayList<FileInfo> tempSnapshot = new ArrayList<FileInfo>();
                SLResponse response = this.accessor.invokeLanguageRequest("select FileName, IsDirectory,ModifiedDate from [" + this.collectionName + "]");
                if (response == null || !response.isOK() || response.getRowSet() == null) {
                    throw new IllegalStateException("Unable to load snapshot from dataspace collection. " + response.getText() != null ? response.getText() : "");
                }
                RowSet rowSet = response.getRowSet();
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    String fileName = rowSet.getString(1);
                    boolean isDirectory = rowSet.getBoolean(2);
                    Date modifiedDate = rowSet.getDate(3);
                    FileInfo entry = new FileInfo(fileName, null, 0L, isDirectory, 0L, modifiedDate.getTime(), 0L, null, null, null, null, 0L, 0);
                    tempSnapshot.add(entry);
                }
                this.snapshot = tempSnapshot;
            }
            catch (Exception exception) {
                this.raiseException((ExceptionEventDatagram)this.createClientException("Unable to init HDFS folder snapshot : " + exception.getMessage()));
            }
        } else {
            this.ctx.logDebug("Initializing HDFS folder snapshot from HDFS server...");
            java.util.Date date = null;
            if (this.recoveryWindow > 0) {
                date = new java.util.Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                switch (this.recoveryWindowUnit) {
                    case SECONDS: {
                        calendar.add(13, -this.recoveryWindow);
                        break;
                    }
                    case MINUTES: {
                        calendar.add(12, -this.recoveryWindow);
                        break;
                    }
                    case HOURS: {
                        calendar.add(12, -this.recoveryWindow);
                        break;
                    }
                    case DAYS: {
                        calendar.add(12, -this.recoveryWindow);
                        break;
                    }
                }
                date = calendar.getTime();
            }
            try {
                try {
                    Trace.logDebug((Object)((Object)this), (String)("Accessing HDFS site '" + this.clientConnection.getName() + "' .."));
                    this.clientConnection.connect();
                    Trace.logDebug((Object)((Object)this), (String)"Connected.");
                }
                catch (Exception exception) {
                    throw this.createClientException("[HDFS OPEN] " + exception.getMessage());
                }
                List<FileInfo> files = this.getFileList();
                if (files == null) {
                    return;
                }
                for (FileInfo file : files) {
                    if (date == null || file.getModificationTime() == -1L || !new java.util.Date(file.getModificationTime()).after(date)) continue;
                    this.applyMonitor(file);
                }
                this.snapshot = files;
            }
            catch (ClientException exception) {
                this.raiseException((ExceptionEventDatagram)exception);
            }
            catch (Exception exception) {
                this.raiseException((ExceptionEventDatagram)this.createClientException("Unable to init HDFS folder snapshot : " + exception.getMessage()));
            }
            finally {
                try {
                    if (this.clientConnection.getState() == ConnectionState.OPEN) {
                        this.clientConnection.disconnect();
                    }
                }
                catch (ClientException error) {
                    Trace.logError((Object)((Object)this), (String)("HDFS disconnect failed: " + error.getMessage()));
                }
            }
        }
        if (this.snapshot != null) {
            this.ctx.logDebug("File snapshot initialized.");
        } else {
            this.ctx.logDebug("Unable to initialize file snapshot.");
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Unable to inialize HDFS folder snapshot.");
        }
    }

    private boolean isSnapshotContainsFile(List<FileInfo> snapshot, FileInfo file) {
        for (FileInfo info : snapshot) {
            if (!info.getName().equals(file.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistSnapshot(List<FileInfo> files) {
        if (this.accessor == null || !this.accessor.isAvailable()) {
            return;
        }
        this.ctx.logDebug("Storing the new file snapshot to underlying collection...");
        boolean commit = true;
        try {
            this.accessor.setAutoCommit(false);
            SLResponse response = this.accessor.invokeLanguageRequest("truncate collection [" + this.collectionName + "]");
            if (!response.isOK()) {
                commit = false;
                return;
            }
            for (FileInfo file : files) {
                this.accessor.executeQuery("insert into [" + this.collectionName + "]   (FileName, IsDirectory, ModifiedDate) values(?,?,?) ", new Object[]{file.getName(), file.isDirectory(), new java.util.Date(file.getModificationTime())});
            }
        }
        catch (Exception error) {
            commit = false;
        }
        finally {
            try {
                if (commit) {
                    this.accessor.commit();
                } else {
                    this.accessor.rollback();
                }
                this.accessor.setAutoCommit(true);
            }
            catch (Exception error) {
                this.ctx.logError("Unable to store file snapshot. " + error.getMessage());
            }
        }
        this.ctx.logDebug("File snapshot synchronized with dataspace collection.");
    }

    private void sendStateChangeEvent(FileInfo entry, FileState state) {
        try {
            MapEvent event = (MapEvent)EventDatagramFactory.getInstance().createEvent(EVENT_ID);
            event.setString("FileName", entry.getName());
            event.setString("FileState", state.name());
            event.setLong("FileSize", entry.getSize());
            event.setLong("BlockSize", entry.getBlockSize());
            event.setShort("Replication", entry.getReplication());
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
        }
        catch (Exception error) {
            this.ctx.logError("Failed to send file state change event. " + error.getMessage());
        }
    }

    private void raiseException(ExceptionEventDatagram error) {
        try {
            this.ctx.raiseException(error);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage() + " for SQL Error: " + error.getErrorMessage());
        }
    }

    protected ClientException createClientException(String error) {
        this.ctx.logError("HDFS Client Exception: " + error);
        ClientException exception = new ClientException(1027, error, Severity.SEVERE);
        if (this.clientConnection != null) {
            exception.setConnectionName(this.clientConnection.getName());
        }
        return exception;
    }

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)SERVICE_TYPE, (boolean)false);
        sco.setServiceClassName(EVHFDaemon.class.getName());
        sco.setServiceDescription("Polls the specified HDFS folder and checks for new files.");
        sco.setServiceDisplayName("Event HDFS System Daemon");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ServiceConfigurationProperty prop = sco.createProperty(CONNECTION, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("HDFS Connection");
        prop.setDescription("Specifies HDFS connection configuration.");
        prop.setValue((Object)new ClientFactoryPropertyValue("TestConnection", "clientConnection"));
        sco.addProperty(prop);
        prop = sco.createProperty(ROOT_FOLDER, ServicePropertyType.STRING, null);
        prop.setLabel("Root Folder");
        prop.setDescription("Specifies root HDFS folder.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(POLLING_INTERVAL, ServicePropertyType.NUMERIC, null);
        prop.setLabel("Polling Interval");
        prop.setDescription("Specifies polling interval.");
        prop.setValue((Object)60000L);
        sco.addProperty(prop);
        prop = sco.createProperty(PERSISTENT_SNAPSHOT, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Persistent Snapshot");
        prop.setDescription("Specifies whether snapshot should be persistent.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty(DATASPACE_NAME, ServicePropertyType.STRING, null);
        prop.setLabel("Dataspace Name");
        prop.setDescription("Specifies name of the dataspace to store snapshot.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(COLLECTION_NAME, ServicePropertyType.STRING, null);
        prop.setLabel("Collection Name");
        prop.setDescription("Specifies name of the collection to store snapshot.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(RECOVERY_WINDOW, ServicePropertyType.STRING, null);
        prop.setLabel("Recovery Window");
        prop.setDescription("Specifies which existing files should be processed during the service start.");
        prop.setValue("60000");
        sco.addProperty(prop);
        prop = sco.createProperty(SORT_STRATEGY, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("File Sort Strategy");
        prop.setDescription("Specifies sort strategy for the files to be processed by monitors.");
        prop.setRange(SortStrategy.MODIFICATION_TIME.name() + "," + SortStrategy.SERVER_DEFAULT.name());
        prop.setValue(SortStrategy.MODIFICATION_TIME.name());
        sco.addProperty(prop);
        ServiceConfigurationProperty monitors = sco.createProperty(MONITORS, ServicePropertyType.LIST, null);
        monitors.setLabel("Monitors");
        monitors.setDescription("Contains list of all monitors.");
        sco.addProperty(monitors);
        ServiceConfigurationProperty monitor = sco.createProperty(MONITOR, ServicePropertyType.TABLE, null);
        monitor.setLabel("Monitor");
        monitor.setDescription("Contains configuration of a monitor.");
        ((List)monitors.getValue()).add(monitor);
        Hashtable monitorConfig = (Hashtable)monitor.getValue();
        prop = sco.createProperty(MONITOR_NAME, ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Name");
        prop.setDescription("Specifies name of the monitor.");
        prop.setValue("TestMonitor");
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty(MONITOR_PATTERN, ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Pattern");
        prop.setDescription("Specifies pattern for the files which this monitor is supposed to process.");
        prop.setValue(".*.zip");
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty(MONITOR_ACTION, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Monitor Action");
        prop.setDescription("Specifies action which should be applied on matched file.");
        prop.setRange(FileAction.COPY.name() + "," + FileAction.MOVE.name() + "," + FileAction.DELETE.name() + "," + FileAction.RENAME.name() + "," + FileAction.NONE.name());
        prop.setValue(FileAction.COPY.name());
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty(MONITOR_ACTION_PARAMETER, ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Action Parameter");
        prop.setDescription("Specifies additional parameter for file action (if necessary).");
        prop.setValue("InboundFolder");
        monitorConfig.put(prop.getName(), prop);
        sco.addActionableEvent(EVENT_ID);
        sco.addException("exception.cli.Interface");
        return sco;
    }

    public static void main(String[] args) throws Exception {
        XSerializer serializer = RuntimeContext.getInstance().getXSerializer();
        FileIOUtils.putFile((String)".", (String)"EVHFDaemon.prototype.sco", (byte[])serializer.serialize((Object)EVHFDaemon.generateSco()).getBytes());
    }

    static {
        try {
            SDOUtils.addEventPrototype((String)"MapEvent", (String)EVENT_ID);
        }
        catch (Exception error) {
            Trace.logError(EVHFDaemon.class, (String)"Unable to register default event prototypes.");
        }
        if (!HDFS_TEMP_FOLDER.exists()) {
            HDFS_TEMP_FOLDER.mkdir();
        }
    }

    static enum SortStrategy {
        SERVER_DEFAULT,
        MODIFICATION_TIME;

    }

    static enum FileAction {
        COPY,
        RENAME,
        MOVE,
        DELETE,
        NONE;

    }

    class FileMonitor {
        String name;
        Pattern pattern;
        FileAction action;
        String actionParameter;

        FileMonitor(EVHFDaemon this$0) {
        }
    }
}

