/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.ftp.evSource;

import com.streamscape.lib.ftp.client.FTPConnection;
import com.streamscape.lib.ftp.client.FileEntry;
import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.service.ftp.FTPRequest;
import com.streamscape.service.ftp.evSource.Version;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FTPEventSource
extends AbstractDaemonService {
    private static final String CONNECTION = "connection.ftp";
    private static final String GET_FILE_MODE = "get.file.mode";
    private static final String SORT_FILE_STRATEGY = "file.sort.strategy";
    private static final String FILE_ACTION = "file.action";
    private static final String RAISE_FILE_EVENT = "file.event.id";
    private static final String ACTIVE_POLL_INTERVAL = "active.poll.interval";
    private static final String PASSIVE_POLL_INTERVAL = "passive.poll.interval";
    private static final String REMOTE_FILE = "file.remote";
    private static final String LOCAL_FILE = "file.local";
    private static final String REMOTE_FILE_ACTION = "action.file.remote";
    private static final String REMOTE_ACTION_ARG = "action.file.remote.arg";
    private static final String RAISE_EVENT_ON_SAVE = "raise.event.on.save";
    private static final String LOCAL_ACTION_EVENT = "local.action.event";
    private static final String OVERWRITE_LOCAL_FILE = "overwrite.local.file";
    private FTPConnection ftpConnection = null;
    private ClientFactory connectionFactory = null;
    private String remotePath = null;
    private String moveToPath = null;
    private String localPath = null;
    private boolean isPollingMode = true;
    private boolean shouldSaveFile = true;
    private boolean shouldRaiseFileEvent = true;
    private RemoteFileAction remoteFileAction = RemoteFileAction.none;
    private long activePollingInterval = 10000L;
    private long passivePollingInterval = 60000L;
    private long pollingInterval = 10000L;
    private boolean activeMode = false;
    private SortFilesStrategy sortStrategy = SortFilesStrategy.MODIFICATION_TIME;
    private boolean raiseEventOnSave = false;
    private boolean overwriteLocalFile = true;
    private String localActionEventId = null;

    public void downloadFile(FTPRequest request) throws ClientException {
        if (this.ftpConnection == null) {
            throw this.createClientException("FTP connection is not initialized.");
        }
        if (this.isPollingMode) {
            this.ctx.logDebug("'Polling' mode - ignoring FTP request events");
            return;
        }
        if (!request.getCommand().equals("get")) {
            throw this.createClientException("Only FTP GET is supported currently");
        }
        this.ctx.logDebug("Processing FTP request " + request.getCommand() + ": source = " + request.getSourcePath() + ", destination = " + request.getDestinationPath());
        this.download(request.getSourcePath(), request.getDestinationPath(), true);
    }

    protected void doRepeatableServiceLogic() {
        try {
            this.download(this.remotePath, this.localPath, false);
        }
        finally {
            try {
                Thread.sleep(this.pollingInterval);
            }
            catch (InterruptedException e) {
                this.ctx.logDebug("FTP polling interrupt: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void download(String sourcePath, String destinationPath, boolean request) {
        try {
            try {
                this.ctx.logDebug("Accessing FTP site '" + this.ftpConnection.getUrl() + "' ..");
                this.ftpConnection.connect();
            }
            catch (Exception exception) {
                this.pollingInterval = this.passivePollingInterval;
                this.ctx.logDebug("Transitioning to passive polling mode..");
                throw this.createClientException("[FTP OPEN] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            }
            List<FileEntry> files = null;
            try {
                files = this.ftpConnection.ftpList(sourcePath, true);
            }
            catch (Exception ftpError) {
                this.pollingInterval = this.passivePollingInterval;
                this.ctx.logDebug("Transitioning to passive polling mode..");
                if (request) {
                    throw this.createClientException("[FTP LIST] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ftpError));
                }
                this.ctx.logDebug("[FTP LIST] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ftpError));
            }
            if (files == null || files.size() == 0) {
                this.ctx.logDebug("No files found for " + sourcePath);
                if (this.activeMode) {
                    this.pollingInterval = this.passivePollingInterval;
                    this.ctx.logDebug("Transitioning to passive polling mode..");
                    this.activeMode = false;
                }
                return;
            }
            this.ctx.logDebug(String.valueOf(files) + " files found for filter " + sourcePath + ":");
            for (FileEntry fileEntry : files) {
                this.ctx.logDebug(fileEntry.getFileName());
            }
            if (files.size() > 1) {
                this.ctx.logDebug("WARNING: Multiple files found for the filter '" + sourcePath + "'.");
            }
            FileEntry fileToGet = null;
            switch (this.sortStrategy.ordinal()) {
                case 1: {
                    for (FileEntry file : files) {
                        if (fileToGet != null && !file.isOlder(fileToGet)) continue;
                        fileToGet = file;
                    }
                    break;
                }
                default: {
                    fileToGet = files.get(0);
                }
            }
            String string = FTPEventSource.getDirAndFile(fileToGet.getFileName())[1];
            String sourceFolderDir = FTPEventSource.getDirAndFile(sourcePath)[0];
            String sourceFilePath = this.makeFilePath(sourceFolderDir, string);
            String destinationFilePath = null;
            destinationFilePath = destinationPath == null ? string : this.makeFilePath(destinationPath, string);
            String moveToFilePath = null;
            if (this.moveToPath != null) {
                moveToFilePath = this.makeFilePath(this.moveToPath, string);
            }
            this.ctx.logDebug("sourceFileName: " + string);
            this.ctx.logDebug("sourceFilePath: " + sourceFilePath);
            this.ctx.logDebug("destinationFilePath: " + destinationFilePath);
            this.ctx.logDebug("moveToPath: " + this.moveToPath);
            this.ctx.logDebug("moveToFilePath: " + moveToFilePath);
            this.ctx.logInfo("Downloading the file '" + sourceFilePath + "'.");
            if (this.shouldSaveFile) {
                try {
                    this.ctx.logInfo("Saving downloaded '" + sourceFilePath + "' to '" + destinationFilePath + "'.");
                    if (!this.overwriteLocalFile && new File(destinationFilePath).exists()) {
                        throw new Exception("Destination local file '" + destinationFilePath + "' already exists. Remove it or set overwrite.local.file service property to false to copy file from FTP.");
                    }
                    this.ftpConnection.ftpGetFileAsFile(sourceFilePath, destinationFilePath);
                    this.ctx.logInfo("File '" + destinationFilePath + "' has been saved.");
                    if (this.raiseEventOnSave) {
                        if (this.localActionEventId != null && !this.localActionEventId.isEmpty()) {
                            EventDatagram event = EventDatagramFactory.getInstance().createEvent(this.localActionEventId);
                            if (event instanceof FileEvent) {
                                this.ctx.logInfo("Raise File Event [" + this.localActionEventId + "].");
                                FileEvent fileEvent = (FileEvent)event;
                                File file = new File(destinationFilePath);
                                fileEvent.init(file, FileState.CREATED);
                                fileEvent.setCorrelationId(string);
                                fileEvent.setFileData(FileUtils.readFileToByteArray((File)file));
                                this.ctx.raiseEvent((ImmutableEventDatagram)fileEvent, 0L);
                                this.ctx.logInfo("FileEvent with the downloaded file has been raised.");
                            } else {
                                this.ctx.logError("Specified Local Action Event Id [" + this.localActionEventId + "] must be FileEvent. Raise event on save action is skipped.");
                            }
                        } else {
                            this.ctx.logError("Local Action Event Id is not specified. Raise event on save action is skipped.");
                        }
                    }
                    this.applyRemoteFileAction(sourceFilePath, moveToFilePath);
                }
                catch (Exception ftpError) {
                    this.pollingInterval = this.passivePollingInterval;
                    this.ctx.logDebug("Transitioning to passive polling mode..");
                    throw this.createClientException("[FTP GET] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ftpError));
                }
            }
            try {
                byte[] data = this.ftpConnection.ftpGetFileAsBytes(sourceFilePath);
                this.ctx.logInfo("Raise Bytes Event [" + this.localActionEventId + "]. Bytes: [" + data.length + "].");
                EventDatagram event = EventDatagramFactory.getInstance().createEvent(this.localActionEventId);
                if (event instanceof BytesEvent) {
                    BytesEvent bytesEvent = (BytesEvent)event;
                    bytesEvent.setBytes(data);
                    bytesEvent.setCorrelationId(string);
                    this.ctx.raiseEvent((ImmutableEventDatagram)bytesEvent, 0L);
                    this.ctx.logInfo("BytesEvent with the downloaded file content has been raised.");
                } else {
                    this.ctx.logError("Specified Local Action Event Id [" + this.localActionEventId + "] must be BytesEvent. Raise event is skipped.");
                }
                this.applyRemoteFileAction(sourceFilePath, moveToFilePath);
            }
            catch (Exception ftpError) {
                throw this.createClientException("[FTP GET] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ftpError));
            }
            if (!this.activeMode) {
                this.pollingInterval = this.activePollingInterval;
                this.ctx.logDebug("Transitioning to active polling mode..");
                this.activeMode = true;
            }
        }
        catch (ClientException exception) {
            this.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Throwable exception) {
            this.raiseException((ExceptionEventDatagram)this.createClientException("Download failed: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
        }
        finally {
            try {
                if (this.ftpConnection != null && this.ftpConnection.getState() == ConnectionState.OPEN) {
                    this.ftpConnection.disconnect();
                }
            }
            catch (ClientException error) {
                this.ctx.logError("FTP disconnect failed: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
            }
        }
    }

    private void applyRemoteFileAction(String sourceFilePath, String moveToFilePath) throws ClientException {
        switch (this.remoteFileAction.ordinal()) {
            case 1: {
                try {
                    this.ctx.logInfo("Moving the remote file '" + sourceFilePath + "' to '" + moveToFilePath + "'.");
                    this.ftpConnection.ftpRen(sourceFilePath, moveToFilePath);
                    this.ctx.logInfo("Remote file '" + sourceFilePath + "' has been moved to '" + moveToFilePath + "'.");
                    break;
                }
                catch (Exception ftpError) {
                    throw this.createClientException("[FTP RENAME] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ftpError));
                }
            }
            case 2: {
                try {
                    this.ctx.logInfo("Removal of remote file '" + sourceFilePath + "'.");
                    this.ftpConnection.ftpDel(sourceFilePath);
                    this.ctx.logInfo("Remote file '" + sourceFilePath + "' has been deleted.");
                    break;
                }
                catch (Exception ftpError) {
                    throw this.createClientException("[FTP REMOVE] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ftpError));
                }
            }
            case 0: {
                this.ctx.logInfo("Remote File Action is none. Do nothing.");
                break;
            }
            default: {
                this.ctx.logError("Unknown Remove File Action: " + String.valueOf((Object)this.remoteFileAction));
            }
        }
    }

    protected static String[] getDirAndFile(String path) {
        String[] dirAndFile = new String[]{"", ""};
        if (path != null) {
            int slashIndex = path.lastIndexOf(47);
            if (slashIndex > 0) {
                dirAndFile[0] = path.substring(0, slashIndex + 1);
            }
            if (slashIndex < path.length() - 1) {
                dirAndFile[1] = path.substring(slashIndex + 1);
            }
        }
        return dirAndFile;
    }

    private String makeFilePath(String folder, String file) {
        return folder.endsWith("/") || folder.endsWith("\\") ? folder + file : folder + "/" + file;
    }

    private void raiseException(ExceptionEventDatagram error) {
        try {
            this.ctx.raiseException(error);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ex) + " for SQL Error: " + error.getErrorMessage());
        }
    }

    protected ClientException createClientException(String error) {
        this.ctx.logError("FTP Client Exception: " + error);
        ClientException exception = new ClientException(1020, error, Severity.SEVERE);
        if (this.ftpConnection != null) {
            exception.setConnectionName(this.ftpConnection.getUrl());
        }
        return exception;
    }

    protected void doInit() {
        try {
            super.doInit();
            if (!this.ctx.lookupStringProperty(GET_FILE_MODE).equals("poll")) {
                this.isPollingMode = false;
            }
            if (this.ctx.lookupStringProperty(SORT_FILE_STRATEGY).equals("ServerDefault")) {
                this.sortStrategy = SortFilesStrategy.SERVER_DEFAULT;
            }
            if (!this.ctx.lookupStringProperty(FILE_ACTION).equals("saveFile")) {
                this.shouldSaveFile = false;
            }
            if (!this.ctx.existsProperty(RAISE_FILE_EVENT)) {
                this.shouldRaiseFileEvent = false;
            }
            if (this.ctx.existsProperty(RAISE_EVENT_ON_SAVE)) {
                this.raiseEventOnSave = this.ctx.lookupBooleanProperty(RAISE_EVENT_ON_SAVE);
            } else {
                this.ctx.logInfo("raise.event.on.save property does not exist. Use default value: " + this.raiseEventOnSave);
            }
            if (this.ctx.existsProperty(OVERWRITE_LOCAL_FILE)) {
                this.overwriteLocalFile = this.ctx.lookupBooleanProperty(OVERWRITE_LOCAL_FILE);
                this.ctx.logInfo("overwrite.local.file: " + this.overwriteLocalFile);
            } else {
                this.ctx.logInfo("overwrite.local.file property does not exist. Use default value: " + this.overwriteLocalFile);
            }
            if (this.ctx.existsProperty(LOCAL_ACTION_EVENT)) {
                this.localActionEventId = this.ctx.lookupStringProperty(LOCAL_ACTION_EVENT);
            } else {
                this.ctx.logError("local.action.event property does not exist.");
            }
            if (this.ctx.existsProperty(REMOTE_FILE_ACTION)) {
                this.remoteFileAction = RemoteFileAction.valueOf(this.ctx.lookupStringProperty(REMOTE_FILE_ACTION));
            } else {
                this.ctx.logError("action.file.remote property does not exist. Use default value: " + String.valueOf((Object)this.remoteFileAction));
            }
            this.activePollingInterval = this.ctx.lookupNumericProperty(ACTIVE_POLL_INTERVAL);
            this.passivePollingInterval = this.ctx.lookupNumericProperty(PASSIVE_POLL_INTERVAL);
            if (this.passivePollingInterval < this.activePollingInterval) {
                this.ctx.logDebug("WARNING: Passive polling interval parameter is less than active polling interval.");
                this.passivePollingInterval = this.activePollingInterval;
            }
            this.pollingInterval = this.passivePollingInterval;
            this.remotePath = this.ctx.lookupStringProperty(REMOTE_FILE);
            this.moveToPath = this.ctx.lookupStringProperty(REMOTE_ACTION_ARG);
            this.localPath = this.ctx.lookupStringProperty(LOCAL_FILE);
            this.assertPropertyExistAndNotNull(CONNECTION);
            this.connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION);
            this.ftpConnection = (FTPConnection)this.connectionFactory.createConnection();
            this.ctx.logDebug("FTPEventSource initialized: " + this.toString());
        }
        catch (Exception badConfiguration) {
            throw new RuntimeException(badConfiguration);
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.connectionFactory != null) {
            try {
                this.connectionFactory.destroyAll();
                this.connectionFactory = null;
            }
            catch (Exception exception) {
                this.ctx.logError("Failed to destroy connection factory '" + this.connectionFactory.toString() + "'. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            }
        }
    }

    protected long getPassiveIterationInterval() {
        return this.passivePollingInterval;
    }

    public String toString() {
        return (String)(this.isPollingMode ? "Active Polling Interval: " + this.pollingInterval + " sec\n" : "WAIT") + "\n remote = " + this.remotePath + "\n local = " + this.localPath + "\n moveTo = " + this.moveToPath + "\n result = " + (this.shouldSaveFile ? "file" : "bytes-event") + "\n remote file action = " + String.valueOf((Object)this.remoteFileAction) + (this.shouldRaiseFileEvent ? ", raise file-event" : "") + ", connection: user = " + this.connectionFactory.getDefaultUser() + ", host = " + this.ftpConnection.getHost();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        if (!TypeFactory.existsSemanticType((String)FTPRequest.class.getSimpleName())) {
            SemanticType type = new SemanticType(FTPRequest.class.getSimpleName(), FTPRequest.class.getName());
            TypeFactory.addSemanticType((SemanticType)type);
        }
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"FTPEventSource", (boolean)false);
        sco.setServiceClassName(FTPEventSource.class.getName());
        sco.setServiceDescription("Polls specified FTP folder or downloads file by request.");
        sco.setServiceDisplayName("FTP Event Source");
        sco.setInvokeMode(InvokeMode.ASYNC);
        SemanticType ftpRequestType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("FTPRequest");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "downloadFile", "DownloadByRequestHandler");
        handler.bindRequestObject("event.ftp.request", ftpRequestType);
        handler.bindVoidResponseObject("event.ftp.response");
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty(ACTIVE_POLL_INTERVAL, ServicePropertyType.NUMERIC, null);
        prop.setLabel("Active Polling Interval");
        prop.setDescription("Specifies active FTP site polling interval (when files are available for downoload).");
        prop.setValue((Object)1000);
        sco.addProperty(prop);
        prop = sco.createProperty(PASSIVE_POLL_INTERVAL, ServicePropertyType.NUMERIC, null);
        prop.setLabel("Passive Polling Interval");
        prop.setDescription("Specifies passive FTP site polling interval (when no files are available for downoload).");
        prop.setValue((Object)60000);
        sco.addProperty(prop);
        prop = sco.createProperty(PASSIVE_POLL_INTERVAL, ServicePropertyType.NUMERIC, null);
        prop.setLabel("Passive Polling Interval");
        prop.setDescription("Specifies passive FTP site polling interval (when no files are available for downoload).");
        prop.setValue((Object)60000);
        sco.addProperty(prop);
        prop = sco.createProperty(CONNECTION, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("FTP Connection Factory");
        prop.setDescription("Specifies FTP connection factory.");
        prop.setValue((Object)new ClientFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty(FILE_ACTION, ServicePropertyType.STRING, null);
        prop.setLabel("File Action");
        prop.setDescription("Specifies action which should be taken on the file once it is downloaded.");
        prop.setRange("saveFile,raiseBytesEvent");
        prop.setValue("raiseBytesEvent");
        sco.addProperty(prop);
        prop = sco.createProperty(GET_FILE_MODE, ServicePropertyType.STRING, null);
        prop.setLabel("Get File Mode");
        prop.setDescription("Specifies whether service need to poll FTP or wait for a download request.");
        prop.setRange("poll,request");
        prop.setValue("poll");
        sco.addProperty(prop);
        prop = sco.createProperty(LOCAL_FILE, ServicePropertyType.STRING, null);
        prop.setLabel("Local File Name");
        prop.setDescription("Specifies name of the file once it is downloaded.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(REMOTE_FILE, ServicePropertyType.STRING, null);
        prop.setLabel("Remote File Name");
        prop.setDescription("Specifies name (or mask) of the remote file name.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(REMOTE_FILE_ACTION, ServicePropertyType.STRING, null);
        prop.setLabel("Remote File Action");
        prop.setDescription("Specifies action which should be taken on remote file once download completed.");
        prop.setRange("none,move,remove");
        prop.setValue("none");
        sco.addProperty(prop);
        prop = sco.createProperty(REMOTE_ACTION_ARG, ServicePropertyType.STRING, null);
        prop.setLabel("Remote File Action Argument");
        prop.setDescription("Specifies argument for remote file action (e.g. name of the folder for move action).");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(SORT_FILE_STRATEGY, ServicePropertyType.STRING, null);
        prop.setLabel("Sort File Strategy");
        prop.setDescription("Specifies sort strategy for remote files.");
        prop.setRange("ServerDefault,ModificationTime");
        prop.setValue("ServerDefault");
        sco.addProperty(prop);
        prop = sco.createProperty(RAISE_EVENT_ON_SAVE, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Event On Save");
        prop.setDescription("Raise or not FileEvent when remote file is saved to local destination.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty(OVERWRITE_LOCAL_FILE, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Overwrite Local File");
        prop.setDescription("Not raise or raise exception if destination file exists.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty(LOCAL_ACTION_EVENT, ServicePropertyType.STRING, null);
        prop.setLabel("Local Action Event Id");
        prop.setDescription("Specifies event id for local action.");
        prop.setValue("");
        sco.addProperty(prop);
        sco.addException("exception.cli.Interface");
        return sco;
    }

    static enum RemoteFileAction {
        none,
        move,
        remove;

    }

    static enum SortFilesStrategy {
        SERVER_DEFAULT,
        MODIFICATION_TIME;

    }
}

