/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.ftp.command;

import com.streamscape.Trace;
import com.streamscape.lib.ftp.client.FTPConnection;
import com.streamscape.lib.ftp.client.FileEntry;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.ftp.command.FTPListRequest;
import com.streamscape.service.ftp.evSink.Version;
import com.streamscape.service.osf.clients.ClientFactory;
import java.util.List;

public class FTPCommand
extends AbstractService {
    private static String CONNECTION = "connection.ftp";
    private static String COMMAND = "command.name";
    private FTPConnection ftpConnection = null;
    private Command command = null;

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    protected void doInit() throws ServiceFrameworkException {
        try {
            this.assertPropertyExistAndNotNull(CONNECTION);
            ClientFactory connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION);
            this.ftpConnection = (FTPConnection)connectionFactory.createConnection();
            this.assertPropertyExistAndNotNull(COMMAND);
            this.command = Command.valueOf(this.ctx.lookupStringProperty(COMMAND));
            this.ctx.logDebug("FTPCommand initialized: " + ((Object)((Object)this)).toString());
        }
        catch (Exception badConfiguration) {
            badConfiguration.printStackTrace();
            throw new RuntimeException(badConfiguration);
        }
    }

    public void invoke(String path) throws ClientException {
        this.initCheck();
        if (this.command != Command.delete && this.command != Command.mkdir && this.command != Command.rmdir) {
            throw this.createClientException("FTP command '" + this.command.toString() + "' is not correct. Only 'delete', 'mkdir', 'rmdir' is supported for current request(String).");
        }
        this.genericInvoke(path);
    }

    public List<FileEntry> invoke(FTPListRequest request) throws ClientException {
        this.initCheck();
        if (this.command != Command.list) {
            throw this.createClientException("FTP command '" + this.command.toString() + "' is not correct. Only 'list' is supported for current request(FTPListRequest).");
        }
        List result = (List)this.genericInvoke(request);
        this.ctx.logDebug("Result: " + String.valueOf(result));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object genericInvoke(Object request) throws ClientException {
        List<FileEntry> result = null;
        try {
            if (request == null) {
                throw this.createClientException("Request is NULL");
            }
            this.ctx.logInfo("Connecting to FTP site..");
            try {
                this.ftpConnection.connect();
            }
            catch (Exception ftpError) {
                throw this.createClientException("[FTP OPEN] " + ftpError.getMessage());
            }
            this.ctx.logInfo("Invoke command: " + this.command.toString() + "; request: " + request.toString());
            switch (this.command.ordinal()) {
                case 1: {
                    FTPListRequest listRequest = (FTPListRequest)request;
                    result = this.ftpConnection.ftpList(listRequest.getPath(), listRequest.isFull());
                    return result;
                }
                case 0: {
                    this.ftpConnection.ftpDel(request.toString());
                    return result;
                }
                case 2: {
                    this.ftpConnection.ftpMkD(request.toString());
                    return result;
                }
                case 3: {
                    this.ftpConnection.ftpRmD(request.toString());
                    return result;
                }
                default: {
                    throw this.createClientException("Unknown command: " + this.command.toString());
                }
            }
        }
        catch (ClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.createClientException("Invoke command error: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ftpConnection.getState() == ConnectionState.OPEN) {
                    this.ctx.logInfo("Disconnecting..");
                    this.ftpConnection.disconnect();
                }
            }
            catch (ClientException error) {
                this.ctx.logError("FTP disconnect failed: " + error.getMessage());
            }
        }
    }

    private void initCheck() throws ClientException {
        if (this.ftpConnection == null) {
            throw this.createClientException("FTP connection is not initialized.");
        }
        if (this.command == null) {
            throw this.createClientException("FTP command is not initialized.");
        }
    }

    private ClientException createClientException(String error) {
        Trace.logError((Object)((Object)this), (String)("FTP Client Exception: " + error));
        this.ctx.logError("FTP Client Exception: " + error);
        ClientException exception = new ClientException(1020, error, Severity.SEVERE);
        if (this.ftpConnection != null) {
            exception.setConnectionName(this.ftpConnection.getUrl());
        }
        return exception;
    }

    public static enum Command {
        delete,
        list,
        mkdir,
        rmdir;

    }
}

