/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.dbms.evSource.mod;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryException;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryBatch;
import com.streamscape.sdo.sql.SQLQueryFactory;
import com.streamscape.sdo.sql.SQLQueryMapper;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.dbms.evSource.mod.IDatabaseEventSource;
import com.streamscape.service.osf.config.ConfigurationObject;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class SQLEventStreamSource
implements IDatabaseEventSource {
    private transient DatabaseConnection connection = null;
    private transient SQLQueryBatch startUpSQL = null;
    private transient SQLQueryBatch shutDownSQL = null;
    private transient SQLQuery getKeyQuery = null;
    private transient SQLQuery acknowledgeQuery = null;
    private transient SQLQuery getNextRowSetQuery = null;
    private transient int queryTimeout = 0;
    private transient SQLQueryMapper getNextQueryMapper = null;
    private transient SQLQueryMapper acknowledgeQueryMapper = null;
    private transient boolean useMultiRowAck = false;
    private transient boolean useMultiRowStream = false;
    private static final String DESCRIPTION = "The module allows an SQL Result to produce an Event Stream.";
    private static final String VENDOR_STRING = "SQL Result Streamer Change Capture v1.1";

    @Override
    public void acknowledge(RowSet result) throws DatabaseSQLException {
        if (this.acknowledgeQuery == null) {
            return;
        }
        try {
            List results;
            Statement stat = this.connection.createStatement();
            SQLQuery temp = this.acknowledgeQuery;
            if (result != null && (results = this.acknowledgeQueryMapper.map(result)).size() > 0) {
                temp = (SQLQuery)results.get(0);
            }
            SQLQueryFactory.execute((SQLQuery)temp, (int)this.queryTimeout, (Connection)this.connection);
            stat.close();
        }
        catch (SQLException error) {
            throw new DatabaseSQLException(error);
        }
        catch (SQLQueryValidationException error) {
            this.wrapException(error);
        }
        catch (SQLQueryParseException error) {
            this.wrapException(error);
        }
        catch (SQLQueryException error) {
            this.wrapException(error);
        }
        catch (RuntimeException error) {
            this.wrapException(error);
        }
    }

    @Override
    public RowSet getNextRowSet(RowSet rowSetIds) throws DatabaseSQLException {
        RowSet result = null;
        try {
            List rowSets;
            SQLQuery temp = this.getNextRowSetQuery;
            if (rowSetIds != null) {
                List results = this.getNextQueryMapper.map(rowSetIds);
                if (results.size() > 0) {
                    temp = (SQLQuery)results.get(0);
                } else {
                    return null;
                }
            }
            if ((rowSets = SQLQueryFactory.execute((SQLQuery)temp, (int)this.queryTimeout, (Connection)this.connection)).size() > 1) {
                Trace.logError((Object)this, (String)"Multiple row sets detected during [Row Set retrieval] operation.");
            } else if (rowSets.size() == 1) {
                result = (RowSet)rowSets.get(0);
            }
        }
        catch (SQLQueryValidationException error) {
            this.wrapException(error);
        }
        catch (SQLQueryParseException error) {
            this.wrapException(error);
        }
        catch (SQLQueryException error) {
            this.wrapException(error);
        }
        catch (RuntimeException error) {
            this.wrapException(error);
        }
        return result;
    }

    @Override
    public RowSet getNextKey() throws DatabaseSQLException {
        if (this.getKeyQuery == null) {
            return null;
        }
        RowSet result = null;
        try {
            List rowSets = SQLQueryFactory.execute((SQLQuery)this.getKeyQuery, (int)this.queryTimeout, (Connection)this.connection);
            if (rowSets.size() > 1) {
                Trace.logError((Object)this, (String)"Multiple row sets detected during [Key retrieval query] operation.");
            } else if (rowSets.size() == 1) {
                result = (RowSet)rowSets.get(0);
            }
        }
        catch (SQLQueryValidationException error) {
            this.wrapException(error);
        }
        catch (SQLQueryParseException error) {
            this.wrapException(error);
        }
        catch (SQLQueryException error) {
            this.wrapException(error);
        }
        catch (RuntimeException error) {
            this.wrapException(error);
        }
        return result;
    }

    @Override
    public void execStartUpScript() throws DatabaseSQLException, ServiceConfigurationException {
        block5: {
            try {
                if (this.startUpSQL == null) break block5;
                try {
                    Statement stat = this.connection.createStatement();
                    SQLQueryFactory.execute((SQLQueryBatch)this.startUpSQL, (int)this.queryTimeout, (Connection)this.connection);
                    stat.close();
                }
                catch (SQLException error) {
                    throw new DatabaseSQLException(error);
                }
                catch (Exception error) {
                    this.wrapException(error);
                }
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
        }
    }

    @Override
    public void execShutDownScript() throws DatabaseSQLException, ServiceConfigurationException {
        block5: {
            try {
                if (this.shutDownSQL == null) break block5;
                try {
                    Statement stat = this.connection.createStatement();
                    SQLQueryFactory.execute((SQLQueryBatch)this.shutDownSQL, (int)this.queryTimeout, (Connection)this.connection);
                    stat.close();
                }
                catch (SQLException error) {
                    throw new DatabaseSQLException(error);
                }
                catch (Exception error) {
                    this.wrapException(error);
                }
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
        }
    }

    @Override
    public void init(DatabaseConnection connection, int queryTimeout, ConfigurationObject sco) throws DatabaseSQLException {
        RuntimeContext runtimeCtx = RuntimeContext.getInstance();
        this.connection = connection;
        this.queryTimeout = queryTimeout;
        try {
            try {
                ObjectPropertyValue startupSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("startup.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.startUpSQL = (SQLQueryBatch)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)startupSQL);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
            try {
                ObjectPropertyValue shutdownSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("shutdown.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.shutDownSQL = (SQLQueryBatch)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)shutdownSQL);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
            try {
                ObjectPropertyValue getNextKeySQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("next.key.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.getKeyQuery = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)getNextKeySQL);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
            ObjectPropertyValue getNextSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("next.rowset.sql").getValue();
            SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
            this.getNextRowSetQuery = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)getNextSQL);
            SemanticObjectReferenceStore.commitXact();
            this.getNextQueryMapper = new SQLQueryMapper(this.getNextRowSetQuery, 1);
            try {
                ObjectPropertyValue acknowledgeSQL = (ObjectPropertyValue)sco.getServiceConfigurationProperties().getProperty("acknowledge.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                this.acknowledgeQuery = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)acknowledgeSQL);
                SemanticObjectReferenceStore.commitXact();
                this.acknowledgeQueryMapper = new SQLQueryMapper(this.acknowledgeQuery, 1);
            }
            catch (Exception error) {
                Trace.logError((Object)this, (String)error.getMessage());
            }
        }
        catch (RuntimeException error) {
            this.wrapException(error);
        }
        catch (ObjectConfigurationException error) {
            this.wrapException(error);
        }
        catch (ServiceConfigurationException error) {
            this.wrapException(error);
        }
    }

    private void wrapException(Throwable error) {
        DatabaseSQLException sqlEx = new DatabaseSQLException(1024, error.getMessage());
        sqlEx.setConnectionName(this.connection.getName());
        this.connection.raiseException(sqlEx);
        throw new RuntimeException((Throwable)sqlEx);
    }

    @Override
    public boolean supportsAcknowledgeQuery() {
        return true;
    }

    @Override
    public boolean supportsGetNextKeyQuery() {
        return false;
    }

    @Override
    public boolean supportsGetNextRowSetQuery() {
        return true;
    }

    @Override
    public boolean supportsSessionInitQuery() {
        return true;
    }

    @Override
    public boolean supportsStartupQuery() {
        return false;
    }

    @Override
    public boolean supportsShutdownQuery() {
        return false;
    }

    @Override
    public boolean supportsMutiRowResult() {
        return true;
    }

    @Override
    public boolean supportsMultiRowResultStreaming() {
        return true;
    }

    @Override
    public void setMultiRowResultStreaming(boolean stream) {
        this.useMultiRowStream = stream;
    }

    @Override
    public boolean isMultiRowResultStreaming() {
        return this.useMultiRowStream;
    }

    @Override
    public boolean supportsMutiRowAcknowledge() {
        return true;
    }

    @Override
    public void setMultiRowAcknowledge(boolean group) {
        this.useMultiRowAck = group;
    }

    @Override
    public boolean isMutiRowAcknowledge() {
        return this.useMultiRowAck;
    }

    @Override
    public void runSetup() throws ServiceConfigurationException, DatabaseSQLException {
        throw new ServiceConfigurationException("Unsupported Capability.");
    }

    @Override
    public boolean supportsAdminSetup() {
        return false;
    }

    @Override
    public void runReset() throws ServiceConfigurationException, DatabaseSQLException {
        throw new ServiceConfigurationException("Unsupported Capability.");
    }

    @Override
    public boolean supportsAdminReset() {
        return false;
    }

    @Override
    public void runRemove() throws ServiceConfigurationException, DatabaseSQLException {
        throw new ServiceConfigurationException("Unsupported Capability.");
    }

    @Override
    public boolean supportsAdminRemove() {
        return false;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getVendorString() {
        return VENDOR_STRING;
    }
}

