/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.dbms.evSource;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.dfo.Observer;
import com.streamscape.runtime.mf.admin.dfo.SingleConnectionObserver;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.dbms.evSource.Version;
import com.streamscape.service.dbms.evSource.mod.IDatabaseEventSource;
import com.streamscape.service.dbms.evSource.mod.SQLEventSource;
import com.streamscape.service.osf.config.ConfigurationObject;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.ExceptionEventListener;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.jdbc.StateNotificationEventListener;
import java.sql.SQLException;

public class DatabaseEventSource
extends AbstractDaemonService
implements StateNotificationEventListener,
ExceptionEventListener {
    private EventDatagramFactory datagramFactory = null;
    IDatabaseEventSource sourceStrategy = null;
    private String eventId = null;
    private boolean transacted = false;
    private JDBCFactory jdbcFactory = null;
    private DatabaseConnection connection = null;
    private volatile boolean dirtySession = true;
    private long pollingInterval;
    private long passivePollingInterval = this.pollingInterval = 500L;
    private Observer connectionObserver;
    private long lastPollingTime = 0L;
    private boolean inActivePolling = false;

    public void start() throws ServiceFrameworkException {
        block2: {
            try {
                this.connection.connect();
            }
            catch (DatabaseSQLException error) {
                error.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
                error.setConnectionName(this.connection.getName());
                error.setSeverity(Severity.SEVERE);
                this.raiseException((ExceptionEventDatagram)error);
                if (this.jdbcFactory.isReliableConnection()) break block2;
                throw new RuntimeException(error);
            }
        }
        super.start();
    }

    public void stop() throws ServiceFrameworkException {
        super.stop();
        if (this.sourceStrategy != null) {
            try {
                this.sourceStrategy.execShutDownScript();
            }
            catch (Exception exception) {
                this.ctx.logError("Shutdown script execution failed. Cause: " + exception.getMessage());
            }
        }
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (DatabaseSQLException error) {
                this.ctx.logError("Disconnect failed.");
                this.printSQLException(error, false, false);
            }
        }
    }

    private void raiseEvent(DataEvent event) {
        try {
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
            this.ctx.logDebug("Actionable event [" + event.getEventId() + "] event has been raised.");
        }
        catch (Exception ex) {
            this.reportAndRethrowError(ex);
        }
    }

    private void raiseException(ExceptionEventDatagram error) {
        try {
            this.ctx.raiseException(error);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage() + " for SQL Error: " + error.getErrorMessage());
        }
    }

    public void doInit() {
        try {
            this.datagramFactory = this.context.getEventDatagramFactory();
        }
        catch (RuntimeException error) {
            this.ctx.logError("Service instantiation error: " + error.getMessage());
        }
        try {
            super.doInit();
            this.initializeJDBCFactory();
            this.pollingInterval = this.ctx.lookupNumericProperty("polling.interval");
            this.ctx.logInfo("Source table polling interval " + this.pollingInterval + "ms.");
            if (this.ctx.existsProperty("passive.polling.interval")) {
                this.passivePollingInterval = this.ctx.lookupNumericProperty("passive.polling.interval");
                this.ctx.logInfo("Source table passive polling interval " + this.passivePollingInterval + "ms.");
            } else {
                this.passivePollingInterval = this.pollingInterval;
            }
            if (this.passivePollingInterval < this.pollingInterval) {
                throw new Exception("Passive polling interval should be greater than polling interval.");
            }
            if (this.jdbcFactory.isReliableConnection() && this.passivePollingInterval <= this.jdbcFactory.getConnectionCheckInterval()) {
                this.ctx.logInfo("Polling interval is less then connection check interval for reliable connection. Disabling observer thread.");
                this.jdbcFactory.setReliableConnection(false);
                try {
                    this.connection = this.jdbcFactory.createConnection();
                }
                finally {
                    this.jdbcFactory.setReliableConnection(true);
                }
                this.connectionObserver = new SingleConnectionObserver(this.jdbcFactory, this.connection);
            } else {
                this.connection = this.jdbcFactory.createConnection();
                if (this.jdbcFactory.isReliableConnection()) {
                    this.ctx.logInfo("Connection will be checked each " + this.jdbcFactory.getConnectionCheckInterval() + "ms.");
                }
            }
            this.ctx.logInfo("Reconnect interval(calculated) " + this.calculateReconnectInterval() + "ms.");
            this.ctx.logInfo("Reconnect retries " + this.jdbcFactory.getReconnectRetries());
            this.connection.setStateNotificationEventListener((StateNotificationEventListener)this);
            this.connection.setExceptionEventListener((ExceptionEventListener)this);
            if (this.ctx.getLogger() != null) {
                this.connection.setServiceLogger(this.ctx.getLogger());
            }
            this.eventId = this.ctx.lookupStringProperty("event.id");
            EventDatagram event = this.datagramFactory.createEvent(this.eventId);
            if (event == null || !(event instanceof DataEvent)) {
                throw new RuntimeException("Unable to create event out of specified prototype '" + this.eventId + "'.");
            }
            this.ctx.logInfo("Database event source will produce events with '" + this.eventId + "' event ID.");
            this.transacted = this.ctx.lookupBooleanProperty("transacted.mode");
            this.ctx.logInfo("Database event source transacted mode is set to :" + this.transacted);
            this.initSourceStrategy();
        }
        catch (Exception error) {
            this.reportAndRethrowError(error);
        }
    }

    private void initializeJDBCFactory() {
        try {
            this.jdbcFactory = this.ctx.lookupJdbcFactoryProperty("jdbc.factory");
        }
        catch (Exception error) {
            this.reportAndRethrowError(error);
        }
    }

    private void initSourceStrategy() throws ServiceConfigurationException {
        try {
            String evtSourceStrategyClassName = this.sco.getServiceConfigurationProperties().getProperty("source.strategy.class").toString();
            this.sourceStrategy = (IDatabaseEventSource)ClassUtils.createFromClassName((Object)((Object)this), (String)evtSourceStrategyClassName, (ClassLoader)this.ctx.getPackageManifestManager().getManifestClassLoader());
            this.sourceStrategy.init(this.connection, this.jdbcFactory.getQueryTimeout(), (ConfigurationObject)this.sco);
            this.ctx.logInfo("Source strategy '" + evtSourceStrategyClassName + "' is used.");
        }
        catch (Exception error) {
            throw new ServiceConfigurationException((Throwable)error);
        }
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Database connection state changed: " + e.getState().toString());
        if (e.getState() != ConnectionState.CONNECTED) {
            this.dirtySession = true;
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Database connection state changed to " + e.getState().toString());
        } else {
            this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
        }
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch error in raiseAdvisory(): " + ex.getMessage() + " SQL Error: " + e.getMessage());
        }
    }

    public void onEvent(DatabaseSQLException e) {
        this.printSQLException(e, false, false);
    }

    private void printSQLException(DatabaseSQLException event, boolean linked, boolean critical) {
        Throwable next;
        if (critical) {
            this.ctx.logError("SQLException" + (linked ? "(next): " : ": ") + "Connection: " + event.getConnectionName() + "\nSeverity: " + String.valueOf(event.getSeverity()) + "\nError Code: " + event.getErrorCodeAsString() + "\nSQL State: " + event.getSQLState() + "\nMessage: " + event.getMessage());
        } else {
            this.ctx.logDebug("SQLException" + (linked ? "(next): " : ": ") + "Connection: " + event.getConnectionName() + "\nSeverity: " + String.valueOf(event.getSeverity()) + "\nError Code: " + event.getErrorCodeAsString() + "\nSQL State: " + event.getSQLState() + "\nMessage: " + event.getMessage());
        }
        while ((next = event.getCause()) != null) {
            if (!(next instanceof DatabaseSQLException)) continue;
            this.printSQLException((DatabaseSQLException)next, true, critical);
        }
    }

    private void sleepPollingInterval() throws InterruptedException {
        if (this.lastPollingTime > 0L) {
            long currentPollingInterval = this.inActivePolling ? this.pollingInterval : this.passivePollingInterval;
            long timediff = System.currentTimeMillis() - this.lastPollingTime;
            if (timediff < currentPollingInterval) {
                Thread.sleep(currentPollingInterval - timediff);
            }
        }
        this.lastPollingTime = System.currentTimeMillis();
    }

    protected void doRepeatableServiceLogic() {
        try {
            RowSet rowSet;
            RowSet key;
            this.establishConnection();
            if (this.connection.isClosed()) {
                return;
            }
            this.sleepPollingInterval();
            this.inActivePolling = false;
            if (this.transacted) {
                this.connection.commit();
            }
            try {
                key = this.sourceStrategy.getNextKey();
            }
            catch (DatabaseSQLException error) {
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
                throw new DatabaseSQLException("[Key Retrieval Query] " + error.getErrorMessage(), error);
            }
            Trace.logDebug((Object)((Object)this), (String)"Executing RowSet Retrieval Query...");
            try {
                rowSet = this.sourceStrategy.getNextRowSet(key);
            }
            catch (DatabaseSQLException error) {
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
                throw new DatabaseSQLException("[RowSet Retrieval Query] " + error.getErrorMessage(), error);
            }
            Trace.logDebug((Object)((Object)this), (String)"RowSet Retrieval Query executed.");
            if (rowSet == null || rowSet.getRowCount() <= 0) {
                Trace.logDebug((Object)((Object)this), (String)"An empty RowSet has been returned after RowSet Retrieval Query execution.");
                if (this.transacted) {
                    this.connection.rollback();
                }
                return;
            }
            this.inActivePolling = true;
            this.ctx.logInfo("RowSet data retrieved, rows count: " + rowSet.getRowCount());
            DataEvent event = (DataEvent)this.datagramFactory.createEvent(this.eventId);
            event.setData((Object)rowSet);
            this.raiseEvent(event);
            try {
                this.sourceStrategy.acknowledge(rowSet);
            }
            catch (DatabaseSQLException error) {
                Trace.logError((Object)((Object)this), (String)"RowSet Acknowledge Query failed. Suspending the service. Before resuming the service make sure that last processed message is akcnowledged and will not be read from the source database again.");
                this.ctx.suspend();
                throw new DatabaseSQLException("[RowSet Acknowledge Query] " + error.getErrorMessage() + " Service has been suspended. Before resuming the service make sure that last processed message is akcnowledged and will not be read from the source database again.", error);
            }
            if (this.transacted) {
                this.connection.commit();
            }
        }
        catch (InterruptedException error) {
            this.activated = false;
        }
        catch (DatabaseSQLException error) {
            this.connection.forceStateCheck();
            if (this.transacted) {
                this.doRollback();
            }
            this.pingConnection();
            error.setConnectionName(this.connection.getName());
            error.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            error.setSeverity(Severity.SEVERE);
            this.printSQLException(error, false, true);
            this.raiseException((ExceptionEventDatagram)error);
        }
        catch (Error | Exception error) {
            if (this.transacted) {
                this.doRollback();
            }
            this.pingConnection();
            DatabaseSQLException internalException = new DatabaseSQLException(1024, error.getMessage());
            internalException.setConnectionName(this.connection.getName());
            internalException.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            internalException.setSeverity(Severity.SEVERE);
            this.raiseException((ExceptionEventDatagram)internalException);
        }
    }

    private void pingConnection() {
        if (this.connectionObserver != null) {
            this.connectionObserver.execute();
        }
    }

    private void establishConnection() {
        if (this.dirtySession || this.connection.getState() != ConnectionState.CONNECTED) {
            this.ctx.logInfo("Waiting for database connection establishment...");
        }
        while (this.connection.getState() != ConnectionState.CONNECTED && this.activated) {
            this.dirtySession = true;
            if (this.connectionObserver != null) {
                this.connectionObserver.execute();
                if (this.connectionObserver.isReconnectRetriesExceeded()) {
                    this.ctx.logInfo("Reconnect retries for connection '" + this.connectionObserver.getName() + "' exceeded.");
                    break;
                }
                if (this.connectionObserver.isConnected()) break;
            }
            try {
                Thread.sleep(this.calculateReconnectInterval());
            }
            catch (InterruptedException ex) {
                this.activated = false;
                break;
            }
        }
        if (this.dirtySession && this.connection.getState() == ConnectionState.CONNECTED) {
            try {
                this.sourceStrategy.execStartUpScript();
                if (this.transacted) {
                    this.connection.setAutoCommit(false);
                }
                this.dirtySession = false;
            }
            catch (SQLException error) {
                DatabaseSQLException ex = new DatabaseSQLException(error);
                ex.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
                ex.setConnectionName(this.connection.getName());
                ex.setSeverity(Severity.SEVERE);
                this.raiseException((ExceptionEventDatagram)ex);
            }
            catch (DatabaseSQLException error) {
                error.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
                error.setConnectionName(this.connection.getName());
                error.setSeverity(Severity.SEVERE);
                this.raiseException((ExceptionEventDatagram)error);
            }
            catch (ServiceConfigurationException error) {
                this.reportAndRethrowError(error);
            }
            this.ctx.logInfo("Database connection established.");
        } else if (this.connection.getState() != ConnectionState.CONNECTED) {
            this.ctx.logInfo("Database connection still not establishment.");
        }
    }

    private long calculateReconnectInterval() {
        long waitTime = this.jdbcFactory.getReconnectInterval();
        if (waitTime <= 0L) {
            waitTime = this.jdbcFactory.getConnectionCheckInterval();
        }
        if (waitTime <= 0L) {
            waitTime = this.passivePollingInterval;
        }
        if (waitTime <= 0L) {
            waitTime = this.pollingInterval;
        }
        if (waitTime > this.passivePollingInterval) {
            waitTime = this.passivePollingInterval;
        }
        return waitTime;
    }

    private void doRollback() {
        try {
            Trace.logDebug((Object)((Object)this), (String)"Transaction ROLLBACK.");
            this.connection.rollback();
        }
        catch (Exception error) {
            this.ctx.logError("Unable to ROLLBACK transaction. " + error.getMessage());
        }
    }

    protected long getPassiveIterationInterval() {
        return this.passivePollingInterval;
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"DBEventSource", (boolean)false);
        sco.setServiceClassName(DatabaseEventSource.class.getName());
        sco.setServiceDescription("Polls configured DBMS server and publishes retrieved data on specified EventId.");
        sco.setServiceDisplayName("Database Event Source");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ReferenceContext ref = new ReferenceContext(new ReferenceContext(null, null), "/sql");
        ServiceConfigurationProperty prop = sco.createProperty("next.key.sql", ServicePropertyType.OBJECT, null);
        prop.setLabel("Next Key SQL Query");
        prop.setDescription("Specifies sql query object for next key retrieval.");
        prop.setValue((Object)new ObjectPropertyValue("nextKeySql", "SQLQuery", ref));
        sco.addProperty(prop);
        prop = sco.createProperty("next.rowset.sql", ServicePropertyType.OBJECT, null);
        prop.setLabel("Next RowSet SQL Query");
        prop.setDescription("Specifies sql query object for next rowset retrieval.");
        prop.setValue((Object)new ObjectPropertyValue("nextRowSetSql", "SQLQuery", ref));
        sco.addProperty(prop);
        prop = sco.createProperty("acknowledge.sql", ServicePropertyType.OBJECT, null);
        prop.setLabel("Acknowledge SQL Query");
        prop.setDescription("Specifies sql query object for retrived rowset acknowledgement.");
        prop.setValue((Object)new ObjectPropertyValue("ackSql", "SQLQuery", ref));
        sco.addProperty(prop);
        prop = sco.createProperty("polling.interval", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Active polling Interval");
        prop.setDescription("Specifies database active polling interval.");
        prop.setValue((Object)1000);
        sco.addProperty(prop);
        prop = sco.createProperty("passive.polling.interval", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Passive polling Interval");
        prop.setDescription("Specifies database passive polling interval.");
        prop.setValue((Object)10000);
        sco.addProperty(prop);
        prop = sco.createProperty("transacted.mode", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Transacted SQL Mode");
        prop.setDescription("Specifies whether service handles transactions or it is JDBC connection responsibility.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("init.session.sql", ServicePropertyType.OBJECT, null);
        prop.setLabel("Init Session SQL");
        prop.setDescription("Specifies SQL query batch which should be executed upon DB connection establishment to set up session.");
        prop.setValue((Object)new ObjectPropertyValue("initSql"));
        sco.addProperty(prop);
        prop = sco.createProperty("shutdown.sql", ServicePropertyType.OBJECT, null);
        prop.setLabel("Shutdown SQL");
        prop.setDescription("Specifies SQL query batch which should be executed before DB connection close.");
        prop.setValue((Object)new ObjectPropertyValue("shutdownSql"));
        sco.addProperty(prop);
        prop = sco.createProperty("jdbc.factory", ServicePropertyType.JDBC_FACTORY, null);
        prop.setLabel("JDBC Connection Factory");
        prop.setDescription("Specifies JDBC connection factory for DB connection establishment.");
        prop.setValue((Object)new JDBCFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty("event.id", ServicePropertyType.STRING, null);
        prop.setLabel("Publish Event Id");
        prop.setDescription("Specifies EventId of event which is used to publish retrived rowsets.");
        prop.setValue("event.rowset");
        sco.addProperty(prop);
        prop = sco.createProperty("exception.on.empty", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Exception On Empty RowSet");
        prop.setDescription("Specifies whether exception should be raised in case of empty rowset retrieval.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("source.strategy.class", ServicePropertyType.STRING, null);
        prop.setLabel("Source Strategy Classname");
        prop.setDescription("Specifies class name of the source strategy implementation.");
        prop.setValue(SQLEventSource.class.getName());
        sco.addProperty(prop);
        sco.addActionableEvent("event.rowset");
        sco.addException("exception.dbms.SQLStatement");
        return sco;
    }
}

