/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.dbms.evSink;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationException;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryException;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryBatch;
import com.streamscape.sdo.sql.SQLQueryFactory;
import com.streamscape.sdo.sql.SQLQueryInfo;
import com.streamscape.sdo.sql.SQLQueryInfoFactory;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.dbms.evSink.MultiRowSetStrategy;
import com.streamscape.service.dbms.evSink.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.ExceptionEventListener;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.jdbc.StateNotificationEventListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class DatabaseEventSink
extends AbstractService
implements StateNotificationEventListener,
ExceptionEventListener {
    private static final int NUMBER_OF_TRYINGS_TO_CONNECT = 3;
    private boolean running = false;
    private boolean dirtySession = true;
    private DatabaseConnection connection = null;
    private boolean isBlockingMode = false;
    private boolean isDynamicSQL = false;
    private boolean transacted = false;
    private JDBCFactory jdbcFactory = null;
    private SQLQueryBatch initSQL = null;
    private SQLQuery staticQuery = null;
    protected String sqlInfoEventId = null;
    protected XSerializer serializer = null;
    protected EventDatagramFactory datagramFactory = null;
    protected MultiRowSetStrategy multiRowSetStrategy = null;

    public DataEvent processEvent(DataEvent request) throws DatabaseSQLException {
        this.ctx.logInfo("New dynamic SQL query data event for execution...");
        try {
            return SDOUtils.createDataEvent((String)"DataEvent", (Object)this.execute(request.getData()));
        }
        catch (SDOException | SecurityViolationException | DatagramFactoryException exception) {
            DatabaseSQLException ex = this.createDatabaseSQLException((Exception)exception);
            this.printSQLException(ex, false, true);
            throw ex;
        }
    }

    public RowSet executeStaticQuery(ImmutableEventDatagram event) throws DatabaseSQLException {
        this.ctx.logInfo("New dynamic static query data event for execution...");
        if (this.staticQuery == null) {
            throw new IllegalStateException("Static query is null. Incoming request can not be processed.");
        }
        return this.execute(this.staticQuery);
    }

    public RowSet processQueryStatement(SQLQuery query) throws DatabaseSQLException {
        this.ctx.logInfo("New dynamic SQL query for execution...");
        return this.execute(query);
    }

    public RowSet processQueryBatch(SQLQueryBatch batch) throws DatabaseSQLException {
        this.ctx.logInfo("New dynamic SQL query batch for execution...");
        return this.execute(batch);
    }

    private RowSet execute(Object query) throws DatabaseSQLException {
        if (!this.running) {
            throw new IllegalStateException("Service is not started and can not process any data.");
        }
        try {
            query = this.resolveQuery(query);
            this.establishConnection();
            if (this.connection.getState() != ConnectionState.CONNECTED) {
                throw new DatabaseSQLException(1000, "Database connection to target database is not established. Can not process the request.");
            }
            if (this.dirtySession) {
                throw new DatabaseSQLException(1000, "Database connection is dirty. Can not process the request.");
            }
        }
        catch (DatabaseSQLException | SQLQueryException | SQLQueryParseException | SQLQueryValidationException | SQLException exception) {
            DatabaseSQLException ex = this.createDatabaseSQLException((Exception)exception);
            this.printSQLException(ex, false, true);
            throw ex;
        }
        this.raiseSQLQueryInfoEvent(query);
        try {
            if (this.transacted) {
                this.connection.commit();
            }
            RowSet result = null;
            if (query instanceof SQLQuery) {
                this.ctx.logDebug("Executing incoming SQL query (timeout " + this.jdbcFactory.getQueryTimeout() + " seconds).");
                List rowSets = SQLQueryFactory.execute((SQLQuery)((SQLQuery)query), (int)this.jdbcFactory.getQueryTimeout(), (Connection)this.connection);
                if (rowSets.size() > 1) {
                    this.ctx.logInfo("WARNING: Multiple row sets (" + rowSets.size() + ") detected, use strategy " + String.valueOf((Object)this.multiRowSetStrategy));
                    switch (this.multiRowSetStrategy) {
                        case USE_LAST: {
                            result = (RowSet)rowSets.get(rowSets.size() - 1);
                            break;
                        }
                        default: {
                            result = (RowSet)rowSets.get(0);
                            break;
                        }
                    }
                } else if (rowSets.size() == 1) {
                    result = (RowSet)rowSets.get(0);
                }
                if (Trace.isDebugEnabled((String)((Object)((Object)this)).getClass().getName())) {
                    try {
                        int i = 0;
                        for (RowSet rowSet : rowSets) {
                            Trace.logDebug((Object)((Object)this), (String)("Query execution result (" + ++i + "): \n" + this.serializer.serialize((Object)rowSet)));
                        }
                    }
                    catch (SerializerException exception) {
                        Trace.logError((Object)((Object)this), (String)("Serialization failed. Cause: " + exception.getMessage()));
                    }
                }
            } else if (query instanceof SQLQueryBatch) {
                int numberOfQueries = SQLQueryFactory.execute((SQLQueryBatch)((SQLQueryBatch)query), (int)this.jdbcFactory.getQueryTimeout(), (Connection)this.connection);
                result = new RowSet();
                result.getRowMetaData().setHasReturnCode(true);
                result.setReturnCodeValue((Object)new Integer(numberOfQueries));
            }
            if (this.transacted) {
                Trace.logDebug((Object)((Object)this), (String)"Commiting changes...");
                try {
                    this.connection.commit();
                }
                catch (SQLException exception) {
                    Trace.logError((Object)((Object)this), (String)"Failed to commit transaction.");
                    throw exception;
                }
            }
            this.ctx.logInfo("Incoming sql has been executed successfully.");
            return result;
        }
        catch (DatabaseSQLException | SQLQueryException | SQLQueryParseException | SQLQueryValidationException | SQLException exception) {
            DatabaseSQLException ex = this.createDatabaseSQLException((Exception)exception);
            this.rollback();
            this.printSQLException(ex, false, false);
            throw ex;
        }
    }

    private void establishConnection() throws DatabaseSQLException, SQLException, SQLQueryParseException, SQLQueryValidationException, SQLQueryException {
        if (this.dirtySession || this.connection.getState() != ConnectionState.CONNECTED) {
            this.ctx.logInfo("Waiting for database connection establishment...");
        }
        if (this.connection.getState() != ConnectionState.CONNECTED) {
            this.connection.forceStateCheck();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
        int counter = 0;
        while (this.isBlockingMode && this.connection.getState() != ConnectionState.CONNECTED && this.running) {
            this.dirtySession = true;
            if (++counter > 3) break;
            try {
                Thread.sleep(this.jdbcFactory.getReconnectInterval());
            }
            catch (InterruptedException error) {
                this.running = false;
                break;
            }
        }
        if (this.dirtySession && this.connection.getState() == ConnectionState.CONNECTED) {
            try {
                if (this.initSQL != null) {
                    Statement stat = this.connection.createStatement();
                    SQLQueryFactory.execute((SQLQueryBatch)this.initSQL, (int)this.jdbcFactory.getQueryTimeout(), (Connection)this.connection);
                    stat.close();
                    Trace.logDebug((Object)((Object)this), (String)SQLQueryFactory.renderBatch((SQLQueryBatch)this.initSQL));
                    this.ctx.logInfo("Init SQL has been executed successfully.");
                } else {
                    this.ctx.logInfo("Init SQL is not set. Skipping...");
                }
                if (this.transacted) {
                    this.connection.setAutoCommit(false);
                } else {
                    this.connection.setAutoCommit(true);
                }
                this.dirtySession = false;
            }
            catch (DatabaseSQLException | SQLQueryException | SQLQueryParseException | SQLQueryValidationException | SQLException exception) {
                Trace.logError((Object)((Object)this), (String)"Initialization of connection failed.");
                throw exception;
            }
            this.ctx.logInfo("Database connection established.");
        } else if (this.connection.getState() != ConnectionState.CONNECTED) {
            this.ctx.logInfo("Database connection still not established.");
        }
    }

    private DatabaseSQLException createDatabaseSQLException(Exception exception) {
        DatabaseSQLException result = exception instanceof DatabaseSQLException ? (DatabaseSQLException)((Object)exception) : (exception instanceof SQLException ? new DatabaseSQLException((SQLException)exception) : new DatabaseSQLException(1023, exception.getMessage()));
        result.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
        result.setConnectionName(this.connection.getName());
        result.setSeverity(Severity.SEVERE);
        return result;
    }

    private void rollback() {
        this.connection.forceStateCheck();
        if (this.transacted) {
            try {
                Trace.logInfo((Object)((Object)this), (String)"Rolling back changes...");
                this.connection.rollback();
            }
            catch (SQLException ex) {
                this.ctx.logError("Unable to ROLLBACK transaction. " + ex.getMessage());
            }
        }
    }

    private void printSQLException(DatabaseSQLException event, boolean linked, boolean critical) {
        Throwable next;
        if (critical) {
            this.ctx.logError("SQLException" + (linked ? "(next): " : ": ") + "Connection: " + event.getConnectionName() + "\nSeverity: " + String.valueOf(event.getSeverity()) + "\nError Code: " + event.getErrorCodeAsString() + "\nSQL State: " + event.getSQLState() + "\nMessage: " + event.getMessage());
        } else {
            this.ctx.logDebug("SQLException" + (linked ? "(next): " : ": ") + "Connection: " + event.getConnectionName() + "\nSeverity: " + String.valueOf(event.getSeverity()) + "\nError Code: " + event.getErrorCodeAsString() + "\nSQL State: " + event.getSQLState() + "\nMessage: " + event.getMessage());
        }
        while ((next = event.getCause()) != null) {
            if (!(next instanceof DatabaseSQLException)) continue;
            this.printSQLException((DatabaseSQLException)next, true, critical);
        }
    }

    private Object resolveQuery(Object query) throws SQLQueryParseException, SQLQueryValidationException {
        if (query instanceof SQLQueryBatch) {
            SQLQueryBatch batch = (SQLQueryBatch)query;
            SQLQueryBatch newBatch = new SQLQueryBatch();
            Iterator iter = batch.getObjectIterator();
            while (iter.hasNext()) {
                newBatch.addQuery(this.resolveQuery((SQLQuery)iter.next()));
            }
            return newBatch;
        }
        return this.resolveQuery((SQLQuery)query);
    }

    private SQLQuery resolveQuery(SQLQuery query) throws SQLQueryParseException, SQLQueryValidationException {
        MacroProcessor processor = this.ctx.getMacroProcessor();
        SQLQuery newQuery = new SQLQuery(processor.process(query.getSqlScript()), query.getQueryType());
        Iterator paramsIter = query.getParameterIterator();
        while (paramsIter.hasNext()) {
            SQLQueryParameter param = (SQLQueryParameter)paramsIter.next();
            if (param.getMode() == SQLQueryParameterMode.OUT.getMode()) {
                newQuery.getParameters().add(param);
                continue;
            }
            newQuery.getParameters().add(new SQLQueryParameter(param.getName(), param.getType(), param.getTypeName(), param.isNullable(), processor.process(param.getDefaultValue()), processor.process(param.getValue()), param.getLength(), param.getPrecision(), param.getScale(), param.isSearchable(), param.isReturnCode(), param.getOrdinal(), param.getMode()));
        }
        return newQuery;
    }

    private void raiseSQLQueryInfoEvent(Object sql) {
        try {
            this.ctx.logDebug("Filling in SQL query info object(s).");
            if (sql instanceof SQLQuery) {
                SQLQueryInfo info = SQLQueryInfoFactory.extractInfo((SQLQuery)((SQLQuery)sql), (String)this.ctx.getType(), (String)this.ctx.getName(), (String)this.jdbcFactory.getCatalog(), (String)this.jdbcFactory.getUrl());
                DataEvent event = (DataEvent)this.datagramFactory.createEvent(this.sqlInfoEventId);
                event.setData((Object)info);
                this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
            } else if (sql instanceof SQLQueryBatch) {
                List infos = SQLQueryInfoFactory.extractInfo((SQLQueryBatch)((SQLQueryBatch)sql), (String)this.ctx.getType(), (String)this.ctx.getName(), (String)this.jdbcFactory.getCatalog(), (String)this.jdbcFactory.getUrl());
                for (SQLQueryInfo info : infos) {
                    DataEvent event = (DataEvent)this.datagramFactory.createEvent(this.sqlInfoEventId);
                    event.setData((Object)info);
                    this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
                }
            } else {
                this.ctx.logError("Invalid sql query object.");
            }
            this.ctx.logDebug("SQL query info object(s) has been filled.");
        }
        catch (SecurityViolationException | DatagramFactoryException | FabricEventSourceException error) {
            Trace.logError((Object)((Object)this), (String)"Failed to fill sql qiery info.");
            this.ctx.logError(error.getMessage());
        }
        catch (Exception error) {
            Trace.logError((Object)((Object)this), (String)"Failed to fill sql qiery info.");
            error.printStackTrace();
        }
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Database connection state changed: " + e.getState().toString());
        if (e.getState() != ConnectionState.CONNECTED) {
            this.dirtySession = true;
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Database connection state changed to " + e.getState().toString());
        } else {
            this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
        }
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch exception: " + ex.getMessage());
        }
    }

    public void onEvent(DatabaseSQLException exception) {
        this.printSQLException(exception, false, false);
        if (this.connection.getState() == ConnectionState.CONNECTING) {
            try {
                this.ctx.raiseException((ExceptionEventDatagram)exception);
            }
            catch (Exception e) {
                Trace.logError((Object)((Object)this), (String)("Failed to raise exception. Cause: " + e.getMessage()));
            }
        }
    }

    public void doInit() {
        try {
            this.datagramFactory = this.context.getEventDatagramFactory();
        }
        catch (RuntimeException error) {
            this.ctx.logError("Service instantiation error: " + error.getMessage());
        }
        try {
            this.jdbcFactory = this.ctx.lookupJdbcFactoryProperty("jdbc.factory");
            this.isBlockingMode = this.ctx.lookupBooleanProperty("blocking.mode");
            this.ctx.logInfo("'BlockingMode' parameter of DB Event Sink is set to " + this.isBlockingMode);
            this.isDynamicSQL = this.ctx.lookupBooleanProperty("dynamic.sql.mode");
            if (!this.isDynamicSQL) {
                try {
                    ObjectPropertyValue staticQueryObject = this.ctx.lookupObjectProperty("static.sql.query");
                    SemanticObjectReferenceStore.beginXact((FabricComponent)this.context);
                    this.staticQuery = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)staticQueryObject);
                    SemanticObjectReferenceStore.commitXact();
                }
                catch (ServiceConfigurationException error) {
                    throw new IllegalStateException("Database event sink is in non-dynamic mode. Static SQL query should be specified.");
                }
            }
            this.ctx.logInfo("'Dynamic SQL mode' parameter of DB Event Sink is set to " + this.isDynamicSQL);
            this.transacted = this.ctx.lookupBooleanProperty("transacted.mode");
            this.ctx.logInfo("'Transacted mode' parameter of DB Event Sink is set to " + this.transacted);
            this.sqlInfoEventId = this.ctx.lookupStringProperty("sql.info.event.id");
            this.ctx.logInfo("'SQL info EventId' parameter of DB Event Sink is set to " + this.sqlInfoEventId);
            String mulipleRowSetStrategy = this.sco.getServiceConfigurationProperties().getProperty("multi.row.set.strategy").toString();
            if (mulipleRowSetStrategy == null || mulipleRowSetStrategy.length() <= 0) {
                this.ctx.logError("'MultiRowSetStrategy' parameter is not specified.");
                throw new RuntimeException("'MultiRowSetStrategy' parameter is not specified.");
            }
            this.multiRowSetStrategy = MultiRowSetStrategy.valueOf(mulipleRowSetStrategy);
            this.ctx.logInfo("'MultiRowSetStrategy' parameter of DB Event Sink is set to " + this.multiRowSetStrategy.name());
            this.connection = this.jdbcFactory.createConnection();
            this.connection.setStateNotificationEventListener((StateNotificationEventListener)this);
            this.connection.setExceptionEventListener((ExceptionEventListener)this);
            if (this.ctx.getLogger() != null) {
                this.connection.setServiceLogger(this.ctx.getLogger());
            }
            try {
                ObjectPropertyValue initSQLObject = (ObjectPropertyValue)this.sco.getServiceConfigurationProperties().getProperty("init.session.sql").getValue();
                SemanticObjectReferenceStore.beginXact((FabricComponent)this.context);
                this.initSQL = (SQLQueryBatch)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)initSQLObject);
                SemanticObjectReferenceStore.commitXact();
                this.ctx.logInfo("Init SQL successfully retrieved from the repository.");
            }
            catch (Exception error) {
                this.ctx.logInfo("Init SQL is not set for the service.");
                Trace.logError((Object)((Object)this), (String)("Unable to get 'init SQL' script. " + error.getMessage()));
            }
            this.serializer = RuntimeContext.getInstance().getXSerializerFactory().createSerializer("ProcessQueueStateAdvisory2MailPluginSerializer");
        }
        catch (JDBCConfigurationException | ObjectConfigurationException | ServiceConfigurationException error) {
            this.ctx.logError(error.getMessage());
            throw new RuntimeException(error);
        }
    }

    public void resume() throws ServiceFrameworkException {
        super.resume();
        this.running = true;
    }

    public void start() throws ServiceFrameworkException {
        super.start();
        this.running = true;
        try {
            if (this.connection != null) {
                this.connection.connect();
            }
        }
        catch (DatabaseSQLException error) {
            this.ctx.logError("Database connection opening error: " + error.getErrorMessage());
            try {
                this.ctx.raiseException((ExceptionEventDatagram)this.createDatabaseSQLException((Exception)((Object)error)));
            }
            catch (Exception ex) {
                System.out.println("Event dispatch exception: " + ex.getMessage() + " for SQL Error: " + error.getMessage());
            }
        }
    }

    public void stop() throws ServiceFrameworkException {
        this.running = false;
        try {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (DatabaseSQLException error) {
            this.printSQLException(error, false, true);
        }
        super.stop();
    }

    public void destroy() throws ServiceFrameworkException {
        this.running = false;
        super.destroy();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"DBEventSink", (boolean)false);
        sco.setServiceClassName(DatabaseEventSink.class.getName());
        sco.setServiceDescription("Executes dynamic and/or static SQL against the configured DBMS server.");
        sco.setServiceDisplayName("Database Event Sink");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ReferenceContext ref = new ReferenceContext(new ReferenceContext(null, null), "/sql");
        SemanticType rowSetSemanticType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("RowSet");
        SemanticType sqlQueryType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("SQLQuery");
        SemanticType sqlQueryBatchType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("SQLQueryBatch");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "executeStaticQuery", "StaticQueryExecutor");
        handler.bindRequestObject("event.rowset", rowSetSemanticType);
        handler.bindResponseObject("event.static.query.result", rowSetSemanticType);
        sco.addEventHandler(handler);
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "processQueryStatement", "QueryExecutor");
        handler.bindRequestObject("event.sql.query", sqlQueryType);
        handler.bindResponseObject("event.sql.query.result", rowSetSemanticType);
        sco.addEventHandler(handler);
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "processQueryBatch", "QueryBatchExecutor");
        handler.bindRequestObject("event.sql.query.batch", sqlQueryBatchType);
        handler.bindResponseObject("event.sql.query.batch.result", rowSetSemanticType);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("blocking.mode", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Blocking Mode");
        prop.setDescription("Specifies whether incoming query should be enqueued till connection to DB server is established or immediately fail.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("dynamic.sql.mode", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Dynamic SQL Mode");
        prop.setDescription("Specifies whether service is in dynamic mode or uses static query.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("transacted.mode", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Transacted SQL Mode");
        prop.setDescription("Specifies whether service handles transactions or it is JDBC connection responsibility.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("init.session.sql", ServicePropertyType.OBJECT, null);
        prop.setLabel("Init Session SQL");
        prop.setDescription("Specifies SQL query batch which should be executed upon DB connection establishment to set up session.");
        prop.setValue((Object)new ObjectPropertyValue("initSql", "SQLQueryBatch", ref));
        sco.addProperty(prop);
        prop = sco.createProperty("shutdown.sql", ServicePropertyType.OBJECT, null);
        prop.setLabel("Shutdown SQL");
        prop.setDescription("Specifies SQL query batch which should be executed before DB connection close.");
        prop.setValue((Object)new ObjectPropertyValue("shutdownSql", "SQLQueryBatch", ref));
        sco.addProperty(prop);
        prop = sco.createProperty("jdbc.factory", ServicePropertyType.JDBC_FACTORY, null);
        prop.setLabel("JDBC Connection Factory");
        prop.setDescription("Specifies JDBC connection factory for DB connection establishment.");
        prop.setValue((Object)new JDBCFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty("multi.row.set.strategy", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Multi RowSet Result Strategy");
        prop.setDescription("Specifies strategy for multi rowset result.");
        prop.setRange(String.valueOf((Object)MultiRowSetStrategy.USE_FIRST) + "," + String.valueOf((Object)MultiRowSetStrategy.USE_LAST) + "," + String.valueOf((Object)MultiRowSetStrategy.USE_ALL));
        prop.setValue(MultiRowSetStrategy.USE_FIRST.name());
        sco.addProperty(prop);
        prop = sco.createProperty("sql.info.event.id", ServicePropertyType.STRING, null);
        prop.setLabel("SQL Info EventId");
        prop.setDescription("Specifies event id for publishing SQL info information (SQL executed by service).");
        prop.setValue("event.sql.info");
        sco.addProperty(prop);
        prop = sco.createProperty("static.sql.query", ServicePropertyType.OBJECT, null);
        prop.setLabel("Static SQL Query");
        prop.setDescription("Specifies SQL query object for static mode.");
        prop.setValue((Object)new ObjectPropertyValue("staticSql", "SQLQuery", ref));
        sco.addProperty(prop);
        sco.addActionableEvent("event.sql.info");
        sco.addException("exception.dbms.SQLStatement");
        return sco;
    }
}

