/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter.plugins;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XConstants;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.converter.ConverterPluginException;
import com.streamscape.service.converter.IAbstractConverterPlugin;
import com.streamscape.service.converter.enums.XmlNullHandlingStrategy;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.swing.JDialog;

public class XmlToSQLQuery
extends IAbstractConverterPlugin<XMLEvent, SQLQuery> {
    private XSerializer serializer = null;
    public static final String SQL_QUERY = "sql.query";
    public static final String NULL_HANDLING_STRATEGY = "null.handling.strategy";
    public static final String CUSTOM_CLASSES_LIST = "custom.classes.list";
    private SQLQuery query = null;
    private XmlNullHandlingStrategy nullHandlingStrategy = null;

    @Override
    public SQLQuery invoke(XMLEvent xmlEvent) throws ConverterPluginException {
        try {
            Trace.logDebug((Object)this, (String)"Invocation...");
            if (xmlEvent == null || xmlEvent.getXML() == null) {
                throw new ConverterPluginException("Incoming XML event is NULL.");
            }
            Object obj = this.serializer.deserialize("StructuredDataObject", xmlEvent.getXML());
            if (obj != null) {
                SQLQuery result = this.mapPojo(obj);
                Trace.logDebug((Object)this, (String)"Invoked.");
                return result;
            }
            throw new ConverterPluginException("Unable to convert incoming XML to Object.");
        }
        catch (XSerializerException error) {
            throw new ConverterPluginException("Unable to deserialize incoming XML. " + error.getErrorMessage());
        }
        catch (ConverterPluginException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConverterPluginException(error);
        }
    }

    private SQLQuery mapPojo(Object pojo) throws ConverterPluginException {
        try {
            Field[] fields;
            Trace.logDebug((Object)this, (String)("Class of the POJO for mapping into SQL query: " + pojo.getClass().getName()));
            SQLQuery result = (SQLQuery)this.query.clone();
            for (Field field : fields = pojo.getClass().getDeclaredFields()) {
                String fieldName = field.getName();
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                Object value = field.get(pojo);
                SQLQueryParameter param = result.getParameters().get(fieldName);
                if (param == null) continue;
                if (value != null && this.nullHandlingStrategy == XmlNullHandlingStrategy.EMPTY_STRING && value.getClass().equals(String.class) && ((String)value).length() == 0) {
                    result.getParameters().set(fieldName, null);
                    continue;
                }
                result.getParameters().set(fieldName, value);
            }
            return result;
        }
        catch (Exception error) {
            throw new ConverterPluginException(error);
        }
    }

    @Override
    public void init() throws ConverterPluginException {
        ServiceConfigurationProperties props;
        block23: {
            RuntimeContext runtimeCtx = RuntimeContext.getInstance();
            ServiceConfigurationObject sco = super.getService().getServiceConfiguration();
            props = sco.getServiceConfigurationProperties();
            if (props.hasProperty(SQL_QUERY)) {
                try {
                    ObjectPropertyValue queryObject = (ObjectPropertyValue)props.getProperty(SQL_QUERY).getValue();
                    SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                    this.query = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)queryObject);
                    SemanticObjectReferenceStore.commitXact();
                    if (this.query == null) {
                        throw new ConverterPluginException("Unable to load specified SQL query.");
                    }
                    break block23;
                }
                catch (ServiceConfigurationException error) {
                    throw new ConverterPluginException(error);
                }
                catch (ObjectConfigurationException error) {
                    throw new ConverterPluginException(error);
                }
            }
            throw new ConverterPluginException("SQL query parameter should be set for the converter plugin.");
        }
        if (props.hasProperty(NULL_HANDLING_STRATEGY)) {
            try {
                String temp = props.getProperty(NULL_HANDLING_STRATEGY).toString();
                this.nullHandlingStrategy = XmlNullHandlingStrategy.valueOf(temp);
            }
            catch (IllegalArgumentException error) {
                throw new ConverterPluginException("Specified Null Handling Strategy parameter value is incorrect.");
            }
            catch (ServiceConfigurationException error) {
                throw new ConverterPluginException(error);
            }
        } else {
            throw new ConverterPluginException("Null Handling Strategy should be set for the converter plugin.");
        }
        String serializerName = this.getService().getType() + "." + this.getService().getName() + "$Serializer";
        this.serializer = RuntimeContext.getInstance().getXSerializerFactory().createSerializer(serializerName);
        if (this.serializer == null) {
            throw new ConverterPluginException("Unable to get system serializer.");
        }
        this.serializer.setClassLoader(this.getService().getPackageManifestManager().getManifestClassLoader());
        switch (this.nullHandlingStrategy) {
            case EXPLICIT_NULL: {
                this.serializer.setEnforceXSerializer(true);
                this.serializer.getDefaultsProvider().setClassDefault(String.class, XConstants.NULL);
                break;
            }
            case EXPLICIT_XSI_NIL: {
                this.serializer.setEnforceXSerializer(true);
                this.serializer.getDefaultsProvider().setClassDefault(String.class, XConstants.XSI_NIL);
            }
        }
        if (props.hasProperty(CUSTOM_CLASSES_LIST)) {
            try {
                ServiceConfigurationProperty customClassesProperty = props.getProperty(CUSTOM_CLASSES_LIST);
                if (this.checkPropertyIsList(customClassesProperty)) {
                    List customClasses = (List)customClassesProperty.getValue();
                    for (ServiceConfigurationProperty customClass : customClasses) {
                        String className = customClass.getName();
                        try {
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                            if (!this.checkPropertyIsList(customClass)) continue;
                            List fieldsAsAttributes = (List)customClass.getValue();
                            for (ServiceConfigurationProperty field : fieldsAsAttributes) {
                                Trace.logDebug((Object)this, (String)("Field '" + field.getName() + "' of the '" + clazz.getName() + "' class are treated as XML tag attribute during deserialization."));
                                this.serializer.useAttributeFor(clazz, field.getName());
                            }
                        }
                        catch (ClassNotFoundException error) {
                            this.getService().logError("Specified in the configuration class '" + className + "' not found.");
                        }
                    }
                }
            }
            catch (ServiceConfigurationException error) {
                throw new ConverterPluginException(error);
            }
        }
    }

    private boolean checkPropertyIsList(ServiceConfigurationProperty property) {
        Object propValue = property.getValue();
        if (List.class.isAssignableFrom(propValue.getClass())) {
            return true;
        }
        this.getService().logError("Property '" + property.getName() + "' has incompatible type. It should be of LIST type.");
        return false;
    }

    @Override
    public void launchWizard(JDialog parentDialog) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

