/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter.plugins;

import com.streamscape.omf.mapper.ConverterException;
import com.streamscape.omf.mapper.ConverterPlugin;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import java.util.StringTokenizer;

public class TransportErrorToEmailConverter
implements ConverterPlugin<TransportException, MailEvent> {
    public int getVersion() {
        return 1;
    }

    public String getDescription() {
        return "Converts TransportException datagrams into human readable e-mail with HTML content.";
    }

    public MailEvent convert(TransportException exception) throws ConverterException {
        try {
            MailEvent mailEvent = (MailEvent)EventDatagramFactory.getInstance().newEventInstance("MailEvent");
            mailEvent.setContentType("text/html");
            StringBuffer body = new StringBuffer();
            body.append("<html><body>");
            body.append("<center><h2 style=\"font-family: arial, sans-serif;\">Error Details</h2></center>");
            body.append("<center><table border=\"0\" style=\"background-color:#C0C0C0;color:black;font-size: 10pt;font-family: arial, sans-serif;\"><tbody>");
            StringTokenizer tokenizer = new StringTokenizer(exception.getConnectionName(), ".");
            if (tokenizer.countTokens() == 3) {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\" width=\"30%\"><p><nobr><b>Connection Name&nbsp;&nbsp;&nbsp;</b></nobr></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + tokenizer.nextToken() + "</p></td>");
                body.append("</tr>");
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><b>Connection Factory Type&nbsp;&nbsp;&nbsp;</b></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + tokenizer.nextToken() + "</p></td>");
                body.append("</tr>");
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><nobr><b>Connection Factory Name&nbsp;&nbsp;</b></nobr></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + tokenizer.nextToken() + "</p></td>");
                body.append("</tr>");
            } else {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"  width=\"30%\"><p><nobr><b>Connection Name&nbsp;&nbsp;&nbsp;</b></nobr></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + exception.getConnectionName() + "</p></td>");
                body.append("</tr>");
            }
            body.append("<tr>");
            body.append("<td style=\"background-color:#808080;color:white\"><p><b>Timestamp</b></p></td>");
            body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + String.valueOf(exception.getTimestamp()) + "</p></td>");
            body.append("</tr>");
            if (exception.getComponentName() != null) {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><b>Component Name</b></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + exception.getComponentName() + "</p></td>");
                body.append("</tr>");
            }
            if (exception.getCorrelationId() != null) {
                body.append("<tr>");
                body.append("<td style=\"background-color:#808080;color:white\"><p><b>Process Correlation ID</b></p></td>");
                body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + exception.getCorrelationId() + "</p></td>");
                body.append("</tr>");
            }
            body.append("<tr>");
            body.append("<td style=\"background-color:#808080;color:white\"><p><b>Severity</b></p></td>");
            body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + String.valueOf(exception.getSeverity()) + "</p></td>");
            body.append("</tr>");
            body.append("<tr>");
            body.append("<td style=\"background-color:#808080;color:white\"><p><b>Error Code</b></p></td>");
            body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + exception.getErrorCodeAsString() + "</p></td>");
            body.append("</tr>");
            body.append("<tr>");
            body.append("<td style=\"background-color:#808080;color:white\"><p><b>Error Message</b></p></td>");
            body.append("<td style=\"background-color:#C0C0C0;color:black\"><p>" + exception.getMessage() + "</p></td>");
            body.append("</tr>");
            body.append("</tbody></table></center>");
            body.append("</body></html>");
            mailEvent.setBody(body.toString());
            return mailEvent;
        }
        catch (DatagramFactoryException error) {
            throw new ConverterException(5036, error.getMessage());
        }
        catch (Exception error) {
            throw new ConverterException(3000, error.getMessage());
        }
    }
}

