/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter.plugins;

import com.streamscape.omf.mapper.ConverterException;
import com.streamscape.omf.mapper.ConverterPlugin;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class ProcessQueueAdvisoryToEmailConverter
implements ConverterPlugin<StateAdvisory, MailEvent> {
    public int getVersion() {
        return 1;
    }

    public String getDescription() {
        return "Converts process queue advisories into human readable e-mail with HTML content.";
    }

    public MailEvent convert(StateAdvisory notification) throws ConverterException {
        try {
            MailEvent mailEvent = (MailEvent)EventDatagramFactory.getInstance().newEventInstance("MailEvent");
            mailEvent.setContentType("text/html");
            StringBuffer body = new StringBuffer();
            body.append("<html><body>");
            String attachmentName = "rs_error.gif";
            String resourceFileName = "/com/streamscape/service/converter/plugins/rs_error.gif";
            InputStream fis = ProcessQueueAdvisoryToEmailConverter.class.getResourceAsStream("/com/streamscape/service/converter/plugins/rs_error.gif");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] BUFFER = new byte[4096];
            int count = 0;
            while ((count = fis.read(BUFFER)) > 0) {
                output.write(BUFFER, 0, count);
            }
            MailEvent.MailAttachment attachment = new MailEvent.MailAttachment(attachmentName, output.toByteArray(), null, "<img1>");
            mailEvent.addAttachment(attachment);
            body.append("<center><table style=\"background-color:white;color:black;font-size: 10pt;font-family: arial, sans-serif;\"><tbody>");
            body.append("<tr>");
            body.append("<td width=\"100\"><img src=\"cid:img1\" height=\"100\" width=\"100\"></img></td>");
            String action = "";
            if (notification.getEventId().equals("qspace.ProcessQueue.Suspended")) {
                action = "Suspended";
            }
            Object processName = "Process " + action;
            if (notification.getProperty("collection") != null) {
                processName = notification.getProperty("collection");
                processName = ((String)processName).endsWith(".Process") ? "Process " + action + " : <b>" + ((String)processName).substring(0, ((String)processName).indexOf(".Process")) + "</b>" : "Process Queue " + action + " : <b>" + (String)processName + "</b>";
            }
            if (notification.getEventId().equals("qspace.ProcessQueue.Suspended")) {
                body.append("<td width=\"500\"><p>" + (String)processName + "</b></p><p>The process has been suspended because there is undelivered message.</p></td>");
            }
            body.append("</tr>");
            body.append("</tbody></table></center>");
            body.append("</body></html>");
            mailEvent.setBody(body.toString());
            return mailEvent;
        }
        catch (DatagramFactoryException error) {
            throw new ConverterException(5036, error.getMessage());
        }
        catch (Exception error) {
            throw new ConverterException(3000, error.getMessage());
        }
    }
}

