/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter;

import com.streamscape.service.converter.FixedPositionalStringFDParser;
import com.streamscape.service.converter.RecordFieldNode;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FixedPositionalStringToXML {
    private Hashtable fieldList;
    private String TOPELEMENT = "POSITIONAL.RECORD";
    private int currentField = 0;
    private boolean hasPFD = false;
    private FixedPositionalStringFDParser fdParser;
    private int fieldCount = 0;
    private String XDoc;
    private boolean DEBUG = false;

    public FixedPositionalStringToXML(String topElement, boolean debug) {
        if (topElement != null) {
            this.TOPELEMENT = topElement;
        }
        if (!topElement.equals("")) {
            this.TOPELEMENT = topElement;
        }
        this.hasPFD = false;
        this.DEBUG = debug;
    }

    public FixedPositionalStringToXML(String pfdXML, String topElement, boolean debug) throws SAXException, ParserConfigurationException, IOException, FactoryConfigurationError {
        if (pfdXML == null) {
            throw new IOException("FixedPositionalToXML constructor error: Parser File Descriptor may not be null.");
        }
        if (topElement != null) {
            this.TOPELEMENT = topElement;
        }
        if (!topElement.equals("")) {
            this.TOPELEMENT = topElement;
        }
        this.hasPFD = true;
        this.DEBUG = debug;
        this.fdParser = new FixedPositionalStringFDParser(pfdXML, this.DEBUG);
        this.fieldList = new Hashtable(this.fdParser.invoke());
        if (!((String)this.fieldList.get("FILETYPE")).equalsIgnoreCase("FIXED_POSITIONAL")) {
            throw new IOException("*** FixedPositionalToXML descriptor type error: Parser File Descriptor not FIXED_POSITIONAL.");
        }
        if (this.DEBUG) {
            System.out.println("*** FixedPositionalStringToXML File Type: " + (String)this.fieldList.get("FILETYPE") + " Build (26)");
        }
        this.fieldList.remove("FILETYPE");
        this.fieldCount = this.fieldList.size();
    }

    public String parse(String record, boolean validateTypes, boolean setDefaults) throws IOException {
        String value = "";
        this.XDoc = null;
        this.currentField = 0;
        this.XDoc = new String("<?xml version=\"1.0\"?>\n");
        this.XDoc = this.XDoc + "<" + this.TOPELEMENT + ">\n";
        if (record.trim().equals("")) {
            this.XDoc = this.XDoc + "<DATA>null</DATA>\n</" + this.TOPELEMENT + ">";
            return this.XDoc;
        }
        if (this.hasPFD) {
            if (this.DEBUG) {
                System.out.println("*** FixedPositionalStringToXML uses PFD");
            }
            while (this.currentField != this.fieldCount) {
                ++this.currentField;
                if (this.DEBUG) {
                    System.out.println("*** FixedPositionalStringToXML getting element: " + this.currentField);
                }
                RecordFieldNode dataElement = (RecordFieldNode)this.fieldList.get(new Integer(this.currentField).toString());
                if (this.DEBUG) {
                    System.out.println("*** FixedPositionalStringToXML obtained element: " + dataElement.FIELD_NAME);
                }
                if (dataElement.END > record.length()) {
                    throw new IOException("Fixed Positinal Delimiter Exception: Substring index " + dataElement.END + " exceeds record length " + record.length());
                }
                if (this.DEBUG) {
                    System.out.println("*** FixedPositionalStringToXML extracting element..");
                }
                if ((value = record.substring(dataElement.START, dataElement.END)).trim().equals("") && setDefaults) {
                    if (this.DEBUG) {
                        System.out.println("*** FixedPositionalStringToXML setting default for element '" + dataElement.FIELD_NAME + "'");
                    }
                    value = dataElement.DEFAULT.trim();
                }
                if (validateTypes) {
                    if (this.DEBUG) {
                        System.out.println("*** FixedPositionalStringToXML validating Data Types.");
                    }
                    try {
                        if (dataElement.DATATYPE.equalsIgnoreCase("INTEGER")) {
                            Integer.parseInt(value.trim());
                        }
                        if (dataElement.DATATYPE.equalsIgnoreCase("FLOAT")) {
                            Float.parseFloat(value.trim());
                        }
                        if (dataElement.DATATYPE.equalsIgnoreCase("DOUBLE")) {
                            Double.parseDouble(value.trim());
                        }
                        if (dataElement.DATATYPE.equalsIgnoreCase("LONG")) {
                            Long.parseLong(value.trim());
                        }
                    }
                    catch (NumberFormatException ne) {
                        throw new IOException(dataElement.DATATYPE + " Conversion Exception on Field '" + dataElement.FIELD_NAME + "', " + ne.getMessage());
                    }
                }
                this.XDoc = this.XDoc + "<" + dataElement.FIELD_NAME + ">" + value.trim() + "</" + dataElement.FIELD_NAME + ">\n";
            }
        } else {
            this.XDoc = this.XDoc + "<DATA>" + record + "</DATA>\n";
        }
        this.XDoc = this.XDoc + "</" + this.TOPELEMENT + ">";
        return this.XDoc;
    }
}

