/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter;

import com.streamscape.service.converter.DelimitedStringFDParser;
import com.streamscape.service.converter.RecordFieldNode;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DelimitedStringToXML {
    private Hashtable fieldList;
    private StringTokenizer TOKENIZER;
    private String DELIMITER;
    private String TOPELEMENT = "DELIMITED.RECORD";
    private int currentField = 0;
    private boolean hasMFD = false;
    private DelimitedStringFDParser fdParser;
    private int fieldCount = 0;
    private String XDoc;
    private boolean DEBUG = false;

    public DelimitedStringToXML(String topElement, String delimiter, boolean debug) throws IOException {
        this.DELIMITER = delimiter;
        this.TOPELEMENT = topElement;
        this.DEBUG = debug;
        if (delimiter == null) {
            throw new IOException("DelimitedStringToXML constructor error: Delimiter may not be null.");
        }
        if (this.DEBUG) {
            System.out.println("\n*** DelimitedStringToXML (no Template) File Type: DELIMITED Build (14)");
        }
    }

    public DelimitedStringToXML(String mfdXML, String topElement, String delimiter, boolean debug) throws SAXException, ParserConfigurationException, FactoryConfigurationError, IOException {
        this.DELIMITER = delimiter;
        this.hasMFD = true;
        this.DEBUG = debug;
        if (mfdXML == null) {
            throw new IOException("DelimitedStringToXML constructor error: Descriptor Template may not be null.");
        }
        if (delimiter == null) {
            throw new IOException("DelimitedStringToXML constructor error: Delimiter may not be null.");
        }
        if (topElement != null) {
            this.TOPELEMENT = topElement;
        }
        if (!topElement.equals("")) {
            this.TOPELEMENT = topElement;
        }
        this.fdParser = new DelimitedStringFDParser(mfdXML, false);
        this.fieldList = new Hashtable(this.fdParser.invoke());
        if (!((String)this.fieldList.get("FILETYPE")).equalsIgnoreCase("DELIMITED")) {
            throw new IOException("DelimitedStringToXML descriptor type error: Parser File Descriptor not DELIMITED.");
        }
        if (this.DEBUG) {
            System.out.println("\n*** DelimitedStringToXML (with Template) File Type: " + (String)this.fieldList.get("FILETYPE") + " Build (14)");
        }
        this.fieldList.remove("FILETYPE");
        if (this.DEBUG) {
            System.out.println("\n** DelimitedStringToXML (with Template). Field Count: " + this.fieldCount);
        }
        this.fieldCount = this.fieldList.size();
    }

    public boolean validateElementCount(String record, int count) {
        this.TOKENIZER = new StringTokenizer(record, this.DELIMITER);
        return this.TOKENIZER.countTokens() == count;
    }

    public boolean validateElementsToTemplate(String record) {
        if (!this.hasMFD) {
            return true;
        }
        this.TOKENIZER = new StringTokenizer(record, this.DELIMITER);
        return this.TOKENIZER.countTokens() == this.fieldList.size();
    }

    public int getTemplateFieldCount() {
        if (this.hasMFD) {
            return this.fieldCount;
        }
        return -1;
    }

    public String parse(String record) {
        this.XDoc = null;
        this.currentField = 0;
        this.XDoc = new String("<?xml version=\"1.0\"?>\n");
        this.XDoc = this.XDoc + "<" + this.TOPELEMENT + ">\n";
        this.TOKENIZER = new StringTokenizer(record, this.DELIMITER);
        if (this.hasMFD) {
            if (this.TOKENIZER.countTokens() != this.fieldList.size()) {
                return null;
            }
            while (this.TOKENIZER.hasMoreElements()) {
                ++this.currentField;
                RecordFieldNode fNode = (RecordFieldNode)this.fieldList.get(new Integer(this.currentField));
                String dataElement = this.TOKENIZER.nextElement().toString();
                if (dataElement.trim().equals("")) {
                    dataElement = fNode.DEFAULT;
                }
                this.XDoc = this.XDoc + "<" + fNode.FIELD_NAME + ">" + dataElement + "</" + fNode.FIELD_NAME + ">\n";
            }
            this.XDoc = this.XDoc + "</" + this.TOPELEMENT + ">";
        } else {
            while (this.TOKENIZER.hasMoreElements()) {
                ++this.currentField;
                String dataElement = this.TOKENIZER.nextElement().toString();
                if (dataElement.trim().equals("")) {
                    dataElement = "NULL";
                }
                this.XDoc = this.XDoc + "<FIELD_" + this.currentField + ">" + dataElement + "</FIELD_" + this.currentField + ">\n";
            }
            this.XDoc = this.XDoc + "</" + this.TOPELEMENT + ">";
        }
        return this.XDoc;
    }
}

