/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.SemanticMapperException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.converter.ConverterPlugin;
import com.streamscape.service.converter.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;

public class ConverterService
extends AbstractService {
    private ConverterPlugin plugin = null;

    public void destroy() {
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void doInit() {
        this.ctx.logInfo("Converter service initializing...");
        try {
            ObjectPropertyValue convPluginValue = this.ctx.lookupObjectProperty("converter.plugin");
            SemanticObjectReferenceStore.beginXact((FabricComponent)this.ctx);
            this.plugin = (ConverterPlugin)((Object)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)convPluginValue));
            SemanticObjectReferenceStore.commitXact();
            this.plugin.init(this.ctx);
            this.ctx.logInfo("Service initialized.");
        }
        catch (Exception exception) {
            String error = "Unable to initialize service. Cause: " + exception.getMessage();
            this.ctx.logError(error);
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), error);
        }
    }

    public Object convert(Object source) throws SemanticMapperException {
        if (source == null) {
            throw new RuntimeException("Null source data in Converter '" + this.sco.getServiceName() + "'.");
        }
        try {
            Trace.logDebug((Object)((Object)this), (String)("Conversion request for plugin '" + ((Object)((Object)this.plugin)).getClass().getName() + "'."));
            Object result = this.plugin.invoke(source);
            Trace.logDebug((Object)((Object)this), (String)"Conversion successfull.");
            return result;
        }
        catch (Exception error) {
            this.ctx.logError("Conversion failed. " + error.getMessage());
            throw new SemanticMapperException(3013, error.getMessage());
        }
    }

    public void convertNoReturn(Object source) throws SemanticMapperException {
        this.convert(source);
    }

    public void start() throws ServiceFrameworkException {
        super.start();
        this.plugin.start();
    }

    public void stop() throws ServiceFrameworkException {
        this.plugin.stop();
        super.stop();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"Converter", (boolean)false);
        sco.setServiceClassName(ConverterService.class.getName());
        sco.setServiceDescription("Performs conversion of one object to another using converter plugin with custom conversion logic.");
        sco.setServiceDisplayName("Converter");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ReferenceContext ref = new ReferenceContext(new ReferenceContext(null, null), "/converter");
        SemanticType objSemType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("object");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "convert", "ConversionHandler");
        handler.bindRequestObject("event.source.object", objSemType);
        handler.bindResponseObject("event.conversion.result", objSemType);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("converter.plugin", ServicePropertyType.OBJECT, null);
        prop.setLabel("Converter Plugin");
        prop.setDescription("Specifies converter plugin object which performs custom conversion.");
        prop.setValue((Object)new ObjectPropertyValue("converter", "ConverterPlugin", ref));
        sco.addProperty(prop);
        sco.addException("exception.omf.SemanticMapper");
        return sco;
    }
}

