/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.ftp.client;

import java.util.Date;

public class FileEntry {
    private String fileName;
    private Date modificationDate;
    private boolean isDirectory = false;
    private String permissions;
    private String links;
    private String user;
    private String group;
    private String size;

    public FileEntry(String file) {
        this(file, null);
    }

    public FileEntry(String file, Date date) {
        this(file, date, false);
    }

    public FileEntry(String file, Date date, boolean isDirectory) {
        this.fileName = file;
        this.modificationDate = date;
        this.isDirectory = isDirectory;
    }

    public FileEntry(String file, Date date, boolean isDirectory, String permissions, String links, String user, String group, String size) {
        this.fileName = file;
        this.modificationDate = date;
        this.isDirectory = isDirectory;
        this.permissions = permissions;
        this.links = links;
        this.user = user;
        this.group = group;
        this.size = size;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public boolean isOlder(FileEntry fileEntry) {
        if (this.modificationDate == null || fileEntry.modificationDate == null) {
            return false;
        }
        return this.modificationDate.before(fileEntry.modificationDate);
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getLinks() {
        return this.links;
    }

    public void setLinks(String links) {
        this.links = links;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String toString() {
        return "fileName=" + this.fileName + ", modificationDate=" + String.valueOf(this.modificationDate) + ", isDirectory=" + this.isDirectory;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof FileEntry && this.fileName.equals(((FileEntry)other).getFileName());
    }
}

