/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.ftp.client;

import com.streamscape.Trace;
import com.streamscape.lib.ftp.client.AbstractFTPConnection;
import com.streamscape.lib.ftp.client.FTPException;
import com.streamscape.lib.ftp.client.FTPTransport;
import com.streamscape.lib.ftp.client.FileEntry;
import com.streamscape.lib.ftp.client.IllegalStateException;
import com.streamscape.lib.ftp.enums.FTPTransferType;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.service.osf.clients.ClientFactory;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

class FTPConnectionImpl
extends AbstractFTPConnection {
    protected FTPTransport transport;
    protected int bufferSize = 1024;
    protected FTPTransferType transferType = FTPTransferType.ASCII;
    protected boolean passive = true;
    protected boolean debug = false;

    @Override
    public void init(ClientFactory factory) throws ClientException {
        super.init(factory);
        String property = factory.getProperty("Passive");
        if (property != null) {
            this.passive = Boolean.valueOf(property);
        }
        if (!this.passive) {
            throw new ClientException(1022, "Only passive mode now supported in FTP connection.");
        }
        Trace.logInfo((Object)this, (String)("Passive: " + this.passive));
        property = factory.getProperty("BufferSize");
        if (property != null) {
            this.bufferSize = Integer.valueOf(property);
        }
        Trace.logInfo((Object)this, (String)("BufferSize: " + this.bufferSize));
        property = factory.getProperty("Ascii");
        this.transferType = property != null && property.trim().equalsIgnoreCase("false") ? FTPTransferType.BINARY : FTPTransferType.ASCII;
        Trace.logInfo((Object)this, (String)("Ascii: " + String.valueOf(this.transferType)));
        property = factory.getProperty("Debug");
        if (property != null) {
            this.debug = Boolean.valueOf(property);
        }
        Trace.logInfo((Object)this, (String)("Debug: " + this.debug));
    }

    public boolean getPassive() {
        return this.passive;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public FTPTransferType setTransferType() {
        return this.transferType;
    }

    @Override
    public void openConnection(String host, int port) throws IOException, FTPException, IllegalStateException {
        if (this.transport != null) {
            throw new IllegalStateException("Illegal FTP Connection State: Opened");
        }
        this.transport = new FTPTransport(host, port);
        this.transport.debugResponses(this.debug);
        this.transport.login(this.factory.getDefaultUser(), this.factory.getDefaultPassword());
    }

    @Override
    public void closeConnection() {
        if (this.transport == null) {
            return;
        }
        try {
            this.transport.quit();
        }
        catch (Exception exception) {
            Trace.logError((Object)this, (String)("Failed to quit ftp connection. Cause: " + exception.getMessage()));
        }
        this.transport = null;
    }

    @Override
    public void pingConnection() throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.system();
    }

    @Override
    public void ftpGetFileAsFile(String remoteFile, String localFile) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(this.transferType);
        this.transport.get(localFile, remoteFile, this.bufferSize);
    }

    @Override
    public byte[] ftpGetFileAsBytes(String remoteFile) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(this.transferType);
        return this.transport.get(remoteFile, this.bufferSize);
    }

    @Override
    public void ftpPutFileAsFile(String localFile, String remoteFile, boolean append) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(this.transferType);
        this.transport.put(localFile, remoteFile, append, this.bufferSize);
    }

    @Override
    public void ftpPutFileAsBytes(byte[] data, String remoteFile, boolean append) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(this.transferType);
        this.transport.put(data, remoteFile, append, this.bufferSize);
    }

    @Override
    public void cancelConnection() throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.cancel();
    }

    @Override
    public void ftpChangeDir(String dir) throws IllegalStateException, FTPException, IOException {
        this.assertState();
        this.transport.chdir(dir);
    }

    @Override
    public List<FileEntry> ftpList(String path, boolean full) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        String sysType = this.transport.sysType();
        String sysMask = path == null ? "" : path;
        ArrayList<FileEntry> result = new ArrayList<FileEntry>();
        if (this.useMdtm && this.isModificationTimeFeatureSupported()) {
            List<String> entries = this.transport.list(sysMask, false);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            for (String entryName : entries) {
                FileEntry entry = new FileEntry(FTPConnectionImpl.getDirAndFile(entryName)[1]);
                try {
                    Object root = "";
                    if (entryName.indexOf(47) < 0) {
                        root = sysMask + "/";
                    }
                    String dateString = this.ftpQuote("MDTM " + (String)root + entryName, null, false).get(0);
                    entry.setModificationDate(format.parse(dateString.substring(dateString.indexOf(32) + 1)));
                    result.add(entry);
                }
                catch (ParseException exception) {
                    if (!full) continue;
                    entry.setDirectory(true);
                    result.add(entry);
                }
            }
        } else {
            List<String> files;
            if (sysType.equals("MVS_OS390")) {
                files = this.transport.list(sysMask, true);
                if (files.size() > 0) {
                    files.remove(0);
                }
            } else {
                files = this.transport.list(sysMask, true);
            }
            for (String line : files) {
                try {
                    if (!full && line.startsWith("d")) continue;
                    result.add(FTPConnectionImpl.getFileEntryFromLs(line));
                }
                catch (ParseException exception) {
                    throw new FTPException("Failed to parse data for file '" + line + "'. Cause: " + exception.getMessage());
                }
            }
        }
        return result;
    }

    protected static String[] getDirAndFile(String path) {
        String[] dirAndFile = new String[]{"", ""};
        if (path != null) {
            int slashIndex = path.lastIndexOf(47);
            if (slashIndex > 0) {
                dirAndFile[0] = path.substring(0, slashIndex + 1);
            }
            if (slashIndex < path.length() - 1) {
                dirAndFile[1] = path.substring(slashIndex + 1);
            }
        }
        return dirAndFile;
    }

    protected static FileEntry getFileEntryFromLs(String lsLine) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(lsLine, " \t");
        if (tokenizer.countTokens() < 9) {
            throw new ParseException("Invalid number of tokens in 'ls' result: " + lsLine, 0);
        }
        String permissions = tokenizer.nextToken();
        String links = tokenizer.nextToken();
        String user = tokenizer.nextToken();
        String group = tokenizer.nextToken();
        String size = tokenizer.nextToken();
        String month = tokenizer.nextToken();
        String day = tokenizer.nextToken();
        String timeOrYear = tokenizer.nextToken();
        String file = tokenizer.nextToken("'").trim();
        String dateString = month + " " + day + " ";
        dateString = timeOrYear.indexOf(58) > 0 ? dateString + timeOrYear + " " + Calendar.getInstance().get(1) : dateString + " 00:00 " + timeOrYear;
        SimpleDateFormat format = new SimpleDateFormat("MMM dd HH:mm yyyy", Locale.US);
        FileEntry entry = new FileEntry(file, format.parse(dateString), permissions.startsWith("d"), permissions, links, user, group, size);
        entry.setDirectory(lsLine.startsWith("d"));
        return entry;
    }

    protected boolean isModificationTimeFeatureSupported() {
        try {
            List<String> commands = this.ftpQuote("FEAT", null, false);
            for (String command : commands) {
                if (!command.trim().equalsIgnoreCase("MDTM")) continue;
                return true;
            }
            return false;
        }
        catch (Exception ftpError) {
            return false;
        }
    }

    @Override
    public void ftpDel(String fileName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        this.transport.delete(fileName);
    }

    @Override
    public void ftpMkD(String dirName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        this.transport.mkdir(dirName);
    }

    @Override
    public void ftpRen(String oldFileName, String newFileName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        this.transport.rename(oldFileName, newFileName);
    }

    @Override
    public void ftpRmD(String dirName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        this.transport.rmdir(dirName);
    }

    @Override
    public List<String> ftpQuote(String cmd, String[] validRCList, boolean socketData) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        return this.transport.quote(cmd, validRCList, socketData);
    }

    @Override
    public boolean ftpSite(String cmd) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        return this.transport.site(cmd);
    }

    @Override
    public String ftpSyST() throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.transport.setType(FTPTransferType.ASCII);
        return this.transport.sysType();
    }

    protected void assertState() throws IllegalStateException {
        if (this.transport == null) {
            throw new IllegalStateException("Illegal FTP Connection State: Closed");
        }
    }
}

