package com.streamscape.mf.utils;

import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessStateChange;
import com.streamscape.mf.agent.RedSquareAgent;
import com.streamscape.mf.agent.enums.NotificationType;
import com.streamscape.mf.agent.sdo.*;
import com.streamscape.mf.manager.RedSquareManager;
import com.streamscape.mf.manager.sdo.AgentStateEvent;
import com.streamscape.mf.manager.sdo.PortalNotification;
import com.streamscape.mf.manager.sdo.ProcessTypesRequest;
import com.streamscape.mf.manager.sdo.RedSquareUser;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.dispatcher.EventTriggerSyntaxStore;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.CreateEventTriggerOperationImpl;
import com.streamscape.slex.lang.DSLStatement;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2011</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.4
 * @since 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  10.08.2011 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 //  18.10.2011 | Mikhail Filichev | ECR 00000478: Public access to TFcache and Repository should be closed.
 // -------------------------------------------------------------------------------------------------------------------
 //  06.02.2012 | Mikhail Filichev | ECR 00000548: Use of serial version ids should be reworked.
 // -------------------------------------------------------------------------------------------------------------------
 //  21.10.2012 | Ruslan Boyarskiy | ECR 00000911: Need to implement purge process queue functionality
 //             |                  | ECR 00000736: Option for re-offering of Process Event should be implemented in RedSquare.
 // -------------------------------------------------------------------------------------------------------------------
 //  22.10.2012 | Ruslan Boyarskiy | ECR 00000928: Implement opportunity to change User's role
 // -------------------------------------------------------------------------------------------------------------------
 //  10.11.2012 | Ruslan Boyarskiy | ECR 00000951: Implement Suspend/Resume functionality for process queue
 // -------------------------------------------------------------------------------------------------------------------
 //  18.11.2013 | Mikhail Filichev | ECR 00001208: Predefined Audit and Exception event prototypes should be added.
 // -------------------------------------------------------------------------------------------------------------------
  public class ConfigurationChecker
 {
    public static void checkSemanticTypes() throws Exception
    {
       createSemanticType(RedSquareRequestWrapper.class, "Red Square request wrapper.");
       createSemanticType(RedSquareResponseWrapper.class, "Red Sqaure response wrapper.");
       
       createSemanticType(AgentRegisterEvent.class, "Agent Registration in Manager");
       createSemanticType(AgentStateEvent.class, "Agent state");
       createSemanticType(PortalNotification.class, "Portal Notification");
       createSemanticType(RedSquareRowSet.class, "Red Square row set");
       createSemanticType(LogLineEvent.class, "Event with log line");
       createSemanticType(ProcessListChangeResponse.class, "Process instances list change");
       createSemanticType(ProcessStateChangeResponse.class, "Proxy method response for que state");
       createSemanticType(ProgressNotification.class, "Notification about operation progress");
       createSemanticType(ServiceStateChange.class, "Service state change");
       createSemanticType(NotificationType.class, "Notification type");
       createSemanticType(RedSquareFilter.class, "Red Square filter");
       createSemanticType(RedSquareUser.class, "Red Square user");
       createSemanticType(ProcessTypesRequest.class, "Process Types request");
       createSemanticType(ProcessListRequest.class, "Process List request");
    }
    
    private static void createSemanticType(Class<?> clazz, String description) throws Exception
    {
       if (!TypeFactory.existsSemanticType(clazz.getSimpleName()))
       {
          SemanticType type = TypeFactory.createSemanticType(clazz.getSimpleName(), clazz);
          type.setAncestorType("StructuredDataObject");
          type.setDescription(description);
          type.setInterface(clazz.isInterface());

          TypeFactory.addSemanticType(type);
       }
    }
    
    public static void checkEventPrototypes() throws Exception
    {
       if (!PrototypeFactory.existsPrototype("event.redsquare.request"))
          PrototypeFactory.addDataEventPrototype("event.redsquare.request", new RedSquareRequestWrapper());
       if (!PrototypeFactory.existsPrototype("event.redsquare.response"))
          PrototypeFactory.addDataEventPrototype("event.redsquare.response", new RedSquareResponseWrapper());
       
       if (!PrototypeFactory.existsPrototype("event.redsquare.agent.ProcessStateChange"))
          PrototypeFactory.addDataEventPrototype("event.redsquare.agent.ProcessStateChange", new ProcessStateChangeResponse());
       if (!PrototypeFactory.existsPrototype("event.redsquare.agent.Register"))
          PrototypeFactory.addDataEventPrototype("event.redsquare.agent.Register", new AgentRegisterEvent());
       if (!PrototypeFactory.existsPrototype(RedSquareManager.AGENT_STATE_CHANGE_EVENT_ID))
          PrototypeFactory.addDataEventPrototype(RedSquareManager.AGENT_STATE_CHANGE_EVENT_ID, new AgentStateEvent());
       if (!PrototypeFactory.existsPrototype(RedSquareManager.PROCESS_STATE_CHANGE_EVENT_ID))
          PrototypeFactory.addDataEventPrototype(RedSquareManager.PROCESS_STATE_CHANGE_EVENT_ID, new RedSquareRowSet());
       if (!PrototypeFactory.existsPrototype("advisory.connection.StateChange"))
          PrototypeFactory.addDataEventPrototype("advisory.connection.StateChange", new RedSquareRowSet());
       if (!PrototypeFactory.existsPrototype("event.redsquare.agent.ProcessStateChange"))
          PrototypeFactory.addDataEventPrototype("event.redsquare.agent.ProcessStateChange", new ProcessStateChangeResponse());
       if (!PrototypeFactory.existsPrototype("advisory.client.http"))
          PrototypeFactory.addDataEventPrototype("advisory.client.http", new RedSquareRowSet());
       if (!PrototypeFactory.existsPrototype("exception.sql.Query"))
          PrototypeFactory.addDataEventPrototype("exception.sql.Query", new RedSquareRowSet());
       if (!PrototypeFactory.existsPrototype("event.instance.change"))
          PrototypeFactory.addDataEventPrototype("event.instance.change", new ProcessStateChange());
       if (!PrototypeFactory.existsPrototype(RedSquareAgent.PROCESS_INSTANCE_CHANGE_EVENT_ID))
          PrototypeFactory.addDataEventPrototype(RedSquareAgent.PROCESS_INSTANCE_CHANGE_EVENT_ID, new ProcessListChangeResponse());
       if (!PrototypeFactory.existsPrototype(RedSquareAgent.RED_SQUARE_AGENT_OPERATION_PROGRESS_EVENT_ID))
          PrototypeFactory.addDataEventPrototype(RedSquareAgent.RED_SQUARE_AGENT_OPERATION_PROGRESS_EVENT_ID, new ProgressNotification("","","","",""));
       if (!PrototypeFactory.existsPrototype(RedSquareAgent.RED_SQUARE_AGENT_REGISTER_EVENT_ID))
          PrototypeFactory.addDataEventPrototype(RedSquareAgent.RED_SQUARE_AGENT_REGISTER_EVENT_ID, new AgentRegisterEvent());
       if (!PrototypeFactory.existsPrototype(RedSquareAgent.RED_SQUARE_SERVICE_STATE_CHANGE_EVENT_ID))
          PrototypeFactory.addDataEventPrototype(RedSquareAgent.RED_SQUARE_SERVICE_STATE_CHANGE_EVENT_ID, new ServiceStateChange());
       if (!PrototypeFactory.existsPrototype("event.redsquare.notification"))
       {
           DataEvent event = (DataEvent)EventDatagramFactory.getInstance().newEventInstance("DataEvent");
           event.setData(new PortalNotification());
           event.addAnnotation("severity", "//data/severity");
           event.addAnnotation("description", "//data/description");
           event.addAnnotation("group", "//data/group");
           event.addAnnotation("source", "//data/source");
           event.addAnnotation("type", "//data/type");
           event.addAnnotation("date", "//data/date");
           PrototypeFactory.addDataEventPrototype("event.redsquare.notification", event);
       }

       if (PrototypeFactory.existsPrototype(RedSquareAgent.RED_SQUARE_LOG_LINE_EVENT_ID))
       {
          Prototype prototype =
             PrototypeFactory.getContext().getDatagramPrototypeCache().lookupPrototype(RedSquareAgent.RED_SQUARE_LOG_LINE_EVENT_ID);
          if (!prototype.isValid())
             PrototypeFactory.removePrototype(RedSquareAgent.RED_SQUARE_LOG_LINE_EVENT_ID);
          else
          {
             EventDatagram event = PrototypeFactory.getContext().getEventDatagramFactory().createEvent(prototype);
             EventAnnotation annotation = event.getAnnotation("date");
             if (annotation == null || !annotation.isValid())
                PrototypeFactory.removePrototype(RedSquareAgent.RED_SQUARE_LOG_LINE_EVENT_ID);
          }
       }
       if (!PrototypeFactory.existsPrototype(RedSquareAgent.RED_SQUARE_LOG_LINE_EVENT_ID))
       {
           DataEvent event = (DataEvent)EventDatagramFactory.getInstance().newEventInstance("DataEvent");
           event.setData(new LogLineEvent());
           event.addAnnotation("level", "//data/traceRecord/level");
           event.addAnnotation("message", "//data/traceRecord/message");
           event.addAnnotation("nodeName", "//data/nodeName");
           event.addAnnotation("date", "//data/traceRecord/timestamp");
           PrototypeFactory.addDataEventPrototype(RedSquareAgent.RED_SQUARE_LOG_LINE_EVENT_ID, event);
       }
       if (!PrototypeFactory.existsPrototype( RedSquareAgent.AGENT_GET_LOG_FILE_REQUEST_EVENT_ID ))
             PrototypeFactory.addEventPrototype( "BytesEvent", RedSquareAgent.AGENT_GET_LOG_FILE_REQUEST_EVENT_ID );
       if (!PrototypeFactory.existsPrototype( RedSquareAgent.AGENT_GET_LOG_FILE_RESPONSE_EVENT_ID ))
             PrototypeFactory.addEventPrototype("BytesEvent", RedSquareAgent.AGENT_GET_LOG_FILE_RESPONSE_EVENT_ID );
       
       if (!PrototypeFactory.existsPrototype("event.redsquare.agent.ping"))
          PrototypeFactory.addDataEventPrototype("event.redsquare.agent.ping", "string");
    }
    
    public static void createTriggers(ServiceContext ctx, String triggersResourcePath) throws Exception
    {
       try
       {
          InputStream inputStream = ConfigurationChecker.class.getResourceAsStream(triggersResourcePath);
          if (inputStream == null)
             throw new Exception(triggersResourcePath + " resource not found.");

          CreateEventTriggerOperationImpl operation = new CreateEventTriggerOperationImpl(); 

          BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
          StringBuilder builder = new StringBuilder();
          String line;
          while ((line = reader.readLine()) != null)
          {
             if (line.trim().endsWith("$$"))
             {
                String triggerSyntax = builder.toString();
                DSLStatement statement = operation.parseDsl(triggerSyntax);
                EventTriggerDefinition definition = operation.parseEventTriggerSlangDefinition(statement);
                EventTriggerManagerDelegate manager = (EventTriggerManagerDelegate)ctx;

                boolean existsInSco = manager.existsEventTrigger(definition.getName());
                boolean existsInSysldef = EventTriggerSyntaxStore.isSyntaxExists(ctx, definition.getName());
                if (!existsInSco || !existsInSysldef)
                {
                   if (existsInSco || existsInSysldef)
                      manager.removeEventTrigger(definition.getName());
                   manager.addEventTrigger(triggerSyntax);
                }
                builder = new StringBuilder();
             }
             else if (!line.trim().startsWith("//"))
                builder.append(line).append('\n');
          }
       }
       catch(Exception exception)
       {
          throw new Exception("Triggers creation failed. Cause: " + exception.getMessage());
       }
    }


 }
