package com.streamscape.mf.agent.sdo;

import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents properties of registered consumer
 * </p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  27.09.2010 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 public class RegisteredConsumerProperties extends CloneableDataObject
 {
    protected String  name             = null;
    protected String  state            = null;
    protected int     offerInterval    = 0;
    protected int     numberOfAttempts = 0;
    protected int     timeout          = 0;
    protected boolean suspendOnFailure = false;
    
    public RegisteredConsumerProperties()
    {}
    
    public String getName()
    {
       return name;
    }

    public void setName(String name)
    {
       this.name = name;
    }

    public String getState()
    {
       return state;
    }

    public void setState(String state)
    {
       this.state = state;
    }

    public int getOfferInterval()
    {
       return offerInterval;
    }

    public void setOfferInterval(int offerInterval)
    {
       this.offerInterval = offerInterval;
    }

    public int getNumberOfAttempts()
    {
       return numberOfAttempts;
    }

    public void setNumberOfAttempts(int numberOfAttempts)
    {
       this.numberOfAttempts = numberOfAttempts;
    }

    public int getTimeout()
    {
       return timeout;
    }

    public void setTimeout(int timeout)
    {
       this.timeout = timeout;
    }

    public boolean isSuspendOnFailure()
    {
       return suspendOnFailure;
    }

    public void setSuspendOnFailure(boolean suspendOnFailure)
    {
       this.suspendOnFailure = suspendOnFailure;
    }    
 }
