package com.streamscape.mf.agent.sdo;

import com.streamscape.repository.cache.IllegalStateException;
import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents data for ExtJS grid widget</p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  10.06.2010 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 //  21.10.2010 | Sergey Zakharov  | Updated to include info about target process type and instance (if available)
 // -------------------------------------------------------------------------------------------------------------------
 public class RedSquareRowSet extends CloneableDataObject
 {
    protected String        targetProcessType = null;
    protected String        targetProcessId   = null;
    
    protected Object        rows[]      = null;
    protected int           columnCount = 0;
    protected int           size        = 0;
    protected transient int cursor      = 0;
    
    public RedSquareRowSet()
    {}
    
    public RedSquareRowSet(int columnCount, int size)
    {
       this.columnCount = columnCount;
       this.size = size;
       rows = new Object[size];       
    }
    
    public void addRow(Object row[]) throws IllegalStateException, IllegalArgumentException
    {
       if (row.length != columnCount)
          throw new IllegalArgumentException("Wrong column count in the incoming row.");
       
       if (cursor >= size)
          throw new IllegalStateException("Data object is full.");
       
       rows[cursor] = row;
       ++cursor;
    }
    
    public void compact()
    {
       if (rows.length == 0)
          return;

       if (cursor < size)
       {
          Object[] data = new Object[cursor];
          System.arraycopy(rows, 0, data, 0, cursor);
          rows = data;
       }
       
       size = cursor;
    }
    
    public void print()
    {
       if (rows != null)
       {
          for (int i = 0;i < rows.length; ++i)
          {
             Object data = rows[i];
             if (data != null && data instanceof Object[])
             {
                Object values[] = (Object[])data;
                for (int j = 0; j < values.length ; ++j)
                {
                   System.out.print("\t" + values[j].toString());
                }
                System.out.println("");
             }
          }
       }
    }
    
    public String getTargetProcessType()
    {
       return targetProcessType;
    }

    public void setTargetProcessType(String targetProcessType)
    {
       this.targetProcessType = targetProcessType;
    }

    public String getTargetProcessId()
    {
       return targetProcessId;
    }

    public void setTargetProcessId(String targetProcessId)
    {
       this.targetProcessId = targetProcessId;
    }
 }
