/**
 * 
 */
package com.streamscape.mf.agent.sdo;

import com.streamscape.mf.agent.enums.ProcessQueueState;
import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Andrey Soloviev
 * @version 3.2
 */
 public class ProcessStateChangeResponse extends CloneableDataObject
 {
    private String             processType       = null;
    private ProcessQueueState  processState      = null;
    private String             flowType          = null;
    private boolean            certifiedDelivery;
    private String             nodeName          = null;
    private String             agentInfo         = null;
    private String            organization = null;
    /**
     * @param processType
     *            the processType to set
     */
    public void setProcessType(String processType)
    {
        this.processType = processType;
    }

    /**
     * @return the processType
     */
    public String getProcessType()
    {
        return processType;
    }

    /**
     * @param resumed
     *            the processStatus to set
     */
    public void setProcessStatus(ProcessQueueState resumed)
    {
        this.processState = resumed;
    }

    /**
     * @return the processStatus
     */
    public ProcessQueueState getProcessState()
    {
        return processState;
    }

    /**
     * @param node
     *            the name of a Fabric node to set
     */
    public void setNodeName(String node)
    {
        this.nodeName = node;
    }

    /**
     * @return the hostPort
     */
    public String getNodeName()
    {
        return nodeName;
    }

    /**
     * @param agentInfo
     *            the agentInfo to set
     */
    public void setAgentInfo(String agentInfo)
    {
        this.agentInfo = agentInfo;
    }

    /**
     * @return the agentInfo
     */
    public String getAgentInfo()
    {
        return agentInfo;
    }

 /**
     * @param organization the organization to set
     */
    public void setOrganization(String organization)
    {
        this.organization = organization;
    }

    /**
     * @return the organization
     */
    public String getOrganization()
    {
        return organization;
    }

    /**
     * @param processType
     * @param processStatus
     */
    public ProcessStateChangeResponse(String processType, ProcessQueueState processStatus)
    {
        super();
        this.processType = processType;
        this.processState = processStatus;
    }

    /**
     * 
     */
    public ProcessStateChangeResponse()
    {
        super();
    }

    /**
     * @param processType
     * @param processStatus
     * @param node
     */
    public ProcessStateChangeResponse(String processType, ProcessQueueState processStatus, String node)
    {
        super();
        this.processType = processType;
        this.processState = processStatus;
        this.nodeName = node;
    }

    /**
     * @param processType
     * @param processStatus
     * @param node
     * @param agentInfo
     */
    public ProcessStateChangeResponse(String processType, ProcessQueueState processStatus,String node, String agentInfo)
    {
        super();
        this.processType = processType;
        this.processState = processStatus;
        this.nodeName = node;
        this.agentInfo = agentInfo;
    }

    /**
     * @param certifiedDelivery the certifiedDelivery to set
     */
    public void setCertifiedDelivery(boolean certifiedDelivery)
    {
        this.certifiedDelivery = certifiedDelivery;
    }

    /**
     * @return the certifiedDelivery
     */
    public boolean isCertifiedDelivery()
    {
        return certifiedDelivery;
    }

    /**
     * @param flowType the flowType to set
     */
    public void setFlowType(String flowType)
    {
        this.flowType = flowType;
    }

    /**
     * @return the flowType
     */
    public String getFlowType()
    {
        return flowType;
    }
 }
