package com.streamscape.mf.agent.sdo;

import java.util.ArrayList;
import java.util.List;

import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents process properties
 * </p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  23.09.2010 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 public class ProcessPropertiesResponse extends CloneableDataObject
 {
    protected String processType  = null;
    protected String processState = null;
    protected String constraint   = null;    
    protected int    size         = 0;
    
    protected List<RegisteredConsumerProperties> consumers = new ArrayList<RegisteredConsumerProperties>();
  
    public ProcessPropertiesResponse()
    {       
    }
        
    public String getConstraint()
    {
       return constraint;
    }

    public void setConstraint(String constraint)
    {
       this.constraint = constraint;
    }

    public int getSize()
    {
       return size;
    }

    public void setSize(int size)
    {
       this.size = size;
    }

    public void addConsumer(RegisteredConsumerProperties consumer)
    {
       consumers.add(consumer);
    }
    
    public ProcessPropertiesResponse(String processId)
    {       
       this.processState = processId;
    }
    
    public String getProcessState()
    {
       return processState;
    }
    
    public void setProcessState(String state)
    {
       this.processState = state;
    }
    
    public String getProcessType()
    {
       return processType;
    }

    public void setProcessType(String processType)
    {
       this.processType = processType;
    }
 }
